/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 *
 */
package de.jensd.fx.glyphs.fontawesome;

import de.jensd.fx.glyphs.GlyphIcons;

/**
 *
 * Icon Enum based on Font-Awesome v4.7.0
 *
 * Font Awesome uses the Unicode Private Use Area (PUA) to ensure screen readers do not read off random characters that represent icons
 *
 * @author Jens Deters
 */
public enum FontAwesomeIcon implements GlyphIcons {

    FA_500PX("\uf26E"),
    ADDRESS_BOOK("\uf2B9"),
    ADDRESS_BOOK_ALT("\uf2BA"),
    ADDRESS_CARD("\uf2BB"),
    ADDRESS_CARD_ALT("\uf2BC"),
    ADJUST("\uf042"),
    ADN("\uf170"),
    ALIGN_CENTER("\uf037"),
    ALIGN_JUSTIFY("\uf039"),
    ALIGN_LEFT("\uf036"),
    ALIGN_RIGHT("\uf038"),
    AMAZON("\uf270"),
    AMBULANCE("\uf0F9"),
    AMERICAN_SIGN_LANGUAGE_INTERPRETING("\uf2A3"),
    ANCHOR("\uf13D"),
    ANDROID("\uf17B"),
    ANGELLIST("\uf209"),
    ANGLE_DOUBLE_DOWN("\uf103"),
    ANGLE_DOUBLE_LEFT("\uf100"),
    ANGLE_DOUBLE_RIGHT("\uf101"),
    ANGLE_DOUBLE_UP("\uf102"),
    ANGLE_DOWN("\uf107"),
    ANGLE_LEFT("\uf104"),
    ANGLE_RIGHT("\uf105"),
    ANGLE_UP("\uf106"),
    APPLE("\uf179"),
    ARCHIVE("\uf187"),
    AREA_CHART("\uf1FE"),
    ARROW_CIRCLE_DOWN("\uf0AB"),
    ARROW_CIRCLE_LEFT("\uf0A8"),
    ARROW_CIRCLE_ALT_DOWN("\uf01A"),
    ARROW_CIRCLE_ALT_LEFT("\uf190"),
    ARROW_CIRCLE_ALT_RIGHT("\uf18E"),
    ARROW_CIRCLE_ALT_UP("\uf01B"),
    ARROW_CIRCLE_RIGHT("\uf0A9"),
    ARROW_CIRCLE_UP("\uf0AA"),
    ARROW_DOWN("\uf063"),
    ARROW_LEFT("\uf060"),
    ARROW_RIGHT("\uf061"),
    ARROW_UP("\uf062"),
    ARROWS("\uf047"),
    ARROWS_ALT("\uf0B2"),
    ARROWS_H("\uf07E"),
    ARROWS_V("\uf07D"),
    ASL_INTERPRETING("\uf2A3"),
    ASSISTIVE_LISTENING_SYSTEMS("\uf2A2"),
    ASTERISK("\uf069"),
    AT("\uf1FA"),
    AUDIO_DESCRIPTION("\uf29E"),
    AUTOMOBILE("\uf1B9"),
    BACKWARD("\uf04A"),
    BALANCE_SCALE("\uf24E"),
    BAN("\uf05E"),
    BANDCAMP("\uf2D5"),
    BANK("\uf19C"),
    BAR_CHART("\uf080"),
    BAR_CHART_ALT("\uf080"),
    BARCODE("\uf02A"),
    BARS("\uf0C9"),
    BATH("\uf2CD"),
    BATHTUB("\uf2CD"),
    BATTERY("\uf240"),
    BATTERY_0("\uf244"),
    BATTERY_1("\uf243"),
    BATTERY_2("\uf242"),
    BATTERY_3("\uf241"),
    BATTERY_4("\uf240"),
    BATTERY_EMPTY("\uf244"),
    BATTERY_FULL("\uf240"),
    BATTERY_HALF("\uf242"),
    BATTERY_QUARTER("\uf243"),
    BATTERY_THREE_QUARTERS("\uf241"),
    BED("\uf236"),
    BEER("\uf0FC"),
    BEHANCE("\uf1B4"),
    BEHANCE_SQUARE("\uf1B5"),
    BELL("\uf0F3"),
    BELL_ALT("\uf0A2"),
    BELL_SLASH("\uf1F6"),
    BELL_SLASH_ALT("\uf1F7"),
    BICYCLE("\uf206"),
    BINOCULARS("\uf1E5"),
    BIRTHDAY_CAKE("\uf1FD"),
    BITBUCKET("\uf171"),
    BITBUCKET_SQUARE("\uf172"),
    BITCOIN("\uf15A"),
    BLACK_TIE("\uf27E"),
    BLIND("\uf29D"),
    BLUETOOTH("\uf293"),
    BLUETOOTH_B("\uf294"),
    BOLD("\uf032"),
    BOLT("\uf0E7"),
    BOMB("\uf1E2"),
    BOOK("\uf02D"),
    BOOKMARK("\uf02E"),
    BOOKMARK_ALT("\uf097"),
    BRAILLE("\uf2A1"),
    BRIEFCASE("\uf0B1"),
    BTC("\uf15A"),
    BUG("\uf188"),
    BUILDING("\uf1AD"),
    BUILDING_ALT("\uf0F7"),
    BULLHORN("\uf0A1"),
    BULLSEYE("\uf140"),
    BUS("\uf207"),
    BUYSELLADS("\uf20D"),
    CAB("\uf1BA"),
    CALCULATOR("\uf1EC"),
    CALENDAR("\uf073"),
    CALENDAR_CHECK_ALT("\uf274"),
    CALENDAR_MINUS_ALT("\uf272"),
    CALENDAR_ALT("\uf133"),
    CALENDAR_PLUS_ALT("\uf271"),
    CALENDAR_TIMES_ALT("\uf273"),
    CAMERA("\uf030"),
    CAMERA_RETRO("\uf083"),
    CAR("\uf1B9"),
    CARET_DOWN("\uf0D7"),
    CARET_LEFT("\uf0D9"),
    CARET_RIGHT("\uf0DA"),
    CARET_SQUARE_ALT_DOWN("\uf150"),
    CARET_SQUARE_ALT_LEFT("\uf191"),
    CARET_SQUARE_ALT_RIGHT("\uf152"),
    CARET_SQUARE_ALT_UP("\uf151"),
    CARET_UP("\uf0D8"),
    CART_ARROW_DOWN("\uf218"),
    CART_PLUS("\uf217"),
    CC("\uf20A"),
    CC_AMEX("\uf1F3"),
    CC_DINERS_CLUB("\uf24C"),
    CC_DISCOVER("\uf1F2"),
    CC_JCB("\uf24B"),
    CC_MASTERCARD("\uf1F1"),
    CC_PAYPAL("\uf1F4"),
    CC_STRIPE("\uf1F5"),
    CC_VISA("\uf1F0"),
    CERTIFICATE("\uf0A3"),
    CHAIN("\uf0C1"),
    CHAIN_BROKEN("\uf127"),
    CHECK("\uf00C"),
    CHECK_CIRCLE("\uf058"),
    CHECK_CIRCLE_ALT("\uf05D"),
    CHECK_SQUARE("\uf14A"),
    CHECK_SQUARE_ALT("\uf046"),
    CHEVRON_CIRCLE_DOWN("\uf13A"),
    CHEVRON_CIRCLE_LEFT("\uf137"),
    CHEVRON_CIRCLE_RIGHT("\uf138"),
    CHEVRON_CIRCLE_UP("\uf139"),
    CHEVRON_DOWN("\uf078"),
    CHEVRON_LEFT("\uf053"),
    CHEVRON_RIGHT("\uf054"),
    CHEVRON_UP("\uf077"),
    CHILD("\uf1AE"),
    CHROME("\uf268"),
    CIRCLE("\uf111"),
    CIRCLE_ALT("\uf10C"),
    CIRCLE_ALT_NOTCH("\uf1CE"),
    CIRCLE_THIN("\uf1DB"),
    CLIPBOARD("\uf0EA"),
    CLOCK_ALT("\uf017"),
    CLONE("\uf24D"),
    CLOSE("\uf00D"),
    CLOUD("\uf0C2"),
    CLOUD_DOWNLOAD("\uf0ED"),
    CLOUD_UPLOAD("\uf0EE"),
    CNY("\uf157"),
    CODE("\uf121"),
    CODE_FORK("\uf126"),
    CODEPEN("\uf1CB"),
    CODIEPIE("\uf284"),
    COFFEE("\uf0F4"),
    COG("\uf013"),
    COGS("\uf085"),
    COLUMNS("\uf0DB"),
    COMMENT("\uf075"),
    COMMENT_ALT("\uf0E5"),
    COMMENTING("\uf27A"),
    COMMENTING_ALT("\uf27B"),
    COMMENTS("\uf086"),
    COMMENTS_ALT("\uf0E6"),
    COMPASS("\uf14E"),
    COMPRESS("\uf066"),
    CONNECTDEVELOP("\uf20E"),
    CONTAO("\uf26D"),
    COPY("\uf0C5"),
    COPYRIGHT("\uf1F9"),
    CREATIVE_COMMONS("\uf25E"),
    CREDIT_CARD("\uf09D"),
    CREDIT_CARD_ALT("\uf283"),
    CROP("\uf125"),
    CROSSHAIRS("\uf05B"),
    CSS3("\uf13C"),
    CUBE("\uf1B2"),
    CUBES("\uf1B3"),
    CUT("\uf0C4"),
    CUTLERY("\uf0F5"),
    DASHBOARD("\uf0E4"),
    DASHCUBE("\uf210"),
    DATABASE("\uf1C0"),
    DEAF("\uf2A4"),
    DEAFNESS("\uf2A4"),
    DEDENT("\uf03B"),
    DELICIOUS("\uf1A5"),
    DESKTOP("\uf108"),
    DEVIANTART("\uf1BD"),
    DIAMOND("\uf219"),
    DIGG("\uf1A6"),
    DOLLAR("\uf155"),
    DOT_CIRCLE_ALT("\uf192"),
    DOWNLOAD("\uf019"),
    DRIBBBLE("\uf17D"),
    DRIVERS_LICENSE("\uf2C2"),
    DRIVERS_LICENSE_ALT("\uf2C3"),
    DROPBOX("\uf16B"),
    DRUPAL("\uf1A9"),
    EDGE("\uf282"),
    EDIT("\uf044"),
    EERCAST("\uf2DA"),
    EJECT("\uf052"),
    ELLIPSIS_H("\uf141"),
    ELLIPSIS_V("\uf142"),
    EMPIRE("\uf1D1"),
    ENVELOPE("\uf0E0"),
    ENVELOPE_ALT("\uf003"),
    ENVELOPE_OPEN("\uf2B6"),
    ENVELOPE_OPEN_ALT("\uf2B7"),
    ENVELOPE_SQUARE("\uf199"),
    ENVIRA("\uf299"),
    ERASER("\uf12D"),
    ETSY("\uf2D7"),
    EUR("\uf153"),
    EURO("\uf153"),
    EXCHANGE("\uf0EC"),
    EXCLAMATION("\uf12A"),
    EXCLAMATION_CIRCLE("\uf06A"),
    EXCLAMATION_TRIANGLE("\uf071"),
    EXPAND("\uf065"),
    EXPEDITEDSSL("\uf23E"),
    EXTERNAL_LINK("\uf08E"),
    EXTERNAL_LINK_SQUARE("\uf14C"),
    EYE("\uf06E"),
    EYE_SLASH("\uf070"),
    EYEDROPPER("\uf1FB"),
    FA("\uf2B4"),
    FACEBOOK("\uf09A"),
    FACEBOOK_F("\uf09A"),
    FACEBOOK_OFFICIAL("\uf230"),
    FACEBOOK_SQUARE("\uf082"),
    FAST_BACKWARD("\uf049"),
    FAST_FORWARD("\uf050"),
    FAX("\uf1AC"),
    FEED("\uf09E"),
    FEMALE("\uf182"),
    FIGHTER_JET("\uf0FB"),
    FILE("\uf15B"),
    FILE_ARCHIVE_ALT("\uf1C6"),
    FILE_AUDIO_ALT("\uf1C7"),
    FILE_CODE_ALT("\uf1C9"),
    FILE_EXCEL_ALT("\uf1C3"),
    FILE_IMAGE_ALT("\uf1C5"),
    FILE_MOVIE_ALT("\uf1C8"),
    FILE_ALT("\uf016"),
    FILE_PDF_ALT("\uf1C1"),
    FILE_PHOTO_ALT("\uf1C5"),
    FILE_PICTURE_ALT("\uf1C5"),
    FILE_POWERPOINT_ALT("\uf1C4"),
    FILE_SOUND_ALT("\uf1C7"),
    FILE_TEXT("\uf15C"),
    FILE_TEXT_ALT("\uf0F6"),
    FILE_VIDEO_ALT("\uf1C8"),
    FILE_WORD_ALT("\uf1C2"),
    FILE_ZIP_ALT("\uf1C6"),
    FILES_ALT("\uf0C5"),
    FILM("\uf008"),
    FILTER("\uf0B0"),
    FIRE("\uf06D"),
    FIRE_EXTINGUISHER("\uf134"),
    FIREFOX("\uf269"),
    FIRST_ORDER("\uf2B0"),
    FLAG("\uf024"),
    FLAG_CHECKERED("\uf11E"),
    FLAG_ALT("\uf11D"),
    FLASH("\uf0E7"),
    FLASK("\uf0C3"),
    FLICKR("\uf16E"),
    FLOPPY_ALT("\uf0C7"),
    FOLDER("\uf07B"),
    FOLDER_ALT("\uf114"),
    FOLDER_OPEN("\uf07C"),
    FOLDER_OPEN_ALT("\uf115"),
    FONT("\uf031"),
    FONT_AWESOME("\uf2B4"),
    FONTICONS("\uf280"),
    FORT_AWESOME("\uf286"),
    FORUMBEE("\uf211"),
    FORWARD("\uf04E"),
    FOURSQUARE("\uf180"),
    FREE_CODE_CAMP("\uf2C5"),
    FROWN_ALT("\uf119"),
    FUTBOL_ALT("\uf1E3"),
    GAMEPAD("\uf11B"),
    GAVEL("\uf0E3"),
    GBP("\uf154"),
    GE("\uf1D1"),
    GEAR("\uf013"),
    GEARS("\uf085"),
    GENDERLESS("\uf22D"),
    GET_POCKET("\uf265"),
    GG("\uf260"),
    GG_CIRCLE("\uf261"),
    GIFT("\uf06B"),
    GIT("\uf1D3"),
    GIT_SQUARE("\uf1D2"),
    GITHUB("\uf09B"),
    GITHUB_ALT("\uf113"),
    GITHUB_SQUARE("\uf092"),
    GITLAB("\uf296"),
    GITTIP("\uf184"),
    GLASS("\uf000"),
    GLIDE("\uf2A5"),
    GLIDE_G("\uf2A6"),
    GLOBE("\uf0AC"),
    GOOGLE("\uf1A0"),
    GOOGLE_PLUS("\uf0D5"),
    GOOGLE_PLUS_CIRCLE("\uf2B3"),
    GOOGLE_PLUS_OFFICIAL("\uf2B3"),
    GOOGLE_PLUS_SQUARE("\uf0D4"),
    GOOGLE_WALLET("\uf1EE"),
    GRADUATION_CAP("\uf19D"),
    GRATIPAY("\uf184"),
    GRAV("\uf2D6"),
    GROUP("\uf0C0"),
    H_SQUARE("\uf0FD"),
    HACKER_NEWS("\uf1D4"),
    HAND_GRAB_ALT("\uf255"),
    HAND_LIZARD_ALT("\uf258"),
    HAND_ALT_DOWN("\uf0A7"),
    HAND_ALT_LEFT("\uf0A5"),
    HAND_ALT_RIGHT("\uf0A4"),
    HAND_ALT_UP("\uf0A6"),
    HAND_PAPER_ALT("\uf256"),
    HAND_PEACE_ALT("\uf25B"),
    HAND_POINTER_ALT("\uf25A"),
    HAND_ROCK_ALT("\uf255"),
    HAND_SCISSORS_ALT("\uf257"),
    HAND_SPOCK_ALT("\uf259"),
    HAND_STOP_ALT("\uf256"),
    HANDSHAKE_ALT("\uf2B5"),
    HARD_OF_HEARING("\uf2A4"),
    HASHTAG("\uf292"),
    HDD_ALT("\uf0A0"),
    HEADER("\uf1DC"),
    HEADPHONES("\uf025"),
    HEART("\uf004"),
    HEART_ALT("\uf08A"),
    HEARTBEAT("\uf21E"),
    HISTORY("\uf1DA"),
    HOME("\uf015"),
    HOSPITAL_ALT("\uf0F8"),
    HOTEL("\uf236"),
    HOURGLASS("\uf254"),
    HOURGLASS_1("\uf251"),
    HOURGLASS_2("\uf252"),
    HOURGLASS_3("\uf253"),
    HOURGLASS_END("\uf253"),
    HOURGLASS_HALF("\uf252"),
    HOURGLASS_ALT("\uf250"),
    HOURGLASS_START("\uf251"),
    HOUZZ("\uf27C"),
    HTML5("\uf13B"),
    I_CURSOR("\uf246"),
    ID_BADGE("\uf2C1"),
    ID_CARD("\uf2C2"),
    ID_CARD_ALT("\uf2C3"),
    ILS("\uf20B"),
    IMAGE("\uf03E"),
    IMDB("\uf2D8"),
    INBOX("\uf01C"),
    INDENT("\uf03C"),
    INDUSTRY("\uf275"),
    INFO("\uf129"),
    INFO_CIRCLE("\uf05A"),
    INR("\uf156"),
    INSTAGRAM("\uf16D"),
    INSTITUTION("\uf19C"),
    INTERNET_EXPLORER("\uf26B"),
    INTERSEX("\uf224"),
    IOXHOST("\uf208"),
    ITALIC("\uf033"),
    JOOMLA("\uf1AA"),
    JPY("\uf157"),
    JSFIDDLE("\uf1CC"),
    KEY("\uf084"),
    KEYBOARD_ALT("\uf11C"),
    KRW("\uf159"),
    LANGUAGE("\uf1AB"),
    LAPTOP("\uf109"),
    LASTFM("\uf202"),
    LASTFM_SQUARE("\uf203"),
    LEAF("\uf06C"),
    LEANPUB("\uf212"),
    LEGAL("\uf0E3"),
    LEMON_ALT("\uf094"),
    LEVEL_DOWN("\uf149"),
    LEVEL_UP("\uf148"),
    LIFE_BOUY("\uf1CD"),
    LIFE_BUOY("\uf1CD"),
    LIFE_RING("\uf1CD"),
    LIFE_SAVER("\uf1CD"),
    LIGHTBULB_ALT("\uf0EB"),
    LINE_CHART("\uf201"),
    LINK("\uf0C1"),
    LINKEDIN("\uf0E1"),
    LINKEDIN_SQUARE("\uf08C"),
    LINODE("\uf2B8"),
    LINUX("\uf17C"),
    LIST("\uf03A"),
    LIST_ALT("\uf022"),
    LIST_OL("\uf0CB"),
    LIST_UL("\uf0CA"),
    LOCATION_ARROW("\uf124"),
    LOCK("\uf023"),
    LONG_ARROW_DOWN("\uf175"),
    LONG_ARROW_LEFT("\uf177"),
    LONG_ARROW_RIGHT("\uf178"),
    LONG_ARROW_UP("\uf176"),
    LOW_VISION("\uf2A8"),
    MAGIC("\uf0D0"),
    MAGNET("\uf076"),
    MAIL_FORWARD("\uf064"),
    MAIL_REPLY("\uf112"),
    MAIL_REPLY_ALL("\uf122"),
    MALE("\uf183"),
    MAP("\uf279"),
    MAP_MARKER("\uf041"),
    MAP_ALT("\uf278"),
    MAP_PIN("\uf276"),
    MAP_SIGNS("\uf277"),
    MARS("\uf222"),
    MARS_DOUBLE("\uf227"),
    MARS_STROKE("\uf229"),
    MARS_STROKE_H("\uf22B"),
    MARS_STROKE_V("\uf22A"),
    MAXCDN("\uf136"),
    MEANPATH("\uf20C"),
    MEDIUM("\uf23A"),
    MEDKIT("\uf0FA"),
    MEETUP("\uf2E0"),
    MEH_ALT("\uf11A"),
    MERCURY("\uf223"),
    MICROCHIP("\uf2DB"),
    MICROPHONE("\uf130"),
    MICROPHONE_SLASH("\uf131"),
    MINUS("\uf068"),
    MINUS_CIRCLE("\uf056"),
    MINUS_SQUARE("\uf146"),
    MINUS_SQUARE_ALT("\uf147"),
    MIXCLOUD("\uf289"),
    MOBILE("\uf10B"),
    MOBILE_PHONE("\uf10B"),
    MODX("\uf285"),
    MONEY("\uf0D6"),
    MOON_ALT("\uf186"),
    MORTAR_BOARD("\uf19D"),
    MOTORCYCLE("\uf21C"),
    MOUSE_POINTER("\uf245"),
    MUSIC("\uf001"),
    NAVICON("\uf0C9"),
    NEUTER("\uf22C"),
    NEWSPAPER_ALT("\uf1EA"),
    OBJECT_GROUP("\uf247"),
    OBJECT_UNGROUP("\uf248"),
    ODNOKLASSNIKI("\uf263"),
    ODNOKLASSNIKI_SQUARE("\uf264"),
    OPENCART("\uf23D"),
    OPENID("\uf19B"),
    OPERA("\uf26A"),
    OPTIN_MONSTER("\uf23C"),
    OUTDENT("\uf03B"),
    PAGELINES("\uf18C"),
    PAINT_BRUSH("\uf1FC"),
    PAPER_PLANE("\uf1D8"),
    PAPER_PLANE_ALT("\uf1D9"),
    PAPERCLIP("\uf0C6"),
    PARAGRAPH("\uf1DD"),
    PASTE("\uf0EA"),
    PAUSE("\uf04C"),
    PAUSE_CIRCLE("\uf28B"),
    PAUSE_CIRCLE_ALT("\uf28C"),
    PAW("\uf1B0"),
    PAYPAL("\uf1ED"),
    PENCIL("\uf040"),
    PENCIL_SQUARE("\uf14B"),
    PENCIL_SQUARE_ALT("\uf044"),
    PERCENT("\uf295"),
    PHONE("\uf095"),
    PHONE_SQUARE("\uf098"),
    PHOTO("\uf03E"),
    PICTURE_ALT("\uf03E"),
    PIE_CHART("\uf200"),
    PIED_PIPER("\uf2AE"),
    PIED_PIPER_ALT("\uf1A8"),
    PIED_PIPER_PP("\uf1A7"),
    PINTEREST("\uf0D2"),
    PINTEREST_P("\uf231"),
    PINTEREST_SQUARE("\uf0D3"),
    PLANE("\uf072"),
    PLAY("\uf04B"),
    PLAY_CIRCLE("\uf144"),
    PLAY_CIRCLE_ALT("\uf01D"),
    PLUG("\uf1E6"),
    PLUS("\uf067"),
    PLUS_CIRCLE("\uf055"),
    PLUS_SQUARE("\uf0FE"),
    PLUS_SQUARE_ALT("\uf196"),
    PODCAST("\uf2CE"),
    POWER_OFF("\uf011"),
    PRINT("\uf02F"),
    PRODUCT_HUNT("\uf288"),
    PUZZLE_PIECE("\uf12E"),
    QQ("\uf1D6"),
    QRCODE("\uf029"),
    QUESTION("\uf128"),
    QUESTION_CIRCLE("\uf059"),
    QUESTION_CIRCLE_ALT("\uf29C"),
    QUORA("\uf2C4"),
    QUOTE_LEFT("\uf10D"),
    QUOTE_RIGHT("\uf10E"),
    RA("\uf1D0"),
    RANDOM("\uf074"),
    RAVELRY("\uf2D9"),
    REBEL("\uf1D0"),
    RECYCLE("\uf1B8"),
    REDDIT("\uf1A1"),
    REDDIT_ALIEN("\uf281"),
    REDDIT_SQUARE("\uf1A2"),
    REFRESH("\uf021"),
    REGISTERED("\uf25D"),
    REMOVE("\uf00D"),
    RENREN("\uf18B"),
    REORDER("\uf0C9"),
    REPEAT("\uf01E"),
    REPLY("\uf112"),
    REPLY_ALL("\uf122"),
    RESISTANCE("\uf1D0"),
    RETWEET("\uf079"),
    RMB("\uf157"),
    ROAD("\uf018"),
    ROCKET("\uf135"),
    ROTATE_LEFT("\uf0E2"),
    ROTATE_RIGHT("\uf01E"),
    ROUBLE("\uf158"),
    RSS("\uf09E"),
    RSS_SQUARE("\uf143"),
    RUB("\uf158"),
    RUBLE("\uf158"),
    RUPEE("\uf156"),
    S15("\uf2CD"),
    SAFARI("\uf267"),
    SAVE("\uf0C7"),
    SCISSORS("\uf0C4"),
    SCRIBD("\uf28A"),
    SEARCH("\uf002"),
    SEARCH_MINUS("\uf010"),
    SEARCH_PLUS("\uf00E"),
    SELLSY("\uf213"),
    SEND("\uf1D8"),
    SEND_ALT("\uf1D9"),
    SERVER("\uf233"),
    SHARE("\uf064"),
    SHARE_ALT("\uf1E0"),
    SHARE_ALT_SQUARE("\uf1E1"),
    SHARE_SQUARE("\uf14D"),
    SHARE_SQUARE_ALT("\uf045"),
    SHEKEL("\uf20B"),
    SHEQEL("\uf20B"),
    SHIELD("\uf132"),
    SHIP("\uf21A"),
    SHIRTSINBULK("\uf214"),
    SHOPPING_BAG("\uf290"),
    SHOPPING_BASKET("\uf291"),
    SHOPPING_CART("\uf07A"),
    SHOWER("\uf2CC"),
    SIGN_IN("\uf090"),
    SIGN_LANGUAGE("\uf2A7"),
    SIGN_OUT("\uf08B"),
    SIGNAL("\uf012"),
    SIGNING("\uf2A7"),
    SIMPLYBUILT("\uf215"),
    SITEMAP("\uf0E8"),
    SKYATLAS("\uf216"),
    SKYPE("\uf17E"),
    SLACK("\uf198"),
    SLIDERS("\uf1DE"),
    SLIDESHARE("\uf1E7"),
    SMILE_ALT("\uf118"),
    SNAPCHAT("\uf2AB"),
    SNAPCHAT_GHOST("\uf2AC"),
    SNAPCHAT_SQUARE("\uf2AD"),
    SNOWFLAKE_ALT("\uf2DC"),
    SOCCER_BALL_ALT("\uf1E3"),
    SORT("\uf0DC"),
    SORT_ALPHA_ASC("\uf15D"),
    SORT_ALPHA_DESC("\uf15E"),
    SORT_AMOUNT_ASC("\uf160"),
    SORT_AMOUNT_DESC("\uf161"),
    SORT_ASC("\uf0DE"),
    SORT_DESC("\uf0DD"),
    SORT_DOWN("\uf0DD"),
    SORT_NUMERIC_ASC("\uf162"),
    SORT_NUMERIC_DESC("\uf163"),
    SORT_UP("\uf0DE"),
    SOUNDCLOUD("\uf1BE"),
    SPACE_SHUTTLE("\uf197"),
    SPINNER("\uf110"),
    SPOON("\uf1B1"),
    SPOTIFY("\uf1BC"),
    SQUARE("\uf0C8"),
    SQUARE_ALT("\uf096"),
    STACK_EXCHANGE("\uf18D"),
    STACK_OVERFLOW("\uf16C"),
    STAR("\uf005"),
    STAR_HALF("\uf089"),
    STAR_HALF_EMPTY("\uf123"),
    STAR_HALF_FULL("\uf123"),
    STAR_HALF_ALT("\uf123"),
    STAR_ALT("\uf006"),
    STEAM("\uf1B6"),
    STEAM_SQUARE("\uf1B7"),
    STEP_BACKWARD("\uf048"),
    STEP_FORWARD("\uf051"),
    STETHOSCOPE("\uf0F1"),
    STICKY_NOTE("\uf249"),
    STICKY_NOTE_ALT("\uf24A"),
    STOP("\uf04D"),
    STOP_CIRCLE("\uf28D"),
    STOP_CIRCLE_ALT("\uf28E"),
    STREET_VIEW("\uf21D"),
    STRIKETHROUGH("\uf0CC"),
    STUMBLEUPON("\uf1A4"),
    STUMBLEUPON_CIRCLE("\uf1A3"),
    SUBSCRIPT("\uf12C"),
    SUBWAY("\uf239"),
    SUITCASE("\uf0F2"),
    SUN_ALT("\uf185"),
    SUPERPOWERS("\uf2DD"),
    SUPERSCRIPT("\uf12B"),
    SUPPORT("\uf1CD"),
    TABLE("\uf0CE"),
    TABLET("\uf10A"),
    TACHOMETER("\uf0E4"),
    TAG("\uf02B"),
    TAGS("\uf02C"),
    TASKS("\uf0AE"),
    TAXI("\uf1BA"),
    TELEGRAM("\uf2C6"),
    TELEVISION("\uf26C"),
    TENCENT_WEIBO("\uf1D5"),
    TERMINAL("\uf120"),
    TEXT_HEIGHT("\uf034"),
    TEXT_WIDTH("\uf035"),
    TH("\uf00A"),
    TH_LARGE("\uf009"),
    TH_LIST("\uf00B"),
    THEMEISLE("\uf2B2"),
    THERMOMETER("\uf2C7"),
    THERMOMETER_0("\uf2CB"),
    THERMOMETER_1("\uf2CA"),
    THERMOMETER_2("\uf2C9"),
    THERMOMETER_3("\uf2C8"),
    THERMOMETER_4("\uf2C7"),
    THERMOMETER_EMPTY("\uf2CB"),
    THERMOMETER_FULL("\uf2C7"),
    THERMOMETER_HALF("\uf2C9"),
    THERMOMETER_QUARTER("\uf2CA"),
    THERMOMETER_THREE_QUARTERS("\uf2C8"),
    THUMB_TACK("\uf08D"),
    THUMBS_DOWN("\uf165"),
    THUMBS_ALT_DOWN("\uf088"),
    THUMBS_ALT_UP("\uf087"),
    THUMBS_UP("\uf164"),
    TICKET("\uf145"),
    TIMES("\uf00D"),
    TIMES_CIRCLE("\uf057"),
    TIMES_CIRCLE_ALT("\uf05C"),
    TIMES_RECTANGLE("\uf2D3"),
    TIMES_RECTANGLE_ALT("\uf2D4"),
    TINT("\uf043"),
    TOGGLE_DOWN("\uf150"),
    TOGGLE_LEFT("\uf191"),
    TOGGLE_OFF("\uf204"),
    TOGGLE_ON("\uf205"),
    TOGGLE_RIGHT("\uf152"),
    TOGGLE_UP("\uf151"),
    TRADEMARK("\uf25C"),
    TRAIN("\uf238"),
    TRANSGENDER("\uf224"),
    TRANSGENDER_ALT("\uf225"),
    TRASH("\uf1F8"),
    TRASH_ALT("\uf014"),
    TREE("\uf1BB"),
    TRELLO("\uf181"),
    TRIPADVISOR("\uf262"),
    TROPHY("\uf091"),
    TRUCK("\uf0D1"),
    TRY("\uf195"),
    TTY("\uf1E4"),
    TUMBLR("\uf173"),
    TUMBLR_SQUARE("\uf174"),
    TURKISH_LIRA("\uf195"),
    TV("\uf26C"),
    TWITCH("\uf1E8"),
    TWITTER("\uf099"),
    TWITTER_SQUARE("\uf081"),
    UMBRELLA("\uf0E9"),
    UNDERLINE("\uf0CD"),
    UNDO("\uf0E2"),
    UNIVERSAL_ACCESS("\uf29A"),
    UNIVERSITY("\uf19C"),
    UNLINK("\uf127"),
    UNLOCK("\uf09C"),
    UNLOCK_ALT("\uf13E"),
    UNSORTED("\uf0DC"),
    UPLOAD("\uf093"),
    USB("\uf287"),
    USD("\uf155"),
    USER("\uf007"),
    USER_CIRCLE("\uf2BD"),
    USER_CIRCLE_ALT("\uf2BE"),
    USER_MD("\uf0F0"),
    USER_ALT("\uf2C0"),
    USER_PLUS("\uf234"),
    USER_SECRET("\uf21B"),
    USER_TIMES("\uf235"),
    USERS("\uf0C0"),
    VCARD("\uf2BB"),
    VCARD_ALT("\uf2BC"),
    VENUS("\uf221"),
    VENUS_DOUBLE("\uf226"),
    VENUS_MARS("\uf228"),
    VIACOIN("\uf237"),
    VIADEO("\uf2A9"),
    VIADEO_SQUARE("\uf2AA"),
    VIDEO_CAMERA("\uf03D"),
    VIMEO("\uf27D"),
    VIMEO_SQUARE("\uf194"),
    VINE("\uf1CA"),
    VK("\uf189"),
    VOLUME_CONTROL_PHONE("\uf2A0"),
    VOLUME_DOWN("\uf027"),
    VOLUME_OFF("\uf026"),
    VOLUME_UP("\uf028"),
    WARNING("\uf071"),
    WECHAT("\uf1D7"),
    WEIBO("\uf18A"),
    WEIXIN("\uf1D7"),
    WHATSAPP("\uf232"),
    WHEELCHAIR("\uf193"),
    WHEELCHAIR_ALT("\uf29B"),
    WIFI("\uf1EB"),
    WIKIPEDIA_W("\uf266"),
    WINDOW_CLOSE("\uf2D3"),
    WINDOW_CLOSE_ALT("\uf2D4"),
    WINDOW_MAXIMIZE("\uf2D0"),
    WINDOW_MINIMIZE("\uf2D1"),
    WINDOW_RESTORE("\uf2D2"),
    WINDOWS("\uf17A"),
    WON("\uf159"),
    WORDPRESS("\uf19A"),
    WPBEGINNER("\uf297"),
    WPEXPLORER("\uf2DE"),
    WPFORMS("\uf298"),
    WRENCH("\uf0AD"),
    XING("\uf168"),
    XING_SQUARE("\uf169"),
    Y_COMBINATOR("\uf23B"),
    Y_COMBINATOR_SQUARE("\uf1D4"),
    YAHOO("\uf19E"),
    YC("\uf23B"),
    YC_SQUARE("\uf1D4"),
    YELP("\uf1E9"),
    YEN("\uf157"),
    YOAST("\uf2B1"),
    YOUTUBE("\uf167"),
    YOUTUBE_PLAY("\uf16A"),
    YOUTUBE_SQUARE("\uf166");

    private final String unicode;

    private FontAwesomeIcon(String unicode) {
        this.unicode = unicode;
    }

    @Override
    public String unicode() {
        return unicode;
    }

    @Override
    public String fontFamily() {
        return "FontAwesome";
    }

}
