/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.android.configure;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class ConfigureProjectTestGenerated extends AbstractConfigureProjectTest {
    @TestMetadata("idea/testData/configuration/android-gradle")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Android_gradle extends AbstractConfigureProjectTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestAndroidGradle, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAndroid_gradle() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/configuration/android-gradle"), Pattern.compile("(\\w+)_before\\.gradle$"), TargetBackend.ANY, true);
        }

        @TestMetadata("androidStudioDefault_before.gradle")
        public void testAndroidStudioDefault() throws Exception {
            runTest("idea/testData/configuration/android-gradle/androidStudioDefault_before.gradle");
        }

        @TestMetadata("androidStudioDefaultShapshot_before.gradle")
        public void testAndroidStudioDefaultShapshot() throws Exception {
            runTest("idea/testData/configuration/android-gradle/androidStudioDefaultShapshot_before.gradle");
        }

        @TestMetadata("buildConfigs_before.gradle")
        public void testBuildConfigs() throws Exception {
            runTest("idea/testData/configuration/android-gradle/buildConfigs_before.gradle");
        }

        @TestMetadata("emptyDependencyList_before.gradle")
        public void testEmptyDependencyList() throws Exception {
            runTest("idea/testData/configuration/android-gradle/emptyDependencyList_before.gradle");
        }

        @TestMetadata("emptyFile_before.gradle")
        public void testEmptyFile() throws Exception {
            runTest("idea/testData/configuration/android-gradle/emptyFile_before.gradle");
        }

        @TestMetadata("helloWorld_before.gradle")
        public void testHelloWorld() throws Exception {
            runTest("idea/testData/configuration/android-gradle/helloWorld_before.gradle");
        }

        @TestMetadata("libraryFile_before.gradle")
        public void testLibraryFile() throws Exception {
            runTest("idea/testData/configuration/android-gradle/libraryFile_before.gradle");
        }

        @TestMetadata("missedApplyAndroidStatement_before.gradle")
        public void testMissedApplyAndroidStatement() throws Exception {
            runTest("idea/testData/configuration/android-gradle/missedApplyAndroidStatement_before.gradle");
        }

        @TestMetadata("missedBuildscriptBlock_before.gradle")
        public void testMissedBuildscriptBlock() throws Exception {
            runTest("idea/testData/configuration/android-gradle/missedBuildscriptBlock_before.gradle");
        }

        @TestMetadata("missedRepositoriesInBuildscriptBlock_before.gradle")
        public void testMissedRepositoriesInBuildscriptBlock() throws Exception {
            runTest("idea/testData/configuration/android-gradle/missedRepositoriesInBuildscriptBlock_before.gradle");
        }

        @TestMetadata("productFlavor_before.gradle")
        public void testProductFlavor() throws Exception {
            runTest("idea/testData/configuration/android-gradle/productFlavor_before.gradle");
        }

        @TestMetadata("idea/testData/configuration/android-gradle/gradleExamples")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class GradleExamples extends AbstractConfigureProjectTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTestAndroidGradle, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInGradleExamples() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/configuration/android-gradle/gradleExamples"), Pattern.compile("(\\w+)_before\\.gradle$"), TargetBackend.ANY, true);
            }

            @TestMetadata("gradleExample0_before.gradle")
            public void testGradleExample0() throws Exception {
                runTest("idea/testData/configuration/android-gradle/gradleExamples/gradleExample0_before.gradle");
            }

            @TestMetadata("gradleExample18_before.gradle")
            public void testGradleExample18() throws Exception {
                runTest("idea/testData/configuration/android-gradle/gradleExamples/gradleExample18_before.gradle");
            }

            @TestMetadata("gradleExample22_before.gradle")
            public void testGradleExample22() throws Exception {
                runTest("idea/testData/configuration/android-gradle/gradleExamples/gradleExample22_before.gradle");
            }

            @TestMetadata("gradleExample44_before.gradle")
            public void testGradleExample44() throws Exception {
                runTest("idea/testData/configuration/android-gradle/gradleExamples/gradleExample44_before.gradle");
            }

            @TestMetadata("gradleExample5_before.gradle")
            public void testGradleExample5() throws Exception {
                runTest("idea/testData/configuration/android-gradle/gradleExamples/gradleExample5_before.gradle");
            }

            @TestMetadata("gradleExample50_before.gradle")
            public void testGradleExample50() throws Exception {
                runTest("idea/testData/configuration/android-gradle/gradleExamples/gradleExample50_before.gradle");
            }

            @TestMetadata("gradleExample58_before.gradle")
            public void testGradleExample58() throws Exception {
                runTest("idea/testData/configuration/android-gradle/gradleExamples/gradleExample58_before.gradle");
            }

            @TestMetadata("gradleExample65_before.gradle")
            public void testGradleExample65() throws Exception {
                runTest("idea/testData/configuration/android-gradle/gradleExamples/gradleExample65_before.gradle");
            }

            @TestMetadata("gradleExample8_before.gradle")
            public void testGradleExample8() throws Exception {
                runTest("idea/testData/configuration/android-gradle/gradleExamples/gradleExample8_before.gradle");
            }
        }
    }

    @TestMetadata("idea/testData/configuration/android-gsk")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Android_gsk extends AbstractConfigureProjectTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestAndroidGradle, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAndroid_gsk() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/configuration/android-gsk"), Pattern.compile("(\\w+)_before\\.gradle.kts$"), TargetBackend.ANY, true);
        }

        @TestMetadata("emptyFile_before.gradle.kts")
        public void testEmptyFile() throws Exception {
            runTest("idea/testData/configuration/android-gsk/emptyFile_before.gradle.kts");
        }

        @TestMetadata("helloWorld_before.gradle.kts")
        public void testHelloWorld() throws Exception {
            runTest("idea/testData/configuration/android-gsk/helloWorld_before.gradle.kts");
        }
    }
}
