---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, indentation, première ligne, 
              espace en début de paragraphe, alinea, supprimer l'alinéa
---

# Comment supprimer le retrait sur la première ligne d'un paragraphe ?

Si vous visez un unique paragraphe, vous devriez privilégier la commande 
`\noindent` au début du texte permet de supprimer le retrait 
(ou renfoncement) de la première ligne d'un paragraphe, comme le montre
cet exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Longtemps, je me suis couché de bonne heure.
Parfois, à peine ma bougie éteinte,
mes yeux se fermaient si vite que je n’avais pas
le temps de me dire : \og{}Je m’endors.\fg{}

\medskip

\noindent Longtemps, je me suis couché de bonne heure.
Parfois, à peine ma bougie éteinte,
mes yeux se fermaient si vite que je n’avais pas
le temps de me dire : \og{}Je m’endors.\fg{}
\end{document}
```

Cependant, si vous souhaitez faire cette modification 
sur tous les paragraphes de votre document, il vaut mieux suivre 
les méthodes  présentées à la question 
"[](supprimer_l_indentation_en_debut_de_paragraphe)".