---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              fractions, écrire une fraction en LaTeX, 
              hauteur du numérateur et du dénominateur, 
              positions des termes dans une fraction
---

# Comment écrire proprement "a/b" ?

## Avec l'extension <ctanpkg:xfrac>

Pour que le numérateur `a` soit légèrement décalé vers le haut à gauche 
et que le dénominateur `b` soit légèrement décalé vers le bas à droite, 
les deux étant plus petits que la police courante, il existe la commande 
`\sfrac` de l'extension <ctanpkg:xfrac> :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{xfrac}

\begin{document}
\Large Votez pour ma fraction : $\sfrac{a}{b}$.
\end{document}
```

Cette commande a été, à une époque, fournie par l'extension <ctanpkg:tugboat>.


## Avec l'extension <ctanpkg:nicefrac>

L'extension <ctanpkg:nicefrac> fournit également une commande pour composer 
des fractions :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{nicefrac}

\begin{document}
\Large Votez pour ma fraction : $\nicefrac{a}{b}$.
\end{document}
```

Cependant, cette extension a été développée quand la police 
*[Computer modern](ctanpkg:cm)* était la plus fréquemment utilisée. Cela peut
poser problème avec d'autres polices. Voici, par exemple, une comparaison 
utilisant la police *[Palatino](ctanpkg:palatino-nfss)* :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathpazo}       % Pour charger Palatino
  \usepackage{nicefrac}
  \usepackage{xfrac}

\begin{document}
\Large Avec \textsf{nicefrac} : $\nicefrac{a}{b}$ 
et avec \textsf{xfrac} : $\sfrac{a}{b}$  (le $a$ est plus bas).
\end{document}
```

En fonction des polices, la différence est plus ou moins visible. 
De façon générale, l'extension <ctanpkg:xfrac> évite beaucoup des problèmes
de <ctanpkg:nicefrac> et devrait toujours être utilisée à sa place.