
#include <fli.h>
#include <malloc.h> 
#include <stdio.h>

FLI_HELP_BROWSER
    *fli_help_browser;
int
    nfli_help_browser;

int fli_load_help_browser (FL_FORM *form, FL_OBJECT *textb, FL_OBJECT
			   *contentsb, FL_OBJECT *indexb, char const *fname)
{
    register FILE
	*f;

    /* clear browsers */
    fl_clear_browser (textb);
    fl_clear_browser (indexb);
    fl_clear_browser (contentsb);

    /* try to open file */
    if (! (f = fopen (fname, "r")) )
	return (1);
    
    /* enter the data */
    if (! (fli_help_browser = (FLI_HELP_BROWSER *)
	   realloc (fli_help_browser,
		    (nfli_help_browser + 1) * sizeof (FLI_HELP_BROWSER))) )
	return (2);

    fli_help_browser [nfli_help_browser].textbrowser = textb;
    fli_help_browser [nfli_help_browser].contentsbrowser = contentsb;
    fli_help_browser [nfli_help_browser].indexbrowser = indexb;
    fli_help_browser [nfli_help_browser].f = f;
    fli_help_browser [nfli_help_browser].form = form;
    
    /* parse first section */
    fli_parse_helpfile (nfli_help_browser);

    /* parsed.. */
    
    fl_set_object_callback (textb, fli_help_browser_cb,
			    (long) nfli_help_browser);
    fl_set_object_callback (contentsb, fli_help_browser_cb,
			    (long) nfli_help_browser);
    fl_set_object_callback (indexb, fli_help_browser_cb,
			    (long) nfli_help_browser);

    nfli_help_browser++;

    /* return success */
    return (0);
}
