.\" $NCDId: @(#)AuWrEl.man,v 1.1 1994/09/27 00:37:37 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuWrEl.man 5 1999-05-08 18:47:16Z jon $
.TH AuWriteElement 3 "1.2" "audiolib - write to element"
.SH \fBName\fP
\fBAuWriteElement\fP \- write data to an ImportClient element in a flow
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
void \fBAuWriteElement\fP(\fIserver\fP, \fIflow\fP, \fIelement\fP, \fInum_bytes\fP, \fIdata\fP, \fIend_of_data\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuFlowID\fP \fIflow\fP;
.br
    int \fIelement\fP;
.br
    \fBAuUint32\fP \fInum_bytes\fP;
.br
    \fBAuPointer\fP \fIdata\fP;
.br
    \fBAuBool\fP \fIend_of_data\fP;
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIflow\fP 1i
Specifies the ID of the flow.
.IP \fIelement\fP 1i
Specifies the index of the ImportClient element to write the data to.
.IP \fInum_bytes\fP 1i
Specifies the number of bytes of audio data to write.
.IP \fIdata\fP 1i
Specifies the buffer to get the audio data from.
.IP \fIend_of_data\fP 1i
Specifies if this is the last write for this import.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuWriteElement\fP transfers audio data from the client application to the server, writing \fInum_bytes\fP from \fIdata\fP to the ImportClient specified by \fIelement\fP in the audio flow \fIflow\fP.
If \fIend_of_data\fP is \fBAuTrue\fP, the ImportClient's eof flag will be set when the write is completed.
.SH \fBNote\fP
If the flow is "trivial" (consisting only of an ImportClient and an ExportBucket), the \fInum_samples\fP fields in the ImportClient and ExportBucket are ignored and a write past the end of the bucket will result in an \fBAuBadLength\fP error.
.SH \fBErrors\fP
\fBAuBadFlow\fP,
\fBAuBadElement\fP,
\fBAuBadValue\fP,
\fBAuBadLength\fP.
.SH \fBSee Also\fP
\fBAuReadElement\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
