#!/bin/sh
# 
# Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# This code is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 only, as
# published by the Free Software Foundation.
# 
# This code is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# version 2 for more details (a copy is included in the LICENSE file that
# accompanied this code).
# 
# You should have received a copy of the GNU General Public License version
# 2 along with this work; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
# 
# Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
# or visit www.oracle.com if you need additional information or have any
# questions.
# 
# 

##
## @test
## @bug 8011675
## @summary testing of ciReplay with using generated by VM replay.txt w/o comp_level
## @author igor.ignatyev@oracle.com
## @run shell TestVM_no_comp_level.sh
##

if [ "${TESTSRC}" = "" ]
then
  TESTSRC=${PWD}
  echo "TESTSRC not set.  Using "${TESTSRC}" as default"
fi
echo "TESTSRC=${TESTSRC}"

## Adding common setup Variables for running shell tests.
. ${TESTSRC}/../../test_env.sh

. ${TESTSRC}/common.sh

generate_replay

if [ ! -s ${replay_data} ]
then
    test_fail 1 "CHECK :: REPLAY DATA GENERATION" \
            "replay data wasn't generated by VM"
fi

${CP} ${replay_data} replay_vm.txt

sed 's/^\(compile *[^ ][^ ]* *[^ ][^ ]* [^ ][^ ]* [^ ][^ ]*\).*$/\1/' \
        replay_vm.txt > ${replay_data}

if [ $client_available -eq 1 ]
then
    # tiered is unavailable in client vm, so results w/ flags will be the same as w/o flags
    negative_test 10 "CLIENT" -client
fi

if [ $server_available -eq 1 ]
then
    positive_test 21 "SERVER :: NON-TIERED" -XX:-TieredCompilation -server
    positive_test 22 "SERVER :: TIERED" -XX:+TieredCompilation -server
fi

cleanup

echo TEST PASSED

