class DefaultOtherRouter:
    def allow_migrate(self, db, app_label, model_name=None, **hints):
        return db in {"default", "other"}


class TestRouter:
    def allow_migrate(self, db, app_label, model_name=None, **hints):
        """
        The Tribble model should be the only one to appear in the 'other' db.
        """
        if model_name == "tribble":
            return db == "other"
        elif db != "default":
            return False
