!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawxcdenm
!! NAME
!! pawxcdenm
!!
!! FUNCTION
!! PAW only
!! Prepare spherical density data before calling local or semi-local xc evaluators.
!! Can also compute the gradient of the density, for use with GGAs.
!! LDA +GGA - USE A DEVELOPMENT OF THE DENSITY OVER (L,M) MOMENTS
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  ngrad : =1, only compute the density ; =2 also compute the
!!      gradient of the density. Note : ngrad**2 is also used to dimension rhonow
!!  nrad= dimension of the radial mesh
!!  nspden=number of spin-density components
!!  rhor(nrad,nspden)=spherical real space electron density in electrons/bohr**3
!!                    (total in first half and spin-up in second half if nspden=2)
!!
!! OUTPUT
!!  rhonow(nrad,nspden,ngrad*ngrad)=electron (spin)-density in real space and
!!     eventually its gradient
!!    rhonow(:,:,1)=electron density in electrons/bohr**3
!!    if ngrad==2 : rhonow(:,:,2:4)=gradient of electron density in electrons/bohr**4
!!
!! PARENTS
!!      pawxcm
!!
!! CHILDREN
!!      leave_new,nderiv_gen,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawxcdenm(ngrad,nrad,nspden,pawrad,rhonow,rhor)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ngrad,nrad,nspden
 type(pawrad_type),intent(in) :: pawrad
!arrays
 real(dp),intent(in) :: rhor(nrad,nspden)
 real(dp),intent(out) :: rhonow(nrad,nspden,ngrad*ngrad)

!Local variables-------------------------------
!scalars
 integer :: ir,ispden
 character(len=500) :: message
!arrays
 real(dp),allocatable :: dff(:),ff(:)

! *************************************************************************

!DEBUG
!write(6,*)' pawxcdenm : enter '
!ENDDEBUG

 if (nspden/=1 .and. nspden/=2) then
  write(message, '(a,a,a,a,i12,a)' ) ch10,&
&   ' pawxcdenm: BUG -',ch10,&
&   '  nspden must be 1 or 2 ; input was',nspden,'.'
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if

 if (ngrad/=1 .and. ngrad/=2) then
  write(message, '(a,a,a,a,i12,a)' ) ch10,&
&   ' pawxcdenm: BUG -',ch10,&
&   '  ngrad must be 1 or 2 ; input was',ngrad,'.'
  call wrtout(06,message,'COLL')
  call leave_new('COLL')
 end if

!Calculation of the density
 do ispden=1,nspden
  rhonow(1:nrad,ispden,1)=rhor(1:nrad,ispden)/sqrt(four_pi)
 end do

!Calculation of the gradient of the density
 if (ngrad==2) then
  allocate(ff(nrad),dff(nrad))
  do ispden=1,nspden
!  Computation of the radial part only
   ff(1:nrad)=rhonow(1:nrad,ispden,1)
   call nderiv_gen(dff,ff,1,pawrad)
   rhonow(1:nrad,ispden,2)=dff(1:nrad)
  end do
  deallocate(ff,dff)
 end if

end subroutine pawxcdenm
!!***
