## About

dcm2niix is designed to convert complicated DICOM images in to simple NIfTI
images. However, the NIfTI images are unable to store much metadata that might
be useful for analyses. Therefore, dcm2niix can create Brain Imaging Data
Structure ([BIDS](https://bids.neuroimaging.io)) files that retain useful
information. These are simple human-readable text files in the
[JSON](https://en.wikipedia.org/wiki/JSON) format. The tables below provide
details regarding the JSON fields generated by dcm2niix. Some of these are
defined by the BIDS standard, while others are unique to dcm2niix.

Note that dcm2niix cannot provide information that is not in the DICOM
header. Common reasons for absent fields are:

 - Irrelevance to the scan type, e.g. MagneticFieldStrength for CT
 - It was removed from the DICOM during anonymization, possibly by accident or overzealousness
 - Difficulty interpreting the storage format used by the manufacturer
 - The manufacturer simply neglected to write it

### Formatting Note
The units listed in this document can be extracted into JSON format using
```./extract_units.py```, as long as they are in tables where the first two columns
are Field and Unit. It can also optionally extract only the units that are used
in a given BIDS sidecar - e.g. if you have a BIDS sidecar file named
```my_series.json``` from dcm2niix, you can use ```extract_units.py``` to get
```my_series_units.json```.

Help on using ```extract_units.py``` is available from running ```extract_units.py -h```.

### Glossary
The Defined By column uses:

- B : The [BIDS](https://bids.neuroimaging.io) standard
- D : dcm2niix (often, but not always, these come directly from the DICOM header without transformation)

The Unit column uses:

- b : boolean
- deg : degrees
- f : fraction
- kg : Kilogram
- list : list of text strings
- MBq : megabecquerel
- MHz : megahertz
- mA : milliampere
- mm : millimeter
- s : second
- T : tesla
- V : volt

## Global Fields

These fields are present regardless of modality (e.g. MR, CT, PET).

### Global Constants

These fields should be the same for all images acquired on a specific scanner.

| Field                       | Unit | Comments             | Defined By |
|-----------------------------|------|----------------------|------------|
| Manufacturer                |      | DICOM tag 0008,0070  | B          |
| DeviceSerialNumber          |      | DICOM tag 0018,1000  | B          |
| StationName                 |      | DICOM tag 0008,1010  | B          |
| SoftwareVersions            |      | DICOM tag 0018,1020  | B          |
| Modality                    |      | DICOM tag 0008,1060  | D          |
| ManufacturersModelName      |      | DICOM tag 0008,1090  | B          |
| InstitutionName             |      | DICOM tag 0008,0080  | B          |
| InstitutionalDepartmentName |      | DICOM tag 0008,1040  | B          |
| InstitutionAddress          |      | DICOM tag 0008,0081  | B          |
| DeviceSerialNumber          |      | DICOM tag 0018,1000  | B          |
| StationName                 |      | DICOM tag 0008,1010  | B          |
| ConversionSoftware          |      | e.g. `dcm2niix`      | D          |
| ConversionSoftwareVersion   |      | e.g. `v1.0.20210317` | D          |

### Global Series Information

These fields are present regardless of modality (e.g. MR, CT, PET).

| Field                    | Unit | Comments            | Defined By |
|--------------------------|------|---------------------|------------|
| BodyPart                 |      | DICOM tag 0018,0015 | B          |
| PatientPosition          |      | DICOM tag 0020,0032 | D          |
| ProcedureStepDescription |      | DICOM tag 0040,0254 | D          |
| SoftwareVersions         |      | DICOM tag 0020,1020 | B          |
| StudyDescription         |      | DICOM tag 0008,1030 | D          |
| SeriesDescription        |      | DICOM tag 0008,103E | D          |
| ProtocolName             |      | DICOM tag 0018,1030 | D          |
| ScanningSequence         |      | DICOM tag 0018,0020 | B          |
| SequenceVariant          |      | DICOM tag 0018,0021 | B          |
| ScanOptions              |      | DICOM tag 0018,0022 | B          |
| SequenceName             |      | DICOM tag 0018,0024 | B          |
| ImageType                | list | DICOM tag 0008,0008 | D          |
| AcquisitionTime          |      | DICOM tag 0008,0032 | D          |
| AcquisitionNumber        |      | DICOM tag 0020,0012 | D          |
| ImageComments            |      | DICOM tag 0020,4000 | D          |

### Global Private Information

These fields contain personally identifiable information. By default dcm2niix will create anonymized files without these fields. The option `-ba n` will retain private information.

| Field                  | Unit | Comments            | Defined By |
|------------------------|------|---------------------|------------|
| SeriesInstanceUID      |      | DICOM tag 0020,000E | D          |
| StudyInstanceUID       |      | DICOM tag 0020,000D | D          |
| ReferringPhysicianName |      | DICOM tag 0008,0090 | D          |
| StudyID                |      | DICOM tag 0020,0010 | D          |
| PatientName            |      | DICOM tag 0010,0010 | D          |
| PatientID              |      | DICOM tag 0010,0020 | D          |
| AccessionNumber        |      | DICOM tag 0008,0050 | D          |
| PatientBirthDate       |      | DICOM tag 0010,0030 | D          |
| PatientSex             |      | DICOM tag 0010,0040 | D          |
| PatientAge             |      | DICOM tag 0010,1010 | D          |
| PatientSize            |      | DICOM tag 0010,1020 | D          |
| PatientWeight          | kg   | DICOM tag 0010,1030 | D          |
| AcquisitionDateTime    |      | DICOM tag 0008,002A | D          |

## Modality Fields

These fields are specific to modality (e.g. MR, CT, PET).


### Modality Computerized Tomography

Fields specific to CT scans.

| Field           | Unit | Comments            | Defined By |
|-----------------|------|---------------------|------------|
| ExposureTime    | s    | DICOM tag 0018,1150 | D          |
| XRayTubeCurrent | mA   | DICOM tag 0018,1151 | D          |
| XRayExposure    | mAs  | DICOM tag 0018,1152 | D          |

### Modality Magnetic Resonance Imaging

Fields specific to MRI scans.

| Field                              | Unit | Comments                                                                                | Defined By |
|------------------------------------|------|-----------------------------------------------------------------------------------------|------------|
| AcquisitionMatrixPE                |      | DICOM tag 0018,9231 (aka PhaseEncodingLines)                                            | D          |
| DerivedVendorReportedEchoSpacing   | s    |                                                                                         | D          |
| EchoNumber                         |      | Only multi-echo series                                                                  | D          |
| EchoTime                           | s    | DICOM tag 0018,0081                                                                     | B          |
| EchoTrainLength                    |      | DICOM tag 0018,0091                                                                     | D          |
| EffectiveEchoSpacing               | s    |                                                                                         | D          |
| EstimatedEffectiveEchoSpacing      | s    |                                                                                         | D          |
| EstimatedTotalReadoutTime          | s    |                                                                                         | D          |
| FlipAngle                          | deg  | DICOM tag 0018,1314                                                                     | B          |
| VariableFlipAngleFlag              | b    | DICOM tag 0018,1315                                                                     | D          |
| ImageOrientationPatientDICOM       |      | DICOM tag 0020,0037                                                                     | D          |
| ImagingFrequency                   | MHz  | DICOM tag 0018,0084 or 0018,9098                                                        | D          |
| InPlanePhaseEncodingDirectionDICOM |      | DICOM tag 0018,1312                                                                     | D          |
| InversionTime                      | s    | DICOM tag 0018,0082                                                                     | B          |
| MagneticFieldStrength              | T    | DICOM tag 0018,0087                                                                     | B          |
| MRAcquisitionType                  |      | DICOM tag 0018,0023                                                                     | B          |
| MTState                            |      | 0018,9020                                                                               | B          |
| MultibandAccelerationFactor        |      | aka `SMS`, `HyperBand`                                                                  | B          |
| NumberOfAverages                   |      | DICOM tag 0018,0083                                                                     | D          |
| ParallelAcquisitionTechnique       |      | DICOM tag 0018, 9078, aka `SENSE`, `GRAPPA`                                             | B          |
| ParallelReductionFactorInPlane     |      | DICOM tag 0018,9069                                                                     | B          |
| ParallelReductionFactorOutOfPlane  |      | DICOM tag 0018,9155                                                                     | B          |
| PartialFourierDirection            |      | DICOM tag 0018,9036                                                                     | B          |
| PercentPhaseFOV                    |      | DICOM tag 0018,0094                                                                     | D          |
| PercentSampling                    |      | DICOM tag 0018,0093                                                                     | D          |
| PhaseEncodingAxis                  |      | When polarity unknown                                                                   | B          |
| PhaseEncodingDirection             |      | When polarity known                                                                     | B          |
| FrequencyEncodingSteps             |      | DICOM tag 0018,9058                                                        | D          |
| PhaseEncodingSteps                 |      | DICOM tag 0018,0089 or 0018,9231 aka PhaseEncodingStepsInPlane                          | D          |
| PhaseEncodingStepsOutOfPlane       |      | DICOM tag 0018,9232                                                        | D          |
| PixelBandwidth                     | Hz   | DICOM tag 0018,0095                                                                     | D          |
| ReceiveCoilName                    |      | DICOM tag 0018,1250                                                                     | B          |
| RepetitionTime                     | s    | DICOM tag 0018,0080                                                                     | B          |
| RepetitionTimeExcitation           | s    | DICOM tag 0018, 0080 for some manufacturers                                             | B          |
| RepetitionTimeInversion            | s    |                                                                                         | D          |
| SAR                                |      | DICOM tag 0018,1316 or 0018,9181 defined by 0018,9179                                   | D          |
| SliceThickness                     | mm   | [nb](http://dclunie.blogspot.com/2013/10/how-thick-am-i-sad-story-of-lonely-slice.html) | D          |
| SliceTiming                        | s    |                                                                                         | B          |
| SpacingBetweenSlices               | mm   | [nb](http://dclunie.blogspot.com/2013/10/how-thick-am-i-sad-story-of-lonely-slice.html) | D          |
| SpoilingState                      |      | 0018,9016 or 0018,0021                                                                  | B          |
| SpoilingType                       |      | 0018,9016                                                                               | B          |
| TotalReadoutTime                   | s    | [FSL definition](https://www.jiscmail.ac.uk/cgi-bin/webadmin?A2=fsl;d2c47aa4.1606)      | B          |
| Units                              |      | `Hz`,`rad` (field maps)                                                                 | B          |

### Modality Positron Emission Tomography

PET fields extracted from [DICOM tags](http://dicom.nema.org/medical/dicom/current/output/chtml/part03/sect_C.8.9.2.html). See BIDS [BEP009 Positron Emission Tomography](https://bids-specification.readthedocs.io/en/v1.2.1/06-extensions.html). Be aware that many of the fields required by BEP009 are not stored in DICOM or ECAT files. Since dcm2niix is limited to the information provided by the input files, it will generate JSON fields that reflect the meta data stored in the source images.

The term ECAT in the comments suggests that values are defined by the [ECAT7](http://www.turkupetcentre.net/petanalysis/format_image_ecat.html) format. Therefore, these fields will not be populated for DICOM data.

| Field                        | Unit | Comments                         | Defined By |
|------------------------------|------|----------------------------------|------------|
| IsotopeHalfLife              |      | ECAT                             | D          |
| Dosage                       |      | ECAT                             | D          |
| FrameTimesStart              | s    | DICOM tag 0008,0022              | B          |
| TracerRadionuclide           |      | DICOM tag 0008,0100 or 0008,0104 | B          |
| Radiopharmaceutical          |      | DICOM tag 0018,0031 or ECAT      | D          |
| InjectedRadioactivity        | MBq  | DICOM tag 0018,1074              | B          |
| RadionuclideHalfLife         | s    | DICOM tag 0018,1075              | D          |
| RadionuclidePositronFraction | f    | DICOM tag 0018,1076              | D          |
| ConvolutionKernel            |      | DICOM tag 0018,1210              | D          |
| Units                        |      | DICOM tag 0054,1001              | B          |
| AttenuationCorrectionMethod  |      | DICOM tag 0054,1101              | B          |
| DecayCorrection              |      | DICOM tag 0054,1102              | D          |
| ReconstructionMethod         |      | DICOM tag 0054,1103              | B          |
| DecayCorrectionFactor        |      | DICOM tag 0054,1321              | B          |
| DoseCalibrationFactor        |      | DICOM tag 0054,1322              | B          |
| ScatterFraction              |      | DICOM tag 0054,1323              | B          |
| FrameDuration                | s    | DICOM tag 0018,1242              | B          |

n.b. ConvolutionKernel (0018,1210) can be parsed to BIDS `ReconFilterType` and `ReconFilterSize`. However, manufacturer variations (Siemens: `XYZGAUSSIAN3.00` GE `Rad: \ rectangle \  4.000000 mm  \ Ax: \ rectangle \  8.500000 mm` require complex logic).

n.b. ReconstructionMethod (0054,1103) can be parsed to ReconMethodName, ReconMethodParameterLabels, ReconMethodParameterUnits and ReconMethodParameterValues. However, this requires maniufacturer specific logic (e.g. Siemens `OP-OSEM4i21s`, GE `3D Kinahan - Rogers`

For Philips scanners, [Source Isotope Name](https://dicom.innolitics.com/ciods/rt-brachy-treatment-record/rt-brachy-session-record/30080100/300a0226) may be a good source for TracerRadionuclide

## Manufacturer Fields

These fields are specific to manufacturer (e.g. GE, Philips, Siemens). For further manufacturer details see:

 - [Canon (Toshiba)](https://github.com/rordenlab/dcm2niix/tree/master/Canon)
 - [GE](https://github.com/rordenlab/dcm2niix/tree/master/GE)
 - [Philips](https://github.com/rordenlab/dcm2niix/tree/master/Philips)
 - [Siemens](https://github.com/rordenlab/dcm2niix/tree/master/Siemens)
 - [UIH](https://github.com/rordenlab/dcm2niix/tree/master/UIH)

### Manufacturer General Electric

Data unique to [GE](https://github.com/rordenlab/dcm2niix/tree/master/GE). Determining these fields from a DICOM image requires decoding the compressed Protocol Data Block (0025,101B).

| Field                          | Unit | Comments                 | Defined By |
|--------------------------------|------|--------------------------|------------|
| PulseSequenceName              |      | `epi` or `epiRT`         | D          |
| InternalPulseSequenceName      |      | `EPI` or `EPI2`          | D          |
| PhaseEncodingPolarityGE        |      | `Unflipped` or `Flipped` | D          |
| PostLabelingDelay              | s    | DICOM tag 0018,0082 (TI) | B          |
| NumberOfPointsPerArm           |      | DICOM tag 0027,1060      | D          |
| NumberOfArms                   |      | DICOM tag 0027,1061      | D          |
| NumberOfExcitations            |      | DICOM tag 0027,1062      | D          |
| ShimSetting[0]                 |      | DICOM tag 0043,1002      | D          |
| ShimSetting[1]                 |      | DICOM tag 0043,1003      | D          |
| ShimSetting[2]                 |      | DICOM tag 0043,1004      | D          |
| ParallelReductionFactorInPlane |      | DICOM tag 0043,1083      | B          |
| PrescanReuseString             |      | DICOM tag 0043,1095      | D          |
| MultibandAccelerationFactor    |      | DICOM tag 0043,1083      | B          |
| ASLContrastTechnique           |      | DICOM tag 0043,10A3      | D          |
| ASLLabelingTechnique           |      | DICOM tag 0043,10A4      | D          |
| LabelingDuration               | s    | DICOM tag 0043,10A5      | B          |
| SliceTiming                    | s    | [see notes](https://github.com/rordenlab/dcm2niix/tree/master/GE#slice-timing)  | B          |
| CompressedSensingFactor        |      | DICOM tag 0043,10B7      | D          |
| TablePosition                  | mm   | The 3rd value of DICOM tag 0043,10B2 - the value of DICOM tag 0019,107F    | B          |
| DeepLearningFactor             |      | DICOM tag 0043,10CA      | D          |

### Manufacturer GE (Positron Emission Tomography)

[GE Private Tags](https://www.gehealthcare.com/-/jssmedia/b86f641ae0bd4a7b919c79215e5c01e7)

| Field                              | Unit | Comments              | Defined By |
|------------------------------------|------|-----------------------|------------|
| InjectedVolume                     |      | DICOM tag 0009,103A   | B          |
| ReconFilterSize                    |      | DICOM tag 0009,108F   | B          |

### Manufacturer Philips

Data unique to Philips, including [custom intensity scaling](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3998685/)

| Field                              | Unit | Comments                         | Defined By |
|------------------------------------|------|----------------------------------|------------|
| TriggerDelayTime                   | s    | DICOM tag 0020,9153 or 0018,1060 | D          |
| PhilipsRWVSlope                    |      | DICOM tag 0040,9225              | D          |
| PhilipsRWVIntercept                |      | DICOM tag 0040,9224              | D          |
| PhilipsRescaleSlope                |      | DICOM tag 0028,1053              | D          |
| PhilipsRescaleIntercept            |      | DICOM tag 0028,1052              | D          |
| UsePhilipsFloatNotDisplayScaling   |      | dcm2niix option `-p y` or `-p n` | D          |
| PartialFourierEnabled              |      | DICOM tag 0018,9081, `YES`       | D          |
| PhaseEncodingStepsNoPartialFourier |      | DICOM tag 0018,9231              | D          |
| WaterFatShift                      |      | DICOM tag 2001,1022              | D          |
| PhilipsScaleSlope                  |      | DICOM tag 2005,100E              | D          |
| TablePosition                      | mm   | DICOM tag 2005,143C              | B          |

### Manufacturer Siemens (Arterial Spin Labeling)

See BIDS [BEP005 Arterial Spin
Labeling](https://bids-specification.readthedocs.io/en/v1.2.1/06-extensions.html). All these values are specific to Siemens V*-series (e.g. VB, VE) MRI systems (e.g. Verio, Trio, Prisma) from the [CSA header](https://nipy.org/nibabel/dicom/siemens_csa.html).
Note that [many of the fields listed by BIDS](https://bids-specification.readthedocs.io/en/stable/04-modality-specific-files/01-magnetic-resonance-imaging-data.html#_asljson-file
) do not have DICOM equivalents.

| Field                           | Unit               | Comments                                                                                                                                                                                       | Defined By |
|---------------------------------|--------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|
| ArterialSpinLabelingType        |                    | `PASL` or `PCASL`                                                                                                                                                                              | B          |
| LabelOffset                     |                    | 2D pCASL [ep2d_pcasl](http://www.loft-lab.org)                                                                                                                                                 | D          |
| PostLabelingDelay               | s                  | 2D pCASL [ep2d_pcasl](http://www.loft-lab.org), [FAIREST](https://pubmed.ncbi.nlm.nih.gov/11746944/) (`ep2d_fairest`)                                                                          | B          |
| PostInversionDelay              | s                  | 2D [FAIREST](https://pubmed.ncbi.nlm.nih.gov/11746944/) (`ep2d_fairest`)                                                                                                                       | D          |
| NumRFBlocks                     |                    | 2D pCASL [ep2d_pcasl](http://www.loft-lab.org)                                                                                                                                                 | D          |
| RFGap                           |                    | 2,3D pCASL [ep2d_pcasl, tgse_pcasl](http://www.loft-lab.org)                                                                                                                                   | D          |
| MeanGzx10                       |                    | 2,3D pCASL [ep2d_pcasl, tgse_pcasl](http://www.loft-lab.org)                                                                                                                                   | D          |
| PhiAdjust                       |                    | 2D pCASL [ep2d_pcasl](http://www.loft-lab.org)                                                                                                                                                 | D          |
| InversionTime                   | s                  | 2D,3D PASL product (`ep2d_pasl`, `tgse_pasl`), [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                            | D          |
| BolusDuration                   | s                  | 2D,3D PASL product (`ep2d_pasl`, `tgse_pasl`), [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                            | D          |
| MeanGzx10                       |                    | 3D pCASL [tgse_pcasl](http://www.loft-lab.org)                                                                                                                                                 | D          |
| TagRFFlipAngle                  | deg                | 2,3D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`, `jw_tgse_VEPCASL`)                                                                                   | D          |
| TagRFDuration                   | s                  | 2,3D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`, `jw_tgse_VEPCASL`)                                                                                   | D          |
| TagRFSeparation                 |                    | 2,3D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`, `jw_tgse_VEPCASL`)                                                                                   | D          |
| MeanTagGradient                 |                    | 2D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                                                                        | D          |
| TagGradientAmplitude            |                    | 2D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                                                                        | D          |
| TagDuration                     | s                  | 2D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                                                                        | D          |
| MaximumT1Opt                    |                    | 2,3D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`, `jw_tgse_VEPCASL`)                                                                                   | D          |
| InitialPostLabelDelay           | s                  | 2D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                                                                        | D          |
| sWipMemBlockAdFree*             | multiple values    | 2D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                                                                        | D          |
| TagPlaneDThickness              |                    | 2D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                                                                        | D          |
| TagPlaneUlShape                 |                    | 2D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                                                                        | D          |
| TagPlaneSPositionDTra           |                    | 2D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                                                                        | D          |
| TagPlaneSNormalDTra             |                    | 2D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`to_ep2d_VEPCASL`)                                                                                                        | D          |
| Tag* (if not explicitly listed) | One value for each | [Post-label delays](https://fsl.fmrib.ox.ac.uk/fslcourse/lectures/practicals/ASLpractical/index.html), 3D [VEPCASL](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3824178/) (`jw_tgse_VEPCASL`) | D          |

### Manufacturer Siemens Magnetic Resonance Imaging (V*)

Fields specific to Siemens V*-series (e.g. VB, VE) MRI systems (e.g. Verio, Trio, Skyra, Prisma) from the [CSA header](https://nipy.org/nibabel/dicom/siemens_csa.html).

| Field                          | Unit                                            | Comments                                                                                                                                                                                                                                                                                                                                                                                               | Defined By |
|--------------------------------|-------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|
| EchoTime1                      | s                                               | For Fieldmaps created with two echo times                                                                                                                                                                                                                                                                                                                                                              | B          |
| EchoTime2                      | s                                               | For Fieldmaps created with two echo times                                                                                                                                                                                                                                                                                                                                                              | B          |
| PartialFourier                 | f                                               | Partial fourier fraction, e.g. image with 6/8 pF will report `0.75`. Different tags depending on manufacturer                                                                                                                                                                                                                                                                                          | B          |
| Interpolation2D                |                                                 | If present, slices interpolated within plane                                                                                                                                                                                                                                                                                                                                                           | D          |
| Interpolation3D                |                                                 | If present, image interpolated in all spatial dimensions                                                                                                                                                                                                                                                                                                                                               | D          |
| BaseResolution                 | integer                                         | # of acquisition lines?                                                                                                                                                                                                                                                                                                                                                                                | D          |
| ShimSetting                    | DAC for 1st order terms, mA for 2nd order terms | The 1st 3 values are the 1st order shims from sGRADSPEC.lOffset{X,Y,Z}. The next 5 are 2nd order shims from sGRADSPEC.alShimCurrent[0-4]. Converting to the first order terms to uT/m may be possible using the "gradient sensitivities". Converting the second order terms to uT/m^2 requires information not stored in the DICOM header, but they are fixed for a given shim hardware configuration. | D          |
| DiffusionScheme                |                                                 | `Monopolar` or `Bipolar`                                                                                                                                                                                                                                                                                                                                                                               | D          |
| DelayTime                      | s                                               | Pause between EPI volumes, where TR is longer than required by TA (`sparse` imaging)                                                                                                                                                                                                                                                                                                                   | D          |
| TxRefAmp                       | V                                               |                                                                                                                                                                                                                                                                                                                                                                                                        | D          |
| ParallelReductionFactorInPlane |                                                 | DICOM tag 0021,1009                                                                                                                                                                                                                                                                                                                                                                                    | B          |
| ParallelReductionFactorOutOfPlane |                                              | CSA `sPat.lAccelFact3D`                                                                                                                                                                                                                                                                                                                                                                                | B          |
| PhaseResolution                | f                                               |                                                                                                                                                                                                                                                                                                                                                                                                        | D          |
| PhaseOversampling              |                                                 |                                                                                                                                                                                                                                                                                                                                                                                                        | D          |
| MultibandAccelerationFactor    |                                                 | DICOM tag 0021,1009                                                                                                                                                                                                                                                                                                                                                                                    | B          |
| VendorReportedEchoSpacing      |                                                 |                                                                                                                                                                                                                                                                                                                                                                                                        | B          |
| ReceiveCoilActiveElements      |                                                 | Given as groups of channels, instead of individual ones, e.g. "HC1-7" for HeadNeck\_64.                                                                                                                                                                                                                                                                                                                | B          |
| CoilString                     |                                                 | May or may not match `ReceiveCoilName`                                                                                                                                                                                                                                                                                                                                                                 | D          |
| PulseSequenceDetails           |                                                 | pulse sequence label, e.g. "%SiemensSeq%\\\\tgse\_pasl"                                                                                                                                                                                                                                                                                                                                                | B          |
| FmriExternalInfo               |                                                 |                                                                                                                                                                                                                                                                                                                                                                                                        | D          |
| WipMemBlock                    |                                                 |                                                                                                                                                                                                                                                                                                                                                                                                        | D          |
| AveragesDouble                 |                                                 | CSA `dAveragesDouble`, fractions possible, independent of DICOM `NumberOfAverages` (0018,0083)                                                                                                                                                                                                                                                                                                         | D          |
| ProtocolName                   |                                                 | Check SeriesDescription - they might be switched around                                                                                                                                                                                                                                                                                                                                                | D          |
| RefLinesPE                     |                                                 | # of reference lines in the phase encoding direction for acceleration (GRAPPA)                                                                                                                                                                                                                                                                                                                         | D          |
| ConsistencyInfo                |                                                 | The more complete software version, e.g. VE11C or VE11E instead of just VE11.                                                                                                                                                                                                                                                                                                                          | D          |
| CoilCombinationMethod          |                                                 | Detects `Sum of Squares` and `Adaptive Combine`                                                                                                                                                                                                                                                                                                                                                        | B          |
| MatrixCoilMode                 |                                                 | Detects `SENSE` and `GRAPPA`                                                                                                                                                                                                                                                                                                                                                                           | B          |
| TablePosition                  | mm                                              | DICOM tag 0019,1014                                                                                                                                                                                                                                                                                                                                                                                    | B          |
| DwellTime                      |                                                 | DICOM tag 0019,1018                                                                                                                                                                                                                                                                                                                                                                                    | B          |
| BandwidthPerPixelPhaseEncode   | Hz                                              | DICOM tag 0019,1028                                                                                                                                                                                                                                                                                                                                                                                    | D          |
| ImageOrientationText           |                                                 | DICOM tag 0051,100E                                                                                                                                                                                                                                                                                                                                                                                    | D          |
| NonlinearGradientCorrection    | b                                               | DICOM tag 0008,0008                                                                                                                                                                                                                                                                                                                                                                                    | B          |

### Manufacturer Siemens Magnetic Resonance Imaging (XA)

Fields specific to [Siemens XA-series](https://github.com/rordenlab/dcm2niix/tree/master/Siemens#siemens-x-series) MRI systems (Sola, Vida).

| Field                        | Unit | Comments                   | Defined By |
|------------------------------|------|----------------------------|------------|
| ReceiveCoilActiveElements    |      | DICOM tag 0021,114F        | B          |
| BandwidthPerPixelPhaseEncode | Hz   | DICOM tag 0021,1153        | D          |
| ScanningSequence             |      | DICOM tag 0021,105a        | D          |
| PostLabelingDelay            | s    | DICOM tag 0018,9258        | B          |
| TablePosition                | mm   | DICOM tag 0021,1005        | B          |
| NonlinearGradientCorrection  | b    | 0008,0008 or 0021,1175     | B          |
| PhaseEncodingDirection       |      | polarity from 0021,111c    | B          |
| SpoilingState                |      | DICOM tag 0021,105B        | B          |

Siemens also includes some sequence information in the private MRPhoenixProtocol (0021,1019) tag. You can view this with [gdcmdump](https://gdcm.sourceforge.net/html/gdcmdump.html), e.g. `gdcmdump --mrprotocol img.dcm`. Fields that dcm2niix inspects include `sPat.lAccelFact3D `, `sPat.lAccelFactPE`, `sPat.lRefLinesPE` and `sPat.ucPATMode`. The behavior of dcm2niix will be more well documented as our understanding of this tag improves.

### Manufacturer UIH

Fields specific to United Imaging Healthcare systems (e.g. uMR 770).

| Field                          | Unit | Comments                 | Defined By |
|--------------------------------|------|--------------------------|------------|
| BandwidthPerPixelPhaseEncode   | Hz   | DICOM tag 0019,1028      | B          |
| ParallelReductionFactorInPlane |      | DICOM tag 0065,100D      | B          |

### Notes

 - Prior to v1.0.20230411, dcm2niix created the internal tag `PostLabelDelay`, subsequent versions use the newly introduced BIDS tag `PostLabelingDelay`