# Deluge 2.0 release notes

Welcome to the latest release of Deluge, a long time in the making!

## What's new

Some of the highlights since the last major release.

- Migrated to Python 3 with minimal support retained for Python 2.7.
- Shiny new logo.
- Multi-user support.
- Performance updates to handle thousands of torrents with faster loading times.
- A New Console UI which emulates GTK/Web UIs.
- GTK UI migrated to GTK3 with UI improvements and additions.
- Magnet pre-fetching to allow file selection when adding torrent.
- Fully support libtorrent 1.2 release.
- Language switching support.
- Improved documentation hosted on ReadTheDocs.
- AutoAdd plugin replaces built-in functionality.
- Web UI now daemonizes by default so service scripts will require `-d` option.

## Packaging

### PyPi

As well as the usual source tarball available for [download] we now have published
Deluge on the PyPi software repository.

- <https://pypi.org/project/deluge/>

### Windows and MacOS

Unfortunately there are no packages yet for [Windows] or MacOS but they are being worked
on. For now alternative [install] methods are available for testing.

## Upgrade considerations

Deluge 2.0 is not compatible with Deluge 1.x clients or daemons so these will require
upgrading too. Also third-party Python scripts may not be compatible if they directly
connect to the Deluge client and will need migrating.

Always make a backup of your [config] before a major version upgrade to guard against
data loss.

Translations may not be as up-to date so please help out, see [translations] page.

Plugins written for Deluge 1.3 will need upgrading for Deluge 2.0, due to the
requirement of Python 3 and GTK3 UI. There is a [update plugin] document to help
Plugin authors update their plugins.

[update plugin]: ../devguide/how-to/update-1.3-plugin.md
[windows]: https://dev.deluge-torrent.org/ticket/3201
[install]: https://deluge.readthedocs.io/en/latest/intro/01-install.html
[config]: https://dev.deluge-torrent.org/wiki/Faq#WheredoesDelugestoreitssettingsconfig
[translations]: ../contributing/translations.md
[download]: http://download.deluge-torrent.org/source/2.0/
