if {0} {

  /*
    * This file is part of din.
    *
    * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
    * For more information, please visit http://dinisnoise.org
    *
    * din is free software: you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation, either version 2 of the License, or
    * (at your option) any later version.
    *
    * din is distributed in the hope that it will be useful, but WITHOUT
    * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    * for more details.
    *
    * You should have received a copy of the GNU General Public License along
    * with din.  If not, see <http://www.gnu.org/licenses/>.
    *
  */

}

set start $timenow

;# defaults
set duration 5 ;# change every 5 seconds
set changes {+5 -5} ;# change key up a 5th then down a 5th ie back to tonic
set index -1

proc loop {} { ;# called once per audio loop

  global timenow start
  global changes duration
  global index

  if {($timenow - $start) > $duration} { ;# time to change

    set len [llength $changes]

    incr index
    if {$index >= $len} {
      set index 0
    }

    set change [lindex $changes $index] ;# pick the index'th change
    set dir [string index $change 0] ;# what is the direction? + is go up, - is go down
    set amount [string range $change 1 end] ;# amount to change - this is interval variable defined in din

    global $amount ;# interval variables are defined in global namespace

    if {$dir eq "+"} { ;# change up
      key [expr [key value] * [set $amount]] ;# changed key
    } elseif {$dir eq "-"} { ;# change down
      set val [set $amount]
      if {$val != 0} { ;# to avoid / by 0
        key [expr [key value] / [set $amount]] ;# changed key
      }
    }
    set start $timenow ;# prep for next change
    echo "changed by $dir$amount to reach [key value] hz / [key note]" ;# inform key change to user
  }
}
