/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __levels
#define __levels

#include "ui.h"
#include "box.h"

#include <string>
#include <vector>

struct levels : ui {

  std::string name; // name of this control

  void load (); // load settings
  void save (); // save settings

  // gui vars
  box<int> bbox;
  int elem_width;
  int height;
  bool hover;

  int nlev; // number of levels
  int lastlev;

  int lev; // edited level
  float val; // edited val
  int hgt; // edited height

  bool moving; // moving this control?

  bool editing; // editing individual elements?
  int editable; // is control editable?
  bool edited; // values edited?

  int saveable; // levels saved on quit?

  std::vector<float> values; // 0 to 1 for each level
  std::vector<int> heights; // 0 to height

  levels (const std::string& s);
  ~levels ();

  bool handle_input ();

  // color
  float r, g, b;
  float a, a0;

  void draw ();

  void clear ();
  void calc ();
  void set (int i, float v, int h = -1);

  void chkpos ();

};

#endif
