/*
 * Entagged Audio Tag library
 * Copyright (c) 2003-2005 Raphal Slinckx <raphael@slinckx.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *  
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package entagged.audioformats.ogg.util;


/**
 *  $Id: OggCRCFactory.java,v 1.1 2007/03/23 14:17:53 nicov1 Exp $
 *
 * @author     Raphael Slinckx (KiKiDonK)
 * @version    19 d�cembre 2003
 */
public class OggCRCFactory {

	private static long[] crc_lookup = new long[256];
	private static boolean init = false;


	public static void init() {
		for ( int i = 0; i < 256; i++ ) {
			long r = i << 24;

			for ( int j = 0; j < 8; j++ )
				if ( ( r & 0x80000000L ) != 0 )
					r = ( r << 1 ) ^ 0x04c11db7L;
				else
					r <<= 1;

			crc_lookup[i] = ( r & 0xffffffff );
		}
		init = true;
	}


	public boolean checkCRC( byte[] data, byte[] crc ) {
		return new String( crc ).equals( new String( computeCRC( data ) ) );
	}

	public static byte[] computeCRC( byte[] data ) {
		//System.err.println(data.length);
		
		if(!init)
			init();
		
		long crc_reg = 0;

		for ( int i = 0; i < data.length; i++ ) {
			int tmp = (int) ( ( ( crc_reg >>> 24 ) & 0xff ) ^ u( data[i] ) );

			crc_reg = ( crc_reg << 8 ) ^ crc_lookup[tmp];
			crc_reg &= 0xffffffff;
		}

		byte[] sum = new byte[4];

		sum[0] = (byte) ( crc_reg & 0xffL );
		sum[1] = (byte) ( ( crc_reg >>> 8 ) & 0xffL );
		sum[2] = (byte) ( ( crc_reg >>> 16 ) & 0xffL );
		sum[3] = (byte) ( ( crc_reg >>> 24 ) & 0xffL );

		return sum;
	}


	private static int u( int n ) {
		return n & 0xff ;
	}
}

