'''OpenGL extension IBM.cull_vertex

This module customises the behaviour of the 
OpenGL.raw.GL.IBM.cull_vertex to provide a more 
Python-friendly API

Overview (from the spec)
	
	IBM_cull_vertex provides a subset of the vertex culling functionality
	found in EXT_cull_vertex without providing a guarantee that faces will
	be culled because of it.  EXT_cull_vertex is a technically superior
	solution, but the vertex culling aspect of IBM_cull_vertex provides
	generally useful function cheaply (without imposing the mandated
	culling found in EXT_cull_vertex).

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/IBM/cull_vertex.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.IBM.cull_vertex import *
from OpenGL.raw.GL.IBM.cull_vertex import _EXTENSION_NAME

def glInitCullVertexIBM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION