/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TIRAGE_H
#define TIRAGE_H

#include "calcul.h"

#include <map>
#include <vector>

class tirage {
  public :
	map<plaque, int> tab; //tableau des plaques

	static int nb_plaques;
	static int compte_minimal;
	static int compte_maximal;
	static map<plaque, int> ref;	//liste des plaques autorises
	void utiliser_comme_ref();	//init des plaques autorises

	int taille() const;
	bool est_valable();
	int coefficient() const;		//indique le coef d'un tirage, ie 2^n o n est le nombre de
						//plaquettes du tirage non doubles et diffrentes de 25,50,75,100
	bool operator!=(const tirage&) const;
	bool operator==(const tirage&) const;
	bool operator<(const tirage&) const;
	bool inclus_dans(tirage) const;
	tirage operator+(const tirage&) const;
	
	//renvoie vecteur des sous-tirages tris dans un ordre "intressant"
	vector<tirage> calcul_sous_tirages() const;
	
	//renvoie l'entier correspondant au rang o se trouve un tirage dans un vecteur de tirage
	int trouve_dans(const vector<tirage>&) const;
};

ostream& operator<<(ostream& ostr, const tirage& t);		//affichage d'un tirage
ostream& operator<<(ostream& ostr, const vector<tirage>& v);	//affichage d'un vecteur de tirages

typedef vector<int> pseudo_tirage;		//un pseudo-tirage est un choix de 6 nb entiers parmi [0;23]

list<pseudo_tirage> cree_liste_pseudo();	//cre les 134596 pseudo-tirages diffrents

tirage pseudo_en_tirage(pseudo_tirage);		//transforme un pseudo-tirage en tirage

set<tirage> tous_les_tirages();			//cre les 13243 tirages diffrents

//fonctions utilises dans widgetprincipal.cpp, pour manipuler les plaques
plaque plus_petite_plaque_sup(tirage,plaque);
plaque plus_petite_plaque_inf(tirage,plaque);
plaque augmente_plaque(plaque);
plaque diminue_plaque(plaque);

#endif
