package org.jboss.cache.notifications.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation should be used on methods that need to be notified when a buddy group changes.
 * <p/>
 * Methods annotated with this annotation should be public and take in a single parameter, a {@link org.jboss.cache.notifications.event.BuddyGroupChangedEvent}
 * otherwise an {@link org.jboss.cache.notifications.IncorrectCacheListenerException} will be thrown when registering
 * your cache listener.
 * <p/>
 * This call back only occurs when a buddy group structure is changed.  In a cache setup where buddy replication is not
 * enabled, this call back would never occur.
 * <p/>
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @see CacheListener
 * @see org.jboss.cache.notifications.event.CacheBlockedEvent
 * @since 2.1.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface BuddyGroupChanged
{
}
