/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.optimistic;

import java.io.Serializable;

/**
 * When versioning data nodes in optimistic locking, a DataVersion is assigned
 * to each node.  Versions need to implement the {@link #newerThan} method so
 * they can be compared during the validation phase upon commit.
 * <p/>
 * It is recommended that implementations implement {@link java.io.Externalizable} and make use
 * of a good marshalling/unmarshalling mechanism for the sake of efficiency, as these objects are
 * frequently serialized to be replicated across the wire.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani (manik@jboss.org)</a>
 */
public interface DataVersion extends Serializable
{
   /**
    * Returns true if this is a newer version than <code>other</code>.  There is no guarantee that the DataVersion passed
    * in is of the same implementation as the current instance.  The implementation will have to check for this (if necessary)
    * and (if necessary) throw a {@link org.jboss.cache.optimistic.DataVersioningException}.
    */
   boolean newerThan(DataVersion other);
}
