package org.jboss.cache.passivation;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.LocalDelegatingCacheLoaderConfig;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/**
 * Runs a test against using delegated cache loader
 *
 * @author <a href="mailto:{hmesha@novell.com}">{Hany Mesha}</a>
 * @version $Id: PassivationToLocalDelegatingCacheLoaderTest.java 5103 2008-01-09 11:52:25Z manik.surtani@jboss.com $
 */
@Test(groups = "functional")
public class PassivationToLocalDelegatingCacheLoaderTest extends PassivationTestsBase
{
   CacheSPI delegating_cache;
   CacheLoader cache_loader;

   protected void configureCache() throws Exception
   {
      delegating_cache = (CacheSPI) new DefaultCacheFactory().createCache(false);
      delegating_cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
      delegating_cache.create();
      delegating_cache.start();

      LocalDelegatingCacheLoaderConfig cfg = new LocalDelegatingCacheLoaderConfig();
      cfg.setDelegate(delegating_cache);
      cfg.setAsync(false);
      cfg.setFetchPersistentState(false);
      CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
      cacheLoaderConfig.addIndividualCacheLoaderConfig(cfg);
      cacheLoaderConfig.setPassivation(true);
      cache.getConfiguration().setCacheLoaderConfig(cacheLoaderConfig);
   }

   @AfterMethod(alwaysRun = true)
   public void tearDown() throws Exception
   {
      super.tearDown();
      delegating_cache.stop();
      delegating_cache.destroy();
   }

   public void testLoadAndStore() throws Exception
   {
      //TODO intentional overload since this test does not pass
      //http://jira.jboss.com/jira/browse/JBCACHE-851
   }

}
