/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.kml;

import org.boehn.kmlframework.kml.ColorModeEnum;
import org.boehn.kmlframework.kml.ColorStyle;
import org.boehn.kmlframework.kml.Kml;
import org.boehn.kmlframework.kml.KmlException;

public class PolyStyle
extends ColorStyle {
    private Boolean fill;
    private Boolean outline;

    public PolyStyle() {
    }

    public PolyStyle(String color, ColorModeEnum colorMode, Boolean fill, Boolean outline) {
        super(color, colorMode);
        this.fill = fill;
        this.outline = outline;
    }

    public Boolean getFill() {
        return this.fill;
    }

    public void setFill(Boolean fill) {
        this.fill = fill;
    }

    public Boolean getOutline() {
        return this.outline;
    }

    public void setOutline(Boolean outline) {
        this.outline = outline;
    }

    public void write(Kml kml) throws KmlException {
        kml.println("<PolyStyle" + this.getIdAndTargetIdFormatted(kml) + ">", 1);
        super.writeInner(kml);
        if (this.fill != null) {
            kml.println("<fill>" + PolyStyle.booleanToInt(this.fill) + "</fill>");
        }
        if (this.outline != null) {
            kml.println("<outline>" + PolyStyle.booleanToInt(this.outline) + "</outline>");
        }
        kml.println(-1, "</PolyStyle>");
    }

    public void writeDelete(Kml kml) throws KmlException {
        kml.println("<PolyStyle" + this.getIdAndTargetIdFormatted(kml) + "></>");
    }
}

