/*
 * $Id: SparkController.java,v 1.3 2007-03-11 20:40:58 larry Exp $
 */
package com.representqueens.spark.service;

/*
 * 
 * Copyright 2007 Larry Ogrodnek
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import java.awt.image.BufferedImage;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.representqueens.spark.BarGraph;
import com.representqueens.spark.LineGraph;
import com.representqueens.spark.SizeParams;
import com.representqueens.spark.util.StringConversion;
import com.representqueens.util.StringUtils;

/**
 * @author Larry Ogrodnek <larry@cheesesteak.net>
 * @version $Revision: 1.3 $ $Date: 2007-03-11 20:40:58 $
 */
public final class SparkController extends HttpServlet
{
  @Override
  public void doGet(final HttpServletRequest request,
                    final HttpServletResponse response) throws IOException
  {
    final Number[] data = StringConversion.getData(request.getParameter("data"));

    final String type = request.getParameter("type");

    final BufferedImage image;

    if (type != null && type.equals("line"))
    {
      image = LineGraph.createGraph(data,
                                    getSizeParams(request, LineGraph.DEFAULT_SIZE),
                                    StringConversion.convertColor(request.getParameter("color"), LineGraph.DEFAULT_COLOR),
                                    StringConversion.convertColor(request.getParameter("background"), null));
    }
    else
    {
      image = BarGraph.createGraph(data,
                                   getSizeParams(request, BarGraph.DEFAULT_SIZE),
                                   StringConversion.convertColor(request.getParameter("color"), BarGraph.DEFAULT_COLOR),
                                   StringConversion.convertColor(request.getParameter("highcolor"), null),
                                   StringConversion.convertColor(request.getParameter("lastcolor"), null),
                                   StringConversion.convertColor(request.getParameter("background"), null));
    }
    
    
    
    final String _output = request.getParameter("output");
    
    final String output = StringUtils.isEmpty(_output) ? "png" : _output;
    
    response.setContentType("image/" + output);
    ImageIO.write(image, output, response.getOutputStream());
    response.getOutputStream().close();
  }


  @Override
  public void doPut(final HttpServletRequest request,
                    final HttpServletResponse response) throws IOException
  {
    doGet(request, response);
  }
  
  private static SizeParams getSizeParams(final HttpServletRequest request,
                                  final SizeParams defaults)
  {
    return new SizeParams(StringConversion.convertInt(request.getParameter("width"), defaults.getWidth()),
                          StringConversion.convertInt(request.getParameter("height"), defaults.getHeight()),
                          StringConversion.convertInt(request.getParameter("spacing"), defaults.getSpacing()));
  }
}
