/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

/*
 * TestReferencePanel.java
 *
 * Created on Dec 8, 2010, 12:43:35 AM
 */

package org.netbeans.modules.cnd.modelui.trace;

/**
 *
 * @author vv159170
 */
public class TestReferencePanel extends javax.swing.JPanel {

    /** Creates new form TestReferencePanel */
    public TestReferencePanel(int threads, long threshold, boolean hasSlowInfo) {
        initComponents();
        threadsField.setText(Integer.toString(threads));
        thresholdField.setText(Long.toString(Math.abs(threshold)));
        btnCollect.setSelected(threshold >= 0);
        btnUseFiles.setSelected(hasSlowInfo && threshold < 0);
        btnUseFiles.setEnabled(hasSlowInfo);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        threadsField = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        btnUseFiles = new javax.swing.JRadioButton();
        btnCollect = new javax.swing.JRadioButton();
        jLabel2 = new javax.swing.JLabel();
        thresholdField = new javax.swing.JTextField();

        jLabel1.setLabelFor(threadsField);
        jLabel1.setText(org.openide.util.NbBundle.getMessage(TestReferencePanel.class, "TestReferencePanel.jLabel1.text")); // NOI18N

        threadsField.setText(org.openide.util.NbBundle.getMessage(TestReferencePanel.class, "TestReferencePanel.threadsField.text")); // NOI18N

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(TestReferencePanel.class, "TestReferencePanel.jPanel1.border.title"))); // NOI18N

        buttonGroup1.add(btnUseFiles);
        btnUseFiles.setText(org.openide.util.NbBundle.getMessage(TestReferencePanel.class, "TestReferencePanel.btnUseFiles.text")); // NOI18N

        buttonGroup1.add(btnCollect);
        btnCollect.setSelected(true);
        btnCollect.setText(org.openide.util.NbBundle.getMessage(TestReferencePanel.class, "TestReferencePanel.btnCollect.text")); // NOI18N

        jLabel2.setLabelFor(thresholdField);
        jLabel2.setText(org.openide.util.NbBundle.getMessage(TestReferencePanel.class, "TestReferencePanel.jLabel2.text")); // NOI18N

        thresholdField.setText(org.openide.util.NbBundle.getMessage(TestReferencePanel.class, "TestReferencePanel.thresholdField.text")); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(btnCollect)
                    .addComponent(btnUseFiles)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(thresholdField, javax.swing.GroupLayout.DEFAULT_SIZE, 266, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(btnCollect)
                .addGap(2, 2, 2)
                .addComponent(btnUseFiles)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(thresholdField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 70, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(threadsField, javax.swing.GroupLayout.DEFAULT_SIZE, 367, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(threadsField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(8, 8, 8)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton btnCollect;
    private javax.swing.JRadioButton btnUseFiles;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTextField threadsField;
    private javax.swing.JTextField thresholdField;
    // End of variables declaration//GEN-END:variables

    boolean isCollecting() {
        return btnCollect.isSelected();
    }

    long getThreshold() {
        long out = -1;
        try {
            out = Long.parseLong(thresholdField.getText());
        } catch (NumberFormatException e) {
            
        }
        return Math.abs(out);
    }
    
    int getThreadsNumber() {
        int numThreads = 1;
        try {
            numThreads = Integer.parseInt(threadsField.getText());
        } catch (NumberFormatException ex) {
        }
        return numThreads;
    }
    
}
