/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.trans.XPathException;

public class Serializer
implements Destination {
    private Map<Property, String> properties = new HashMap<Property, String>(10);
    private StreamResult result = new StreamResult();
    private boolean mustClose = false;

    public void setOutputProperty(Property property, String value) {
        try {
            SaxonOutputKeys.checkOutputProperty(property.toString(), value, null);
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (value == null) {
            this.properties.remove((Object)property);
        } else {
            this.properties.put(property, value);
        }
    }

    public String getOutputProperty(Property property) {
        return this.properties.get((Object)property);
    }

    public void setOutputWriter(Writer writer) {
        this.result.setOutputStream(null);
        this.result.setSystemId((String)null);
        this.result.setWriter(writer);
        this.mustClose = false;
    }

    public void setOutputStream(OutputStream stream) {
        this.result.setWriter(null);
        this.result.setSystemId((String)null);
        this.result.setOutputStream(stream);
        this.mustClose = false;
    }

    public void setOutputFile(File file) {
        this.result.setOutputStream(null);
        this.result.setWriter(null);
        this.result.setSystemId(file);
        this.mustClose = true;
    }

    public Object getOutputDestination() {
        if (this.result.getOutputStream() != null) {
            return this.result.getOutputStream();
        }
        if (this.result.getWriter() != null) {
            return this.result.getWriter();
        }
        String systemId = this.result.getSystemId();
        if (systemId != null) {
            try {
                return new File(new URI(systemId));
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        return this.getReceiver(config, null, null);
    }

    protected Receiver getReceiver(Configuration config, Controller controller, Properties predefinedProperties) throws SaxonApiException {
        try {
            String value;
            SerializerFactory sf = config.getSerializerFactory();
            PipelineConfiguration pipe = controller == null ? config.makePipelineConfiguration() : controller.makePipelineConfiguration();
            Properties props = new Properties();
            for (Property p : this.properties.keySet()) {
                value = this.properties.get((Object)p);
                props.setProperty(p.toString(), value);
            }
            if (predefinedProperties != null) {
                Enumeration<?> eps = predefinedProperties.propertyNames();
                while (eps.hasMoreElements()) {
                    String name = (String)eps.nextElement();
                    value = predefinedProperties.getProperty(name);
                    if (props.getProperty(name) == null) {
                        props.setProperty(name, value);
                        continue;
                    }
                    if (!name.equals("cdata-section-elements") && !name.equals("{http://saxon.sf.net/}suppress-indentation")) continue;
                    props.setProperty(name, props.getProperty(name) + " " + value);
                }
            }
            return sf.getReceiver(this.result, pipe, props);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public void close() throws SaxonApiException {
        if (this.mustClose) {
            Writer writer;
            OutputStream stream = this.result.getOutputStream();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException err) {
                    throw new SaxonApiException("Failed while closing output file", err);
                }
            }
            if ((writer = this.result.getWriter()) != null) {
                try {
                    writer.close();
                }
                catch (IOException err) {
                    throw new SaxonApiException("Failed while closing output file", err);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        METHOD("method"),
        VERSION("version"),
        ENCODING("encoding"),
        OMIT_XML_DECLARATION("omit-xml-declaration"),
        STANDALONE("standalone"),
        DOCTYPE_PUBLIC("doctype-public"),
        DOCTYPE_SYSTEM("doctype-system"),
        CDATA_SECTION_ELEMENTS("cdata-section-elements"),
        INDENT("indent"),
        MEDIA_TYPE("media-type"),
        USE_CHARACTER_MAPS("use-character-maps"),
        INCLUDE_CONTENT_TYPE("include-content-type"),
        UNDECLARE_PREFIXES("undeclare-prefixes"),
        ESCAPE_URI_ATTRIBUTES("escape-uri-attributes"),
        BYTE_ORDER_MARK("byte-order-mark"),
        NORMALIZATION_FORM("normalization-form"),
        SAXON_INDENT_SPACES("{http://saxon.sf.net/}indent-spaces"),
        SAXON_SUPPRESS_INDENTATION("{http://saxon.sf.net/}suppress-indentation"),
        SAXON_DOUBLE_SPACE("{http://saxon.sf.net/}double-space"),
        SAXON_STYLESHEET_VERSION("{http://saxon.sf.net/}stylesheet-version"),
        SAXON_CHARACTER_REPRESENTATION("{http://saxon.sf.net/}character-representation"),
        SAXON_NEXT_IN_CHAIN("{http://saxon.sf.net/}next-in-chain"),
        SAXON_NEXT_IN_CHAIN_BASE_URI("{http://saxon.sf.net/}next-in-chain-base-uri"),
        SAXON_RECOGNIZE_BINARY("{http://saxon.sf.net/}recognize-binary"),
        SAXON_REQUIRE_WELL_FORMED("{http://saxon.sf.net/}require-well-formed"),
        SAXON_WRAP("{http://saxon.sf.net/}wrap-result-sequence"),
        SAXON_IMPLICIT_RESULT_DOCUMENT("{http://saxon.sf.net/}implicit-result-document"),
        SAXON_SUPPLY_SOURCE_LOCATOR("{http://saxon.sf.net/}supply-source-locator");

        private String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

