#region License
//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2009 the Open Toolkit library.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to 
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
#endregion

using System;

namespace OpenTK.Graphics.OpenGL
{
    #pragma warning disable 1591

    public enum AccumOp : int
    {
        Accum = ((int)0x0100),
        Load = ((int)0x0101),
        Return = ((int)0x0102),
        Mult = ((int)0x0103),
        Add = ((int)0x0104),
    }

    public enum ActiveAttribType : int
    {
        Float = ((int)0x1406),
        FloatVec2 = ((int)0x8B50),
        FloatVec3 = ((int)0x8B51),
        FloatVec4 = ((int)0x8B52),
        FloatMat2 = ((int)0x8B5A),
        FloatMat3 = ((int)0x8B5B),
        FloatMat4 = ((int)0x8B5C),
    }

    public enum ActiveUniformBlockParameter : int
    {
        UniformBlockBinding = ((int)0x8A3F),
        UniformBlockDataSize = ((int)0x8A40),
        UniformBlockNameLength = ((int)0x8A41),
        UniformBlockActiveUniforms = ((int)0x8A42),
        UniformBlockActiveUniformIndices = ((int)0x8A43),
        UniformBlockReferencedByVertexShader = ((int)0x8A44),
        UniformBlockReferencedByFragmentShader = ((int)0x8A46),
    }

    public enum ActiveUniformParameter : int
    {
        UniformType = ((int)0x8A37),
        UniformSize = ((int)0x8A38),
        UniformNameLength = ((int)0x8A39),
        UniformBlockIndex = ((int)0x8A3A),
        UniformOffset = ((int)0x8A3B),
        UniformArrayStride = ((int)0x8A3C),
        UniformMatrixStride = ((int)0x8A3D),
        UniformIsRowMajor = ((int)0x8A3E),
    }

    public enum ActiveUniformType : int
    {
        Int = ((int)0x1404),
        Float = ((int)0x1406),
        FloatVec2 = ((int)0x8B50),
        FloatVec3 = ((int)0x8B51),
        FloatVec4 = ((int)0x8B52),
        IntVec2 = ((int)0x8B53),
        IntVec3 = ((int)0x8B54),
        IntVec4 = ((int)0x8B55),
        Bool = ((int)0x8B56),
        BoolVec2 = ((int)0x8B57),
        BoolVec3 = ((int)0x8B58),
        BoolVec4 = ((int)0x8B59),
        FloatMat2 = ((int)0x8B5A),
        FloatMat3 = ((int)0x8B5B),
        FloatMat4 = ((int)0x8B5C),
        Sampler1D = ((int)0x8B5D),
        Sampler2D = ((int)0x8B5E),
        Sampler3D = ((int)0x8B5F),
        SamplerCube = ((int)0x8B60),
        Sampler1DShadow = ((int)0x8B61),
        Sampler2DShadow = ((int)0x8B62),
        Sampler2DRect = ((int)0x8B63),
        Sampler2DRectShadow = ((int)0x8B64),
        FloatMat2x3 = ((int)0x8B65),
        FloatMat2x4 = ((int)0x8B66),
        FloatMat3x2 = ((int)0x8B67),
        FloatMat3x4 = ((int)0x8B68),
        FloatMat4x2 = ((int)0x8B69),
        FloatMat4x3 = ((int)0x8B6A),
        Sampler1DArray = ((int)0x8DC0),
        Sampler2DArray = ((int)0x8DC1),
        SamplerBuffer = ((int)0x8DC2),
        Sampler1DArrayShadow = ((int)0x8DC3),
        Sampler2DArrayShadow = ((int)0x8DC4),
        SamplerCubeShadow = ((int)0x8DC5),
        UnsignedIntVec2 = ((int)0x8DC6),
        UnsignedIntVec3 = ((int)0x8DC7),
        UnsignedIntVec4 = ((int)0x8DC8),
        IntSampler1D = ((int)0x8DC9),
        IntSampler2D = ((int)0x8DCA),
        IntSampler3D = ((int)0x8DCB),
        IntSamplerCube = ((int)0x8DCC),
        IntSampler2DRect = ((int)0x8DCD),
        IntSampler1DArray = ((int)0x8DCE),
        IntSampler2DArray = ((int)0x8DCF),
        IntSamplerBuffer = ((int)0x8DD0),
        UnsignedIntSampler1D = ((int)0x8DD1),
        UnsignedIntSampler2D = ((int)0x8DD2),
        UnsignedIntSampler3D = ((int)0x8DD3),
        UnsignedIntSamplerCube = ((int)0x8DD4),
        UnsignedIntSampler2DRect = ((int)0x8DD5),
        UnsignedIntSampler1DArray = ((int)0x8DD6),
        UnsignedIntSampler2DArray = ((int)0x8DD7),
        UnsignedIntSamplerBuffer = ((int)0x8DD8),
        Sampler2DMultisample = ((int)0x9108),
        IntSampler2DMultisample = ((int)0x9109),
        UnsignedIntSampler2DMultisample = ((int)0x910A),
        Sampler2DMultisampleArray = ((int)0x910B),
        IntSampler2DMultisampleArray = ((int)0x910C),
        UnsignedIntSampler2DMultisampleArray = ((int)0x910D),
    }

    public enum All : int
    {
        False = ((int)0),
        NoError = ((int)0),
        None = ((int)0),
        Zero = ((int)0),
        Points = ((int)0x0000),
        ClientPixelStoreBit = ((int)0x00000001),
        ContextCoreProfileBit = ((int)0x00000001),
        CurrentBit = ((int)0x00000001),
        Gl2XBitAti = ((int)0x00000001),
        RedBitAti = ((int)0x00000001),
        SyncFlushCommandsBit = ((int)0x00000001),
        TextureDeformationBitSgix = ((int)0x00000001),
        ClientVertexArrayBit = ((int)0x00000002),
        CompBitAti = ((int)0x00000002),
        ContextCompatibilityProfileBit = ((int)0x00000002),
        GeometryDeformationBitSgix = ((int)0x00000002),
        Gl4XBitAti = ((int)0x00000002),
        GreenBitAti = ((int)0x00000002),
        PointBit = ((int)0x00000002),
        BlueBitAti = ((int)0x00000004),
        Gl8XBitAti = ((int)0x00000004),
        LineBit = ((int)0x00000004),
        NegateBitAti = ((int)0x00000004),
        Vertex23BitPgi = ((int)0x00000004),
        BiasBitAti = ((int)0x00000008),
        HalfBitAti = ((int)0x00000008),
        PolygonBit = ((int)0x00000008),
        Vertex4BitPgi = ((int)0x00000008),
        PolygonStippleBit = ((int)0x00000010),
        QuarterBitAti = ((int)0x00000010),
        EighthBitAti = ((int)0x00000020),
        PixelModeBit = ((int)0x00000020),
        LightingBit = ((int)0x00000040),
        SaturateBitAti = ((int)0x00000040),
        FogBit = ((int)0x00000080),
        DepthBufferBit = ((int)0x00000100),
        AccumBufferBit = ((int)0x00000200),
        StencilBufferBit = ((int)0x00000400),
        ViewportBit = ((int)0x00000800),
        TransformBit = ((int)0x00001000),
        EnableBit = ((int)0x00002000),
        ColorBufferBit = ((int)0x00004000),
        HintBit = ((int)0x00008000),
        ContextFlagForwardCompatibleBit = ((int)0x0001),
        Lines = ((int)0x0001),
        MapReadBit = ((int)0x0001),
        RestartSun = ((int)0x0001),
        Color3BitPgi = ((int)0x00010000),
        EvalBit = ((int)0x00010000),
        LineLoop = ((int)0x0002),
        MapWriteBit = ((int)0x0002),
        ReplaceMiddleSun = ((int)0x0002),
        Color4BitPgi = ((int)0x00020000),
        ListBit = ((int)0x00020000),
        LineStrip = ((int)0x0003),
        ReplaceOldestSun = ((int)0x0003),
        MapInvalidateRangeBit = ((int)0x0004),
        Triangles = ((int)0x0004),
        EdgeflagBitPgi = ((int)0x00040000),
        TextureBit = ((int)0x00040000),
        TriangleStrip = ((int)0x0005),
        TriangleFan = ((int)0x0006),
        Quads = ((int)0x0007),
        MapInvalidateBufferBit = ((int)0x0008),
        QuadStrip = ((int)0x0008),
        IndexBitPgi = ((int)0x00080000),
        ScissorBit = ((int)0x00080000),
        Polygon = ((int)0x0009),
        LinesAdjacency = ((int)0x000A),
        LinesAdjacencyArb = ((int)0x000A),
        LinesAdjacencyExt = ((int)0x000A),
        LineStripAdjacency = ((int)0x000B),
        LineStripAdjacencyArb = ((int)0x000B),
        LineStripAdjacencyExt = ((int)0x000B),
        TrianglesAdjacency = ((int)0x000C),
        TrianglesAdjacencyArb = ((int)0x000C),
        TrianglesAdjacencyExt = ((int)0x000C),
        TriangleStripAdjacency = ((int)0x000D),
        TriangleStripAdjacencyArb = ((int)0x000D),
        TriangleStripAdjacencyExt = ((int)0x000D),
        MapFlushExplicitBit = ((int)0x0010),
        MatAmbientBitPgi = ((int)0x00100000),
        MapUnsynchronizedBit = ((int)0x0020),
        MatAmbientAndDiffuseBitPgi = ((int)0x00200000),
        MatDiffuseBitPgi = ((int)0x00400000),
        MatEmissionBitPgi = ((int)0x00800000),
        Accum = ((int)0x0100),
        MatColorIndexesBitPgi = ((int)0x01000000),
        Load = ((int)0x0101),
        Return = ((int)0x0102),
        Mult = ((int)0x0103),
        Add = ((int)0x0104),
        Never = ((int)0x0200),
        MatShininessBitPgi = ((int)0x02000000),
        Less = ((int)0x0201),
        Equal = ((int)0x0202),
        Lequal = ((int)0x0203),
        Greater = ((int)0x0204),
        Notequal = ((int)0x0205),
        Gequal = ((int)0x0206),
        Always = ((int)0x0207),
        SrcColor = ((int)0x0300),
        OneMinusSrcColor = ((int)0x0301),
        SrcAlpha = ((int)0x0302),
        OneMinusSrcAlpha = ((int)0x0303),
        DstAlpha = ((int)0x0304),
        OneMinusDstAlpha = ((int)0x0305),
        DstColor = ((int)0x0306),
        OneMinusDstColor = ((int)0x0307),
        SrcAlphaSaturate = ((int)0x0308),
        FrontLeft = ((int)0x0400),
        MatSpecularBitPgi = ((int)0x04000000),
        FrontRight = ((int)0x0401),
        BackLeft = ((int)0x0402),
        BackRight = ((int)0x0403),
        Front = ((int)0x0404),
        Back = ((int)0x0405),
        Left = ((int)0x0406),
        Right = ((int)0x0407),
        FrontAndBack = ((int)0x0408),
        Aux0 = ((int)0x0409),
        Aux1 = ((int)0x040A),
        Aux2 = ((int)0x040B),
        Aux3 = ((int)0x040C),
        InvalidEnum = ((int)0x0500),
        InvalidValue = ((int)0x0501),
        InvalidOperation = ((int)0x0502),
        StackOverflow = ((int)0x0503),
        StackUnderflow = ((int)0x0504),
        OutOfMemory = ((int)0x0505),
        InvalidFramebufferOperation = ((int)0x0506),
        InvalidFramebufferOperationExt = ((int)0x0506),
        Gl2D = ((int)0x0600),
        Gl3D = ((int)0x0601),
        Gl3DColor = ((int)0x0602),
        Gl3DColorTexture = ((int)0x0603),
        Gl4DColorTexture = ((int)0x0604),
        PassThroughToken = ((int)0x0700),
        PointToken = ((int)0x0701),
        LineToken = ((int)0x0702),
        PolygonToken = ((int)0x0703),
        BitmapToken = ((int)0x0704),
        DrawPixelToken = ((int)0x0705),
        CopyPixelToken = ((int)0x0706),
        LineResetToken = ((int)0x0707),
        Exp = ((int)0x0800),
        NormalBitPgi = ((int)0x08000000),
        Exp2 = ((int)0x0801),
        Cw = ((int)0x0900),
        Ccw = ((int)0x0901),
        Coeff = ((int)0x0A00),
        Order = ((int)0x0A01),
        Domain = ((int)0x0A02),
        CurrentColor = ((int)0x0B00),
        CurrentIndex = ((int)0x0B01),
        CurrentNormal = ((int)0x0B02),
        CurrentTextureCoords = ((int)0x0B03),
        CurrentRasterColor = ((int)0x0B04),
        CurrentRasterIndex = ((int)0x0B05),
        CurrentRasterTextureCoords = ((int)0x0B06),
        CurrentRasterPosition = ((int)0x0B07),
        CurrentRasterPositionValid = ((int)0x0B08),
        CurrentRasterDistance = ((int)0x0B09),
        PointSmooth = ((int)0x0B10),
        PointSize = ((int)0x0B11),
        PointSizeRange = ((int)0x0B12),
        SmoothPointSizeRange = ((int)0x0B12),
        PointSizeGranularity = ((int)0x0B13),
        SmoothPointSizeGranularity = ((int)0x0B13),
        LineSmooth = ((int)0x0B20),
        LineWidth = ((int)0x0B21),
        LineWidthRange = ((int)0x0B22),
        SmoothLineWidthRange = ((int)0x0B22),
        LineWidthGranularity = ((int)0x0B23),
        SmoothLineWidthGranularity = ((int)0x0B23),
        LineStipple = ((int)0x0B24),
        LineStipplePattern = ((int)0x0B25),
        LineStippleRepeat = ((int)0x0B26),
        ListMode = ((int)0x0B30),
        MaxListNesting = ((int)0x0B31),
        ListBase = ((int)0x0B32),
        ListIndex = ((int)0x0B33),
        PolygonMode = ((int)0x0B40),
        PolygonSmooth = ((int)0x0B41),
        PolygonStipple = ((int)0x0B42),
        EdgeFlag = ((int)0x0B43),
        CullFace = ((int)0x0B44),
        CullFaceMode = ((int)0x0B45),
        FrontFace = ((int)0x0B46),
        Lighting = ((int)0x0B50),
        LightModelLocalViewer = ((int)0x0B51),
        LightModelTwoSide = ((int)0x0B52),
        LightModelAmbient = ((int)0x0B53),
        ShadeModel = ((int)0x0B54),
        ColorMaterialFace = ((int)0x0B55),
        ColorMaterialParameter = ((int)0x0B56),
        ColorMaterial = ((int)0x0B57),
        Fog = ((int)0x0B60),
        FogIndex = ((int)0x0B61),
        FogDensity = ((int)0x0B62),
        FogStart = ((int)0x0B63),
        FogEnd = ((int)0x0B64),
        FogMode = ((int)0x0B65),
        FogColor = ((int)0x0B66),
        DepthRange = ((int)0x0B70),
        DepthTest = ((int)0x0B71),
        DepthWritemask = ((int)0x0B72),
        DepthClearValue = ((int)0x0B73),
        DepthFunc = ((int)0x0B74),
        AccumClearValue = ((int)0x0B80),
        StencilTest = ((int)0x0B90),
        StencilClearValue = ((int)0x0B91),
        StencilFunc = ((int)0x0B92),
        StencilValueMask = ((int)0x0B93),
        StencilFail = ((int)0x0B94),
        StencilPassDepthFail = ((int)0x0B95),
        StencilPassDepthPass = ((int)0x0B96),
        StencilRef = ((int)0x0B97),
        StencilWritemask = ((int)0x0B98),
        MatrixMode = ((int)0x0BA0),
        Normalize = ((int)0x0BA1),
        Viewport = ((int)0x0BA2),
        Modelview0StackDepthExt = ((int)0x0BA3),
        ModelviewStackDepth = ((int)0x0BA3),
        ProjectionStackDepth = ((int)0x0BA4),
        TextureStackDepth = ((int)0x0BA5),
        Modelview0MatrixExt = ((int)0x0BA6),
        ModelviewMatrix = ((int)0x0BA6),
        ProjectionMatrix = ((int)0x0BA7),
        TextureMatrix = ((int)0x0BA8),
        AttribStackDepth = ((int)0x0BB0),
        ClientAttribStackDepth = ((int)0x0BB1),
        AlphaTest = ((int)0x0BC0),
        AlphaTestFunc = ((int)0x0BC1),
        AlphaTestRef = ((int)0x0BC2),
        Dither = ((int)0x0BD0),
        BlendDst = ((int)0x0BE0),
        BlendSrc = ((int)0x0BE1),
        Blend = ((int)0x0BE2),
        LogicOpMode = ((int)0x0BF0),
        IndexLogicOp = ((int)0x0BF1),
        LogicOp = ((int)0x0BF1),
        ColorLogicOp = ((int)0x0BF2),
        AuxBuffers = ((int)0x0C00),
        DrawBuffer = ((int)0x0C01),
        ReadBuffer = ((int)0x0C02),
        ScissorBox = ((int)0x0C10),
        ScissorTest = ((int)0x0C11),
        IndexClearValue = ((int)0x0C20),
        IndexWritemask = ((int)0x0C21),
        ColorClearValue = ((int)0x0C22),
        ColorWritemask = ((int)0x0C23),
        IndexMode = ((int)0x0C30),
        RgbaMode = ((int)0x0C31),
        Doublebuffer = ((int)0x0C32),
        Stereo = ((int)0x0C33),
        RenderMode = ((int)0x0C40),
        PerspectiveCorrectionHint = ((int)0x0C50),
        PointSmoothHint = ((int)0x0C51),
        LineSmoothHint = ((int)0x0C52),
        PolygonSmoothHint = ((int)0x0C53),
        FogHint = ((int)0x0C54),
        TextureGenS = ((int)0x0C60),
        TextureGenT = ((int)0x0C61),
        TextureGenR = ((int)0x0C62),
        TextureGenQ = ((int)0x0C63),
        PixelMapIToI = ((int)0x0C70),
        PixelMapSToS = ((int)0x0C71),
        PixelMapIToR = ((int)0x0C72),
        PixelMapIToG = ((int)0x0C73),
        PixelMapIToB = ((int)0x0C74),
        PixelMapIToA = ((int)0x0C75),
        PixelMapRToR = ((int)0x0C76),
        PixelMapGToG = ((int)0x0C77),
        PixelMapBToB = ((int)0x0C78),
        PixelMapAToA = ((int)0x0C79),
        PixelMapIToISize = ((int)0x0CB0),
        PixelMapSToSSize = ((int)0x0CB1),
        PixelMapIToRSize = ((int)0x0CB2),
        PixelMapIToGSize = ((int)0x0CB3),
        PixelMapIToBSize = ((int)0x0CB4),
        PixelMapIToASize = ((int)0x0CB5),
        PixelMapRToRSize = ((int)0x0CB6),
        PixelMapGToGSize = ((int)0x0CB7),
        PixelMapBToBSize = ((int)0x0CB8),
        PixelMapAToASize = ((int)0x0CB9),
        UnpackSwapBytes = ((int)0x0CF0),
        UnpackLsbFirst = ((int)0x0CF1),
        UnpackRowLength = ((int)0x0CF2),
        UnpackSkipRows = ((int)0x0CF3),
        UnpackSkipPixels = ((int)0x0CF4),
        UnpackAlignment = ((int)0x0CF5),
        PackSwapBytes = ((int)0x0D00),
        PackLsbFirst = ((int)0x0D01),
        PackRowLength = ((int)0x0D02),
        PackSkipRows = ((int)0x0D03),
        PackSkipPixels = ((int)0x0D04),
        PackAlignment = ((int)0x0D05),
        MapColor = ((int)0x0D10),
        MapStencil = ((int)0x0D11),
        IndexShift = ((int)0x0D12),
        IndexOffset = ((int)0x0D13),
        RedScale = ((int)0x0D14),
        RedBias = ((int)0x0D15),
        ZoomX = ((int)0x0D16),
        ZoomY = ((int)0x0D17),
        GreenScale = ((int)0x0D18),
        GreenBias = ((int)0x0D19),
        BlueScale = ((int)0x0D1A),
        BlueBias = ((int)0x0D1B),
        AlphaScale = ((int)0x0D1C),
        AlphaBias = ((int)0x0D1D),
        DepthScale = ((int)0x0D1E),
        DepthBias = ((int)0x0D1F),
        MaxEvalOrder = ((int)0x0D30),
        MaxLights = ((int)0x0D31),
        MaxClipDistances = ((int)0x0D32),
        MaxClipPlanes = ((int)0x0D32),
        MaxTextureSize = ((int)0x0D33),
        MaxPixelMapTable = ((int)0x0D34),
        MaxAttribStackDepth = ((int)0x0D35),
        MaxModelviewStackDepth = ((int)0x0D36),
        MaxNameStackDepth = ((int)0x0D37),
        MaxProjectionStackDepth = ((int)0x0D38),
        MaxTextureStackDepth = ((int)0x0D39),
        MaxViewportDims = ((int)0x0D3A),
        MaxClientAttribStackDepth = ((int)0x0D3B),
        SubpixelBits = ((int)0x0D50),
        IndexBits = ((int)0x0D51),
        RedBits = ((int)0x0D52),
        GreenBits = ((int)0x0D53),
        BlueBits = ((int)0x0D54),
        AlphaBits = ((int)0x0D55),
        DepthBits = ((int)0x0D56),
        StencilBits = ((int)0x0D57),
        AccumRedBits = ((int)0x0D58),
        AccumGreenBits = ((int)0x0D59),
        AccumBlueBits = ((int)0x0D5A),
        AccumAlphaBits = ((int)0x0D5B),
        NameStackDepth = ((int)0x0D70),
        AutoNormal = ((int)0x0D80),
        Map1Color4 = ((int)0x0D90),
        Map1Index = ((int)0x0D91),
        Map1Normal = ((int)0x0D92),
        Map1TextureCoord1 = ((int)0x0D93),
        Map1TextureCoord2 = ((int)0x0D94),
        Map1TextureCoord3 = ((int)0x0D95),
        Map1TextureCoord4 = ((int)0x0D96),
        Map1Vertex3 = ((int)0x0D97),
        Map1Vertex4 = ((int)0x0D98),
        Map2Color4 = ((int)0x0DB0),
        Map2Index = ((int)0x0DB1),
        Map2Normal = ((int)0x0DB2),
        Map2TextureCoord1 = ((int)0x0DB3),
        Map2TextureCoord2 = ((int)0x0DB4),
        Map2TextureCoord3 = ((int)0x0DB5),
        Map2TextureCoord4 = ((int)0x0DB6),
        Map2Vertex3 = ((int)0x0DB7),
        Map2Vertex4 = ((int)0x0DB8),
        Map1GridDomain = ((int)0x0DD0),
        Map1GridSegments = ((int)0x0DD1),
        Map2GridDomain = ((int)0x0DD2),
        Map2GridSegments = ((int)0x0DD3),
        Texture1D = ((int)0x0DE0),
        Texture2D = ((int)0x0DE1),
        FeedbackBufferPointer = ((int)0x0DF0),
        FeedbackBufferSize = ((int)0x0DF1),
        FeedbackBufferType = ((int)0x0DF2),
        SelectionBufferPointer = ((int)0x0DF3),
        SelectionBufferSize = ((int)0x0DF4),
        TextureWidth = ((int)0x1000),
        Texcoord1BitPgi = ((int)0x10000000),
        TextureHeight = ((int)0x1001),
        TextureComponents = ((int)0x1003),
        TextureInternalFormat = ((int)0x1003),
        TextureBorderColor = ((int)0x1004),
        TextureBorder = ((int)0x1005),
        DontCare = ((int)0x1100),
        Fastest = ((int)0x1101),
        Nicest = ((int)0x1102),
        Ambient = ((int)0x1200),
        Diffuse = ((int)0x1201),
        Specular = ((int)0x1202),
        Position = ((int)0x1203),
        SpotDirection = ((int)0x1204),
        SpotExponent = ((int)0x1205),
        SpotCutoff = ((int)0x1206),
        ConstantAttenuation = ((int)0x1207),
        LinearAttenuation = ((int)0x1208),
        QuadraticAttenuation = ((int)0x1209),
        Compile = ((int)0x1300),
        CompileAndExecute = ((int)0x1301),
        Byte = ((int)0x1400),
        UnsignedByte = ((int)0x1401),
        Short = ((int)0x1402),
        UnsignedShort = ((int)0x1403),
        Int = ((int)0x1404),
        UnsignedInt = ((int)0x1405),
        Float = ((int)0x1406),
        Gl2Bytes = ((int)0x1407),
        Gl3Bytes = ((int)0x1408),
        Gl4Bytes = ((int)0x1409),
        Double = ((int)0x140A),
        DoubleExt = ((int)0x140A),
        HalfApple = ((int)0x140B),
        HalfFloat = ((int)0x140B),
        HalfFloatArb = ((int)0x140B),
        HalfFloatNv = ((int)0x140B),
        Clear = ((int)0x1500),
        And = ((int)0x1501),
        AndReverse = ((int)0x1502),
        Copy = ((int)0x1503),
        AndInverted = ((int)0x1504),
        Noop = ((int)0x1505),
        Xor = ((int)0x1506),
        Or = ((int)0x1507),
        Nor = ((int)0x1508),
        Equiv = ((int)0x1509),
        Invert = ((int)0x150A),
        OrReverse = ((int)0x150B),
        CopyInverted = ((int)0x150C),
        OrInverted = ((int)0x150D),
        Nand = ((int)0x150E),
        Set = ((int)0x150F),
        Emission = ((int)0x1600),
        Shininess = ((int)0x1601),
        AmbientAndDiffuse = ((int)0x1602),
        ColorIndexes = ((int)0x1603),
        Modelview = ((int)0x1700),
        Modelview0Arb = ((int)0x1700),
        Modelview0Ext = ((int)0x1700),
        Projection = ((int)0x1701),
        Texture = ((int)0x1702),
        Color = ((int)0x1800),
        Depth = ((int)0x1801),
        Stencil = ((int)0x1802),
        ColorIndex = ((int)0x1900),
        StencilIndex = ((int)0x1901),
        DepthComponent = ((int)0x1902),
        Red = ((int)0x1903),
        Green = ((int)0x1904),
        Blue = ((int)0x1905),
        Alpha = ((int)0x1906),
        Rgb = ((int)0x1907),
        Rgba = ((int)0x1908),
        Luminance = ((int)0x1909),
        LuminanceAlpha = ((int)0x190A),
        RasterPositionUnclippedIbm = ((int)0x19262),
        Bitmap = ((int)0x1A00),
        PreferDoublebufferHintPgi = ((int)0x1A1F8),
        ConserveMemoryHintPgi = ((int)0x1A1FD),
        ReclaimMemoryHintPgi = ((int)0x1A1FE),
        NativeGraphicsHandlePgi = ((int)0x1A202),
        NativeGraphicsBeginHintPgi = ((int)0x1A203),
        NativeGraphicsEndHintPgi = ((int)0x1A204),
        AlwaysFastHintPgi = ((int)0x1A20C),
        AlwaysSoftHintPgi = ((int)0x1A20D),
        AllowDrawObjHintPgi = ((int)0x1A20E),
        AllowDrawWinHintPgi = ((int)0x1A20F),
        AllowDrawFrgHintPgi = ((int)0x1A210),
        AllowDrawMemHintPgi = ((int)0x1A211),
        StrictDepthfuncHintPgi = ((int)0x1A216),
        StrictLightingHintPgi = ((int)0x1A217),
        StrictScissorHintPgi = ((int)0x1A218),
        FullStippleHintPgi = ((int)0x1A219),
        ClipNearHintPgi = ((int)0x1A220),
        ClipFarHintPgi = ((int)0x1A221),
        WideLineHintPgi = ((int)0x1A222),
        BackNormalsHintPgi = ((int)0x1A223),
        VertexDataHintPgi = ((int)0x1A22A),
        VertexConsistentHintPgi = ((int)0x1A22B),
        MaterialSideHintPgi = ((int)0x1A22C),
        MaxVertexHintPgi = ((int)0x1A22D),
        Point = ((int)0x1B00),
        Line = ((int)0x1B01),
        Fill = ((int)0x1B02),
        Render = ((int)0x1C00),
        Feedback = ((int)0x1C01),
        Select = ((int)0x1C02),
        Flat = ((int)0x1D00),
        Smooth = ((int)0x1D01),
        Keep = ((int)0x1E00),
        Replace = ((int)0x1E01),
        Incr = ((int)0x1E02),
        Decr = ((int)0x1E03),
        Vendor = ((int)0x1F00),
        Renderer = ((int)0x1F01),
        Version = ((int)0x1F02),
        Extensions = ((int)0x1F03),
        S = ((int)0x2000),
        MultisampleBit = ((int)0x20000000),
        MultisampleBit3Dfx = ((int)0x20000000),
        MultisampleBitArb = ((int)0x20000000),
        MultisampleBitExt = ((int)0x20000000),
        Texcoord2BitPgi = ((int)0x20000000),
        T = ((int)0x2001),
        R = ((int)0x2002),
        Q = ((int)0x2003),
        Modulate = ((int)0x2100),
        Decal = ((int)0x2101),
        TextureEnvMode = ((int)0x2200),
        TextureEnvColor = ((int)0x2201),
        TextureEnv = ((int)0x2300),
        EyeLinear = ((int)0x2400),
        ObjectLinear = ((int)0x2401),
        SphereMap = ((int)0x2402),
        TextureGenMode = ((int)0x2500),
        ObjectPlane = ((int)0x2501),
        EyePlane = ((int)0x2502),
        Nearest = ((int)0x2600),
        Linear = ((int)0x2601),
        NearestMipmapNearest = ((int)0x2700),
        LinearMipmapNearest = ((int)0x2701),
        NearestMipmapLinear = ((int)0x2702),
        LinearMipmapLinear = ((int)0x2703),
        TextureMagFilter = ((int)0x2800),
        TextureMinFilter = ((int)0x2801),
        TextureWrapS = ((int)0x2802),
        TextureWrapT = ((int)0x2803),
        Clamp = ((int)0x2900),
        Repeat = ((int)0x2901),
        PolygonOffsetUnits = ((int)0x2A00),
        PolygonOffsetPoint = ((int)0x2A01),
        PolygonOffsetLine = ((int)0x2A02),
        R3G3B2 = ((int)0x2A10),
        V2f = ((int)0x2A20),
        V3f = ((int)0x2A21),
        C4ubV2f = ((int)0x2A22),
        C4ubV3f = ((int)0x2A23),
        C3fV3f = ((int)0x2A24),
        N3fV3f = ((int)0x2A25),
        C4fN3fV3f = ((int)0x2A26),
        T2fV3f = ((int)0x2A27),
        T4fV4f = ((int)0x2A28),
        T2fC4ubV3f = ((int)0x2A29),
        T2fC3fV3f = ((int)0x2A2A),
        T2fN3fV3f = ((int)0x2A2B),
        T2fC4fN3fV3f = ((int)0x2A2C),
        T4fC4fN3fV4f = ((int)0x2A2D),
        ClipDistance0 = ((int)0x3000),
        ClipPlane0 = ((int)0x3000),
        ClipDistance1 = ((int)0x3001),
        ClipPlane1 = ((int)0x3001),
        ClipDistance2 = ((int)0x3002),
        ClipPlane2 = ((int)0x3002),
        ClipDistance3 = ((int)0x3003),
        ClipPlane3 = ((int)0x3003),
        ClipDistance4 = ((int)0x3004),
        ClipPlane4 = ((int)0x3004),
        ClipDistance5 = ((int)0x3005),
        ClipPlane5 = ((int)0x3005),
        ClipDistance6 = ((int)0x3006),
        ClipDistance7 = ((int)0x3007),
        Light0 = ((int)0x4000),
        Texcoord3BitPgi = ((int)0x40000000),
        Light1 = ((int)0x4001),
        Light2 = ((int)0x4002),
        Light3 = ((int)0x4003),
        Light4 = ((int)0x4004),
        Light5 = ((int)0x4005),
        Light6 = ((int)0x4006),
        Light7 = ((int)0x4007),
        AbgrExt = ((int)0x8000),
        Texcoord4BitPgi = unchecked((int)0x80000000),
        ConstantColor = ((int)0x8001),
        ConstantColorExt = ((int)0x8001),
        OneMinusConstantColor = ((int)0x8002),
        OneMinusConstantColorExt = ((int)0x8002),
        ConstantAlpha = ((int)0x8003),
        ConstantAlphaExt = ((int)0x8003),
        OneMinusConstantAlpha = ((int)0x8004),
        OneMinusConstantAlphaExt = ((int)0x8004),
        BlendColor = ((int)0x8005),
        BlendColorExt = ((int)0x8005),
        FuncAdd = ((int)0x8006),
        FuncAddExt = ((int)0x8006),
        Min = ((int)0x8007),
        MinExt = ((int)0x8007),
        Max = ((int)0x8008),
        MaxExt = ((int)0x8008),
        BlendEquation = ((int)0x8009),
        BlendEquationExt = ((int)0x8009),
        BlendEquationRgb = ((int)0x8009),
        BlendEquationRgbExt = ((int)0x8009),
        FuncSubtract = ((int)0x800A),
        FuncSubtractExt = ((int)0x800A),
        FuncReverseSubtract = ((int)0x800B),
        FuncReverseSubtractExt = ((int)0x800B),
        CmykExt = ((int)0x800C),
        CmykaExt = ((int)0x800D),
        PackCmykHintExt = ((int)0x800E),
        UnpackCmykHintExt = ((int)0x800F),
        Convolution1D = ((int)0x8010),
        Convolution1DExt = ((int)0x8010),
        Convolution2D = ((int)0x8011),
        Convolution2DExt = ((int)0x8011),
        Separable2D = ((int)0x8012),
        Separable2DExt = ((int)0x8012),
        ConvolutionBorderMode = ((int)0x8013),
        ConvolutionBorderModeExt = ((int)0x8013),
        ConvolutionFilterScale = ((int)0x8014),
        ConvolutionFilterScaleExt = ((int)0x8014),
        ConvolutionFilterBias = ((int)0x8015),
        ConvolutionFilterBiasExt = ((int)0x8015),
        Reduce = ((int)0x8016),
        ReduceExt = ((int)0x8016),
        ConvolutionFormat = ((int)0x8017),
        ConvolutionFormatExt = ((int)0x8017),
        ConvolutionWidth = ((int)0x8018),
        ConvolutionWidthExt = ((int)0x8018),
        ConvolutionHeight = ((int)0x8019),
        ConvolutionHeightExt = ((int)0x8019),
        MaxConvolutionWidth = ((int)0x801A),
        MaxConvolutionWidthExt = ((int)0x801A),
        MaxConvolutionHeight = ((int)0x801B),
        MaxConvolutionHeightExt = ((int)0x801B),
        PostConvolutionRedScale = ((int)0x801C),
        PostConvolutionRedScaleExt = ((int)0x801C),
        PostConvolutionGreenScale = ((int)0x801D),
        PostConvolutionGreenScaleExt = ((int)0x801D),
        PostConvolutionBlueScale = ((int)0x801E),
        PostConvolutionBlueScaleExt = ((int)0x801E),
        PostConvolutionAlphaScale = ((int)0x801F),
        PostConvolutionAlphaScaleExt = ((int)0x801F),
        PostConvolutionRedBias = ((int)0x8020),
        PostConvolutionRedBiasExt = ((int)0x8020),
        PostConvolutionGreenBias = ((int)0x8021),
        PostConvolutionGreenBiasExt = ((int)0x8021),
        PostConvolutionBlueBias = ((int)0x8022),
        PostConvolutionBlueBiasExt = ((int)0x8022),
        PostConvolutionAlphaBias = ((int)0x8023),
        PostConvolutionAlphaBiasExt = ((int)0x8023),
        Histogram = ((int)0x8024),
        HistogramExt = ((int)0x8024),
        ProxyHistogram = ((int)0x8025),
        ProxyHistogramExt = ((int)0x8025),
        HistogramWidth = ((int)0x8026),
        HistogramWidthExt = ((int)0x8026),
        HistogramFormat = ((int)0x8027),
        HistogramFormatExt = ((int)0x8027),
        HistogramRedSize = ((int)0x8028),
        HistogramRedSizeExt = ((int)0x8028),
        HistogramGreenSize = ((int)0x8029),
        HistogramGreenSizeExt = ((int)0x8029),
        HistogramBlueSize = ((int)0x802A),
        HistogramBlueSizeExt = ((int)0x802A),
        HistogramAlphaSize = ((int)0x802B),
        HistogramAlphaSizeExt = ((int)0x802B),
        HistogramLuminanceSize = ((int)0x802C),
        HistogramLuminanceSizeExt = ((int)0x802C),
        HistogramSink = ((int)0x802D),
        HistogramSinkExt = ((int)0x802D),
        Minmax = ((int)0x802E),
        MinmaxExt = ((int)0x802E),
        MinmaxFormat = ((int)0x802F),
        MinmaxFormatExt = ((int)0x802F),
        MinmaxSink = ((int)0x8030),
        MinmaxSinkExt = ((int)0x8030),
        TableTooLarge = ((int)0x8031),
        TableTooLargeExt = ((int)0x8031),
        UnsignedByte332 = ((int)0x8032),
        UnsignedByte332Ext = ((int)0x8032),
        UnsignedShort4444 = ((int)0x8033),
        UnsignedShort4444Ext = ((int)0x8033),
        UnsignedShort5551 = ((int)0x8034),
        UnsignedShort5551Ext = ((int)0x8034),
        UnsignedInt8888 = ((int)0x8035),
        UnsignedInt8888Ext = ((int)0x8035),
        UnsignedInt1010102 = ((int)0x8036),
        UnsignedInt1010102Ext = ((int)0x8036),
        PolygonOffsetExt = ((int)0x8037),
        PolygonOffsetFill = ((int)0x8037),
        PolygonOffsetFactor = ((int)0x8038),
        PolygonOffsetFactorExt = ((int)0x8038),
        PolygonOffsetBiasExt = ((int)0x8039),
        RescaleNormal = ((int)0x803A),
        RescaleNormalExt = ((int)0x803A),
        Alpha4 = ((int)0x803B),
        Alpha4Ext = ((int)0x803B),
        Alpha8 = ((int)0x803C),
        Alpha8Ext = ((int)0x803C),
        Alpha12 = ((int)0x803D),
        Alpha12Ext = ((int)0x803D),
        Alpha16 = ((int)0x803E),
        Alpha16Ext = ((int)0x803E),
        Luminance4 = ((int)0x803F),
        Luminance4Ext = ((int)0x803F),
        Luminance8 = ((int)0x8040),
        Luminance8Ext = ((int)0x8040),
        Luminance12 = ((int)0x8041),
        Luminance12Ext = ((int)0x8041),
        Luminance16 = ((int)0x8042),
        Luminance16Ext = ((int)0x8042),
        Luminance4Alpha4 = ((int)0x8043),
        Luminance4Alpha4Ext = ((int)0x8043),
        Luminance6Alpha2 = ((int)0x8044),
        Luminance6Alpha2Ext = ((int)0x8044),
        Luminance8Alpha8 = ((int)0x8045),
        Luminance8Alpha8Ext = ((int)0x8045),
        Luminance12Alpha4 = ((int)0x8046),
        Luminance12Alpha4Ext = ((int)0x8046),
        Luminance12Alpha12 = ((int)0x8047),
        Luminance12Alpha12Ext = ((int)0x8047),
        Luminance16Alpha16 = ((int)0x8048),
        Luminance16Alpha16Ext = ((int)0x8048),
        Intensity = ((int)0x8049),
        IntensityExt = ((int)0x8049),
        Intensity4 = ((int)0x804A),
        Intensity4Ext = ((int)0x804A),
        Intensity8 = ((int)0x804B),
        Intensity8Ext = ((int)0x804B),
        Intensity12 = ((int)0x804C),
        Intensity12Ext = ((int)0x804C),
        Intensity16 = ((int)0x804D),
        Intensity16Ext = ((int)0x804D),
        Rgb2Ext = ((int)0x804E),
        Rgb4 = ((int)0x804F),
        Rgb4Ext = ((int)0x804F),
        Rgb5 = ((int)0x8050),
        Rgb5Ext = ((int)0x8050),
        Rgb8 = ((int)0x8051),
        Rgb8Ext = ((int)0x8051),
        Rgb10 = ((int)0x8052),
        Rgb10Ext = ((int)0x8052),
        Rgb12 = ((int)0x8053),
        Rgb12Ext = ((int)0x8053),
        Rgb16 = ((int)0x8054),
        Rgb16Ext = ((int)0x8054),
        Rgba2 = ((int)0x8055),
        Rgba2Ext = ((int)0x8055),
        Rgba4 = ((int)0x8056),
        Rgba4Ext = ((int)0x8056),
        Rgb5A1 = ((int)0x8057),
        Rgb5A1Ext = ((int)0x8057),
        Rgba8 = ((int)0x8058),
        Rgba8Ext = ((int)0x8058),
        Rgb10A2 = ((int)0x8059),
        Rgb10A2Ext = ((int)0x8059),
        Rgba12 = ((int)0x805A),
        Rgba12Ext = ((int)0x805A),
        Rgba16 = ((int)0x805B),
        Rgba16Ext = ((int)0x805B),
        TextureRedSize = ((int)0x805C),
        TextureRedSizeExt = ((int)0x805C),
        TextureGreenSize = ((int)0x805D),
        TextureGreenSizeExt = ((int)0x805D),
        TextureBlueSize = ((int)0x805E),
        TextureBlueSizeExt = ((int)0x805E),
        TextureAlphaSize = ((int)0x805F),
        TextureAlphaSizeExt = ((int)0x805F),
        TextureLuminanceSize = ((int)0x8060),
        TextureLuminanceSizeExt = ((int)0x8060),
        TextureIntensitySize = ((int)0x8061),
        TextureIntensitySizeExt = ((int)0x8061),
        ReplaceExt = ((int)0x8062),
        ProxyTexture1D = ((int)0x8063),
        ProxyTexture1DExt = ((int)0x8063),
        ProxyTexture2D = ((int)0x8064),
        ProxyTexture2DExt = ((int)0x8064),
        TextureTooLargeExt = ((int)0x8065),
        TexturePriority = ((int)0x8066),
        TexturePriorityExt = ((int)0x8066),
        TextureResident = ((int)0x8067),
        TextureResidentExt = ((int)0x8067),
        Texture1DBindingExt = ((int)0x8068),
        TextureBinding1D = ((int)0x8068),
        Texture2DBindingExt = ((int)0x8069),
        TextureBinding2D = ((int)0x8069),
        Texture3DBindingExt = ((int)0x806A),
        TextureBinding3D = ((int)0x806A),
        PackSkipImages = ((int)0x806B),
        PackSkipImagesExt = ((int)0x806B),
        PackImageHeight = ((int)0x806C),
        PackImageHeightExt = ((int)0x806C),
        UnpackSkipImages = ((int)0x806D),
        UnpackSkipImagesExt = ((int)0x806D),
        UnpackImageHeight = ((int)0x806E),
        UnpackImageHeightExt = ((int)0x806E),
        Texture3D = ((int)0x806F),
        Texture3DExt = ((int)0x806F),
        ProxyTexture3D = ((int)0x8070),
        ProxyTexture3DExt = ((int)0x8070),
        TextureDepth = ((int)0x8071),
        TextureDepthExt = ((int)0x8071),
        TextureWrapR = ((int)0x8072),
        TextureWrapRExt = ((int)0x8072),
        Max3DTextureSize = ((int)0x8073),
        Max3DTextureSizeExt = ((int)0x8073),
        VertexArray = ((int)0x8074),
        VertexArrayExt = ((int)0x8074),
        NormalArray = ((int)0x8075),
        NormalArrayExt = ((int)0x8075),
        ColorArray = ((int)0x8076),
        ColorArrayExt = ((int)0x8076),
        IndexArray = ((int)0x8077),
        IndexArrayExt = ((int)0x8077),
        TextureCoordArray = ((int)0x8078),
        TextureCoordArrayExt = ((int)0x8078),
        EdgeFlagArray = ((int)0x8079),
        EdgeFlagArrayExt = ((int)0x8079),
        VertexArraySize = ((int)0x807A),
        VertexArraySizeExt = ((int)0x807A),
        VertexArrayType = ((int)0x807B),
        VertexArrayTypeExt = ((int)0x807B),
        VertexArrayStride = ((int)0x807C),
        VertexArrayStrideExt = ((int)0x807C),
        VertexArrayCountExt = ((int)0x807D),
        NormalArrayType = ((int)0x807E),
        NormalArrayTypeExt = ((int)0x807E),
        NormalArrayStride = ((int)0x807F),
        NormalArrayStrideExt = ((int)0x807F),
        NormalArrayCountExt = ((int)0x8080),
        ColorArraySize = ((int)0x8081),
        ColorArraySizeExt = ((int)0x8081),
        ColorArrayType = ((int)0x8082),
        ColorArrayTypeExt = ((int)0x8082),
        ColorArrayStride = ((int)0x8083),
        ColorArrayStrideExt = ((int)0x8083),
        ColorArrayCountExt = ((int)0x8084),
        IndexArrayType = ((int)0x8085),
        IndexArrayTypeExt = ((int)0x8085),
        IndexArrayStride = ((int)0x8086),
        IndexArrayStrideExt = ((int)0x8086),
        IndexArrayCountExt = ((int)0x8087),
        TextureCoordArraySize = ((int)0x8088),
        TextureCoordArraySizeExt = ((int)0x8088),
        TextureCoordArrayType = ((int)0x8089),
        TextureCoordArrayTypeExt = ((int)0x8089),
        TextureCoordArrayStride = ((int)0x808A),
        TextureCoordArrayStrideExt = ((int)0x808A),
        TextureCoordArrayCountExt = ((int)0x808B),
        EdgeFlagArrayStride = ((int)0x808C),
        EdgeFlagArrayStrideExt = ((int)0x808C),
        EdgeFlagArrayCountExt = ((int)0x808D),
        VertexArrayPointer = ((int)0x808E),
        VertexArrayPointerExt = ((int)0x808E),
        NormalArrayPointer = ((int)0x808F),
        NormalArrayPointerExt = ((int)0x808F),
        ColorArrayPointer = ((int)0x8090),
        ColorArrayPointerExt = ((int)0x8090),
        IndexArrayPointer = ((int)0x8091),
        IndexArrayPointerExt = ((int)0x8091),
        TextureCoordArrayPointer = ((int)0x8092),
        TextureCoordArrayPointerExt = ((int)0x8092),
        EdgeFlagArrayPointer = ((int)0x8093),
        EdgeFlagArrayPointerExt = ((int)0x8093),
        InterlaceSgix = ((int)0x8094),
        DetailTexture2DSgis = ((int)0x8095),
        DetailTexture2DBindingSgis = ((int)0x8096),
        LinearDetailSgis = ((int)0x8097),
        LinearDetailAlphaSgis = ((int)0x8098),
        LinearDetailColorSgis = ((int)0x8099),
        DetailTextureLevelSgis = ((int)0x809A),
        DetailTextureModeSgis = ((int)0x809B),
        DetailTextureFuncPointsSgis = ((int)0x809C),
        Multisample = ((int)0x809D),
        MultisampleArb = ((int)0x809D),
        MultisampleExt = ((int)0x809D),
        MultisampleSgis = ((int)0x809D),
        SampleAlphaToCoverage = ((int)0x809E),
        SampleAlphaToCoverageArb = ((int)0x809E),
        SampleAlphaToMaskExt = ((int)0x809E),
        SampleAlphaToMaskSgis = ((int)0x809E),
        SampleAlphaToOne = ((int)0x809F),
        SampleAlphaToOneArb = ((int)0x809F),
        SampleAlphaToOneExt = ((int)0x809F),
        SampleAlphaToOneSgis = ((int)0x809F),
        SampleCoverage = ((int)0x80A0),
        SampleCoverageArb = ((int)0x80A0),
        SampleMaskExt = ((int)0x80A0),
        SampleMaskSgis = ((int)0x80A0),
        Gl1PassExt = ((int)0x80A1),
        Gl1PassSgis = ((int)0x80A1),
        Gl2Pass0Ext = ((int)0x80A2),
        Gl2Pass0Sgis = ((int)0x80A2),
        Gl2Pass1Ext = ((int)0x80A3),
        Gl2Pass1Sgis = ((int)0x80A3),
        Gl4Pass0Ext = ((int)0x80A4),
        Gl4Pass0Sgis = ((int)0x80A4),
        Gl4Pass1Ext = ((int)0x80A5),
        Gl4Pass1Sgis = ((int)0x80A5),
        Gl4Pass2Ext = ((int)0x80A6),
        Gl4Pass2Sgis = ((int)0x80A6),
        Gl4Pass3Ext = ((int)0x80A7),
        Gl4Pass3Sgis = ((int)0x80A7),
        SampleBuffers = ((int)0x80A8),
        SampleBuffersArb = ((int)0x80A8),
        SampleBuffersExt = ((int)0x80A8),
        SampleBuffersSgis = ((int)0x80A8),
        Samples = ((int)0x80A9),
        SamplesArb = ((int)0x80A9),
        SamplesExt = ((int)0x80A9),
        SamplesSgis = ((int)0x80A9),
        SampleCoverageValue = ((int)0x80AA),
        SampleCoverageValueArb = ((int)0x80AA),
        SampleMaskValueExt = ((int)0x80AA),
        SampleMaskValueSgis = ((int)0x80AA),
        SampleCoverageInvert = ((int)0x80AB),
        SampleCoverageInvertArb = ((int)0x80AB),
        SampleMaskInvertExt = ((int)0x80AB),
        SampleMaskInvertSgis = ((int)0x80AB),
        SamplePatternExt = ((int)0x80AC),
        SamplePatternSgis = ((int)0x80AC),
        LinearSharpenSgis = ((int)0x80AD),
        LinearSharpenAlphaSgis = ((int)0x80AE),
        LinearSharpenColorSgis = ((int)0x80AF),
        SharpenTextureFuncPointsSgis = ((int)0x80B0),
        ColorMatrix = ((int)0x80B1),
        ColorMatrixSgi = ((int)0x80B1),
        ColorMatrixStackDepth = ((int)0x80B2),
        ColorMatrixStackDepthSgi = ((int)0x80B2),
        MaxColorMatrixStackDepth = ((int)0x80B3),
        MaxColorMatrixStackDepthSgi = ((int)0x80B3),
        PostColorMatrixRedScale = ((int)0x80B4),
        PostColorMatrixRedScaleSgi = ((int)0x80B4),
        PostColorMatrixGreenScale = ((int)0x80B5),
        PostColorMatrixGreenScaleSgi = ((int)0x80B5),
        PostColorMatrixBlueScale = ((int)0x80B6),
        PostColorMatrixBlueScaleSgi = ((int)0x80B6),
        PostColorMatrixAlphaScale = ((int)0x80B7),
        PostColorMatrixAlphaScaleSgi = ((int)0x80B7),
        PostColorMatrixRedBias = ((int)0x80B8),
        PostColorMatrixRedBiasSgi = ((int)0x80B8),
        PostColorMatrixGreenBias = ((int)0x80B9),
        PostColorMatrixGreenBiasSgi = ((int)0x80B9),
        PostColorMatrixBlueBias = ((int)0x80BA),
        PostColorMatrixBlueBiasSgi = ((int)0x80BA),
        PostColorMatrixAlphaBias = ((int)0x80BB),
        PostColorMatrixAlphaBiasSgi = ((int)0x80BB),
        TextureColorTableSgi = ((int)0x80BC),
        ProxyTextureColorTableSgi = ((int)0x80BD),
        TextureEnvBiasSgix = ((int)0x80BE),
        ShadowAmbientSgix = ((int)0x80BF),
        TextureCompareFailValue = ((int)0x80BF),
        TextureCompareFailValueArb = ((int)0x80BF),
        BlendDstRgb = ((int)0x80C8),
        BlendDstRgbExt = ((int)0x80C8),
        BlendSrcRgb = ((int)0x80C9),
        BlendSrcRgbExt = ((int)0x80C9),
        BlendDstAlpha = ((int)0x80CA),
        BlendDstAlphaExt = ((int)0x80CA),
        BlendSrcAlpha = ((int)0x80CB),
        BlendSrcAlphaExt = ((int)0x80CB),
        Gl422Ext = ((int)0x80CC),
        Gl422RevExt = ((int)0x80CD),
        Gl422AverageExt = ((int)0x80CE),
        Gl422RevAverageExt = ((int)0x80CF),
        ColorTable = ((int)0x80D0),
        ColorTableSgi = ((int)0x80D0),
        PostConvolutionColorTable = ((int)0x80D1),
        PostConvolutionColorTableSgi = ((int)0x80D1),
        PostColorMatrixColorTable = ((int)0x80D2),
        PostColorMatrixColorTableSgi = ((int)0x80D2),
        ProxyColorTable = ((int)0x80D3),
        ProxyColorTableSgi = ((int)0x80D3),
        ProxyPostConvolutionColorTable = ((int)0x80D4),
        ProxyPostConvolutionColorTableSgi = ((int)0x80D4),
        ProxyPostColorMatrixColorTable = ((int)0x80D5),
        ProxyPostColorMatrixColorTableSgi = ((int)0x80D5),
        ColorTableScale = ((int)0x80D6),
        ColorTableScaleSgi = ((int)0x80D6),
        ColorTableBias = ((int)0x80D7),
        ColorTableBiasSgi = ((int)0x80D7),
        ColorTableFormat = ((int)0x80D8),
        ColorTableFormatSgi = ((int)0x80D8),
        ColorTableWidth = ((int)0x80D9),
        ColorTableWidthSgi = ((int)0x80D9),
        ColorTableRedSize = ((int)0x80DA),
        ColorTableRedSizeSgi = ((int)0x80DA),
        ColorTableGreenSize = ((int)0x80DB),
        ColorTableGreenSizeSgi = ((int)0x80DB),
        ColorTableBlueSize = ((int)0x80DC),
        ColorTableBlueSizeSgi = ((int)0x80DC),
        ColorTableAlphaSize = ((int)0x80DD),
        ColorTableAlphaSizeSgi = ((int)0x80DD),
        ColorTableLuminanceSize = ((int)0x80DE),
        ColorTableLuminanceSizeSgi = ((int)0x80DE),
        ColorTableIntensitySize = ((int)0x80DF),
        ColorTableIntensitySizeSgi = ((int)0x80DF),
        Bgr = ((int)0x80E0),
        BgrExt = ((int)0x80E0),
        Bgra = ((int)0x80E1),
        BgraExt = ((int)0x80E1),
        ColorIndex1Ext = ((int)0x80E2),
        ColorIndex2Ext = ((int)0x80E3),
        ColorIndex4Ext = ((int)0x80E4),
        ColorIndex8Ext = ((int)0x80E5),
        ColorIndex12Ext = ((int)0x80E6),
        ColorIndex16Ext = ((int)0x80E7),
        MaxElementsVertices = ((int)0x80E8),
        MaxElementsVerticesExt = ((int)0x80E8),
        MaxElementsIndices = ((int)0x80E9),
        MaxElementsIndicesExt = ((int)0x80E9),
        PhongWin = ((int)0x80EA),
        PhongHintWin = ((int)0x80EB),
        FogSpecularTextureWin = ((int)0x80EC),
        TextureIndexSizeExt = ((int)0x80ED),
        ClipVolumeClippingHintExt = ((int)0x80F0),
        DualAlpha4Sgis = ((int)0x8110),
        DualAlpha8Sgis = ((int)0x8111),
        DualAlpha12Sgis = ((int)0x8112),
        DualAlpha16Sgis = ((int)0x8113),
        DualLuminance4Sgis = ((int)0x8114),
        DualLuminance8Sgis = ((int)0x8115),
        DualLuminance12Sgis = ((int)0x8116),
        DualLuminance16Sgis = ((int)0x8117),
        DualIntensity4Sgis = ((int)0x8118),
        DualIntensity8Sgis = ((int)0x8119),
        DualIntensity12Sgis = ((int)0x811A),
        DualIntensity16Sgis = ((int)0x811B),
        DualLuminanceAlpha4Sgis = ((int)0x811C),
        DualLuminanceAlpha8Sgis = ((int)0x811D),
        QuadAlpha4Sgis = ((int)0x811E),
        QuadAlpha8Sgis = ((int)0x811F),
        QuadLuminance4Sgis = ((int)0x8120),
        QuadLuminance8Sgis = ((int)0x8121),
        QuadIntensity4Sgis = ((int)0x8122),
        QuadIntensity8Sgis = ((int)0x8123),
        DualTextureSelectSgis = ((int)0x8124),
        QuadTextureSelectSgis = ((int)0x8125),
        PointSizeMin = ((int)0x8126),
        PointSizeMinArb = ((int)0x8126),
        PointSizeMinExt = ((int)0x8126),
        PointSizeMinSgis = ((int)0x8126),
        PointSizeMax = ((int)0x8127),
        PointSizeMaxArb = ((int)0x8127),
        PointSizeMaxExt = ((int)0x8127),
        PointSizeMaxSgis = ((int)0x8127),
        PointFadeThresholdSize = ((int)0x8128),
        PointFadeThresholdSizeArb = ((int)0x8128),
        PointFadeThresholdSizeExt = ((int)0x8128),
        PointFadeThresholdSizeSgis = ((int)0x8128),
        DistanceAttenuationExt = ((int)0x8129),
        DistanceAttenuationSgis = ((int)0x8129),
        PointDistanceAttenuation = ((int)0x8129),
        PointDistanceAttenuationArb = ((int)0x8129),
        FogFuncSgis = ((int)0x812A),
        FogFuncPointsSgis = ((int)0x812B),
        MaxFogFuncPointsSgis = ((int)0x812C),
        ClampToBorder = ((int)0x812D),
        ClampToBorderArb = ((int)0x812D),
        ClampToBorderSgis = ((int)0x812D),
        TextureMultiBufferHintSgix = ((int)0x812E),
        ClampToEdge = ((int)0x812F),
        ClampToEdgeSgis = ((int)0x812F),
        PackSkipVolumesSgis = ((int)0x8130),
        PackImageDepthSgis = ((int)0x8131),
        UnpackSkipVolumesSgis = ((int)0x8132),
        UnpackImageDepthSgis = ((int)0x8133),
        Texture4DSgis = ((int)0x8134),
        ProxyTexture4DSgis = ((int)0x8135),
        Texture4DsizeSgis = ((int)0x8136),
        TextureWrapQSgis = ((int)0x8137),
        Max4DTextureSizeSgis = ((int)0x8138),
        PixelTexGenSgix = ((int)0x8139),
        TextureMinLod = ((int)0x813A),
        TextureMinLodSgis = ((int)0x813A),
        TextureMaxLod = ((int)0x813B),
        TextureMaxLodSgis = ((int)0x813B),
        TextureBaseLevel = ((int)0x813C),
        TextureBaseLevelSgis = ((int)0x813C),
        TextureMaxLevel = ((int)0x813D),
        TextureMaxLevelSgis = ((int)0x813D),
        PixelTileBestAlignmentSgix = ((int)0x813E),
        PixelTileCacheIncrementSgix = ((int)0x813F),
        PixelTileWidthSgix = ((int)0x8140),
        PixelTileHeightSgix = ((int)0x8141),
        PixelTileGridWidthSgix = ((int)0x8142),
        PixelTileGridHeightSgix = ((int)0x8143),
        PixelTileGridDepthSgix = ((int)0x8144),
        PixelTileCacheSizeSgix = ((int)0x8145),
        Filter4Sgis = ((int)0x8146),
        TextureFilter4SizeSgis = ((int)0x8147),
        SpriteSgix = ((int)0x8148),
        SpriteModeSgix = ((int)0x8149),
        SpriteAxisSgix = ((int)0x814A),
        SpriteTranslationSgix = ((int)0x814B),
        SpriteAxialSgix = ((int)0x814C),
        SpriteObjectAlignedSgix = ((int)0x814D),
        SpriteEyeAlignedSgix = ((int)0x814E),
        Texture4DBindingSgis = ((int)0x814F),
        IgnoreBorderHp = ((int)0x8150),
        ConstantBorder = ((int)0x8151),
        ConstantBorderHp = ((int)0x8151),
        ReplicateBorder = ((int)0x8153),
        ReplicateBorderHp = ((int)0x8153),
        ConvolutionBorderColor = ((int)0x8154),
        ConvolutionBorderColorHp = ((int)0x8154),
        ImageScaleXHp = ((int)0x8155),
        ImageScaleYHp = ((int)0x8156),
        ImageTranslateXHp = ((int)0x8157),
        ImageTranslateYHp = ((int)0x8158),
        ImageRotateAngleHp = ((int)0x8159),
        ImageRotateOriginXHp = ((int)0x815A),
        ImageRotateOriginYHp = ((int)0x815B),
        ImageMagFilterHp = ((int)0x815C),
        ImageMinFilterHp = ((int)0x815D),
        ImageCubicWeightHp = ((int)0x815E),
        CubicHp = ((int)0x815F),
        AverageHp = ((int)0x8160),
        ImageTransform2DHp = ((int)0x8161),
        PostImageTransformColorTableHp = ((int)0x8162),
        ProxyPostImageTransformColorTableHp = ((int)0x8163),
        OcclusionTestHp = ((int)0x8165),
        OcclusionTestResultHp = ((int)0x8166),
        TextureLightingModeHp = ((int)0x8167),
        TexturePostSpecularHp = ((int)0x8168),
        TexturePreSpecularHp = ((int)0x8169),
        LinearClipmapLinearSgix = ((int)0x8170),
        TextureClipmapCenterSgix = ((int)0x8171),
        TextureClipmapFrameSgix = ((int)0x8172),
        TextureClipmapOffsetSgix = ((int)0x8173),
        TextureClipmapVirtualDepthSgix = ((int)0x8174),
        TextureClipmapLodOffsetSgix = ((int)0x8175),
        TextureClipmapDepthSgix = ((int)0x8176),
        MaxClipmapDepthSgix = ((int)0x8177),
        MaxClipmapVirtualDepthSgix = ((int)0x8178),
        PostTextureFilterBiasSgix = ((int)0x8179),
        PostTextureFilterScaleSgix = ((int)0x817A),
        PostTextureFilterBiasRangeSgix = ((int)0x817B),
        PostTextureFilterScaleRangeSgix = ((int)0x817C),
        ReferencePlaneSgix = ((int)0x817D),
        ReferencePlaneEquationSgix = ((int)0x817E),
        IrInstrument1Sgix = ((int)0x817F),
        InstrumentBufferPointerSgix = ((int)0x8180),
        InstrumentMeasurementsSgix = ((int)0x8181),
        ListPrioritySgix = ((int)0x8182),
        CalligraphicFragmentSgix = ((int)0x8183),
        PixelTexGenQCeilingSgix = ((int)0x8184),
        PixelTexGenQRoundSgix = ((int)0x8185),
        PixelTexGenQFloorSgix = ((int)0x8186),
        PixelTexGenAlphaReplaceSgix = ((int)0x8187),
        PixelTexGenAlphaNoReplaceSgix = ((int)0x8188),
        PixelTexGenAlphaLsSgix = ((int)0x8189),
        PixelTexGenAlphaMsSgix = ((int)0x818A),
        FramezoomSgix = ((int)0x818B),
        FramezoomFactorSgix = ((int)0x818C),
        MaxFramezoomFactorSgix = ((int)0x818D),
        TextureLodBiasSSgix = ((int)0x818E),
        TextureLodBiasTSgix = ((int)0x818F),
        TextureLodBiasRSgix = ((int)0x8190),
        GenerateMipmap = ((int)0x8191),
        GenerateMipmapSgis = ((int)0x8191),
        GenerateMipmapHint = ((int)0x8192),
        GenerateMipmapHintSgis = ((int)0x8192),
        GeometryDeformationSgix = ((int)0x8194),
        TextureDeformationSgix = ((int)0x8195),
        DeformationsMaskSgix = ((int)0x8196),
        MaxDeformationOrderSgix = ((int)0x8197),
        FogOffsetSgix = ((int)0x8198),
        FogOffsetValueSgix = ((int)0x8199),
        TextureCompareSgix = ((int)0x819A),
        TextureCompareOperatorSgix = ((int)0x819B),
        TextureLequalRSgix = ((int)0x819C),
        TextureGequalRSgix = ((int)0x819D),
        DepthComponent16 = ((int)0x81A5),
        DepthComponent16Arb = ((int)0x81A5),
        DepthComponent16Sgix = ((int)0x81A5),
        DepthComponent24 = ((int)0x81A6),
        DepthComponent24Arb = ((int)0x81A6),
        DepthComponent24Sgix = ((int)0x81A6),
        DepthComponent32 = ((int)0x81A7),
        DepthComponent32Arb = ((int)0x81A7),
        DepthComponent32Sgix = ((int)0x81A7),
        ArrayElementLockFirstExt = ((int)0x81A8),
        ArrayElementLockCountExt = ((int)0x81A9),
        CullVertexExt = ((int)0x81AA),
        CullVertexEyePositionExt = ((int)0x81AB),
        CullVertexObjectPositionExt = ((int)0x81AC),
        IuiV2fExt = ((int)0x81AD),
        IuiV3fExt = ((int)0x81AE),
        IuiN3fV2fExt = ((int)0x81AF),
        IuiN3fV3fExt = ((int)0x81B0),
        T2fIuiV2fExt = ((int)0x81B1),
        T2fIuiV3fExt = ((int)0x81B2),
        T2fIuiN3fV2fExt = ((int)0x81B3),
        T2fIuiN3fV3fExt = ((int)0x81B4),
        IndexTestExt = ((int)0x81B5),
        IndexTestFuncExt = ((int)0x81B6),
        IndexTestRefExt = ((int)0x81B7),
        IndexMaterialExt = ((int)0x81B8),
        IndexMaterialParameterExt = ((int)0x81B9),
        IndexMaterialFaceExt = ((int)0x81BA),
        Ycrcb422Sgix = ((int)0x81BB),
        Ycrcb444Sgix = ((int)0x81BC),
        WrapBorderSun = ((int)0x81D4),
        UnpackConstantDataSunx = ((int)0x81D5),
        TextureConstantDataSunx = ((int)0x81D6),
        TriangleListSun = ((int)0x81D7),
        ReplacementCodeSun = ((int)0x81D8),
        GlobalAlphaSun = ((int)0x81D9),
        GlobalAlphaFactorSun = ((int)0x81DA),
        TextureColorWritemaskSgis = ((int)0x81EF),
        EyeDistanceToPointSgis = ((int)0x81F0),
        ObjectDistanceToPointSgis = ((int)0x81F1),
        EyeDistanceToLineSgis = ((int)0x81F2),
        ObjectDistanceToLineSgis = ((int)0x81F3),
        EyePointSgis = ((int)0x81F4),
        ObjectPointSgis = ((int)0x81F5),
        EyeLineSgis = ((int)0x81F6),
        ObjectLineSgis = ((int)0x81F7),
        LightModelColorControl = ((int)0x81F8),
        LightModelColorControlExt = ((int)0x81F8),
        SingleColor = ((int)0x81F9),
        SingleColorExt = ((int)0x81F9),
        SeparateSpecularColor = ((int)0x81FA),
        SeparateSpecularColorExt = ((int)0x81FA),
        SharedTexturePaletteExt = ((int)0x81FB),
        FogScaleSgix = ((int)0x81FC),
        FogScaleValueSgix = ((int)0x81FD),
        TextFragmentShaderAti = ((int)0x8200),
        FramebufferAttachmentColorEncoding = ((int)0x8210),
        FramebufferAttachmentComponentType = ((int)0x8211),
        FramebufferAttachmentRedSize = ((int)0x8212),
        FramebufferAttachmentGreenSize = ((int)0x8213),
        FramebufferAttachmentBlueSize = ((int)0x8214),
        FramebufferAttachmentAlphaSize = ((int)0x8215),
        FramebufferAttachmentDepthSize = ((int)0x8216),
        FramebufferAttachmentStencilSize = ((int)0x8217),
        FramebufferDefault = ((int)0x8218),
        FramebufferUndefined = ((int)0x8219),
        DepthStencilAttachment = ((int)0x821A),
        MajorVersion = ((int)0x821B),
        MinorVersion = ((int)0x821C),
        NumExtensions = ((int)0x821D),
        ContextFlags = ((int)0x821E),
        Index = ((int)0x8222),
        DepthBuffer = ((int)0x8223),
        StencilBuffer = ((int)0x8224),
        CompressedRed = ((int)0x8225),
        CompressedRg = ((int)0x8226),
        Rg = ((int)0x8227),
        RgInteger = ((int)0x8228),
        R8 = ((int)0x8229),
        R16 = ((int)0x822A),
        Rg8 = ((int)0x822B),
        Rg16 = ((int)0x822C),
        R16f = ((int)0x822D),
        R32f = ((int)0x822E),
        Rg16f = ((int)0x822F),
        Rg32f = ((int)0x8230),
        R8i = ((int)0x8231),
        R8ui = ((int)0x8232),
        R16i = ((int)0x8233),
        R16ui = ((int)0x8234),
        R32i = ((int)0x8235),
        R32ui = ((int)0x8236),
        Rg8i = ((int)0x8237),
        Rg8ui = ((int)0x8238),
        Rg16i = ((int)0x8239),
        Rg16ui = ((int)0x823A),
        Rg32i = ((int)0x823B),
        Rg32ui = ((int)0x823C),
        DepthPassInstrumentSgix = ((int)0x8310),
        DepthPassInstrumentCountersSgix = ((int)0x8311),
        DepthPassInstrumentMaxSgix = ((int)0x8312),
        ConvolutionHintSgix = ((int)0x8316),
        YcrcbSgix = ((int)0x8318),
        YcrcbaSgix = ((int)0x8319),
        AlphaMinSgix = ((int)0x8320),
        AlphaMaxSgix = ((int)0x8321),
        ScalebiasHintSgix = ((int)0x8322),
        AsyncMarkerSgix = ((int)0x8329),
        PixelTexGenModeSgix = ((int)0x832B),
        AsyncHistogramSgix = ((int)0x832C),
        MaxAsyncHistogramSgix = ((int)0x832D),
        PixelTransform2DExt = ((int)0x8330),
        PixelMagFilterExt = ((int)0x8331),
        PixelMinFilterExt = ((int)0x8332),
        PixelCubicWeightExt = ((int)0x8333),
        CubicExt = ((int)0x8334),
        AverageExt = ((int)0x8335),
        PixelTransform2DStackDepthExt = ((int)0x8336),
        MaxPixelTransform2DStackDepthExt = ((int)0x8337),
        PixelTransform2DMatrixExt = ((int)0x8338),
        FragmentMaterialExt = ((int)0x8349),
        FragmentNormalExt = ((int)0x834A),
        FragmentColorExt = ((int)0x834C),
        AttenuationExt = ((int)0x834D),
        ShadowAttenuationExt = ((int)0x834E),
        TextureApplicationModeExt = ((int)0x834F),
        TextureLightExt = ((int)0x8350),
        TextureMaterialFaceExt = ((int)0x8351),
        TextureMaterialParameterExt = ((int)0x8352),
        PixelTextureSgis = ((int)0x8353),
        PixelFragmentRgbSourceSgis = ((int)0x8354),
        PixelFragmentAlphaSourceSgis = ((int)0x8355),
        PixelGroupColorSgis = ((int)0x8356),
        AsyncTexImageSgix = ((int)0x835C),
        AsyncDrawPixelsSgix = ((int)0x835D),
        AsyncReadPixelsSgix = ((int)0x835E),
        MaxAsyncTexImageSgix = ((int)0x835F),
        MaxAsyncDrawPixelsSgix = ((int)0x8360),
        MaxAsyncReadPixelsSgix = ((int)0x8361),
        UnsignedByte233Rev = ((int)0x8362),
        UnsignedByte233Reversed = ((int)0x8362),
        UnsignedByte233RevExt = ((int)0x8362),
        UnsignedShort565 = ((int)0x8363),
        UnsignedShort565Ext = ((int)0x8363),
        UnsignedShort565Rev = ((int)0x8364),
        UnsignedShort565Reversed = ((int)0x8364),
        UnsignedShort565RevExt = ((int)0x8364),
        UnsignedShort4444Rev = ((int)0x8365),
        UnsignedShort4444Reversed = ((int)0x8365),
        UnsignedShort4444RevExt = ((int)0x8365),
        UnsignedShort1555Rev = ((int)0x8366),
        UnsignedShort1555Reversed = ((int)0x8366),
        UnsignedShort1555RevExt = ((int)0x8366),
        UnsignedInt8888Rev = ((int)0x8367),
        UnsignedInt8888Reversed = ((int)0x8367),
        UnsignedInt8888RevExt = ((int)0x8367),
        UnsignedInt2101010Rev = ((int)0x8368),
        UnsignedInt2101010Reversed = ((int)0x8368),
        UnsignedInt2101010RevExt = ((int)0x8368),
        TextureMaxClampSSgix = ((int)0x8369),
        TextureMaxClampTSgix = ((int)0x836A),
        TextureMaxClampRSgix = ((int)0x836B),
        FogFactorToAlphaSgix = ((int)0x836F),
        MirroredRepeat = ((int)0x8370),
        MirroredRepeatArb = ((int)0x8370),
        MirroredRepeatIbm = ((int)0x8370),
        RgbS3tc = ((int)0x83A0),
        Rgb4S3tc = ((int)0x83A1),
        RgbaS3tc = ((int)0x83A2),
        Rgba4S3tc = ((int)0x83A3),
        VertexPreclipSgix = ((int)0x83EE),
        VertexPreclipHintSgix = ((int)0x83EF),
        CompressedRgbS3tcDxt1Ext = ((int)0x83F0),
        CompressedRgbaS3tcDxt1Ext = ((int)0x83F1),
        CompressedRgbaS3tcDxt3Ext = ((int)0x83F2),
        CompressedRgbaS3tcDxt5Ext = ((int)0x83F3),
        ParallelArraysIntel = ((int)0x83F4),
        VertexArrayParallelPointersIntel = ((int)0x83F5),
        NormalArrayParallelPointersIntel = ((int)0x83F6),
        ColorArrayParallelPointersIntel = ((int)0x83F7),
        TextureCoordArrayParallelPointersIntel = ((int)0x83F8),
        FragmentLightingSgix = ((int)0x8400),
        FragmentColorMaterialSgix = ((int)0x8401),
        FragmentColorMaterialFaceSgix = ((int)0x8402),
        FragmentColorMaterialParameterSgix = ((int)0x8403),
        MaxFragmentLightsSgix = ((int)0x8404),
        MaxActiveLightsSgix = ((int)0x8405),
        CurrentRasterNormalSgix = ((int)0x8406),
        LightEnvModeSgix = ((int)0x8407),
        FragmentLightModelLocalViewerSgix = ((int)0x8408),
        FragmentLightModelTwoSideSgix = ((int)0x8409),
        FragmentLightModelAmbientSgix = ((int)0x840A),
        FragmentLightModelNormalInterpolationSgix = ((int)0x840B),
        FragmentLight0Sgix = ((int)0x840C),
        FragmentLight1Sgix = ((int)0x840D),
        FragmentLight2Sgix = ((int)0x840E),
        FragmentLight3Sgix = ((int)0x840F),
        FragmentLight4Sgix = ((int)0x8410),
        FragmentLight5Sgix = ((int)0x8411),
        FragmentLight6Sgix = ((int)0x8412),
        FragmentLight7Sgix = ((int)0x8413),
        PackResampleSgix = ((int)0x842C),
        UnpackResampleSgix = ((int)0x842D),
        ResampleReplicateSgix = ((int)0x842E),
        ResampleZeroFillSgix = ((int)0x842F),
        ResampleDecimateSgix = ((int)0x8430),
        TangentArrayExt = ((int)0x8439),
        BinormalArrayExt = ((int)0x843A),
        CurrentTangentExt = ((int)0x843B),
        CurrentBinormalExt = ((int)0x843C),
        TangentArrayTypeExt = ((int)0x843E),
        TangentArrayStrideExt = ((int)0x843F),
        BinormalArrayTypeExt = ((int)0x8440),
        BinormalArrayStrideExt = ((int)0x8441),
        TangentArrayPointerExt = ((int)0x8442),
        BinormalArrayPointerExt = ((int)0x8443),
        Map1TangentExt = ((int)0x8444),
        Map2TangentExt = ((int)0x8445),
        Map1BinormalExt = ((int)0x8446),
        Map2BinormalExt = ((int)0x8447),
        NearestClipmapNearestSgix = ((int)0x844D),
        NearestClipmapLinearSgix = ((int)0x844E),
        LinearClipmapNearestSgix = ((int)0x844F),
        FogCoordinateSource = ((int)0x8450),
        FogCoordinateSourceExt = ((int)0x8450),
        FogCoordSrc = ((int)0x8450),
        FogCoord = ((int)0x8451),
        FogCoordinate = ((int)0x8451),
        FogCoordinateExt = ((int)0x8451),
        FragmentDepth = ((int)0x8452),
        FragmentDepthExt = ((int)0x8452),
        CurrentFogCoord = ((int)0x8453),
        CurrentFogCoordinate = ((int)0x8453),
        CurrentFogCoordinateExt = ((int)0x8453),
        FogCoordArrayType = ((int)0x8454),
        FogCoordinateArrayType = ((int)0x8454),
        FogCoordinateArrayTypeExt = ((int)0x8454),
        FogCoordArrayStride = ((int)0x8455),
        FogCoordinateArrayStride = ((int)0x8455),
        FogCoordinateArrayStrideExt = ((int)0x8455),
        FogCoordArrayPointer = ((int)0x8456),
        FogCoordinateArrayPointer = ((int)0x8456),
        FogCoordinateArrayPointerExt = ((int)0x8456),
        FogCoordArray = ((int)0x8457),
        FogCoordinateArray = ((int)0x8457),
        FogCoordinateArrayExt = ((int)0x8457),
        ColorSum = ((int)0x8458),
        ColorSumArb = ((int)0x8458),
        ColorSumExt = ((int)0x8458),
        CurrentSecondaryColor = ((int)0x8459),
        CurrentSecondaryColorExt = ((int)0x8459),
        SecondaryColorArraySize = ((int)0x845A),
        SecondaryColorArraySizeExt = ((int)0x845A),
        SecondaryColorArrayType = ((int)0x845B),
        SecondaryColorArrayTypeExt = ((int)0x845B),
        SecondaryColorArrayStride = ((int)0x845C),
        SecondaryColorArrayStrideExt = ((int)0x845C),
        SecondaryColorArrayPointer = ((int)0x845D),
        SecondaryColorArrayPointerExt = ((int)0x845D),
        SecondaryColorArray = ((int)0x845E),
        SecondaryColorArrayExt = ((int)0x845E),
        CurrentRasterSecondaryColor = ((int)0x845F),
        AliasedPointSizeRange = ((int)0x846D),
        AliasedLineWidthRange = ((int)0x846E),
        ScreenCoordinatesRend = ((int)0x8490),
        InvertedScreenWRend = ((int)0x8491),
        Texture0 = ((int)0x84C0),
        Texture0Arb = ((int)0x84C0),
        Texture1 = ((int)0x84C1),
        Texture1Arb = ((int)0x84C1),
        Texture2 = ((int)0x84C2),
        Texture2Arb = ((int)0x84C2),
        Texture3 = ((int)0x84C3),
        Texture3Arb = ((int)0x84C3),
        Texture4 = ((int)0x84C4),
        Texture4Arb = ((int)0x84C4),
        Texture5 = ((int)0x84C5),
        Texture5Arb = ((int)0x84C5),
        Texture6 = ((int)0x84C6),
        Texture6Arb = ((int)0x84C6),
        Texture7 = ((int)0x84C7),
        Texture7Arb = ((int)0x84C7),
        Texture8 = ((int)0x84C8),
        Texture8Arb = ((int)0x84C8),
        Texture9 = ((int)0x84C9),
        Texture9Arb = ((int)0x84C9),
        Texture10 = ((int)0x84CA),
        Texture10Arb = ((int)0x84CA),
        Texture11 = ((int)0x84CB),
        Texture11Arb = ((int)0x84CB),
        Texture12 = ((int)0x84CC),
        Texture12Arb = ((int)0x84CC),
        Texture13 = ((int)0x84CD),
        Texture13Arb = ((int)0x84CD),
        Texture14 = ((int)0x84CE),
        Texture14Arb = ((int)0x84CE),
        Texture15 = ((int)0x84CF),
        Texture15Arb = ((int)0x84CF),
        Texture16 = ((int)0x84D0),
        Texture16Arb = ((int)0x84D0),
        Texture17 = ((int)0x84D1),
        Texture17Arb = ((int)0x84D1),
        Texture18 = ((int)0x84D2),
        Texture18Arb = ((int)0x84D2),
        Texture19 = ((int)0x84D3),
        Texture19Arb = ((int)0x84D3),
        Texture20 = ((int)0x84D4),
        Texture20Arb = ((int)0x84D4),
        Texture21 = ((int)0x84D5),
        Texture21Arb = ((int)0x84D5),
        Texture22 = ((int)0x84D6),
        Texture22Arb = ((int)0x84D6),
        Texture23 = ((int)0x84D7),
        Texture23Arb = ((int)0x84D7),
        Texture24 = ((int)0x84D8),
        Texture24Arb = ((int)0x84D8),
        Texture25 = ((int)0x84D9),
        Texture25Arb = ((int)0x84D9),
        Texture26 = ((int)0x84DA),
        Texture26Arb = ((int)0x84DA),
        Texture27 = ((int)0x84DB),
        Texture27Arb = ((int)0x84DB),
        Texture28 = ((int)0x84DC),
        Texture28Arb = ((int)0x84DC),
        Texture29 = ((int)0x84DD),
        Texture29Arb = ((int)0x84DD),
        Texture30 = ((int)0x84DE),
        Texture30Arb = ((int)0x84DE),
        Texture31 = ((int)0x84DF),
        Texture31Arb = ((int)0x84DF),
        ActiveTexture = ((int)0x84E0),
        ActiveTextureArb = ((int)0x84E0),
        ClientActiveTexture = ((int)0x84E1),
        ClientActiveTextureArb = ((int)0x84E1),
        MaxTextureUnits = ((int)0x84E2),
        MaxTextureUnitsArb = ((int)0x84E2),
        TransposeModelviewMatrix = ((int)0x84E3),
        TransposeModelviewMatrixArb = ((int)0x84E3),
        TransposeProjectionMatrix = ((int)0x84E4),
        TransposeProjectionMatrixArb = ((int)0x84E4),
        TransposeTextureMatrix = ((int)0x84E5),
        TransposeTextureMatrixArb = ((int)0x84E5),
        TransposeColorMatrix = ((int)0x84E6),
        TransposeColorMatrixArb = ((int)0x84E6),
        Subtract = ((int)0x84E7),
        SubtractArb = ((int)0x84E7),
        MaxRenderbufferSize = ((int)0x84E8),
        MaxRenderbufferSizeExt = ((int)0x84E8),
        CompressedAlpha = ((int)0x84E9),
        CompressedAlphaArb = ((int)0x84E9),
        CompressedLuminance = ((int)0x84EA),
        CompressedLuminanceArb = ((int)0x84EA),
        CompressedLuminanceAlpha = ((int)0x84EB),
        CompressedLuminanceAlphaArb = ((int)0x84EB),
        CompressedIntensity = ((int)0x84EC),
        CompressedIntensityArb = ((int)0x84EC),
        CompressedRgb = ((int)0x84ED),
        CompressedRgbArb = ((int)0x84ED),
        CompressedRgba = ((int)0x84EE),
        CompressedRgbaArb = ((int)0x84EE),
        TextureCompressionHint = ((int)0x84EF),
        TextureCompressionHintArb = ((int)0x84EF),
        AllCompletedNv = ((int)0x84F2),
        FenceStatusNv = ((int)0x84F3),
        FenceConditionNv = ((int)0x84F4),
        TextureRectangle = ((int)0x84F5),
        TextureRectangleArb = ((int)0x84F5),
        TextureRectangleNv = ((int)0x84F5),
        TextureBindingRectangle = ((int)0x84F6),
        TextureBindingRectangleArb = ((int)0x84F6),
        TextureBindingRectangleNv = ((int)0x84F6),
        ProxyTextureRectangle = ((int)0x84F7),
        ProxyTextureRectangleArb = ((int)0x84F7),
        ProxyTextureRectangleNv = ((int)0x84F7),
        MaxRectangleTextureSize = ((int)0x84F8),
        MaxRectangleTextureSizeArb = ((int)0x84F8),
        MaxRectangleTextureSizeNv = ((int)0x84F8),
        DepthStencil = ((int)0x84F9),
        DepthStencilExt = ((int)0x84F9),
        DepthStencilNv = ((int)0x84F9),
        UnsignedInt248 = ((int)0x84FA),
        UnsignedInt248Ext = ((int)0x84FA),
        UnsignedInt248Nv = ((int)0x84FA),
        MaxTextureLodBias = ((int)0x84FD),
        MaxTextureLodBiasExt = ((int)0x84FD),
        TextureMaxAnisotropyExt = ((int)0x84FE),
        MaxTextureMaxAnisotropyExt = ((int)0x84FF),
        TextureFilterControl = ((int)0x8500),
        TextureFilterControlExt = ((int)0x8500),
        TextureLodBias = ((int)0x8501),
        TextureLodBiasExt = ((int)0x8501),
        Modelview1StackDepthExt = ((int)0x8502),
        Combine4Nv = ((int)0x8503),
        MaxShininessNv = ((int)0x8504),
        MaxSpotExponentNv = ((int)0x8505),
        Modelview1MatrixExt = ((int)0x8506),
        IncrWrap = ((int)0x8507),
        IncrWrapExt = ((int)0x8507),
        DecrWrap = ((int)0x8508),
        DecrWrapExt = ((int)0x8508),
        VertexWeightingExt = ((int)0x8509),
        Modelview1Arb = ((int)0x850A),
        Modelview1Ext = ((int)0x850A),
        CurrentVertexWeightExt = ((int)0x850B),
        VertexWeightArrayExt = ((int)0x850C),
        VertexWeightArraySizeExt = ((int)0x850D),
        VertexWeightArrayTypeExt = ((int)0x850E),
        VertexWeightArrayStrideExt = ((int)0x850F),
        VertexWeightArrayPointerExt = ((int)0x8510),
        NormalMap = ((int)0x8511),
        NormalMapArb = ((int)0x8511),
        NormalMapExt = ((int)0x8511),
        NormalMapNv = ((int)0x8511),
        ReflectionMap = ((int)0x8512),
        ReflectionMapArb = ((int)0x8512),
        ReflectionMapExt = ((int)0x8512),
        ReflectionMapNv = ((int)0x8512),
        TextureCubeMap = ((int)0x8513),
        TextureCubeMapArb = ((int)0x8513),
        TextureCubeMapExt = ((int)0x8513),
        TextureBindingCubeMap = ((int)0x8514),
        TextureBindingCubeMapArb = ((int)0x8514),
        TextureBindingCubeMapExt = ((int)0x8514),
        TextureCubeMapPositiveX = ((int)0x8515),
        TextureCubeMapPositiveXArb = ((int)0x8515),
        TextureCubeMapPositiveXExt = ((int)0x8515),
        TextureCubeMapNegativeX = ((int)0x8516),
        TextureCubeMapNegativeXArb = ((int)0x8516),
        TextureCubeMapNegativeXExt = ((int)0x8516),
        TextureCubeMapPositiveY = ((int)0x8517),
        TextureCubeMapPositiveYArb = ((int)0x8517),
        TextureCubeMapPositiveYExt = ((int)0x8517),
        TextureCubeMapNegativeY = ((int)0x8518),
        TextureCubeMapNegativeYArb = ((int)0x8518),
        TextureCubeMapNegativeYExt = ((int)0x8518),
        TextureCubeMapPositiveZ = ((int)0x8519),
        TextureCubeMapPositiveZArb = ((int)0x8519),
        TextureCubeMapPositiveZExt = ((int)0x8519),
        TextureCubeMapNegativeZ = ((int)0x851A),
        TextureCubeMapNegativeZArb = ((int)0x851A),
        TextureCubeMapNegativeZExt = ((int)0x851A),
        ProxyTextureCubeMap = ((int)0x851B),
        ProxyTextureCubeMapArb = ((int)0x851B),
        ProxyTextureCubeMapExt = ((int)0x851B),
        MaxCubeMapTextureSize = ((int)0x851C),
        MaxCubeMapTextureSizeArb = ((int)0x851C),
        MaxCubeMapTextureSizeExt = ((int)0x851C),
        VertexArrayRangeApple = ((int)0x851D),
        VertexArrayRangeNv = ((int)0x851D),
        VertexArrayRangeLengthApple = ((int)0x851E),
        VertexArrayRangeLengthNv = ((int)0x851E),
        VertexArrayRangeValidNv = ((int)0x851F),
        VertexArrayStorageHintApple = ((int)0x851F),
        MaxVertexArrayRangeElementNv = ((int)0x8520),
        VertexArrayRangePointerApple = ((int)0x8521),
        VertexArrayRangePointerNv = ((int)0x8521),
        RegisterCombinersNv = ((int)0x8522),
        VariableANv = ((int)0x8523),
        VariableBNv = ((int)0x8524),
        VariableCNv = ((int)0x8525),
        VariableDNv = ((int)0x8526),
        VariableENv = ((int)0x8527),
        VariableFNv = ((int)0x8528),
        VariableGNv = ((int)0x8529),
        ConstantColor0Nv = ((int)0x852A),
        ConstantColor1Nv = ((int)0x852B),
        PrimaryColorNv = ((int)0x852C),
        SecondaryColorNv = ((int)0x852D),
        Spare0Nv = ((int)0x852E),
        Spare1Nv = ((int)0x852F),
        DiscardNv = ((int)0x8530),
        ETimesFNv = ((int)0x8531),
        Spare0PlusSecondaryColorNv = ((int)0x8532),
        VertexArrayRangeWithoutFlushNv = ((int)0x8533),
        MultisampleFilterHintNv = ((int)0x8534),
        PerStageConstantsNv = ((int)0x8535),
        UnsignedIdentityNv = ((int)0x8536),
        UnsignedInvertNv = ((int)0x8537),
        ExpandNormalNv = ((int)0x8538),
        ExpandNegateNv = ((int)0x8539),
        HalfBiasNormalNv = ((int)0x853A),
        HalfBiasNegateNv = ((int)0x853B),
        SignedIdentityNv = ((int)0x853C),
        SignedNegateNv = ((int)0x853D),
        ScaleByTwoNv = ((int)0x853E),
        ScaleByFourNv = ((int)0x853F),
        ScaleByOneHalfNv = ((int)0x8540),
        BiasByNegativeOneHalfNv = ((int)0x8541),
        CombinerInputNv = ((int)0x8542),
        CombinerMappingNv = ((int)0x8543),
        CombinerComponentUsageNv = ((int)0x8544),
        CombinerAbDotProductNv = ((int)0x8545),
        CombinerCdDotProductNv = ((int)0x8546),
        CombinerMuxSumNv = ((int)0x8547),
        CombinerScaleNv = ((int)0x8548),
        CombinerBiasNv = ((int)0x8549),
        CombinerAbOutputNv = ((int)0x854A),
        CombinerCdOutputNv = ((int)0x854B),
        CombinerSumOutputNv = ((int)0x854C),
        MaxGeneralCombinersNv = ((int)0x854D),
        NumGeneralCombinersNv = ((int)0x854E),
        ColorSumClampNv = ((int)0x854F),
        Combiner0Nv = ((int)0x8550),
        Combiner1Nv = ((int)0x8551),
        Combiner2Nv = ((int)0x8552),
        Combiner3Nv = ((int)0x8553),
        Combiner4Nv = ((int)0x8554),
        Combiner5Nv = ((int)0x8555),
        Combiner6Nv = ((int)0x8556),
        Combiner7Nv = ((int)0x8557),
        PrimitiveRestartNv = ((int)0x8558),
        PrimitiveRestartIndexNv = ((int)0x8559),
        FogDistanceModeNv = ((int)0x855A),
        EyeRadialNv = ((int)0x855B),
        EyePlaneAbsoluteNv = ((int)0x855C),
        EmbossLightNv = ((int)0x855D),
        EmbossConstantNv = ((int)0x855E),
        EmbossMapNv = ((int)0x855F),
        RedMinClampIngr = ((int)0x8560),
        GreenMinClampIngr = ((int)0x8561),
        BlueMinClampIngr = ((int)0x8562),
        AlphaMinClampIngr = ((int)0x8563),
        RedMaxClampIngr = ((int)0x8564),
        GreenMaxClampIngr = ((int)0x8565),
        BlueMaxClampIngr = ((int)0x8566),
        AlphaMaxClampIngr = ((int)0x8567),
        InterlaceReadIngr = ((int)0x8568),
        Combine = ((int)0x8570),
        CombineArb = ((int)0x8570),
        CombineExt = ((int)0x8570),
        CombineRgb = ((int)0x8571),
        CombineRgbArb = ((int)0x8571),
        CombineRgbExt = ((int)0x8571),
        CombineAlpha = ((int)0x8572),
        CombineAlphaArb = ((int)0x8572),
        CombineAlphaExt = ((int)0x8572),
        RgbScale = ((int)0x8573),
        RgbScaleArb = ((int)0x8573),
        RgbScaleExt = ((int)0x8573),
        AddSigned = ((int)0x8574),
        AddSignedArb = ((int)0x8574),
        AddSignedExt = ((int)0x8574),
        Interpolate = ((int)0x8575),
        InterpolateArb = ((int)0x8575),
        InterpolateExt = ((int)0x8575),
        Constant = ((int)0x8576),
        ConstantArb = ((int)0x8576),
        ConstantExt = ((int)0x8576),
        PrimaryColor = ((int)0x8577),
        PrimaryColorArb = ((int)0x8577),
        PrimaryColorExt = ((int)0x8577),
        Previous = ((int)0x8578),
        PreviousArb = ((int)0x8578),
        PreviousExt = ((int)0x8578),
        Source0Rgb = ((int)0x8580),
        Source0RgbArb = ((int)0x8580),
        Source0RgbExt = ((int)0x8580),
        Src0Rgb = ((int)0x8580),
        Source1Rgb = ((int)0x8581),
        Source1RgbArb = ((int)0x8581),
        Source1RgbExt = ((int)0x8581),
        Src1Rgb = ((int)0x8581),
        Source2Rgb = ((int)0x8582),
        Source2RgbArb = ((int)0x8582),
        Source2RgbExt = ((int)0x8582),
        Src2Rgb = ((int)0x8582),
        Source3RgbNv = ((int)0x8583),
        Source0Alpha = ((int)0x8588),
        Source0AlphaArb = ((int)0x8588),
        Source0AlphaExt = ((int)0x8588),
        Src0Alpha = ((int)0x8588),
        Source1Alpha = ((int)0x8589),
        Source1AlphaArb = ((int)0x8589),
        Source1AlphaExt = ((int)0x8589),
        Src1Alpha = ((int)0x8589),
        Source2Alpha = ((int)0x858A),
        Source2AlphaArb = ((int)0x858A),
        Source2AlphaExt = ((int)0x858A),
        Src2Alpha = ((int)0x858A),
        Source3AlphaNv = ((int)0x858B),
        Operand0Rgb = ((int)0x8590),
        Operand0RgbArb = ((int)0x8590),
        Operand0RgbExt = ((int)0x8590),
        Operand1Rgb = ((int)0x8591),
        Operand1RgbArb = ((int)0x8591),
        Operand1RgbExt = ((int)0x8591),
        Operand2Rgb = ((int)0x8592),
        Operand2RgbArb = ((int)0x8592),
        Operand2RgbExt = ((int)0x8592),
        Operand3RgbNv = ((int)0x8593),
        Operand0Alpha = ((int)0x8598),
        Operand0AlphaArb = ((int)0x8598),
        Operand0AlphaExt = ((int)0x8598),
        Operand1Alpha = ((int)0x8599),
        Operand1AlphaArb = ((int)0x8599),
        Operand1AlphaExt = ((int)0x8599),
        Operand2Alpha = ((int)0x859A),
        Operand2AlphaArb = ((int)0x859A),
        Operand2AlphaExt = ((int)0x859A),
        Operand3AlphaNv = ((int)0x859B),
        PackSubsampleRateSgix = ((int)0x85A0),
        UnpackSubsampleRateSgix = ((int)0x85A1),
        PixelSubsample4444Sgix = ((int)0x85A2),
        PixelSubsample2424Sgix = ((int)0x85A3),
        PixelSubsample4242Sgix = ((int)0x85A4),
        PerturbExt = ((int)0x85AE),
        TextureNormalExt = ((int)0x85AF),
        LightModelSpecularVectorApple = ((int)0x85B0),
        TransformHintApple = ((int)0x85B1),
        UnpackClientStorageApple = ((int)0x85B2),
        BufferObjectApple = ((int)0x85B3),
        VertexArrayBinding = ((int)0x85B5),
        VertexArrayBindingApple = ((int)0x85B5),
        TextureRangeLengthApple = ((int)0x85B7),
        TextureRangePointerApple = ((int)0x85B8),
        Ycbcr422Apple = ((int)0x85B9),
        UnsignedShort88Apple = ((int)0x85BA),
        UnsignedShort88Mesa = ((int)0x85BA),
        UnsignedShort88RevApple = ((int)0x85BB),
        UnsignedShort88RevMesa = ((int)0x85BB),
        TextureStorageHintApple = ((int)0x85BC),
        StoragePrivateApple = ((int)0x85BD),
        StorageCachedApple = ((int)0x85BE),
        StorageSharedApple = ((int)0x85BF),
        ReplacementCodeArraySun = ((int)0x85C0),
        ReplacementCodeArrayTypeSun = ((int)0x85C1),
        ReplacementCodeArrayStrideSun = ((int)0x85C2),
        ReplacementCodeArrayPointerSun = ((int)0x85C3),
        R1uiV3fSun = ((int)0x85C4),
        R1uiC4ubV3fSun = ((int)0x85C5),
        R1uiC3fV3fSun = ((int)0x85C6),
        R1uiN3fV3fSun = ((int)0x85C7),
        R1uiC4fN3fV3fSun = ((int)0x85C8),
        R1uiT2fV3fSun = ((int)0x85C9),
        R1uiT2fN3fV3fSun = ((int)0x85CA),
        R1uiT2fC4fN3fV3fSun = ((int)0x85CB),
        SliceAccumSun = ((int)0x85CC),
        QuadMeshSun = ((int)0x8614),
        TriangleMeshSun = ((int)0x8615),
        VertexProgram = ((int)0x8620),
        VertexProgramArb = ((int)0x8620),
        VertexProgramNv = ((int)0x8620),
        VertexStateProgramNv = ((int)0x8621),
        ArrayEnabled = ((int)0x8622),
        VertexAttribArrayEnabled = ((int)0x8622),
        VertexAttribArrayEnabledArb = ((int)0x8622),
        ArraySize = ((int)0x8623),
        AttribArraySizeNv = ((int)0x8623),
        VertexAttribArraySize = ((int)0x8623),
        VertexAttribArraySizeArb = ((int)0x8623),
        ArrayStride = ((int)0x8624),
        AttribArrayStrideNv = ((int)0x8624),
        VertexAttribArrayStride = ((int)0x8624),
        VertexAttribArrayStrideArb = ((int)0x8624),
        ArrayType = ((int)0x8625),
        AttribArrayTypeNv = ((int)0x8625),
        VertexAttribArrayType = ((int)0x8625),
        VertexAttribArrayTypeArb = ((int)0x8625),
        CurrentAttribNv = ((int)0x8626),
        CurrentVertexAttrib = ((int)0x8626),
        CurrentVertexAttribArb = ((int)0x8626),
        ProgramLength = ((int)0x8627),
        ProgramLengthArb = ((int)0x8627),
        ProgramLengthNv = ((int)0x8627),
        ProgramString = ((int)0x8628),
        ProgramStringArb = ((int)0x8628),
        ProgramStringNv = ((int)0x8628),
        ModelviewProjectionNv = ((int)0x8629),
        IdentityNv = ((int)0x862A),
        InverseNv = ((int)0x862B),
        TransposeNv = ((int)0x862C),
        InverseTransposeNv = ((int)0x862D),
        MaxProgramMatrixStackDepthArb = ((int)0x862E),
        MaxTrackMatrixStackDepthNv = ((int)0x862E),
        MaxProgramMatricesArb = ((int)0x862F),
        MaxTrackMatricesNv = ((int)0x862F),
        Matrix0Nv = ((int)0x8630),
        Matrix1Nv = ((int)0x8631),
        Matrix2Nv = ((int)0x8632),
        Matrix3Nv = ((int)0x8633),
        Matrix4Nv = ((int)0x8634),
        Matrix5Nv = ((int)0x8635),
        Matrix6Nv = ((int)0x8636),
        Matrix7Nv = ((int)0x8637),
        CurrentMatrixStackDepthArb = ((int)0x8640),
        CurrentMatrixStackDepthNv = ((int)0x8640),
        CurrentMatrixArb = ((int)0x8641),
        CurrentMatrixNv = ((int)0x8641),
        ProgramPointSize = ((int)0x8642),
        ProgramPointSizeArb = ((int)0x8642),
        ProgramPointSizeExt = ((int)0x8642),
        VertexProgramPointSize = ((int)0x8642),
        VertexProgramPointSizeArb = ((int)0x8642),
        VertexProgramPointSizeNv = ((int)0x8642),
        VertexProgramTwoSide = ((int)0x8643),
        VertexProgramTwoSideArb = ((int)0x8643),
        VertexProgramTwoSideNv = ((int)0x8643),
        ProgramParameterNv = ((int)0x8644),
        ArrayPointer = ((int)0x8645),
        AttribArrayPointerNv = ((int)0x8645),
        VertexAttribArrayPointer = ((int)0x8645),
        VertexAttribArrayPointerArb = ((int)0x8645),
        ProgramTargetNv = ((int)0x8646),
        ProgramResidentNv = ((int)0x8647),
        TrackMatrixNv = ((int)0x8648),
        TrackMatrixTransformNv = ((int)0x8649),
        VertexProgramBindingNv = ((int)0x864A),
        ProgramErrorPositionArb = ((int)0x864B),
        ProgramErrorPositionNv = ((int)0x864B),
        OffsetTextureRectangleNv = ((int)0x864C),
        OffsetTextureRectangleScaleNv = ((int)0x864D),
        DotProductTextureRectangleNv = ((int)0x864E),
        DepthClamp = ((int)0x864F),
        DepthClampNv = ((int)0x864F),
        VertexAttribArray0Nv = ((int)0x8650),
        VertexAttribArray1Nv = ((int)0x8651),
        VertexAttribArray2Nv = ((int)0x8652),
        VertexAttribArray3Nv = ((int)0x8653),
        VertexAttribArray4Nv = ((int)0x8654),
        VertexAttribArray5Nv = ((int)0x8655),
        VertexAttribArray6Nv = ((int)0x8656),
        VertexAttribArray7Nv = ((int)0x8657),
        VertexAttribArray8Nv = ((int)0x8658),
        VertexAttribArray9Nv = ((int)0x8659),
        VertexAttribArray10Nv = ((int)0x865A),
        VertexAttribArray11Nv = ((int)0x865B),
        VertexAttribArray12Nv = ((int)0x865C),
        VertexAttribArray13Nv = ((int)0x865D),
        VertexAttribArray14Nv = ((int)0x865E),
        VertexAttribArray15Nv = ((int)0x865F),
        Map1VertexAttrib04Nv = ((int)0x8660),
        Map1VertexAttrib14Nv = ((int)0x8661),
        Map1VertexAttrib24Nv = ((int)0x8662),
        Map1VertexAttrib34Nv = ((int)0x8663),
        Map1VertexAttrib44Nv = ((int)0x8664),
        Map1VertexAttrib54Nv = ((int)0x8665),
        Map1VertexAttrib64Nv = ((int)0x8666),
        Map1VertexAttrib74Nv = ((int)0x8667),
        Map1VertexAttrib84Nv = ((int)0x8668),
        Map1VertexAttrib94Nv = ((int)0x8669),
        Map1VertexAttrib104Nv = ((int)0x866A),
        Map1VertexAttrib114Nv = ((int)0x866B),
        Map1VertexAttrib124Nv = ((int)0x866C),
        Map1VertexAttrib134Nv = ((int)0x866D),
        Map1VertexAttrib144Nv = ((int)0x866E),
        Map1VertexAttrib154Nv = ((int)0x866F),
        Map2VertexAttrib04Nv = ((int)0x8670),
        Map2VertexAttrib14Nv = ((int)0x8671),
        Map2VertexAttrib24Nv = ((int)0x8672),
        Map2VertexAttrib34Nv = ((int)0x8673),
        Map2VertexAttrib44Nv = ((int)0x8674),
        Map2VertexAttrib54Nv = ((int)0x8675),
        Map2VertexAttrib64Nv = ((int)0x8676),
        Map2VertexAttrib74Nv = ((int)0x8677),
        ProgramBinding = ((int)0x8677),
        ProgramBindingArb = ((int)0x8677),
        Map2VertexAttrib84Nv = ((int)0x8678),
        Map2VertexAttrib94Nv = ((int)0x8679),
        Map2VertexAttrib104Nv = ((int)0x867A),
        Map2VertexAttrib114Nv = ((int)0x867B),
        Map2VertexAttrib124Nv = ((int)0x867C),
        Map2VertexAttrib134Nv = ((int)0x867D),
        Map2VertexAttrib144Nv = ((int)0x867E),
        Map2VertexAttrib154Nv = ((int)0x867F),
        TextureCompressedImageSize = ((int)0x86A0),
        TextureCompressedImageSizeArb = ((int)0x86A0),
        TextureCompressed = ((int)0x86A1),
        TextureCompressedArb = ((int)0x86A1),
        NumCompressedTextureFormats = ((int)0x86A2),
        NumCompressedTextureFormatsArb = ((int)0x86A2),
        CompressedTextureFormats = ((int)0x86A3),
        CompressedTextureFormatsArb = ((int)0x86A3),
        MaxVertexUnitsArb = ((int)0x86A4),
        ActiveVertexUnitsArb = ((int)0x86A5),
        WeightSumUnityArb = ((int)0x86A6),
        VertexBlendArb = ((int)0x86A7),
        CurrentWeightArb = ((int)0x86A8),
        WeightArrayTypeArb = ((int)0x86A9),
        WeightArrayStrideArb = ((int)0x86AA),
        WeightArraySizeArb = ((int)0x86AB),
        WeightArrayPointerArb = ((int)0x86AC),
        WeightArrayArb = ((int)0x86AD),
        Dot3Rgb = ((int)0x86AE),
        Dot3RgbArb = ((int)0x86AE),
        Dot3Rgba = ((int)0x86AF),
        Dot3RgbaArb = ((int)0x86AF),
        CompressedRgbFxt13Dfx = ((int)0x86B0),
        CompressedRgbaFxt13Dfx = ((int)0x86B1),
        Multisample3Dfx = ((int)0x86B2),
        SampleBuffers3Dfx = ((int)0x86B3),
        Samples3Dfx = ((int)0x86B4),
        Eval2DNv = ((int)0x86C0),
        EvalTriangular2DNv = ((int)0x86C1),
        MapTessellationNv = ((int)0x86C2),
        MapAttribUOrderNv = ((int)0x86C3),
        MapAttribVOrderNv = ((int)0x86C4),
        EvalFractionalTessellationNv = ((int)0x86C5),
        EvalVertexAttrib0Nv = ((int)0x86C6),
        EvalVertexAttrib1Nv = ((int)0x86C7),
        EvalVertexAttrib2Nv = ((int)0x86C8),
        EvalVertexAttrib3Nv = ((int)0x86C9),
        EvalVertexAttrib4Nv = ((int)0x86CA),
        EvalVertexAttrib5Nv = ((int)0x86CB),
        EvalVertexAttrib6Nv = ((int)0x86CC),
        EvalVertexAttrib7Nv = ((int)0x86CD),
        EvalVertexAttrib8Nv = ((int)0x86CE),
        EvalVertexAttrib9Nv = ((int)0x86CF),
        EvalVertexAttrib10Nv = ((int)0x86D0),
        EvalVertexAttrib11Nv = ((int)0x86D1),
        EvalVertexAttrib12Nv = ((int)0x86D2),
        EvalVertexAttrib13Nv = ((int)0x86D3),
        EvalVertexAttrib14Nv = ((int)0x86D4),
        EvalVertexAttrib15Nv = ((int)0x86D5),
        MaxMapTessellationNv = ((int)0x86D6),
        MaxRationalEvalOrderNv = ((int)0x86D7),
        RgbaUnsignedDotProductMappingNv = ((int)0x86D9),
        UnsignedIntS8S888Nv = ((int)0x86DA),
        UnsignedInt88S8S8RevNv = ((int)0x86DB),
        DsdtMagIntensityNv = ((int)0x86DC),
        ShaderConsistentNv = ((int)0x86DD),
        TextureShaderNv = ((int)0x86DE),
        ShaderOperationNv = ((int)0x86DF),
        CullModesNv = ((int)0x86E0),
        OffsetTexture2DMatrixNv = ((int)0x86E1),
        OffsetTextureMatrixNv = ((int)0x86E1),
        OffsetTexture2DScaleNv = ((int)0x86E2),
        OffsetTextureScaleNv = ((int)0x86E2),
        OffsetTexture2DBiasNv = ((int)0x86E3),
        OffsetTextureBiasNv = ((int)0x86E3),
        PreviousTextureInputNv = ((int)0x86E4),
        ConstEyeNv = ((int)0x86E5),
        PassThroughNv = ((int)0x86E6),
        CullFragmentNv = ((int)0x86E7),
        OffsetTexture2DNv = ((int)0x86E8),
        DependentArTexture2DNv = ((int)0x86E9),
        DependentGbTexture2DNv = ((int)0x86EA),
        DotProductNv = ((int)0x86EC),
        DotProductDepthReplaceNv = ((int)0x86ED),
        DotProductTexture2DNv = ((int)0x86EE),
        DotProductTexture3DNv = ((int)0x86EF),
        DotProductTextureCubeMapNv = ((int)0x86F0),
        DotProductDiffuseCubeMapNv = ((int)0x86F1),
        DotProductReflectCubeMapNv = ((int)0x86F2),
        DotProductConstEyeReflectCubeMapNv = ((int)0x86F3),
        HiloNv = ((int)0x86F4),
        DsdtNv = ((int)0x86F5),
        DsdtMagNv = ((int)0x86F6),
        DsdtMagVibNv = ((int)0x86F7),
        Hilo16Nv = ((int)0x86F8),
        SignedHiloNv = ((int)0x86F9),
        SignedHilo16Nv = ((int)0x86FA),
        SignedRgbaNv = ((int)0x86FB),
        SignedRgba8Nv = ((int)0x86FC),
        SignedRgbNv = ((int)0x86FE),
        SignedRgb8Nv = ((int)0x86FF),
        SignedLuminanceNv = ((int)0x8701),
        SignedLuminance8Nv = ((int)0x8702),
        SignedLuminanceAlphaNv = ((int)0x8703),
        SignedLuminance8Alpha8Nv = ((int)0x8704),
        SignedAlphaNv = ((int)0x8705),
        SignedAlpha8Nv = ((int)0x8706),
        SignedIntensityNv = ((int)0x8707),
        SignedIntensity8Nv = ((int)0x8708),
        Dsdt8Nv = ((int)0x8709),
        Dsdt8Mag8Nv = ((int)0x870A),
        Dsdt8Mag8Intensity8Nv = ((int)0x870B),
        SignedRgbUnsignedAlphaNv = ((int)0x870C),
        SignedRgb8UnsignedAlpha8Nv = ((int)0x870D),
        HiScaleNv = ((int)0x870E),
        LoScaleNv = ((int)0x870F),
        DsScaleNv = ((int)0x8710),
        DtScaleNv = ((int)0x8711),
        MagnitudeScaleNv = ((int)0x8712),
        VibranceScaleNv = ((int)0x8713),
        HiBiasNv = ((int)0x8714),
        LoBiasNv = ((int)0x8715),
        DsBiasNv = ((int)0x8716),
        DtBiasNv = ((int)0x8717),
        MagnitudeBiasNv = ((int)0x8718),
        VibranceBiasNv = ((int)0x8719),
        TextureBorderValuesNv = ((int)0x871A),
        TextureHiSizeNv = ((int)0x871B),
        TextureLoSizeNv = ((int)0x871C),
        TextureDsSizeNv = ((int)0x871D),
        TextureDtSizeNv = ((int)0x871E),
        TextureMagSizeNv = ((int)0x871F),
        Modelview2Arb = ((int)0x8722),
        Modelview3Arb = ((int)0x8723),
        Modelview4Arb = ((int)0x8724),
        Modelview5Arb = ((int)0x8725),
        Modelview6Arb = ((int)0x8726),
        Modelview7Arb = ((int)0x8727),
        Modelview8Arb = ((int)0x8728),
        Modelview9Arb = ((int)0x8729),
        Modelview10Arb = ((int)0x872A),
        Modelview11Arb = ((int)0x872B),
        Modelview12Arb = ((int)0x872C),
        Modelview13Arb = ((int)0x872D),
        Modelview14Arb = ((int)0x872E),
        Modelview15Arb = ((int)0x872F),
        Modelview16Arb = ((int)0x8730),
        Modelview17Arb = ((int)0x8731),
        Modelview18Arb = ((int)0x8732),
        Modelview19Arb = ((int)0x8733),
        Modelview20Arb = ((int)0x8734),
        Modelview21Arb = ((int)0x8735),
        Modelview22Arb = ((int)0x8736),
        Modelview23Arb = ((int)0x8737),
        Modelview24Arb = ((int)0x8738),
        Modelview25Arb = ((int)0x8739),
        Modelview26Arb = ((int)0x873A),
        Modelview27Arb = ((int)0x873B),
        Modelview28Arb = ((int)0x873C),
        Modelview29Arb = ((int)0x873D),
        Modelview30Arb = ((int)0x873E),
        Modelview31Arb = ((int)0x873F),
        Dot3RgbExt = ((int)0x8740),
        Dot3RgbaExt = ((int)0x8741),
        MirrorClampAti = ((int)0x8742),
        MirrorClampExt = ((int)0x8742),
        MirrorClampToEdgeAti = ((int)0x8743),
        MirrorClampToEdgeExt = ((int)0x8743),
        ModulateAddAti = ((int)0x8744),
        ModulateSignedAddAti = ((int)0x8745),
        ModulateSubtractAti = ((int)0x8746),
        YcbcrMesa = ((int)0x8757),
        PackInvertMesa = ((int)0x8758),
        Texture1DStackMesax = ((int)0x8759),
        Texture2DStackMesax = ((int)0x875A),
        ProxyTexture1DStackMesax = ((int)0x875B),
        ProxyTexture2DStackMesax = ((int)0x875C),
        Texture1DStackBindingMesax = ((int)0x875D),
        Texture2DStackBindingMesax = ((int)0x875E),
        StaticAti = ((int)0x8760),
        DynamicAti = ((int)0x8761),
        PreserveAti = ((int)0x8762),
        DiscardAti = ((int)0x8763),
        BufferSize = ((int)0x8764),
        BufferSizeArb = ((int)0x8764),
        ObjectBufferSizeAti = ((int)0x8764),
        BufferUsage = ((int)0x8765),
        BufferUsageArb = ((int)0x8765),
        ObjectBufferUsageAti = ((int)0x8765),
        ArrayObjectBufferAti = ((int)0x8766),
        ArrayObjectOffsetAti = ((int)0x8767),
        ElementArrayApple = ((int)0x8768),
        ElementArrayAti = ((int)0x8768),
        ElementArrayTypeApple = ((int)0x8769),
        ElementArrayTypeAti = ((int)0x8769),
        ElementArrayPointerApple = ((int)0x876A),
        ElementArrayPointerAti = ((int)0x876A),
        MaxVertexStreamsAti = ((int)0x876B),
        VertexStream0Ati = ((int)0x876C),
        VertexStream1Ati = ((int)0x876D),
        VertexStream2Ati = ((int)0x876E),
        VertexStream3Ati = ((int)0x876F),
        VertexStream4Ati = ((int)0x8770),
        VertexStream5Ati = ((int)0x8771),
        VertexStream6Ati = ((int)0x8772),
        VertexStream7Ati = ((int)0x8773),
        VertexSourceAti = ((int)0x8774),
        BumpRotMatrixAti = ((int)0x8775),
        BumpRotMatrixSizeAti = ((int)0x8776),
        BumpNumTexUnitsAti = ((int)0x8777),
        BumpTexUnitsAti = ((int)0x8778),
        DudvAti = ((int)0x8779),
        Du8dv8Ati = ((int)0x877A),
        BumpEnvmapAti = ((int)0x877B),
        BumpTargetAti = ((int)0x877C),
        VertexShaderExt = ((int)0x8780),
        VertexShaderBindingExt = ((int)0x8781),
        OpIndexExt = ((int)0x8782),
        OpNegateExt = ((int)0x8783),
        OpDot3Ext = ((int)0x8784),
        OpDot4Ext = ((int)0x8785),
        OpMulExt = ((int)0x8786),
        OpAddExt = ((int)0x8787),
        OpMaddExt = ((int)0x8788),
        OpFracExt = ((int)0x8789),
        OpMaxExt = ((int)0x878A),
        OpMinExt = ((int)0x878B),
        OpSetGeExt = ((int)0x878C),
        OpSetLtExt = ((int)0x878D),
        OpClampExt = ((int)0x878E),
        OpFloorExt = ((int)0x878F),
        OpRoundExt = ((int)0x8790),
        OpExpBase2Ext = ((int)0x8791),
        OpLogBase2Ext = ((int)0x8792),
        OpPowerExt = ((int)0x8793),
        OpRecipExt = ((int)0x8794),
        OpRecipSqrtExt = ((int)0x8795),
        OpSubExt = ((int)0x8796),
        OpCrossProductExt = ((int)0x8797),
        OpMultiplyMatrixExt = ((int)0x8798),
        OpMovExt = ((int)0x8799),
        OutputVertexExt = ((int)0x879A),
        OutputColor0Ext = ((int)0x879B),
        OutputColor1Ext = ((int)0x879C),
        OutputTextureCoord0Ext = ((int)0x879D),
        OutputTextureCoord1Ext = ((int)0x879E),
        OutputTextureCoord2Ext = ((int)0x879F),
        OutputTextureCoord3Ext = ((int)0x87A0),
        OutputTextureCoord4Ext = ((int)0x87A1),
        OutputTextureCoord5Ext = ((int)0x87A2),
        OutputTextureCoord6Ext = ((int)0x87A3),
        OutputTextureCoord7Ext = ((int)0x87A4),
        OutputTextureCoord8Ext = ((int)0x87A5),
        OutputTextureCoord9Ext = ((int)0x87A6),
        OutputTextureCoord10Ext = ((int)0x87A7),
        OutputTextureCoord11Ext = ((int)0x87A8),
        OutputTextureCoord12Ext = ((int)0x87A9),
        OutputTextureCoord13Ext = ((int)0x87AA),
        OutputTextureCoord14Ext = ((int)0x87AB),
        OutputTextureCoord15Ext = ((int)0x87AC),
        OutputTextureCoord16Ext = ((int)0x87AD),
        OutputTextureCoord17Ext = ((int)0x87AE),
        OutputTextureCoord18Ext = ((int)0x87AF),
        OutputTextureCoord19Ext = ((int)0x87B0),
        OutputTextureCoord20Ext = ((int)0x87B1),
        OutputTextureCoord21Ext = ((int)0x87B2),
        OutputTextureCoord22Ext = ((int)0x87B3),
        OutputTextureCoord23Ext = ((int)0x87B4),
        OutputTextureCoord24Ext = ((int)0x87B5),
        OutputTextureCoord25Ext = ((int)0x87B6),
        OutputTextureCoord26Ext = ((int)0x87B7),
        OutputTextureCoord27Ext = ((int)0x87B8),
        OutputTextureCoord28Ext = ((int)0x87B9),
        OutputTextureCoord29Ext = ((int)0x87BA),
        OutputTextureCoord30Ext = ((int)0x87BB),
        OutputTextureCoord31Ext = ((int)0x87BC),
        OutputFogExt = ((int)0x87BD),
        ScalarExt = ((int)0x87BE),
        VectorExt = ((int)0x87BF),
        MatrixExt = ((int)0x87C0),
        VariantExt = ((int)0x87C1),
        InvariantExt = ((int)0x87C2),
        LocalConstantExt = ((int)0x87C3),
        LocalExt = ((int)0x87C4),
        MaxVertexShaderInstructionsExt = ((int)0x87C5),
        MaxVertexShaderVariantsExt = ((int)0x87C6),
        MaxVertexShaderInvariantsExt = ((int)0x87C7),
        MaxVertexShaderLocalConstantsExt = ((int)0x87C8),
        MaxVertexShaderLocalsExt = ((int)0x87C9),
        MaxOptimizedVertexShaderInstructionsExt = ((int)0x87CA),
        MaxOptimizedVertexShaderVariantsExt = ((int)0x87CB),
        MaxOptimizedVertexShaderLocalConstantsExt = ((int)0x87CC),
        MaxOptimizedVertexShaderInvariantsExt = ((int)0x87CD),
        MaxOptimizedVertexShaderLocalsExt = ((int)0x87CE),
        VertexShaderInstructionsExt = ((int)0x87CF),
        VertexShaderVariantsExt = ((int)0x87D0),
        VertexShaderInvariantsExt = ((int)0x87D1),
        VertexShaderLocalConstantsExt = ((int)0x87D2),
        VertexShaderLocalsExt = ((int)0x87D3),
        VertexShaderOptimizedExt = ((int)0x87D4),
        XExt = ((int)0x87D5),
        YExt = ((int)0x87D6),
        ZExt = ((int)0x87D7),
        WExt = ((int)0x87D8),
        NegativeXExt = ((int)0x87D9),
        NegativeYExt = ((int)0x87DA),
        NegativeZExt = ((int)0x87DB),
        NegativeWExt = ((int)0x87DC),
        ZeroExt = ((int)0x87DD),
        OneExt = ((int)0x87DE),
        NegativeOneExt = ((int)0x87DF),
        NormalizedRangeExt = ((int)0x87E0),
        FullRangeExt = ((int)0x87E1),
        CurrentVertexExt = ((int)0x87E2),
        MvpMatrixExt = ((int)0x87E3),
        VariantValueExt = ((int)0x87E4),
        VariantDatatypeExt = ((int)0x87E5),
        VariantArrayStrideExt = ((int)0x87E6),
        VariantArrayTypeExt = ((int)0x87E7),
        VariantArrayExt = ((int)0x87E8),
        VariantArrayPointerExt = ((int)0x87E9),
        InvariantValueExt = ((int)0x87EA),
        InvariantDatatypeExt = ((int)0x87EB),
        LocalConstantValueExt = ((int)0x87EC),
        LocalConstantDatatypeExt = ((int)0x87ED),
        PnTrianglesAti = ((int)0x87F0),
        MaxPnTrianglesTesselationLevelAti = ((int)0x87F1),
        PnTrianglesPointModeAti = ((int)0x87F2),
        PnTrianglesNormalModeAti = ((int)0x87F3),
        PnTrianglesTesselationLevelAti = ((int)0x87F4),
        PnTrianglesPointModeLinearAti = ((int)0x87F5),
        PnTrianglesPointModeCubicAti = ((int)0x87F6),
        PnTrianglesNormalModeLinearAti = ((int)0x87F7),
        PnTrianglesNormalModeQuadraticAti = ((int)0x87F8),
        VboFreeMemoryAti = ((int)0x87FB),
        TextureFreeMemoryAti = ((int)0x87FC),
        RenderbufferFreeMemoryAti = ((int)0x87FD),
        StencilBackFunc = ((int)0x8800),
        StencilBackFuncAti = ((int)0x8800),
        StencilBackFail = ((int)0x8801),
        StencilBackFailAti = ((int)0x8801),
        StencilBackPassDepthFail = ((int)0x8802),
        StencilBackPassDepthFailAti = ((int)0x8802),
        StencilBackPassDepthPass = ((int)0x8803),
        StencilBackPassDepthPassAti = ((int)0x8803),
        FragmentProgram = ((int)0x8804),
        FragmentProgramArb = ((int)0x8804),
        ProgramAluInstructionsArb = ((int)0x8805),
        ProgramTexInstructionsArb = ((int)0x8806),
        ProgramTexIndirectionsArb = ((int)0x8807),
        ProgramNativeAluInstructionsArb = ((int)0x8808),
        ProgramNativeTexInstructionsArb = ((int)0x8809),
        ProgramNativeTexIndirectionsArb = ((int)0x880A),
        MaxProgramAluInstructionsArb = ((int)0x880B),
        MaxProgramTexInstructionsArb = ((int)0x880C),
        MaxProgramTexIndirectionsArb = ((int)0x880D),
        MaxProgramNativeAluInstructionsArb = ((int)0x880E),
        MaxProgramNativeTexInstructionsArb = ((int)0x880F),
        MaxProgramNativeTexIndirectionsArb = ((int)0x8810),
        Rgba32f = ((int)0x8814),
        Rgba32fArb = ((int)0x8814),
        RgbaFloat32Apple = ((int)0x8814),
        RgbaFloat32Ati = ((int)0x8814),
        Rgb32f = ((int)0x8815),
        Rgb32fArb = ((int)0x8815),
        RgbFloat32Apple = ((int)0x8815),
        RgbFloat32Ati = ((int)0x8815),
        Alpha32fArb = ((int)0x8816),
        AlphaFloat32Apple = ((int)0x8816),
        AlphaFloat32Ati = ((int)0x8816),
        Intensity32fArb = ((int)0x8817),
        IntensityFloat32Apple = ((int)0x8817),
        IntensityFloat32Ati = ((int)0x8817),
        Luminance32fArb = ((int)0x8818),
        LuminanceFloat32Apple = ((int)0x8818),
        LuminanceFloat32Ati = ((int)0x8818),
        LuminanceAlpha32fArb = ((int)0x8819),
        LuminanceAlphaFloat32Apple = ((int)0x8819),
        LuminanceAlphaFloat32Ati = ((int)0x8819),
        Rgba16f = ((int)0x881A),
        Rgba16fArb = ((int)0x881A),
        RgbaFloat16Apple = ((int)0x881A),
        RgbaFloat16Ati = ((int)0x881A),
        Rgb16f = ((int)0x881B),
        Rgb16fArb = ((int)0x881B),
        RgbFloat16Apple = ((int)0x881B),
        RgbFloat16Ati = ((int)0x881B),
        Alpha16fArb = ((int)0x881C),
        AlphaFloat16Apple = ((int)0x881C),
        AlphaFloat16Ati = ((int)0x881C),
        Intensity16fArb = ((int)0x881D),
        IntensityFloat16Apple = ((int)0x881D),
        IntensityFloat16Ati = ((int)0x881D),
        Luminance16fArb = ((int)0x881E),
        LuminanceFloat16Apple = ((int)0x881E),
        LuminanceFloat16Ati = ((int)0x881E),
        LuminanceAlpha16fArb = ((int)0x881F),
        LuminanceAlphaFloat16Apple = ((int)0x881F),
        LuminanceAlphaFloat16Ati = ((int)0x881F),
        RgbaFloatMode = ((int)0x8820),
        RgbaFloatModeArb = ((int)0x8820),
        TypeRgbaFloatAti = ((int)0x8820),
        MaxDrawBuffers = ((int)0x8824),
        MaxDrawBuffersArb = ((int)0x8824),
        MaxDrawBuffersAti = ((int)0x8824),
        DrawBuffer0 = ((int)0x8825),
        DrawBuffer0Arb = ((int)0x8825),
        DrawBuffer0Ati = ((int)0x8825),
        DrawBuffer1 = ((int)0x8826),
        DrawBuffer1Arb = ((int)0x8826),
        DrawBuffer1Ati = ((int)0x8826),
        DrawBuffer2 = ((int)0x8827),
        DrawBuffer2Arb = ((int)0x8827),
        DrawBuffer2Ati = ((int)0x8827),
        DrawBuffer3 = ((int)0x8828),
        DrawBuffer3Arb = ((int)0x8828),
        DrawBuffer3Ati = ((int)0x8828),
        DrawBuffer4 = ((int)0x8829),
        DrawBuffer4Arb = ((int)0x8829),
        DrawBuffer4Ati = ((int)0x8829),
        DrawBuffer5 = ((int)0x882A),
        DrawBuffer5Arb = ((int)0x882A),
        DrawBuffer5Ati = ((int)0x882A),
        DrawBuffer6 = ((int)0x882B),
        DrawBuffer6Arb = ((int)0x882B),
        DrawBuffer6Ati = ((int)0x882B),
        DrawBuffer7 = ((int)0x882C),
        DrawBuffer7Arb = ((int)0x882C),
        DrawBuffer7Ati = ((int)0x882C),
        DrawBuffer8 = ((int)0x882D),
        DrawBuffer8Arb = ((int)0x882D),
        DrawBuffer8Ati = ((int)0x882D),
        DrawBuffer9 = ((int)0x882E),
        DrawBuffer9Arb = ((int)0x882E),
        DrawBuffer9Ati = ((int)0x882E),
        DrawBuffer10 = ((int)0x882F),
        DrawBuffer10Arb = ((int)0x882F),
        DrawBuffer10Ati = ((int)0x882F),
        DrawBuffer11 = ((int)0x8830),
        DrawBuffer11Arb = ((int)0x8830),
        DrawBuffer11Ati = ((int)0x8830),
        DrawBuffer12 = ((int)0x8831),
        DrawBuffer12Arb = ((int)0x8831),
        DrawBuffer12Ati = ((int)0x8831),
        DrawBuffer13 = ((int)0x8832),
        DrawBuffer13Arb = ((int)0x8832),
        DrawBuffer13Ati = ((int)0x8832),
        DrawBuffer14 = ((int)0x8833),
        DrawBuffer14Arb = ((int)0x8833),
        DrawBuffer14Ati = ((int)0x8833),
        DrawBuffer15 = ((int)0x8834),
        DrawBuffer15Arb = ((int)0x8834),
        DrawBuffer15Ati = ((int)0x8834),
        ColorClearUnclampedValueAti = ((int)0x8835),
        BlendEquationAlpha = ((int)0x883D),
        BlendEquationAlphaExt = ((int)0x883D),
        MatrixPaletteArb = ((int)0x8840),
        MaxMatrixPaletteStackDepthArb = ((int)0x8841),
        MaxPaletteMatricesArb = ((int)0x8842),
        CurrentPaletteMatrixArb = ((int)0x8843),
        MatrixIndexArrayArb = ((int)0x8844),
        CurrentMatrixIndexArb = ((int)0x8845),
        MatrixIndexArraySizeArb = ((int)0x8846),
        MatrixIndexArrayTypeArb = ((int)0x8847),
        MatrixIndexArrayStrideArb = ((int)0x8848),
        MatrixIndexArrayPointerArb = ((int)0x8849),
        TextureDepthSize = ((int)0x884A),
        TextureDepthSizeArb = ((int)0x884A),
        DepthTextureMode = ((int)0x884B),
        DepthTextureModeArb = ((int)0x884B),
        TextureCompareMode = ((int)0x884C),
        TextureCompareModeArb = ((int)0x884C),
        TextureCompareFunc = ((int)0x884D),
        TextureCompareFuncArb = ((int)0x884D),
        CompareRefDepthToTextureExt = ((int)0x884E),
        CompareRefToTexture = ((int)0x884E),
        CompareRToTexture = ((int)0x884E),
        CompareRToTextureArb = ((int)0x884E),
        TextureCubeMapSeamless = ((int)0x884F),
        OffsetProjectiveTexture2DNv = ((int)0x8850),
        OffsetProjectiveTexture2DScaleNv = ((int)0x8851),
        OffsetProjectiveTextureRectangleNv = ((int)0x8852),
        OffsetProjectiveTextureRectangleScaleNv = ((int)0x8853),
        OffsetHiloTexture2DNv = ((int)0x8854),
        OffsetHiloTextureRectangleNv = ((int)0x8855),
        OffsetHiloProjectiveTexture2DNv = ((int)0x8856),
        OffsetHiloProjectiveTextureRectangleNv = ((int)0x8857),
        DependentHiloTexture2DNv = ((int)0x8858),
        DependentRgbTexture3DNv = ((int)0x8859),
        DependentRgbTextureCubeMapNv = ((int)0x885A),
        DotProductPassThroughNv = ((int)0x885B),
        DotProductTexture1DNv = ((int)0x885C),
        DotProductAffineDepthReplaceNv = ((int)0x885D),
        Hilo8Nv = ((int)0x885E),
        SignedHilo8Nv = ((int)0x885F),
        ForceBlueToOneNv = ((int)0x8860),
        PointSprite = ((int)0x8861),
        PointSpriteArb = ((int)0x8861),
        PointSpriteNv = ((int)0x8861),
        CoordReplace = ((int)0x8862),
        CoordReplaceArb = ((int)0x8862),
        CoordReplaceNv = ((int)0x8862),
        PointSpriteRModeNv = ((int)0x8863),
        PixelCounterBitsNv = ((int)0x8864),
        QueryCounterBits = ((int)0x8864),
        QueryCounterBitsArb = ((int)0x8864),
        CurrentOcclusionQueryIdNv = ((int)0x8865),
        CurrentQuery = ((int)0x8865),
        CurrentQueryArb = ((int)0x8865),
        PixelCountNv = ((int)0x8866),
        QueryResult = ((int)0x8866),
        QueryResultArb = ((int)0x8866),
        PixelCountAvailableNv = ((int)0x8867),
        QueryResultAvailable = ((int)0x8867),
        QueryResultAvailableArb = ((int)0x8867),
        MaxFragmentProgramLocalParametersNv = ((int)0x8868),
        MaxVertexAttribs = ((int)0x8869),
        MaxVertexAttribsArb = ((int)0x8869),
        ArrayNormalized = ((int)0x886A),
        VertexAttribArrayNormalized = ((int)0x886A),
        VertexAttribArrayNormalizedArb = ((int)0x886A),
        DepthStencilToRgbaNv = ((int)0x886E),
        DepthStencilToBgraNv = ((int)0x886F),
        FragmentProgramNv = ((int)0x8870),
        MaxTextureCoords = ((int)0x8871),
        MaxTextureCoordsArb = ((int)0x8871),
        MaxTextureCoordsNv = ((int)0x8871),
        MaxTextureImageUnits = ((int)0x8872),
        MaxTextureImageUnitsArb = ((int)0x8872),
        MaxTextureImageUnitsNv = ((int)0x8872),
        FragmentProgramBindingNv = ((int)0x8873),
        ProgramErrorStringArb = ((int)0x8874),
        ProgramErrorStringNv = ((int)0x8874),
        ProgramFormatAsciiArb = ((int)0x8875),
        ProgramFormat = ((int)0x8876),
        ProgramFormatArb = ((int)0x8876),
        WritePixelDataRangeNv = ((int)0x8878),
        ReadPixelDataRangeNv = ((int)0x8879),
        WritePixelDataRangeLengthNv = ((int)0x887A),
        ReadPixelDataRangeLengthNv = ((int)0x887B),
        WritePixelDataRangePointerNv = ((int)0x887C),
        ReadPixelDataRangePointerNv = ((int)0x887D),
        FloatRNv = ((int)0x8880),
        FloatRgNv = ((int)0x8881),
        FloatRgbNv = ((int)0x8882),
        FloatRgbaNv = ((int)0x8883),
        FloatR16Nv = ((int)0x8884),
        FloatR32Nv = ((int)0x8885),
        FloatRg16Nv = ((int)0x8886),
        FloatRg32Nv = ((int)0x8887),
        FloatRgb16Nv = ((int)0x8888),
        FloatRgb32Nv = ((int)0x8889),
        FloatRgba16Nv = ((int)0x888A),
        FloatRgba32Nv = ((int)0x888B),
        TextureFloatComponentsNv = ((int)0x888C),
        FloatClearColorValueNv = ((int)0x888D),
        FloatRgbaModeNv = ((int)0x888E),
        TextureUnsignedRemapModeNv = ((int)0x888F),
        DepthBoundsTestExt = ((int)0x8890),
        DepthBoundsExt = ((int)0x8891),
        ArrayBuffer = ((int)0x8892),
        ArrayBufferArb = ((int)0x8892),
        ElementArrayBuffer = ((int)0x8893),
        ElementArrayBufferArb = ((int)0x8893),
        ArrayBufferBinding = ((int)0x8894),
        ArrayBufferBindingArb = ((int)0x8894),
        ElementArrayBufferBinding = ((int)0x8895),
        ElementArrayBufferBindingArb = ((int)0x8895),
        VertexArrayBufferBinding = ((int)0x8896),
        VertexArrayBufferBindingArb = ((int)0x8896),
        NormalArrayBufferBinding = ((int)0x8897),
        NormalArrayBufferBindingArb = ((int)0x8897),
        ColorArrayBufferBinding = ((int)0x8898),
        ColorArrayBufferBindingArb = ((int)0x8898),
        IndexArrayBufferBinding = ((int)0x8899),
        IndexArrayBufferBindingArb = ((int)0x8899),
        TextureCoordArrayBufferBinding = ((int)0x889A),
        TextureCoordArrayBufferBindingArb = ((int)0x889A),
        EdgeFlagArrayBufferBinding = ((int)0x889B),
        EdgeFlagArrayBufferBindingArb = ((int)0x889B),
        SecondaryColorArrayBufferBinding = ((int)0x889C),
        SecondaryColorArrayBufferBindingArb = ((int)0x889C),
        FogCoordArrayBufferBinding = ((int)0x889D),
        FogCoordinateArrayBufferBinding = ((int)0x889D),
        FogCoordinateArrayBufferBindingArb = ((int)0x889D),
        WeightArrayBufferBinding = ((int)0x889E),
        WeightArrayBufferBindingArb = ((int)0x889E),
        VertexAttribArrayBufferBinding = ((int)0x889F),
        VertexAttribArrayBufferBindingArb = ((int)0x889F),
        ProgramInstruction = ((int)0x88A0),
        ProgramInstructionsArb = ((int)0x88A0),
        MaxProgramInstructions = ((int)0x88A1),
        MaxProgramInstructionsArb = ((int)0x88A1),
        ProgramNativeInstructions = ((int)0x88A2),
        ProgramNativeInstructionsArb = ((int)0x88A2),
        MaxProgramNativeInstructions = ((int)0x88A3),
        MaxProgramNativeInstructionsArb = ((int)0x88A3),
        ProgramTemporaries = ((int)0x88A4),
        ProgramTemporariesArb = ((int)0x88A4),
        MaxProgramTemporaries = ((int)0x88A5),
        MaxProgramTemporariesArb = ((int)0x88A5),
        ProgramNativeTemporaries = ((int)0x88A6),
        ProgramNativeTemporariesArb = ((int)0x88A6),
        MaxProgramNativeTemporaries = ((int)0x88A7),
        MaxProgramNativeTemporariesArb = ((int)0x88A7),
        ProgramParameters = ((int)0x88A8),
        ProgramParametersArb = ((int)0x88A8),
        MaxProgramParameters = ((int)0x88A9),
        MaxProgramParametersArb = ((int)0x88A9),
        ProgramNativeParameters = ((int)0x88AA),
        ProgramNativeParametersArb = ((int)0x88AA),
        MaxProgramNativeParameters = ((int)0x88AB),
        MaxProgramNativeParametersArb = ((int)0x88AB),
        ProgramAttribs = ((int)0x88AC),
        ProgramAttribsArb = ((int)0x88AC),
        MaxProgramAttribs = ((int)0x88AD),
        MaxProgramAttribsArb = ((int)0x88AD),
        ProgramNativeAttribs = ((int)0x88AE),
        ProgramNativeAttribsArb = ((int)0x88AE),
        MaxProgramNativeAttribs = ((int)0x88AF),
        MaxProgramNativeAttribsArb = ((int)0x88AF),
        ProgramAddressRegisters = ((int)0x88B0),
        ProgramAddressRegistersArb = ((int)0x88B0),
        MaxProgramAddressRegisters = ((int)0x88B1),
        MaxProgramAddressRegistersArb = ((int)0x88B1),
        ProgramNativeAddressRegisters = ((int)0x88B2),
        ProgramNativeAddressRegistersArb = ((int)0x88B2),
        MaxProgramNativeAddressRegisters = ((int)0x88B3),
        MaxProgramNativeAddressRegistersArb = ((int)0x88B3),
        MaxProgramLocalParameters = ((int)0x88B4),
        MaxProgramLocalParametersArb = ((int)0x88B4),
        MaxProgramEnvParameters = ((int)0x88B5),
        MaxProgramEnvParametersArb = ((int)0x88B5),
        ProgramUnderNativeLimits = ((int)0x88B6),
        ProgramUnderNativeLimitsArb = ((int)0x88B6),
        TransposeCurrentMatrixArb = ((int)0x88B7),
        ReadOnly = ((int)0x88B8),
        ReadOnlyArb = ((int)0x88B8),
        WriteOnly = ((int)0x88B9),
        WriteOnlyArb = ((int)0x88B9),
        ReadWrite = ((int)0x88BA),
        ReadWriteArb = ((int)0x88BA),
        BufferAccess = ((int)0x88BB),
        BufferAccessArb = ((int)0x88BB),
        BufferMapped = ((int)0x88BC),
        BufferMappedArb = ((int)0x88BC),
        BufferMapPointer = ((int)0x88BD),
        BufferMapPointerArb = ((int)0x88BD),
        TimeElapsedExt = ((int)0x88BF),
        Matrix0 = ((int)0x88C0),
        Matrix0Arb = ((int)0x88C0),
        Matrix1 = ((int)0x88C1),
        Matrix1Arb = ((int)0x88C1),
        Matrix2 = ((int)0x88C2),
        Matrix2Arb = ((int)0x88C2),
        Matrix3 = ((int)0x88C3),
        Matrix3Arb = ((int)0x88C3),
        Matrix4 = ((int)0x88C4),
        Matrix4Arb = ((int)0x88C4),
        Matrix5 = ((int)0x88C5),
        Matrix5Arb = ((int)0x88C5),
        Matrix6 = ((int)0x88C6),
        Matrix6Arb = ((int)0x88C6),
        Matrix7 = ((int)0x88C7),
        Matrix7Arb = ((int)0x88C7),
        Matrix8 = ((int)0x88C8),
        Matrix8Arb = ((int)0x88C8),
        Matrix9 = ((int)0x88C9),
        Matrix9Arb = ((int)0x88C9),
        Matrix10 = ((int)0x88CA),
        Matrix10Arb = ((int)0x88CA),
        Matrix11 = ((int)0x88CB),
        Matrix11Arb = ((int)0x88CB),
        Matrix12 = ((int)0x88CC),
        Matrix12Arb = ((int)0x88CC),
        Matrix13 = ((int)0x88CD),
        Matrix13Arb = ((int)0x88CD),
        Matrix14 = ((int)0x88CE),
        Matrix14Arb = ((int)0x88CE),
        Matrix15 = ((int)0x88CF),
        Matrix15Arb = ((int)0x88CF),
        Matrix16 = ((int)0x88D0),
        Matrix16Arb = ((int)0x88D0),
        Matrix17 = ((int)0x88D1),
        Matrix17Arb = ((int)0x88D1),
        Matrix18 = ((int)0x88D2),
        Matrix18Arb = ((int)0x88D2),
        Matrix19 = ((int)0x88D3),
        Matrix19Arb = ((int)0x88D3),
        Matrix20 = ((int)0x88D4),
        Matrix20Arb = ((int)0x88D4),
        Matrix21 = ((int)0x88D5),
        Matrix21Arb = ((int)0x88D5),
        Matrix22 = ((int)0x88D6),
        Matrix22Arb = ((int)0x88D6),
        Matrix23 = ((int)0x88D7),
        Matrix23Arb = ((int)0x88D7),
        Matrix24 = ((int)0x88D8),
        Matrix24Arb = ((int)0x88D8),
        Matrix25 = ((int)0x88D9),
        Matrix25Arb = ((int)0x88D9),
        Matrix26 = ((int)0x88DA),
        Matrix26Arb = ((int)0x88DA),
        Matrix27 = ((int)0x88DB),
        Matrix27Arb = ((int)0x88DB),
        Matrix28 = ((int)0x88DC),
        Matrix28Arb = ((int)0x88DC),
        Matrix29 = ((int)0x88DD),
        Matrix29Arb = ((int)0x88DD),
        Matrix30 = ((int)0x88DE),
        Matrix30Arb = ((int)0x88DE),
        Matrix31 = ((int)0x88DF),
        Matrix31Arb = ((int)0x88DF),
        StreamDraw = ((int)0x88E0),
        StreamDrawArb = ((int)0x88E0),
        StreamRead = ((int)0x88E1),
        StreamReadArb = ((int)0x88E1),
        StreamCopy = ((int)0x88E2),
        StreamCopyArb = ((int)0x88E2),
        StaticDraw = ((int)0x88E4),
        StaticDrawArb = ((int)0x88E4),
        StaticRead = ((int)0x88E5),
        StaticReadArb = ((int)0x88E5),
        StaticCopy = ((int)0x88E6),
        StaticCopyArb = ((int)0x88E6),
        DynamicDraw = ((int)0x88E8),
        DynamicDrawArb = ((int)0x88E8),
        DynamicRead = ((int)0x88E9),
        DynamicReadArb = ((int)0x88E9),
        DynamicCopy = ((int)0x88EA),
        DynamicCopyArb = ((int)0x88EA),
        PixelPackBuffer = ((int)0x88EB),
        PixelPackBufferArb = ((int)0x88EB),
        PixelPackBufferExt = ((int)0x88EB),
        PixelUnpackBuffer = ((int)0x88EC),
        PixelUnpackBufferArb = ((int)0x88EC),
        PixelUnpackBufferExt = ((int)0x88EC),
        PixelPackBufferBinding = ((int)0x88ED),
        PixelPackBufferBindingArb = ((int)0x88ED),
        PixelPackBufferBindingExt = ((int)0x88ED),
        PixelUnpackBufferBinding = ((int)0x88EF),
        PixelUnpackBufferBindingArb = ((int)0x88EF),
        PixelUnpackBufferBindingExt = ((int)0x88EF),
        Depth24Stencil8 = ((int)0x88F0),
        Depth24Stencil8Ext = ((int)0x88F0),
        TextureStencilSize = ((int)0x88F1),
        TextureStencilSizeExt = ((int)0x88F1),
        StencilTagBitsExt = ((int)0x88F2),
        StencilClearTagValueExt = ((int)0x88F3),
        MaxProgramExecInstructionsNv = ((int)0x88F4),
        MaxProgramCallDepthNv = ((int)0x88F5),
        MaxProgramIfDepthNv = ((int)0x88F6),
        MaxProgramLoopDepthNv = ((int)0x88F7),
        MaxProgramLoopCountNv = ((int)0x88F8),
        VertexAttribArrayInteger = ((int)0x88FD),
        VertexAttribArrayIntegerNv = ((int)0x88FD),
        ArrayDivisor = ((int)0x88FE),
        VertexAttribArrayDivisorArb = ((int)0x88FE),
        MaxArrayTextureLayers = ((int)0x88FF),
        MaxArrayTextureLayersExt = ((int)0x88FF),
        MinProgramTexelOffset = ((int)0x8904),
        MinProgramTexelOffsetNv = ((int)0x8904),
        MaxProgramTexelOffset = ((int)0x8905),
        MaxProgramTexelOffsetNv = ((int)0x8905),
        ProgramAttribComponentsNv = ((int)0x8906),
        ProgramResultComponentsNv = ((int)0x8907),
        MaxProgramAttribComponentsNv = ((int)0x8908),
        MaxProgramResultComponentsNv = ((int)0x8909),
        StencilTestTwoSideExt = ((int)0x8910),
        ActiveStencilFaceExt = ((int)0x8911),
        MirrorClampToBorderExt = ((int)0x8912),
        SamplesPassed = ((int)0x8914),
        SamplesPassedArb = ((int)0x8914),
        GeometryVerticesOut = ((int)0x8916),
        GeometryInputType = ((int)0x8917),
        GeometryOutputType = ((int)0x8918),
        ClampVertexColor = ((int)0x891A),
        ClampVertexColorArb = ((int)0x891A),
        ClampFragmentColor = ((int)0x891B),
        ClampFragmentColorArb = ((int)0x891B),
        ClampReadColor = ((int)0x891C),
        ClampReadColorArb = ((int)0x891C),
        FixedOnly = ((int)0x891D),
        FixedOnlyArb = ((int)0x891D),
        FragmentShaderAti = ((int)0x8920),
        Reg0Ati = ((int)0x8921),
        Reg1Ati = ((int)0x8922),
        Reg2Ati = ((int)0x8923),
        Reg3Ati = ((int)0x8924),
        Reg4Ati = ((int)0x8925),
        Reg5Ati = ((int)0x8926),
        Reg6Ati = ((int)0x8927),
        Reg7Ati = ((int)0x8928),
        Reg8Ati = ((int)0x8929),
        Reg9Ati = ((int)0x892A),
        Reg10Ati = ((int)0x892B),
        Reg11Ati = ((int)0x892C),
        Reg12Ati = ((int)0x892D),
        Reg13Ati = ((int)0x892E),
        Reg14Ati = ((int)0x892F),
        Reg15Ati = ((int)0x8930),
        Reg16Ati = ((int)0x8931),
        Reg17Ati = ((int)0x8932),
        Reg18Ati = ((int)0x8933),
        Reg19Ati = ((int)0x8934),
        Reg20Ati = ((int)0x8935),
        Reg21Ati = ((int)0x8936),
        Reg22Ati = ((int)0x8937),
        Reg23Ati = ((int)0x8938),
        Reg24Ati = ((int)0x8939),
        Reg25Ati = ((int)0x893A),
        Reg26Ati = ((int)0x893B),
        Reg27Ati = ((int)0x893C),
        Reg28Ati = ((int)0x893D),
        Reg29Ati = ((int)0x893E),
        Reg30Ati = ((int)0x893F),
        Reg31Ati = ((int)0x8940),
        Con0Ati = ((int)0x8941),
        Con1Ati = ((int)0x8942),
        Con2Ati = ((int)0x8943),
        Con3Ati = ((int)0x8944),
        Con4Ati = ((int)0x8945),
        Con5Ati = ((int)0x8946),
        Con6Ati = ((int)0x8947),
        Con7Ati = ((int)0x8948),
        Con8Ati = ((int)0x8949),
        Con9Ati = ((int)0x894A),
        Con10Ati = ((int)0x894B),
        Con11Ati = ((int)0x894C),
        Con12Ati = ((int)0x894D),
        Con13Ati = ((int)0x894E),
        Con14Ati = ((int)0x894F),
        Con15Ati = ((int)0x8950),
        Con16Ati = ((int)0x8951),
        Con17Ati = ((int)0x8952),
        Con18Ati = ((int)0x8953),
        Con19Ati = ((int)0x8954),
        Con20Ati = ((int)0x8955),
        Con21Ati = ((int)0x8956),
        Con22Ati = ((int)0x8957),
        Con23Ati = ((int)0x8958),
        Con24Ati = ((int)0x8959),
        Con25Ati = ((int)0x895A),
        Con26Ati = ((int)0x895B),
        Con27Ati = ((int)0x895C),
        Con28Ati = ((int)0x895D),
        Con29Ati = ((int)0x895E),
        Con30Ati = ((int)0x895F),
        Con31Ati = ((int)0x8960),
        MovAti = ((int)0x8961),
        AddAti = ((int)0x8963),
        MulAti = ((int)0x8964),
        SubAti = ((int)0x8965),
        Dot3Ati = ((int)0x8966),
        Dot4Ati = ((int)0x8967),
        MadAti = ((int)0x8968),
        LerpAti = ((int)0x8969),
        CndAti = ((int)0x896A),
        Cnd0Ati = ((int)0x896B),
        Dot2AddAti = ((int)0x896C),
        SecondaryInterpolatorAti = ((int)0x896D),
        NumFragmentRegistersAti = ((int)0x896E),
        NumFragmentConstantsAti = ((int)0x896F),
        NumPassesAti = ((int)0x8970),
        NumInstructionsPerPassAti = ((int)0x8971),
        NumInstructionsTotalAti = ((int)0x8972),
        NumInputInterpolatorComponentsAti = ((int)0x8973),
        NumLoopbackComponentsAti = ((int)0x8974),
        ColorAlphaPairingAti = ((int)0x8975),
        SwizzleStrAti = ((int)0x8976),
        SwizzleStqAti = ((int)0x8977),
        SwizzleStrDrAti = ((int)0x8978),
        SwizzleStqDqAti = ((int)0x8979),
        SwizzleStrqAti = ((int)0x897A),
        SwizzleStrqDqAti = ((int)0x897B),
        InterlaceOml = ((int)0x8980),
        InterlaceReadOml = ((int)0x8981),
        FormatSubsample2424Oml = ((int)0x8982),
        FormatSubsample244244Oml = ((int)0x8983),
        PackResampleOml = ((int)0x8984),
        UnpackResampleOml = ((int)0x8985),
        ResampleReplicateOml = ((int)0x8986),
        ResampleZeroFillOml = ((int)0x8987),
        ResampleAverageOml = ((int)0x8988),
        ResampleDecimateOml = ((int)0x8989),
        VertexAttribMap1Apple = ((int)0x8A00),
        VertexAttribMap2Apple = ((int)0x8A01),
        VertexAttribMap1SizeApple = ((int)0x8A02),
        VertexAttribMap1CoeffApple = ((int)0x8A03),
        VertexAttribMap1OrderApple = ((int)0x8A04),
        VertexAttribMap1DomainApple = ((int)0x8A05),
        VertexAttribMap2SizeApple = ((int)0x8A06),
        VertexAttribMap2CoeffApple = ((int)0x8A07),
        VertexAttribMap2OrderApple = ((int)0x8A08),
        VertexAttribMap2DomainApple = ((int)0x8A09),
        DrawPixelsApple = ((int)0x8A0A),
        FenceApple = ((int)0x8A0B),
        ColorFloatApple = ((int)0x8A0F),
        UniformBuffer = ((int)0x8A11),
        BufferSerializedModifyApple = ((int)0x8A12),
        BufferFlushingUnmapApple = ((int)0x8A13),
        AuxDepthStencilApple = ((int)0x8A14),
        PackRowBytesApple = ((int)0x8A15),
        UnpackRowBytesApple = ((int)0x8A16),
        ReleasedApple = ((int)0x8A19),
        VolatileApple = ((int)0x8A1A),
        RetainedApple = ((int)0x8A1B),
        UndefinedApple = ((int)0x8A1C),
        PurgeableApple = ((int)0x8A1D),
        UniformBufferBinding = ((int)0x8A28),
        UniformBufferStart = ((int)0x8A29),
        UniformBufferSize = ((int)0x8A2A),
        MaxVertexUniformBlocks = ((int)0x8A2B),
        MaxGeometryUniformBlocks = ((int)0x8A2C),
        MaxFragmentUniformBlocks = ((int)0x8A2D),
        MaxCombinedUniformBlocks = ((int)0x8A2E),
        MaxUniformBufferBindings = ((int)0x8A2F),
        MaxUniformBlockSize = ((int)0x8A30),
        MaxCombinedVertexUniformComponents = ((int)0x8A31),
        MaxCombinedGeometryUniformComponents = ((int)0x8A32),
        MaxCombinedFragmentUniformComponents = ((int)0x8A33),
        UniformBufferOffsetAlignment = ((int)0x8A34),
        ActiveUniformBlockMaxNameLength = ((int)0x8A35),
        ActiveUniformBlocks = ((int)0x8A36),
        UniformType = ((int)0x8A37),
        UniformSize = ((int)0x8A38),
        UniformNameLength = ((int)0x8A39),
        UniformBlockIndex = ((int)0x8A3A),
        UniformOffset = ((int)0x8A3B),
        UniformArrayStride = ((int)0x8A3C),
        UniformMatrixStride = ((int)0x8A3D),
        UniformIsRowMajor = ((int)0x8A3E),
        UniformBlockBinding = ((int)0x8A3F),
        UniformBlockDataSize = ((int)0x8A40),
        UniformBlockNameLength = ((int)0x8A41),
        UniformBlockActiveUniforms = ((int)0x8A42),
        UniformBlockActiveUniformIndices = ((int)0x8A43),
        UniformBlockReferencedByVertexShader = ((int)0x8A44),
        UniformBlockReferencedByGeometryShader = ((int)0x8A45),
        UniformBlockReferencedByFragmentShader = ((int)0x8A46),
        FragmentShader = ((int)0x8B30),
        FragmentShaderArb = ((int)0x8B30),
        VertexShader = ((int)0x8B31),
        VertexShaderArb = ((int)0x8B31),
        ProgramObjectArb = ((int)0x8B40),
        ShaderObjectArb = ((int)0x8B48),
        MaxFragmentUniformComponents = ((int)0x8B49),
        MaxFragmentUniformComponentsArb = ((int)0x8B49),
        MaxVertexUniformComponents = ((int)0x8B4A),
        MaxVertexUniformComponentsArb = ((int)0x8B4A),
        MaxVaryingComponents = ((int)0x8B4B),
        MaxVaryingComponentsExt = ((int)0x8B4B),
        MaxVaryingFloats = ((int)0x8B4B),
        MaxVaryingFloatsArb = ((int)0x8B4B),
        MaxVertexTextureImageUnits = ((int)0x8B4C),
        MaxVertexTextureImageUnitsArb = ((int)0x8B4C),
        MaxCombinedTextureImageUnits = ((int)0x8B4D),
        MaxCombinedTextureImageUnitsArb = ((int)0x8B4D),
        ObjectTypeArb = ((int)0x8B4E),
        ObjectSubtypeArb = ((int)0x8B4F),
        ShaderType = ((int)0x8B4F),
        FloatVec2 = ((int)0x8B50),
        FloatVec2Arb = ((int)0x8B50),
        FloatVec3 = ((int)0x8B51),
        FloatVec3Arb = ((int)0x8B51),
        FloatVec4 = ((int)0x8B52),
        FloatVec4Arb = ((int)0x8B52),
        IntVec2 = ((int)0x8B53),
        IntVec2Arb = ((int)0x8B53),
        IntVec3 = ((int)0x8B54),
        IntVec3Arb = ((int)0x8B54),
        IntVec4 = ((int)0x8B55),
        IntVec4Arb = ((int)0x8B55),
        Bool = ((int)0x8B56),
        BoolArb = ((int)0x8B56),
        BoolVec2 = ((int)0x8B57),
        BoolVec2Arb = ((int)0x8B57),
        BoolVec3 = ((int)0x8B58),
        BoolVec3Arb = ((int)0x8B58),
        BoolVec4 = ((int)0x8B59),
        BoolVec4Arb = ((int)0x8B59),
        FloatMat2 = ((int)0x8B5A),
        FloatMat2Arb = ((int)0x8B5A),
        FloatMat3 = ((int)0x8B5B),
        FloatMat3Arb = ((int)0x8B5B),
        FloatMat4 = ((int)0x8B5C),
        FloatMat4Arb = ((int)0x8B5C),
        Sampler1D = ((int)0x8B5D),
        Sampler1DArb = ((int)0x8B5D),
        Sampler2D = ((int)0x8B5E),
        Sampler2DArb = ((int)0x8B5E),
        Sampler3D = ((int)0x8B5F),
        Sampler3DArb = ((int)0x8B5F),
        SamplerCube = ((int)0x8B60),
        SamplerCubeArb = ((int)0x8B60),
        Sampler1DShadow = ((int)0x8B61),
        Sampler1DShadowArb = ((int)0x8B61),
        Sampler2DShadow = ((int)0x8B62),
        Sampler2DShadowArb = ((int)0x8B62),
        Sampler2DRect = ((int)0x8B63),
        Sampler2DRectArb = ((int)0x8B63),
        Sampler2DRectShadow = ((int)0x8B64),
        Sampler2DRectShadowArb = ((int)0x8B64),
        FloatMat2x3 = ((int)0x8B65),
        FloatMat2x4 = ((int)0x8B66),
        FloatMat3x2 = ((int)0x8B67),
        FloatMat3x4 = ((int)0x8B68),
        FloatMat4x2 = ((int)0x8B69),
        FloatMat4x3 = ((int)0x8B6A),
        DeleteStatus = ((int)0x8B80),
        ObjectDeleteStatusArb = ((int)0x8B80),
        CompileStatus = ((int)0x8B81),
        ObjectCompileStatusArb = ((int)0x8B81),
        LinkStatus = ((int)0x8B82),
        ObjectLinkStatusArb = ((int)0x8B82),
        ObjectValidateStatusArb = ((int)0x8B83),
        ValidateStatus = ((int)0x8B83),
        InfoLogLength = ((int)0x8B84),
        ObjectInfoLogLengthArb = ((int)0x8B84),
        AttachedShaders = ((int)0x8B85),
        ObjectAttachedObjectsArb = ((int)0x8B85),
        ActiveUniforms = ((int)0x8B86),
        ObjectActiveUniformsArb = ((int)0x8B86),
        ActiveUniformMaxLength = ((int)0x8B87),
        ObjectActiveUniformMaxLengthArb = ((int)0x8B87),
        ObjectShaderSourceLengthArb = ((int)0x8B88),
        ShaderSourceLength = ((int)0x8B88),
        ActiveAttributes = ((int)0x8B89),
        ObjectActiveAttributesArb = ((int)0x8B89),
        ActiveAttributeMaxLength = ((int)0x8B8A),
        ObjectActiveAttributeMaxLengthArb = ((int)0x8B8A),
        FragmentShaderDerivativeHint = ((int)0x8B8B),
        FragmentShaderDerivativeHintArb = ((int)0x8B8B),
        ShadingLanguageVersion = ((int)0x8B8C),
        ShadingLanguageVersionArb = ((int)0x8B8C),
        CurrentProgram = ((int)0x8B8D),
        ImplementationColorReadTypeOes = ((int)0x8B9A),
        ImplementationColorReadFormatOes = ((int)0x8B9B),
        CounterTypeAmd = ((int)0x8BC0),
        CounterRangeAmd = ((int)0x8BC1),
        UnsignedInt64Amd = ((int)0x8BC2),
        PercentageAmd = ((int)0x8BC3),
        PerfmonResultAvailableAmd = ((int)0x8BC4),
        PerfmonResultSizeAmd = ((int)0x8BC5),
        PerfmonResultAmd = ((int)0x8BC6),
        TextureRedType = ((int)0x8C10),
        TextureRedTypeArb = ((int)0x8C10),
        TextureGreenType = ((int)0x8C11),
        TextureGreenTypeArb = ((int)0x8C11),
        TextureBlueType = ((int)0x8C12),
        TextureBlueTypeArb = ((int)0x8C12),
        TextureAlphaType = ((int)0x8C13),
        TextureAlphaTypeArb = ((int)0x8C13),
        TextureLuminanceType = ((int)0x8C14),
        TextureLuminanceTypeArb = ((int)0x8C14),
        TextureIntensityType = ((int)0x8C15),
        TextureIntensityTypeArb = ((int)0x8C15),
        TextureDepthType = ((int)0x8C16),
        TextureDepthTypeArb = ((int)0x8C16),
        UnsignedNormalized = ((int)0x8C17),
        UnsignedNormalizedArb = ((int)0x8C17),
        Texture1DArray = ((int)0x8C18),
        Texture1DArrayExt = ((int)0x8C18),
        ProxyTexture1DArray = ((int)0x8C19),
        ProxyTexture1DArrayExt = ((int)0x8C19),
        Texture2DArray = ((int)0x8C1A),
        Texture2DArrayExt = ((int)0x8C1A),
        ProxyTexture2DArray = ((int)0x8C1B),
        ProxyTexture2DArrayExt = ((int)0x8C1B),
        TextureBinding1DArray = ((int)0x8C1C),
        TextureBinding1DArrayExt = ((int)0x8C1C),
        TextureBinding2DArray = ((int)0x8C1D),
        TextureBinding2DArrayExt = ((int)0x8C1D),
        GeometryProgramNv = ((int)0x8C26),
        MaxProgramOutputVerticesNv = ((int)0x8C27),
        MaxProgramTotalOutputComponentsNv = ((int)0x8C28),
        MaxGeometryTextureImageUnits = ((int)0x8C29),
        MaxGeometryTextureImageUnitsArb = ((int)0x8C29),
        MaxGeometryTextureImageUnitsExt = ((int)0x8C29),
        TextureBuffer = ((int)0x8C2A),
        TextureBufferArb = ((int)0x8C2A),
        TextureBufferExt = ((int)0x8C2A),
        MaxTextureBufferSize = ((int)0x8C2B),
        MaxTextureBufferSizeArb = ((int)0x8C2B),
        MaxTextureBufferSizeExt = ((int)0x8C2B),
        TextureBindingBuffer = ((int)0x8C2C),
        TextureBindingBufferArb = ((int)0x8C2C),
        TextureBindingBufferExt = ((int)0x8C2C),
        TextureBufferDataStoreBinding = ((int)0x8C2D),
        TextureBufferDataStoreBindingArb = ((int)0x8C2D),
        TextureBufferDataStoreBindingExt = ((int)0x8C2D),
        TextureBufferFormat = ((int)0x8C2E),
        TextureBufferFormatArb = ((int)0x8C2E),
        TextureBufferFormatExt = ((int)0x8C2E),
        SampleShading = ((int)0x8C36),
        MinSampleShadingValue = ((int)0x8C37),
        R11fG11fB10f = ((int)0x8C3A),
        R11fG11fB10fExt = ((int)0x8C3A),
        UnsignedInt10F11F11FRev = ((int)0x8C3B),
        UnsignedInt10F11F11FRevExt = ((int)0x8C3B),
        RgbaSignedComponentsExt = ((int)0x8C3C),
        Rgb9E5 = ((int)0x8C3D),
        Rgb9E5Ext = ((int)0x8C3D),
        UnsignedInt5999Rev = ((int)0x8C3E),
        UnsignedInt5999RevExt = ((int)0x8C3E),
        TextureSharedSize = ((int)0x8C3F),
        TextureSharedSizeExt = ((int)0x8C3F),
        Srgb = ((int)0x8C40),
        SrgbExt = ((int)0x8C40),
        Srgb8 = ((int)0x8C41),
        Srgb8Ext = ((int)0x8C41),
        SrgbAlpha = ((int)0x8C42),
        SrgbAlphaExt = ((int)0x8C42),
        Srgb8Alpha8 = ((int)0x8C43),
        Srgb8Alpha8Ext = ((int)0x8C43),
        SluminanceAlpha = ((int)0x8C44),
        SluminanceAlphaExt = ((int)0x8C44),
        Sluminance8Alpha8 = ((int)0x8C45),
        Sluminance8Alpha8Ext = ((int)0x8C45),
        Sluminance = ((int)0x8C46),
        SluminanceExt = ((int)0x8C46),
        Sluminance8 = ((int)0x8C47),
        Sluminance8Ext = ((int)0x8C47),
        CompressedSrgb = ((int)0x8C48),
        CompressedSrgbExt = ((int)0x8C48),
        CompressedSrgbAlpha = ((int)0x8C49),
        CompressedSrgbAlphaExt = ((int)0x8C49),
        CompressedSluminance = ((int)0x8C4A),
        CompressedSluminanceExt = ((int)0x8C4A),
        CompressedSluminanceAlpha = ((int)0x8C4B),
        CompressedSluminanceAlphaExt = ((int)0x8C4B),
        CompressedSrgbS3tcDxt1Ext = ((int)0x8C4C),
        CompressedSrgbAlphaS3tcDxt1Ext = ((int)0x8C4D),
        CompressedSrgbAlphaS3tcDxt3Ext = ((int)0x8C4E),
        CompressedSrgbAlphaS3tcDxt5Ext = ((int)0x8C4F),
        CompressedLuminanceLatc1Ext = ((int)0x8C70),
        CompressedSignedLuminanceLatc1Ext = ((int)0x8C71),
        CompressedLuminanceAlphaLatc2Ext = ((int)0x8C72),
        CompressedSignedLuminanceAlphaLatc2Ext = ((int)0x8C73),
        TransformFeedbackVaryingMaxLength = ((int)0x8C76),
        TransformFeedbackVaryingMaxLengthExt = ((int)0x8C76),
        BackPrimaryColorNv = ((int)0x8C77),
        BackSecondaryColorNv = ((int)0x8C78),
        TextureCoordNv = ((int)0x8C79),
        ClipDistanceNv = ((int)0x8C7A),
        VertexIdNv = ((int)0x8C7B),
        PrimitiveIdNv = ((int)0x8C7C),
        GenericAttribNv = ((int)0x8C7D),
        TransformFeedbackAttribsNv = ((int)0x8C7E),
        TransformFeedbackBufferMode = ((int)0x8C7F),
        TransformFeedbackBufferModeExt = ((int)0x8C7F),
        TransformFeedbackBufferModeNv = ((int)0x8C7F),
        MaxTransformFeedbackSeparateComponents = ((int)0x8C80),
        MaxTransformFeedbackSeparateComponentsExt = ((int)0x8C80),
        MaxTransformFeedbackSeparateComponentsNv = ((int)0x8C80),
        ActiveVaryingsNv = ((int)0x8C81),
        ActiveVaryingMaxLengthNv = ((int)0x8C82),
        TransformFeedbackVaryings = ((int)0x8C83),
        TransformFeedbackVaryingsExt = ((int)0x8C83),
        TransformFeedbackVaryingsNv = ((int)0x8C83),
        TransformFeedbackBufferStart = ((int)0x8C84),
        TransformFeedbackBufferStartExt = ((int)0x8C84),
        TransformFeedbackBufferStartNv = ((int)0x8C84),
        TransformFeedbackBufferSize = ((int)0x8C85),
        TransformFeedbackBufferSizeExt = ((int)0x8C85),
        TransformFeedbackBufferSizeNv = ((int)0x8C85),
        TransformFeedbackRecordNv = ((int)0x8C86),
        PrimitivesGenerated = ((int)0x8C87),
        PrimitivesGeneratedExt = ((int)0x8C87),
        PrimitivesGeneratedNv = ((int)0x8C87),
        TransformFeedbackPrimitivesWritten = ((int)0x8C88),
        TransformFeedbackPrimitivesWrittenExt = ((int)0x8C88),
        TransformFeedbackPrimitivesWrittenNv = ((int)0x8C88),
        RasterizerDiscard = ((int)0x8C89),
        RasterizerDiscardExt = ((int)0x8C89),
        RasterizerDiscardNv = ((int)0x8C89),
        MaxTransformFeedbackInterleavedAttribsNv = ((int)0x8C8A),
        MaxTransformFeedbackInterleavedComponents = ((int)0x8C8A),
        MaxTransformFeedbackInterleavedComponentsExt = ((int)0x8C8A),
        MaxTransformFeedbackSeparateAttribs = ((int)0x8C8B),
        MaxTransformFeedbackSeparateAttribsExt = ((int)0x8C8B),
        MaxTransformFeedbackSeparateAttribsNv = ((int)0x8C8B),
        InterleavedAttribs = ((int)0x8C8C),
        InterleavedAttribsExt = ((int)0x8C8C),
        InterleavedAttribsNv = ((int)0x8C8C),
        SeparateAttribs = ((int)0x8C8D),
        SeparateAttribsExt = ((int)0x8C8D),
        SeparateAttribsNv = ((int)0x8C8D),
        TransformFeedbackBuffer = ((int)0x8C8E),
        TransformFeedbackBufferExt = ((int)0x8C8E),
        TransformFeedbackBufferNv = ((int)0x8C8E),
        TransformFeedbackBufferBinding = ((int)0x8C8F),
        TransformFeedbackBufferBindingExt = ((int)0x8C8F),
        TransformFeedbackBufferBindingNv = ((int)0x8C8F),
        PointSpriteCoordOrigin = ((int)0x8CA0),
        LowerLeft = ((int)0x8CA1),
        UpperLeft = ((int)0x8CA2),
        StencilBackRef = ((int)0x8CA3),
        StencilBackValueMask = ((int)0x8CA4),
        StencilBackWritemask = ((int)0x8CA5),
        DrawFramebufferBinding = ((int)0x8CA6),
        DrawFramebufferBindingExt = ((int)0x8CA6),
        FramebufferBinding = ((int)0x8CA6),
        FramebufferBindingExt = ((int)0x8CA6),
        RenderbufferBinding = ((int)0x8CA7),
        RenderbufferBindingExt = ((int)0x8CA7),
        ReadFramebuffer = ((int)0x8CA8),
        ReadFramebufferExt = ((int)0x8CA8),
        DrawFramebuffer = ((int)0x8CA9),
        DrawFramebufferExt = ((int)0x8CA9),
        ReadFramebufferBinding = ((int)0x8CAA),
        ReadFramebufferBindingExt = ((int)0x8CAA),
        RenderbufferCoverageSamplesNv = ((int)0x8CAB),
        RenderbufferSamples = ((int)0x8CAB),
        RenderbufferSamplesExt = ((int)0x8CAB),
        DepthComponent32f = ((int)0x8CAC),
        Depth32fStencil8 = ((int)0x8CAD),
        FramebufferAttachmentObjectType = ((int)0x8CD0),
        FramebufferAttachmentObjectTypeExt = ((int)0x8CD0),
        FramebufferAttachmentObjectName = ((int)0x8CD1),
        FramebufferAttachmentObjectNameExt = ((int)0x8CD1),
        FramebufferAttachmentTextureLevel = ((int)0x8CD2),
        FramebufferAttachmentTextureLevelExt = ((int)0x8CD2),
        FramebufferAttachmentTextureCubeMapFace = ((int)0x8CD3),
        FramebufferAttachmentTextureCubeMapFaceExt = ((int)0x8CD3),
        FramebufferAttachmentTexture3DZoffsetExt = ((int)0x8CD4),
        FramebufferAttachmentTextureLayer = ((int)0x8CD4),
        FramebufferAttachmentTextureLayerExt = ((int)0x8CD4),
        FramebufferComplete = ((int)0x8CD5),
        FramebufferCompleteExt = ((int)0x8CD5),
        FramebufferIncompleteAttachment = ((int)0x8CD6),
        FramebufferIncompleteAttachmentExt = ((int)0x8CD6),
        FramebufferIncompleteMissingAttachment = ((int)0x8CD7),
        FramebufferIncompleteMissingAttachmentExt = ((int)0x8CD7),
        FramebufferIncompleteDimensionsExt = ((int)0x8CD9),
        FramebufferIncompleteFormatsExt = ((int)0x8CDA),
        FramebufferIncompleteDrawBuffer = ((int)0x8CDB),
        FramebufferIncompleteDrawBufferExt = ((int)0x8CDB),
        FramebufferIncompleteReadBuffer = ((int)0x8CDC),
        FramebufferIncompleteReadBufferExt = ((int)0x8CDC),
        FramebufferUnsupported = ((int)0x8CDD),
        FramebufferUnsupportedExt = ((int)0x8CDD),
        MaxColorAttachments = ((int)0x8CDF),
        MaxColorAttachmentsExt = ((int)0x8CDF),
        ColorAttachment0 = ((int)0x8CE0),
        ColorAttachment0Ext = ((int)0x8CE0),
        ColorAttachment1 = ((int)0x8CE1),
        ColorAttachment1Ext = ((int)0x8CE1),
        ColorAttachment2 = ((int)0x8CE2),
        ColorAttachment2Ext = ((int)0x8CE2),
        ColorAttachment3 = ((int)0x8CE3),
        ColorAttachment3Ext = ((int)0x8CE3),
        ColorAttachment4 = ((int)0x8CE4),
        ColorAttachment4Ext = ((int)0x8CE4),
        ColorAttachment5 = ((int)0x8CE5),
        ColorAttachment5Ext = ((int)0x8CE5),
        ColorAttachment6 = ((int)0x8CE6),
        ColorAttachment6Ext = ((int)0x8CE6),
        ColorAttachment7 = ((int)0x8CE7),
        ColorAttachment7Ext = ((int)0x8CE7),
        ColorAttachment8 = ((int)0x8CE8),
        ColorAttachment8Ext = ((int)0x8CE8),
        ColorAttachment9 = ((int)0x8CE9),
        ColorAttachment9Ext = ((int)0x8CE9),
        ColorAttachment10 = ((int)0x8CEA),
        ColorAttachment10Ext = ((int)0x8CEA),
        ColorAttachment11 = ((int)0x8CEB),
        ColorAttachment11Ext = ((int)0x8CEB),
        ColorAttachment12 = ((int)0x8CEC),
        ColorAttachment12Ext = ((int)0x8CEC),
        ColorAttachment13 = ((int)0x8CED),
        ColorAttachment13Ext = ((int)0x8CED),
        ColorAttachment14 = ((int)0x8CEE),
        ColorAttachment14Ext = ((int)0x8CEE),
        ColorAttachment15 = ((int)0x8CEF),
        ColorAttachment15Ext = ((int)0x8CEF),
        DepthAttachment = ((int)0x8D00),
        DepthAttachmentExt = ((int)0x8D00),
        StencilAttachment = ((int)0x8D20),
        StencilAttachmentExt = ((int)0x8D20),
        Framebuffer = ((int)0x8D40),
        FramebufferExt = ((int)0x8D40),
        Renderbuffer = ((int)0x8D41),
        RenderbufferExt = ((int)0x8D41),
        RenderbufferWidth = ((int)0x8D42),
        RenderbufferWidthExt = ((int)0x8D42),
        RenderbufferHeight = ((int)0x8D43),
        RenderbufferHeightExt = ((int)0x8D43),
        RenderbufferInternalFormat = ((int)0x8D44),
        RenderbufferInternalFormatExt = ((int)0x8D44),
        StencilIndex1 = ((int)0x8D46),
        StencilIndex1Ext = ((int)0x8D46),
        StencilIndex4 = ((int)0x8D47),
        StencilIndex4Ext = ((int)0x8D47),
        StencilIndex8 = ((int)0x8D48),
        StencilIndex8Ext = ((int)0x8D48),
        StencilIndex16 = ((int)0x8D49),
        StencilIndex16Ext = ((int)0x8D49),
        RenderbufferRedSize = ((int)0x8D50),
        RenderbufferRedSizeExt = ((int)0x8D50),
        RenderbufferGreenSize = ((int)0x8D51),
        RenderbufferGreenSizeExt = ((int)0x8D51),
        RenderbufferBlueSize = ((int)0x8D52),
        RenderbufferBlueSizeExt = ((int)0x8D52),
        RenderbufferAlphaSize = ((int)0x8D53),
        RenderbufferAlphaSizeExt = ((int)0x8D53),
        RenderbufferDepthSize = ((int)0x8D54),
        RenderbufferDepthSizeExt = ((int)0x8D54),
        RenderbufferStencilSize = ((int)0x8D55),
        RenderbufferStencilSizeExt = ((int)0x8D55),
        FramebufferIncompleteMultisample = ((int)0x8D56),
        FramebufferIncompleteMultisampleExt = ((int)0x8D56),
        MaxSamples = ((int)0x8D57),
        MaxSamplesExt = ((int)0x8D57),
        Rgba32ui = ((int)0x8D70),
        Rgba32uiExt = ((int)0x8D70),
        Rgb32ui = ((int)0x8D71),
        Rgb32uiExt = ((int)0x8D71),
        Alpha32uiExt = ((int)0x8D72),
        Intensity32uiExt = ((int)0x8D73),
        Luminance32uiExt = ((int)0x8D74),
        LuminanceAlpha32uiExt = ((int)0x8D75),
        Rgba16ui = ((int)0x8D76),
        Rgba16uiExt = ((int)0x8D76),
        Rgb16ui = ((int)0x8D77),
        Rgb16uiExt = ((int)0x8D77),
        Alpha16uiExt = ((int)0x8D78),
        Intensity16uiExt = ((int)0x8D79),
        Luminance16uiExt = ((int)0x8D7A),
        LuminanceAlpha16uiExt = ((int)0x8D7B),
        Rgba8ui = ((int)0x8D7C),
        Rgba8uiExt = ((int)0x8D7C),
        Rgb8ui = ((int)0x8D7D),
        Rgb8uiExt = ((int)0x8D7D),
        Alpha8uiExt = ((int)0x8D7E),
        Intensity8uiExt = ((int)0x8D7F),
        Luminance8uiExt = ((int)0x8D80),
        LuminanceAlpha8uiExt = ((int)0x8D81),
        Rgba32i = ((int)0x8D82),
        Rgba32iExt = ((int)0x8D82),
        Rgb32i = ((int)0x8D83),
        Rgb32iExt = ((int)0x8D83),
        Alpha32iExt = ((int)0x8D84),
        Intensity32iExt = ((int)0x8D85),
        Luminance32iExt = ((int)0x8D86),
        LuminanceAlpha32iExt = ((int)0x8D87),
        Rgba16i = ((int)0x8D88),
        Rgba16iExt = ((int)0x8D88),
        Rgb16i = ((int)0x8D89),
        Rgb16iExt = ((int)0x8D89),
        Alpha16iExt = ((int)0x8D8A),
        Intensity16iExt = ((int)0x8D8B),
        Luminance16iExt = ((int)0x8D8C),
        LuminanceAlpha16iExt = ((int)0x8D8D),
        Rgba8i = ((int)0x8D8E),
        Rgba8iExt = ((int)0x8D8E),
        Rgb8i = ((int)0x8D8F),
        Rgb8iExt = ((int)0x8D8F),
        Alpha8iExt = ((int)0x8D90),
        Intensity8iExt = ((int)0x8D91),
        Luminance8iExt = ((int)0x8D92),
        LuminanceAlpha8iExt = ((int)0x8D93),
        RedInteger = ((int)0x8D94),
        RedIntegerExt = ((int)0x8D94),
        GreenInteger = ((int)0x8D95),
        GreenIntegerExt = ((int)0x8D95),
        BlueInteger = ((int)0x8D96),
        BlueIntegerExt = ((int)0x8D96),
        AlphaInteger = ((int)0x8D97),
        AlphaIntegerExt = ((int)0x8D97),
        RgbInteger = ((int)0x8D98),
        RgbIntegerExt = ((int)0x8D98),
        RgbaInteger = ((int)0x8D99),
        RgbaIntegerExt = ((int)0x8D99),
        BgrInteger = ((int)0x8D9A),
        BgrIntegerExt = ((int)0x8D9A),
        BgraInteger = ((int)0x8D9B),
        BgraIntegerExt = ((int)0x8D9B),
        LuminanceIntegerExt = ((int)0x8D9C),
        LuminanceAlphaIntegerExt = ((int)0x8D9D),
        RgbaIntegerModeExt = ((int)0x8D9E),
        MaxProgramParameterBufferBindingsNv = ((int)0x8DA0),
        MaxProgramParameterBufferSizeNv = ((int)0x8DA1),
        VertexProgramParameterBufferNv = ((int)0x8DA2),
        GeometryProgramParameterBufferNv = ((int)0x8DA3),
        FragmentProgramParameterBufferNv = ((int)0x8DA4),
        MaxProgramGenericAttribsNv = ((int)0x8DA5),
        MaxProgramGenericResultsNv = ((int)0x8DA6),
        FramebufferAttachmentLayered = ((int)0x8DA7),
        FramebufferAttachmentLayeredArb = ((int)0x8DA7),
        FramebufferAttachmentLayeredExt = ((int)0x8DA7),
        FramebufferIncompleteLayerTargets = ((int)0x8DA8),
        FramebufferIncompleteLayerTargetsArb = ((int)0x8DA8),
        FramebufferIncompleteLayerTargetsExt = ((int)0x8DA8),
        FramebufferIncompleteLayerCount = ((int)0x8DA9),
        FramebufferIncompleteLayerCountArb = ((int)0x8DA9),
        FramebufferIncompleteLayerCountExt = ((int)0x8DA9),
        DepthComponent32fNv = ((int)0x8DAB),
        Depth32fStencil8Nv = ((int)0x8DAC),
        Float32UnsignedInt248Rev = ((int)0x8DAD),
        Float32UnsignedInt248RevNv = ((int)0x8DAD),
        DepthBufferFloatModeNv = ((int)0x8DAF),
        FramebufferSrgb = ((int)0x8DB9),
        FramebufferSrgbExt = ((int)0x8DB9),
        FramebufferSrgbCapableExt = ((int)0x8DBA),
        CompressedRedRgtc1 = ((int)0x8DBB),
        CompressedRedRgtc1Ext = ((int)0x8DBB),
        CompressedSignedRedRgtc1 = ((int)0x8DBC),
        CompressedSignedRedRgtc1Ext = ((int)0x8DBC),
        CompressedRedGreenRgtc2Ext = ((int)0x8DBD),
        CompressedRgRgtc2 = ((int)0x8DBD),
        CompressedSignedRedGreenRgtc2Ext = ((int)0x8DBE),
        CompressedSignedRgRgtc2 = ((int)0x8DBE),
        Sampler1DArray = ((int)0x8DC0),
        Sampler1DArrayExt = ((int)0x8DC0),
        Sampler2DArray = ((int)0x8DC1),
        Sampler2DArrayExt = ((int)0x8DC1),
        SamplerBuffer = ((int)0x8DC2),
        SamplerBufferExt = ((int)0x8DC2),
        Sampler1DArrayShadow = ((int)0x8DC3),
        Sampler1DArrayShadowExt = ((int)0x8DC3),
        Sampler2DArrayShadow = ((int)0x8DC4),
        Sampler2DArrayShadowExt = ((int)0x8DC4),
        SamplerCubeShadow = ((int)0x8DC5),
        SamplerCubeShadowExt = ((int)0x8DC5),
        UnsignedIntVec2 = ((int)0x8DC6),
        UnsignedIntVec2Ext = ((int)0x8DC6),
        UnsignedIntVec3 = ((int)0x8DC7),
        UnsignedIntVec3Ext = ((int)0x8DC7),
        UnsignedIntVec4 = ((int)0x8DC8),
        UnsignedIntVec4Ext = ((int)0x8DC8),
        IntSampler1D = ((int)0x8DC9),
        IntSampler1DExt = ((int)0x8DC9),
        IntSampler2D = ((int)0x8DCA),
        IntSampler2DExt = ((int)0x8DCA),
        IntSampler3D = ((int)0x8DCB),
        IntSampler3DExt = ((int)0x8DCB),
        IntSamplerCube = ((int)0x8DCC),
        IntSamplerCubeExt = ((int)0x8DCC),
        IntSampler2DRect = ((int)0x8DCD),
        IntSampler2DRectExt = ((int)0x8DCD),
        IntSampler1DArray = ((int)0x8DCE),
        IntSampler1DArrayExt = ((int)0x8DCE),
        IntSampler2DArray = ((int)0x8DCF),
        IntSampler2DArrayExt = ((int)0x8DCF),
        IntSamplerBuffer = ((int)0x8DD0),
        IntSamplerBufferExt = ((int)0x8DD0),
        UnsignedIntSampler1D = ((int)0x8DD1),
        UnsignedIntSampler1DExt = ((int)0x8DD1),
        UnsignedIntSampler2D = ((int)0x8DD2),
        UnsignedIntSampler2DExt = ((int)0x8DD2),
        UnsignedIntSampler3D = ((int)0x8DD3),
        UnsignedIntSampler3DExt = ((int)0x8DD3),
        UnsignedIntSamplerCube = ((int)0x8DD4),
        UnsignedIntSamplerCubeExt = ((int)0x8DD4),
        UnsignedIntSampler2DRect = ((int)0x8DD5),
        UnsignedIntSampler2DRectExt = ((int)0x8DD5),
        UnsignedIntSampler1DArray = ((int)0x8DD6),
        UnsignedIntSampler1DArrayExt = ((int)0x8DD6),
        UnsignedIntSampler2DArray = ((int)0x8DD7),
        UnsignedIntSampler2DArrayExt = ((int)0x8DD7),
        UnsignedIntSamplerBuffer = ((int)0x8DD8),
        UnsignedIntSamplerBufferExt = ((int)0x8DD8),
        GeometryShader = ((int)0x8DD9),
        GeometryShaderArb = ((int)0x8DD9),
        GeometryShaderExt = ((int)0x8DD9),
        GeometryVerticesOutArb = ((int)0x8DDA),
        GeometryVerticesOutExt = ((int)0x8DDA),
        GeometryInputTypeArb = ((int)0x8DDB),
        GeometryInputTypeExt = ((int)0x8DDB),
        GeometryOutputTypeArb = ((int)0x8DDC),
        GeometryOutputTypeExt = ((int)0x8DDC),
        MaxGeometryVaryingComponents = ((int)0x8DDD),
        MaxGeometryVaryingComponentsArb = ((int)0x8DDD),
        MaxGeometryVaryingComponentsExt = ((int)0x8DDD),
        MaxVertexVaryingComponents = ((int)0x8DDE),
        MaxVertexVaryingComponentsArb = ((int)0x8DDE),
        MaxVertexVaryingComponentsExt = ((int)0x8DDE),
        MaxGeometryUniformComponents = ((int)0x8DDF),
        MaxGeometryUniformComponentsArb = ((int)0x8DDF),
        MaxGeometryUniformComponentsExt = ((int)0x8DDF),
        MaxGeometryOutputVertices = ((int)0x8DE0),
        MaxGeometryOutputVerticesArb = ((int)0x8DE0),
        MaxGeometryOutputVerticesExt = ((int)0x8DE0),
        MaxGeometryTotalOutputComponents = ((int)0x8DE1),
        MaxGeometryTotalOutputComponentsArb = ((int)0x8DE1),
        MaxGeometryTotalOutputComponentsExt = ((int)0x8DE1),
        MaxVertexBindableUniformsExt = ((int)0x8DE2),
        MaxFragmentBindableUniformsExt = ((int)0x8DE3),
        MaxGeometryBindableUniformsExt = ((int)0x8DE4),
        MaxBindableUniformSizeExt = ((int)0x8DED),
        UniformBufferExt = ((int)0x8DEE),
        UniformBufferBindingExt = ((int)0x8DEF),
        RenderbufferColorSamplesNv = ((int)0x8E10),
        MaxMultisampleCoverageModesNv = ((int)0x8E11),
        MultisampleCoverageModesNv = ((int)0x8E12),
        QueryWait = ((int)0x8E13),
        QueryWaitNv = ((int)0x8E13),
        QueryNoWait = ((int)0x8E14),
        QueryNoWaitNv = ((int)0x8E14),
        QueryByRegionWait = ((int)0x8E15),
        QueryByRegionWaitNv = ((int)0x8E15),
        QueryByRegionNoWait = ((int)0x8E16),
        QueryByRegionNoWaitNv = ((int)0x8E16),
        TransformFeedbackNv = ((int)0x8E22),
        TransformFeedbackBufferPausedNv = ((int)0x8E23),
        TransformFeedbackBufferActiveNv = ((int)0x8E24),
        TransformFeedbackBindingNv = ((int)0x8E25),
        FrameNv = ((int)0x8E26),
        FieldsNv = ((int)0x8E27),
        CurrentTimeNv = ((int)0x8E28),
        NumFillStreamsNv = ((int)0x8E29),
        PresentTimeNv = ((int)0x8E2A),
        PresentDurationNv = ((int)0x8E2B),
        ProgramMatrixExt = ((int)0x8E2D),
        TransposeProgramMatrixExt = ((int)0x8E2E),
        ProgramMatrixStackDepthExt = ((int)0x8E2F),
        TextureSwizzleRExt = ((int)0x8E42),
        TextureSwizzleGExt = ((int)0x8E43),
        TextureSwizzleBExt = ((int)0x8E44),
        TextureSwizzleAExt = ((int)0x8E45),
        TextureSwizzleRgbaExt = ((int)0x8E46),
        QuadsFollowProvokingVertexConvention = ((int)0x8E4C),
        QuadsFollowProvokingVertexConventionExt = ((int)0x8E4C),
        FirstVertexConvention = ((int)0x8E4D),
        FirstVertexConventionExt = ((int)0x8E4D),
        LastVertexConvention = ((int)0x8E4E),
        LastVertexConventionExt = ((int)0x8E4E),
        ProvokingVertex = ((int)0x8E4F),
        ProvokingVertexExt = ((int)0x8E4F),
        SamplePosition = ((int)0x8E50),
        SamplePositionNv = ((int)0x8E50),
        SampleMask = ((int)0x8E51),
        SampleMaskNv = ((int)0x8E51),
        SampleMaskValue = ((int)0x8E52),
        SampleMaskValueNv = ((int)0x8E52),
        TextureBindingRenderbufferNv = ((int)0x8E53),
        TextureRenderbufferDataStoreBindingNv = ((int)0x8E54),
        TextureRenderbufferNv = ((int)0x8E55),
        SamplerRenderbufferNv = ((int)0x8E56),
        IntSamplerRenderbufferNv = ((int)0x8E57),
        UnsignedIntSamplerRenderbufferNv = ((int)0x8E58),
        MaxSampleMaskWords = ((int)0x8E59),
        MaxSampleMaskWordsNv = ((int)0x8E59),
        MinProgramTextureGatherOffset = ((int)0x8E5E),
        MaxProgramTextureGatherOffset = ((int)0x8E5F),
        CopyReadBuffer = ((int)0x8F36),
        CopyWriteBuffer = ((int)0x8F37),
        RedSnorm = ((int)0x8F90),
        RgSnorm = ((int)0x8F91),
        RgbSnorm = ((int)0x8F92),
        RgbaSnorm = ((int)0x8F93),
        R8Snorm = ((int)0x8F94),
        Rg8Snorm = ((int)0x8F95),
        Rgb8Snorm = ((int)0x8F96),
        Rgba8Snorm = ((int)0x8F97),
        R16Snorm = ((int)0x8F98),
        Rg16Snorm = ((int)0x8F99),
        Rgb16Snorm = ((int)0x8F9A),
        Rgba16Snorm = ((int)0x8F9B),
        SignedNormalized = ((int)0x8F9C),
        PrimitiveRestart = ((int)0x8F9D),
        PrimitiveRestartIndex = ((int)0x8F9E),
        MaxProgramTextureGatherComponents = ((int)0x8F9F),
        SamplerBufferAmd = ((int)0x9001),
        IntSamplerBufferAmd = ((int)0x9002),
        UnsignedIntSamplerBufferAmd = ((int)0x9003),
        TessellationModeAmd = ((int)0x9004),
        TessellationFactorAmd = ((int)0x9005),
        DiscreteAmd = ((int)0x9006),
        ContinuousAmd = ((int)0x9007),
        TextureCubeMapArray = ((int)0x9009),
        TextureBindingCubeMapArray = ((int)0x900A),
        ProxyTextureCubeMapArray = ((int)0x900B),
        SamplerCubeMapArray = ((int)0x900C),
        SamplerCubeMapArrayShadow = ((int)0x900D),
        IntSamplerCubeMapArray = ((int)0x900E),
        UnsignedIntSamplerCubeMapArray = ((int)0x900F),
        AlphaSnorm = ((int)0x9010),
        LuminanceSnorm = ((int)0x9011),
        LuminanceAlphaSnorm = ((int)0x9012),
        IntensitySnorm = ((int)0x9013),
        Alpha8Snorm = ((int)0x9014),
        Luminance8Snorm = ((int)0x9015),
        Luminance8Alpha8Snorm = ((int)0x9016),
        Intensity8Snorm = ((int)0x9017),
        Alpha16Snorm = ((int)0x9018),
        Luminance16Snorm = ((int)0x9019),
        Luminance16Alpha16Snorm = ((int)0x901A),
        Intensity16Snorm = ((int)0x901B),
        Texture2DMultisample = ((int)0x9100),
        ProxyTexture2DMultisample = ((int)0x9101),
        Texture2DMultisampleArray = ((int)0x9102),
        ProxyTexture2DMultisampleArray = ((int)0x9103),
        TextureBinding2DMultisample = ((int)0x9104),
        TextureBinding2DMultisampleArray = ((int)0x9105),
        TextureSamples = ((int)0x9106),
        TextureFixedSampleLocations = ((int)0x9107),
        Sampler2DMultisample = ((int)0x9108),
        IntSampler2DMultisample = ((int)0x9109),
        UnsignedIntSampler2DMultisample = ((int)0x910A),
        Sampler2DMultisampleArray = ((int)0x910B),
        IntSampler2DMultisampleArray = ((int)0x910C),
        UnsignedIntSampler2DMultisampleArray = ((int)0x910D),
        MaxColorTextureSamples = ((int)0x910E),
        MaxDepthTextureSamples = ((int)0x910F),
        MaxIntegerSamples = ((int)0x9110),
        MaxServerWaitTimeout = ((int)0x9111),
        ObjectType = ((int)0x9112),
        SyncCondition = ((int)0x9113),
        SyncStatus = ((int)0x9114),
        SyncFlags = ((int)0x9115),
        SyncFence = ((int)0x9116),
        SyncGpuCommandsComplete = ((int)0x9117),
        Unsignaled = ((int)0x9118),
        Signaled = ((int)0x9119),
        AlreadySignaled = ((int)0x911A),
        TimeoutExpired = ((int)0x911B),
        ConditionSatisfied = ((int)0x911C),
        WaitFailed = ((int)0x911D),
        BufferAccessFlags = ((int)0x911F),
        BufferMapLength = ((int)0x9120),
        BufferMapOffset = ((int)0x9121),
        MaxVertexOutputComponents = ((int)0x9122),
        MaxGeometryInputComponents = ((int)0x9123),
        MaxGeometryOutputComponents = ((int)0x9124),
        MaxFragmentInputComponents = ((int)0x9125),
        ContextProfileMask = ((int)0x9126),
        AllAttribBits = unchecked((int)0xFFFFFFFF),
        ClientAllAttribBits = unchecked((int)0xFFFFFFFF),
        InvalidIndex = unchecked((int)0xFFFFFFFF),
        TimeoutIgnored = unchecked((int)0xFFFFFFFFFFFFFFFF),
        One = ((int)1),
        True = ((int)1),
        CullVertexIbm = ((int)103050),
        VertexArrayListIbm = ((int)103070),
        NormalArrayListIbm = ((int)103071),
        ColorArrayListIbm = ((int)103072),
        IndexArrayListIbm = ((int)103073),
        TextureCoordArrayListIbm = ((int)103074),
        EdgeFlagArrayListIbm = ((int)103075),
        FogCoordinateArrayListIbm = ((int)103076),
        SecondaryColorArrayListIbm = ((int)103077),
        VertexArrayListStrideIbm = ((int)103080),
        NormalArrayListStrideIbm = ((int)103081),
        ColorArrayListStrideIbm = ((int)103082),
        IndexArrayListStrideIbm = ((int)103083),
        TextureCoordArrayListStrideIbm = ((int)103084),
        EdgeFlagArrayListStrideIbm = ((int)103085),
        FogCoordinateArrayListStrideIbm = ((int)103086),
        SecondaryColorArrayListStrideIbm = ((int)103087),
        Two = ((int)2),
        Three = ((int)3),
        Four = ((int)4),
    }

    public enum AlphaFunction : int
    {
        Never = ((int)0x0200),
        Less = ((int)0x0201),
        Equal = ((int)0x0202),
        Lequal = ((int)0x0203),
        Greater = ((int)0x0204),
        Notequal = ((int)0x0205),
        Gequal = ((int)0x0206),
        Always = ((int)0x0207),
    }

    public enum AmdDrawBuffersBlend : int
    {
    }

    public enum AmdPerformanceMonitor : int
    {
        CounterTypeAmd = ((int)0x8BC0),
        CounterRangeAmd = ((int)0x8BC1),
        UnsignedInt64Amd = ((int)0x8BC2),
        PercentageAmd = ((int)0x8BC3),
        PerfmonResultAvailableAmd = ((int)0x8BC4),
        PerfmonResultSizeAmd = ((int)0x8BC5),
        PerfmonResultAmd = ((int)0x8BC6),
    }

    public enum AmdTextureTexture4 : int
    {
    }

    public enum AmdVertexShaderTesselator : int
    {
        SamplerBufferAmd = ((int)0x9001),
        IntSamplerBufferAmd = ((int)0x9002),
        UnsignedIntSamplerBufferAmd = ((int)0x9003),
        TessellationModeAmd = ((int)0x9004),
        TessellationFactorAmd = ((int)0x9005),
        DiscreteAmd = ((int)0x9006),
        ContinuousAmd = ((int)0x9007),
    }

    public enum AppleAuxDepthStencil : int
    {
        AuxDepthStencilApple = ((int)0x8A14),
    }

    public enum AppleClientStorage : int
    {
        UnpackClientStorageApple = ((int)0x85B2),
    }

    public enum AppleElementArray : int
    {
        ElementArrayApple = ((int)0x8768),
        ElementArrayTypeApple = ((int)0x8769),
        ElementArrayPointerApple = ((int)0x876A),
    }

    public enum AppleFence : int
    {
        DrawPixelsApple = ((int)0x8A0A),
        FenceApple = ((int)0x8A0B),
    }

    public enum AppleFloatPixels : int
    {
        HalfApple = ((int)0x140B),
        RgbaFloat32Apple = ((int)0x8814),
        RgbFloat32Apple = ((int)0x8815),
        AlphaFloat32Apple = ((int)0x8816),
        IntensityFloat32Apple = ((int)0x8817),
        LuminanceFloat32Apple = ((int)0x8818),
        LuminanceAlphaFloat32Apple = ((int)0x8819),
        RgbaFloat16Apple = ((int)0x881A),
        RgbFloat16Apple = ((int)0x881B),
        AlphaFloat16Apple = ((int)0x881C),
        IntensityFloat16Apple = ((int)0x881D),
        LuminanceFloat16Apple = ((int)0x881E),
        LuminanceAlphaFloat16Apple = ((int)0x881F),
        ColorFloatApple = ((int)0x8A0F),
    }

    public enum AppleFlushBufferRange : int
    {
        BufferSerializedModifyApple = ((int)0x8A12),
        BufferFlushingUnmapApple = ((int)0x8A13),
    }

    public enum AppleObjectPurgeable : int
    {
        BufferObjectApple = ((int)0x85B3),
        ReleasedApple = ((int)0x8A19),
        VolatileApple = ((int)0x8A1A),
        RetainedApple = ((int)0x8A1B),
        UndefinedApple = ((int)0x8A1C),
        PurgeableApple = ((int)0x8A1D),
    }

    public enum AppleRowBytes : int
    {
        PackRowBytesApple = ((int)0x8A15),
        UnpackRowBytesApple = ((int)0x8A16),
    }

    public enum AppleSpecularVector : int
    {
        LightModelSpecularVectorApple = ((int)0x85B0),
    }

    public enum AppleTextureRange : int
    {
        TextureRangeLengthApple = ((int)0x85B7),
        TextureRangePointerApple = ((int)0x85B8),
        TextureStorageHintApple = ((int)0x85BC),
        StoragePrivateApple = ((int)0x85BD),
        StorageCachedApple = ((int)0x85BE),
        StorageSharedApple = ((int)0x85BF),
    }

    public enum AppleTransformHint : int
    {
        TransformHintApple = ((int)0x85B1),
    }

    public enum AppleVertexArrayObject : int
    {
        VertexArrayBindingApple = ((int)0x85B5),
    }

    public enum AppleVertexArrayRange : int
    {
        VertexArrayRangeApple = ((int)0x851D),
        VertexArrayRangeLengthApple = ((int)0x851E),
        VertexArrayStorageHintApple = ((int)0x851F),
        VertexArrayRangePointerApple = ((int)0x8521),
        StorageCachedApple = ((int)0x85BE),
        StorageSharedApple = ((int)0x85BF),
    }

    public enum AppleVertexProgramEvaluators : int
    {
        VertexAttribMap1Apple = ((int)0x8A00),
        VertexAttribMap2Apple = ((int)0x8A01),
        VertexAttribMap1SizeApple = ((int)0x8A02),
        VertexAttribMap1CoeffApple = ((int)0x8A03),
        VertexAttribMap1OrderApple = ((int)0x8A04),
        VertexAttribMap1DomainApple = ((int)0x8A05),
        VertexAttribMap2SizeApple = ((int)0x8A06),
        VertexAttribMap2CoeffApple = ((int)0x8A07),
        VertexAttribMap2OrderApple = ((int)0x8A08),
        VertexAttribMap2DomainApple = ((int)0x8A09),
    }

    public enum AppleYcbcr422 : int
    {
        Ycbcr422Apple = ((int)0x85B9),
        UnsignedShort88Apple = ((int)0x85BA),
        UnsignedShort88RevApple = ((int)0x85BB),
    }

    public enum ArbColorBufferFloat : int
    {
        RgbaFloatModeArb = ((int)0x8820),
        ClampVertexColorArb = ((int)0x891A),
        ClampFragmentColorArb = ((int)0x891B),
        ClampReadColorArb = ((int)0x891C),
        FixedOnlyArb = ((int)0x891D),
    }

    public enum ArbCompatibility : int
    {
    }

    public enum ArbCopyBuffer : int
    {
        CopyReadBuffer = ((int)0x8F36),
        CopyWriteBuffer = ((int)0x8F37),
    }

    public enum ArbDepthBufferFloat : int
    {
        DepthComponent32f = ((int)0x8CAC),
        Depth32fStencil8 = ((int)0x8CAD),
        Float32UnsignedInt248Rev = ((int)0x8DAD),
    }

    public enum ArbDepthClamp : int
    {
        DepthClamp = ((int)0x864F),
    }

    public enum ArbDepthTexture : int
    {
        DepthComponent16Arb = ((int)0x81A5),
        DepthComponent24Arb = ((int)0x81A6),
        DepthComponent32Arb = ((int)0x81A7),
        TextureDepthSizeArb = ((int)0x884A),
        DepthTextureModeArb = ((int)0x884B),
    }

    public enum ArbDrawBuffers : int
    {
        MaxDrawBuffersArb = ((int)0x8824),
        DrawBuffer0Arb = ((int)0x8825),
        DrawBuffer1Arb = ((int)0x8826),
        DrawBuffer2Arb = ((int)0x8827),
        DrawBuffer3Arb = ((int)0x8828),
        DrawBuffer4Arb = ((int)0x8829),
        DrawBuffer5Arb = ((int)0x882A),
        DrawBuffer6Arb = ((int)0x882B),
        DrawBuffer7Arb = ((int)0x882C),
        DrawBuffer8Arb = ((int)0x882D),
        DrawBuffer9Arb = ((int)0x882E),
        DrawBuffer10Arb = ((int)0x882F),
        DrawBuffer11Arb = ((int)0x8830),
        DrawBuffer12Arb = ((int)0x8831),
        DrawBuffer13Arb = ((int)0x8832),
        DrawBuffer14Arb = ((int)0x8833),
        DrawBuffer15Arb = ((int)0x8834),
    }

    public enum ArbDrawBuffersBlend : int
    {
    }

    public enum ArbDrawElementsBaseVertex : int
    {
    }

    public enum ArbDrawInstanced : int
    {
    }

    public enum ArbFragmentCoordConventions : int
    {
    }

    public enum ArbFragmentProgram : int
    {
        FragmentProgramArb = ((int)0x8804),
        ProgramAluInstructionsArb = ((int)0x8805),
        ProgramTexInstructionsArb = ((int)0x8806),
        ProgramTexIndirectionsArb = ((int)0x8807),
        ProgramNativeAluInstructionsArb = ((int)0x8808),
        ProgramNativeTexInstructionsArb = ((int)0x8809),
        ProgramNativeTexIndirectionsArb = ((int)0x880A),
        MaxProgramAluInstructionsArb = ((int)0x880B),
        MaxProgramTexInstructionsArb = ((int)0x880C),
        MaxProgramTexIndirectionsArb = ((int)0x880D),
        MaxProgramNativeAluInstructionsArb = ((int)0x880E),
        MaxProgramNativeTexInstructionsArb = ((int)0x880F),
        MaxProgramNativeTexIndirectionsArb = ((int)0x8810),
        MaxTextureCoordsArb = ((int)0x8871),
        MaxTextureImageUnitsArb = ((int)0x8872),
    }

    public enum ArbFragmentProgramShadow : int
    {
    }

    public enum ArbFragmentShader : int
    {
        FragmentShaderArb = ((int)0x8B30),
        MaxFragmentUniformComponentsArb = ((int)0x8B49),
        FragmentShaderDerivativeHintArb = ((int)0x8B8B),
    }

    public enum ArbFramebufferObject : int
    {
        InvalidFramebufferOperation = ((int)0x0506),
        FramebufferAttachmentColorEncoding = ((int)0x8210),
        FramebufferAttachmentComponentType = ((int)0x8211),
        FramebufferAttachmentRedSize = ((int)0x8212),
        FramebufferAttachmentGreenSize = ((int)0x8213),
        FramebufferAttachmentBlueSize = ((int)0x8214),
        FramebufferAttachmentAlphaSize = ((int)0x8215),
        FramebufferAttachmentDepthSize = ((int)0x8216),
        FramebufferAttachmentStencilSize = ((int)0x8217),
        FramebufferDefault = ((int)0x8218),
        FramebufferUndefined = ((int)0x8219),
        DepthStencilAttachment = ((int)0x821A),
        MaxRenderbufferSize = ((int)0x84E8),
        DepthStencil = ((int)0x84F9),
        UnsignedInt248 = ((int)0x84FA),
        Depth24Stencil8 = ((int)0x88F0),
        TextureStencilSize = ((int)0x88F1),
        TextureRedType = ((int)0x8C10),
        TextureGreenType = ((int)0x8C11),
        TextureBlueType = ((int)0x8C12),
        TextureAlphaType = ((int)0x8C13),
        TextureDepthType = ((int)0x8C16),
        UnsignedNormalized = ((int)0x8C17),
        DrawFramebufferBinding = ((int)0x8CA6),
        FramebufferBinding = ((int)0x8CA6),
        RenderbufferBinding = ((int)0x8CA7),
        ReadFramebuffer = ((int)0x8CA8),
        DrawFramebuffer = ((int)0x8CA9),
        ReadFramebufferBinding = ((int)0x8CAA),
        RenderbufferSamples = ((int)0x8CAB),
        FramebufferAttachmentObjectType = ((int)0x8CD0),
        FramebufferAttachmentObjectName = ((int)0x8CD1),
        FramebufferAttachmentTextureLevel = ((int)0x8CD2),
        FramebufferAttachmentTextureCubeMapFace = ((int)0x8CD3),
        FramebufferAttachmentTextureLayer = ((int)0x8CD4),
        FramebufferComplete = ((int)0x8CD5),
        FramebufferIncompleteAttachment = ((int)0x8CD6),
        FramebufferIncompleteMissingAttachment = ((int)0x8CD7),
        FramebufferIncompleteDrawBuffer = ((int)0x8CDB),
        FramebufferIncompleteReadBuffer = ((int)0x8CDC),
        FramebufferUnsupported = ((int)0x8CDD),
        MaxColorAttachments = ((int)0x8CDF),
        ColorAttachment0 = ((int)0x8CE0),
        ColorAttachment1 = ((int)0x8CE1),
        ColorAttachment2 = ((int)0x8CE2),
        ColorAttachment3 = ((int)0x8CE3),
        ColorAttachment4 = ((int)0x8CE4),
        ColorAttachment5 = ((int)0x8CE5),
        ColorAttachment6 = ((int)0x8CE6),
        ColorAttachment7 = ((int)0x8CE7),
        ColorAttachment8 = ((int)0x8CE8),
        ColorAttachment9 = ((int)0x8CE9),
        ColorAttachment10 = ((int)0x8CEA),
        ColorAttachment11 = ((int)0x8CEB),
        ColorAttachment12 = ((int)0x8CEC),
        ColorAttachment13 = ((int)0x8CED),
        ColorAttachment14 = ((int)0x8CEE),
        ColorAttachment15 = ((int)0x8CEF),
        DepthAttachment = ((int)0x8D00),
        StencilAttachment = ((int)0x8D20),
        Framebuffer = ((int)0x8D40),
        Renderbuffer = ((int)0x8D41),
        RenderbufferWidth = ((int)0x8D42),
        RenderbufferHeight = ((int)0x8D43),
        RenderbufferInternalFormat = ((int)0x8D44),
        StencilIndex1 = ((int)0x8D46),
        StencilIndex4 = ((int)0x8D47),
        StencilIndex8 = ((int)0x8D48),
        StencilIndex16 = ((int)0x8D49),
        RenderbufferRedSize = ((int)0x8D50),
        RenderbufferGreenSize = ((int)0x8D51),
        RenderbufferBlueSize = ((int)0x8D52),
        RenderbufferAlphaSize = ((int)0x8D53),
        RenderbufferDepthSize = ((int)0x8D54),
        RenderbufferStencilSize = ((int)0x8D55),
        FramebufferIncompleteMultisample = ((int)0x8D56),
        MaxSamples = ((int)0x8D57),
    }

    public enum ArbFramebufferObjectDeprecated : int
    {
        Index = ((int)0x8222),
        TextureLuminanceType = ((int)0x8C14),
        TextureIntensityType = ((int)0x8C15),
    }

    public enum ArbFramebufferSrgb : int
    {
        FramebufferSrgb = ((int)0x8DB9),
    }

    public enum ArbGeometryShader4 : int
    {
        LinesAdjacencyArb = ((int)0x000A),
        LineStripAdjacencyArb = ((int)0x000B),
        TrianglesAdjacencyArb = ((int)0x000C),
        TriangleStripAdjacencyArb = ((int)0x000D),
        ProgramPointSizeArb = ((int)0x8642),
        MaxVaryingComponents = ((int)0x8B4B),
        MaxGeometryTextureImageUnitsArb = ((int)0x8C29),
        FramebufferAttachmentTextureLayer = ((int)0x8CD4),
        FramebufferAttachmentLayeredArb = ((int)0x8DA7),
        FramebufferIncompleteLayerTargetsArb = ((int)0x8DA8),
        FramebufferIncompleteLayerCountArb = ((int)0x8DA9),
        GeometryShaderArb = ((int)0x8DD9),
        GeometryVerticesOutArb = ((int)0x8DDA),
        GeometryInputTypeArb = ((int)0x8DDB),
        GeometryOutputTypeArb = ((int)0x8DDC),
        MaxGeometryVaryingComponentsArb = ((int)0x8DDD),
        MaxVertexVaryingComponentsArb = ((int)0x8DDE),
        MaxGeometryUniformComponentsArb = ((int)0x8DDF),
        MaxGeometryOutputVerticesArb = ((int)0x8DE0),
        MaxGeometryTotalOutputComponentsArb = ((int)0x8DE1),
    }

    public enum ArbHalfFloatPixel : int
    {
        HalfFloatArb = ((int)0x140B),
    }

    public enum ArbHalfFloatVertex : int
    {
        HalfFloat = ((int)0x140B),
    }

    public enum ArbImaging : int
    {
        ConstantColor = ((int)0x8001),
        OneMinusConstantColor = ((int)0x8002),
        ConstantAlpha = ((int)0x8003),
        OneMinusConstantAlpha = ((int)0x8004),
        BlendColor = ((int)0x8005),
        FuncAdd = ((int)0x8006),
        Min = ((int)0x8007),
        Max = ((int)0x8008),
        BlendEquation = ((int)0x8009),
        FuncSubtract = ((int)0x800A),
        FuncReverseSubtract = ((int)0x800B),
    }

    public enum ArbImagingDeprecated : int
    {
        Convolution1D = ((int)0x8010),
        Convolution2D = ((int)0x8011),
        Separable2D = ((int)0x8012),
        ConvolutionBorderMode = ((int)0x8013),
        ConvolutionFilterScale = ((int)0x8014),
        ConvolutionFilterBias = ((int)0x8015),
        Reduce = ((int)0x8016),
        ConvolutionFormat = ((int)0x8017),
        ConvolutionWidth = ((int)0x8018),
        ConvolutionHeight = ((int)0x8019),
        MaxConvolutionWidth = ((int)0x801A),
        MaxConvolutionHeight = ((int)0x801B),
        PostConvolutionRedScale = ((int)0x801C),
        PostConvolutionGreenScale = ((int)0x801D),
        PostConvolutionBlueScale = ((int)0x801E),
        PostConvolutionAlphaScale = ((int)0x801F),
        PostConvolutionRedBias = ((int)0x8020),
        PostConvolutionGreenBias = ((int)0x8021),
        PostConvolutionBlueBias = ((int)0x8022),
        PostConvolutionAlphaBias = ((int)0x8023),
        Histogram = ((int)0x8024),
        ProxyHistogram = ((int)0x8025),
        HistogramWidth = ((int)0x8026),
        HistogramFormat = ((int)0x8027),
        HistogramRedSize = ((int)0x8028),
        HistogramGreenSize = ((int)0x8029),
        HistogramBlueSize = ((int)0x802A),
        HistogramAlphaSize = ((int)0x802B),
        HistogramLuminanceSize = ((int)0x802C),
        HistogramSink = ((int)0x802D),
        Minmax = ((int)0x802E),
        MinmaxFormat = ((int)0x802F),
        MinmaxSink = ((int)0x8030),
        TableTooLarge = ((int)0x8031),
        ColorMatrix = ((int)0x80B1),
        ColorMatrixStackDepth = ((int)0x80B2),
        MaxColorMatrixStackDepth = ((int)0x80B3),
        PostColorMatrixRedScale = ((int)0x80B4),
        PostColorMatrixGreenScale = ((int)0x80B5),
        PostColorMatrixBlueScale = ((int)0x80B6),
        PostColorMatrixAlphaScale = ((int)0x80B7),
        PostColorMatrixRedBias = ((int)0x80B8),
        PostColorMatrixGreenBias = ((int)0x80B9),
        PostColorMatrixBlueBias = ((int)0x80BA),
        PostColorMatrixAlphaBias = ((int)0x80BB),
        ColorTable = ((int)0x80D0),
        PostConvolutionColorTable = ((int)0x80D1),
        PostColorMatrixColorTable = ((int)0x80D2),
        ProxyColorTable = ((int)0x80D3),
        ProxyPostConvolutionColorTable = ((int)0x80D4),
        ProxyPostColorMatrixColorTable = ((int)0x80D5),
        ColorTableScale = ((int)0x80D6),
        ColorTableBias = ((int)0x80D7),
        ColorTableFormat = ((int)0x80D8),
        ColorTableWidth = ((int)0x80D9),
        ColorTableRedSize = ((int)0x80DA),
        ColorTableGreenSize = ((int)0x80DB),
        ColorTableBlueSize = ((int)0x80DC),
        ColorTableAlphaSize = ((int)0x80DD),
        ColorTableLuminanceSize = ((int)0x80DE),
        ColorTableIntensitySize = ((int)0x80DF),
        ConstantBorder = ((int)0x8151),
        ReplicateBorder = ((int)0x8153),
        ConvolutionBorderColor = ((int)0x8154),
    }

    public enum ArbInstancedArrays : int
    {
        VertexAttribArrayDivisorArb = ((int)0x88FE),
    }

    public enum ArbMapBufferRange : int
    {
        MapReadBit = ((int)0x0001),
        MapWriteBit = ((int)0x0002),
        MapInvalidateRangeBit = ((int)0x0004),
        MapInvalidateBufferBit = ((int)0x0008),
        MapFlushExplicitBit = ((int)0x0010),
        MapUnsynchronizedBit = ((int)0x0020),
    }

    public enum ArbMatrixPalette : int
    {
        MatrixPaletteArb = ((int)0x8840),
        MaxMatrixPaletteStackDepthArb = ((int)0x8841),
        MaxPaletteMatricesArb = ((int)0x8842),
        CurrentPaletteMatrixArb = ((int)0x8843),
        MatrixIndexArrayArb = ((int)0x8844),
        CurrentMatrixIndexArb = ((int)0x8845),
        MatrixIndexArraySizeArb = ((int)0x8846),
        MatrixIndexArrayTypeArb = ((int)0x8847),
        MatrixIndexArrayStrideArb = ((int)0x8848),
        MatrixIndexArrayPointerArb = ((int)0x8849),
    }

    public enum ArbMultisample : int
    {
        MultisampleBitArb = ((int)0x20000000),
        MultisampleArb = ((int)0x809D),
        SampleAlphaToCoverageArb = ((int)0x809E),
        SampleAlphaToOneArb = ((int)0x809F),
        SampleCoverageArb = ((int)0x80A0),
        SampleBuffersArb = ((int)0x80A8),
        SamplesArb = ((int)0x80A9),
        SampleCoverageValueArb = ((int)0x80AA),
        SampleCoverageInvertArb = ((int)0x80AB),
    }

    public enum ArbMultitexture : int
    {
        Texture0Arb = ((int)0x84C0),
        Texture1Arb = ((int)0x84C1),
        Texture2Arb = ((int)0x84C2),
        Texture3Arb = ((int)0x84C3),
        Texture4Arb = ((int)0x84C4),
        Texture5Arb = ((int)0x84C5),
        Texture6Arb = ((int)0x84C6),
        Texture7Arb = ((int)0x84C7),
        Texture8Arb = ((int)0x84C8),
        Texture9Arb = ((int)0x84C9),
        Texture10Arb = ((int)0x84CA),
        Texture11Arb = ((int)0x84CB),
        Texture12Arb = ((int)0x84CC),
        Texture13Arb = ((int)0x84CD),
        Texture14Arb = ((int)0x84CE),
        Texture15Arb = ((int)0x84CF),
        Texture16Arb = ((int)0x84D0),
        Texture17Arb = ((int)0x84D1),
        Texture18Arb = ((int)0x84D2),
        Texture19Arb = ((int)0x84D3),
        Texture20Arb = ((int)0x84D4),
        Texture21Arb = ((int)0x84D5),
        Texture22Arb = ((int)0x84D6),
        Texture23Arb = ((int)0x84D7),
        Texture24Arb = ((int)0x84D8),
        Texture25Arb = ((int)0x84D9),
        Texture26Arb = ((int)0x84DA),
        Texture27Arb = ((int)0x84DB),
        Texture28Arb = ((int)0x84DC),
        Texture29Arb = ((int)0x84DD),
        Texture30Arb = ((int)0x84DE),
        Texture31Arb = ((int)0x84DF),
        ActiveTextureArb = ((int)0x84E0),
        ClientActiveTextureArb = ((int)0x84E1),
        MaxTextureUnitsArb = ((int)0x84E2),
    }

    public enum ArbOcclusionQuery : int
    {
        QueryCounterBitsArb = ((int)0x8864),
        CurrentQueryArb = ((int)0x8865),
        QueryResultArb = ((int)0x8866),
        QueryResultAvailableArb = ((int)0x8867),
        SamplesPassedArb = ((int)0x8914),
    }

    public enum ArbPixelBufferObject : int
    {
        PixelPackBufferArb = ((int)0x88EB),
        PixelUnpackBufferArb = ((int)0x88EC),
        PixelPackBufferBindingArb = ((int)0x88ED),
        PixelUnpackBufferBindingArb = ((int)0x88EF),
    }

    public enum ArbPointParameters : int
    {
        PointSizeMinArb = ((int)0x8126),
        PointSizeMaxArb = ((int)0x8127),
        PointFadeThresholdSizeArb = ((int)0x8128),
        PointDistanceAttenuationArb = ((int)0x8129),
    }

    public enum ArbPointSprite : int
    {
        PointSpriteArb = ((int)0x8861),
        CoordReplaceArb = ((int)0x8862),
    }

    public enum ArbProvokingVertex : int
    {
        QuadsFollowProvokingVertexConvention = ((int)0x8E4C),
        FirstVertexConvention = ((int)0x8E4D),
        LastVertexConvention = ((int)0x8E4E),
        ProvokingVertex = ((int)0x8E4F),
    }

    public enum ArbSampleShading : int
    {
        SampleShading = ((int)0x8C36),
        MinSampleShadingValue = ((int)0x8C37),
    }

    public enum ArbSeamlessCubeMap : int
    {
        TextureCubeMapSeamless = ((int)0x884F),
    }

    public enum ArbShaderObjects : int
    {
        ProgramObjectArb = ((int)0x8B40),
        ShaderObjectArb = ((int)0x8B48),
        ObjectTypeArb = ((int)0x8B4E),
        ObjectSubtypeArb = ((int)0x8B4F),
        FloatVec2Arb = ((int)0x8B50),
        FloatVec3Arb = ((int)0x8B51),
        FloatVec4Arb = ((int)0x8B52),
        IntVec2Arb = ((int)0x8B53),
        IntVec3Arb = ((int)0x8B54),
        IntVec4Arb = ((int)0x8B55),
        BoolArb = ((int)0x8B56),
        BoolVec2Arb = ((int)0x8B57),
        BoolVec3Arb = ((int)0x8B58),
        BoolVec4Arb = ((int)0x8B59),
        FloatMat2Arb = ((int)0x8B5A),
        FloatMat3Arb = ((int)0x8B5B),
        FloatMat4Arb = ((int)0x8B5C),
        Sampler1DArb = ((int)0x8B5D),
        Sampler2DArb = ((int)0x8B5E),
        Sampler3DArb = ((int)0x8B5F),
        SamplerCubeArb = ((int)0x8B60),
        Sampler1DShadowArb = ((int)0x8B61),
        Sampler2DShadowArb = ((int)0x8B62),
        Sampler2DRectArb = ((int)0x8B63),
        Sampler2DRectShadowArb = ((int)0x8B64),
        ObjectDeleteStatusArb = ((int)0x8B80),
        ObjectCompileStatusArb = ((int)0x8B81),
        ObjectLinkStatusArb = ((int)0x8B82),
        ObjectValidateStatusArb = ((int)0x8B83),
        ObjectInfoLogLengthArb = ((int)0x8B84),
        ObjectAttachedObjectsArb = ((int)0x8B85),
        ObjectActiveUniformsArb = ((int)0x8B86),
        ObjectActiveUniformMaxLengthArb = ((int)0x8B87),
        ObjectShaderSourceLengthArb = ((int)0x8B88),
    }

    public enum ArbShaderTextureLod : int
    {
    }

    public enum ArbShadingLanguage100 : int
    {
        ShadingLanguageVersionArb = ((int)0x8B8C),
    }

    public enum ArbShadow : int
    {
        TextureCompareModeArb = ((int)0x884C),
        TextureCompareFuncArb = ((int)0x884D),
        CompareRToTextureArb = ((int)0x884E),
    }

    public enum ArbShadowAmbient : int
    {
        TextureCompareFailValueArb = ((int)0x80BF),
    }

    public enum ArbSync : int
    {
        SyncFlushCommandsBit = ((int)0x00000001),
        MaxServerWaitTimeout = ((int)0x9111),
        ObjectType = ((int)0x9112),
        SyncCondition = ((int)0x9113),
        SyncStatus = ((int)0x9114),
        SyncFlags = ((int)0x9115),
        SyncFence = ((int)0x9116),
        SyncGpuCommandsComplete = ((int)0x9117),
        Unsignaled = ((int)0x9118),
        Signaled = ((int)0x9119),
        AlreadySignaled = ((int)0x911A),
        TimeoutExpired = ((int)0x911B),
        ConditionSatisfied = ((int)0x911C),
        WaitFailed = ((int)0x911D),
        TimeoutIgnored = unchecked((int)0xFFFFFFFFFFFFFFFF),
    }

    public enum ArbTextureBorderClamp : int
    {
        ClampToBorderArb = ((int)0x812D),
    }

    public enum ArbTextureBufferObject : int
    {
        TextureBufferArb = ((int)0x8C2A),
        MaxTextureBufferSizeArb = ((int)0x8C2B),
        TextureBindingBufferArb = ((int)0x8C2C),
        TextureBufferDataStoreBindingArb = ((int)0x8C2D),
        TextureBufferFormatArb = ((int)0x8C2E),
    }

    public enum ArbTextureCompression : int
    {
        CompressedAlphaArb = ((int)0x84E9),
        CompressedLuminanceArb = ((int)0x84EA),
        CompressedLuminanceAlphaArb = ((int)0x84EB),
        CompressedIntensityArb = ((int)0x84EC),
        CompressedRgbArb = ((int)0x84ED),
        CompressedRgbaArb = ((int)0x84EE),
        TextureCompressionHintArb = ((int)0x84EF),
        TextureCompressedImageSizeArb = ((int)0x86A0),
        TextureCompressedArb = ((int)0x86A1),
        NumCompressedTextureFormatsArb = ((int)0x86A2),
        CompressedTextureFormatsArb = ((int)0x86A3),
    }

    public enum ArbTextureCompressionRgtc : int
    {
        CompressedRedRgtc1 = ((int)0x8DBB),
        CompressedSignedRedRgtc1 = ((int)0x8DBC),
        CompressedRgRgtc2 = ((int)0x8DBD),
        CompressedSignedRgRgtc2 = ((int)0x8DBE),
    }

    public enum ArbTextureCubeMap : int
    {
        NormalMapArb = ((int)0x8511),
        ReflectionMapArb = ((int)0x8512),
        TextureCubeMapArb = ((int)0x8513),
        TextureBindingCubeMapArb = ((int)0x8514),
        TextureCubeMapPositiveXArb = ((int)0x8515),
        TextureCubeMapNegativeXArb = ((int)0x8516),
        TextureCubeMapPositiveYArb = ((int)0x8517),
        TextureCubeMapNegativeYArb = ((int)0x8518),
        TextureCubeMapPositiveZArb = ((int)0x8519),
        TextureCubeMapNegativeZArb = ((int)0x851A),
        ProxyTextureCubeMapArb = ((int)0x851B),
        MaxCubeMapTextureSizeArb = ((int)0x851C),
    }

    public enum ArbTextureCubeMapArray : int
    {
        TextureCubeMapArray = ((int)0x9009),
        TextureBindingCubeMapArray = ((int)0x900A),
        ProxyTextureCubeMapArray = ((int)0x900B),
        SamplerCubeMapArray = ((int)0x900C),
        SamplerCubeMapArrayShadow = ((int)0x900D),
        IntSamplerCubeMapArray = ((int)0x900E),
        UnsignedIntSamplerCubeMapArray = ((int)0x900F),
    }

    public enum ArbTextureEnvAdd : int
    {
    }

    public enum ArbTextureEnvCombine : int
    {
        SubtractArb = ((int)0x84E7),
        CombineArb = ((int)0x8570),
        CombineRgbArb = ((int)0x8571),
        CombineAlphaArb = ((int)0x8572),
        RgbScaleArb = ((int)0x8573),
        AddSignedArb = ((int)0x8574),
        InterpolateArb = ((int)0x8575),
        ConstantArb = ((int)0x8576),
        PrimaryColorArb = ((int)0x8577),
        PreviousArb = ((int)0x8578),
        Source0RgbArb = ((int)0x8580),
        Source1RgbArb = ((int)0x8581),
        Source2RgbArb = ((int)0x8582),
        Source0AlphaArb = ((int)0x8588),
        Source1AlphaArb = ((int)0x8589),
        Source2AlphaArb = ((int)0x858A),
        Operand0RgbArb = ((int)0x8590),
        Operand1RgbArb = ((int)0x8591),
        Operand2RgbArb = ((int)0x8592),
        Operand0AlphaArb = ((int)0x8598),
        Operand1AlphaArb = ((int)0x8599),
        Operand2AlphaArb = ((int)0x859A),
    }

    public enum ArbTextureEnvCrossbar : int
    {
    }

    public enum ArbTextureEnvDot3 : int
    {
        Dot3RgbArb = ((int)0x86AE),
        Dot3RgbaArb = ((int)0x86AF),
    }

    public enum ArbTextureFloat : int
    {
        Rgba32fArb = ((int)0x8814),
        Rgb32fArb = ((int)0x8815),
        Alpha32fArb = ((int)0x8816),
        Intensity32fArb = ((int)0x8817),
        Luminance32fArb = ((int)0x8818),
        LuminanceAlpha32fArb = ((int)0x8819),
        Rgba16fArb = ((int)0x881A),
        Rgb16fArb = ((int)0x881B),
        Alpha16fArb = ((int)0x881C),
        Intensity16fArb = ((int)0x881D),
        Luminance16fArb = ((int)0x881E),
        LuminanceAlpha16fArb = ((int)0x881F),
        TextureRedTypeArb = ((int)0x8C10),
        TextureGreenTypeArb = ((int)0x8C11),
        TextureBlueTypeArb = ((int)0x8C12),
        TextureAlphaTypeArb = ((int)0x8C13),
        TextureLuminanceTypeArb = ((int)0x8C14),
        TextureIntensityTypeArb = ((int)0x8C15),
        TextureDepthTypeArb = ((int)0x8C16),
        UnsignedNormalizedArb = ((int)0x8C17),
    }

    public enum ArbTextureGather : int
    {
        MinProgramTextureGatherOffset = ((int)0x8E5E),
        MaxProgramTextureGatherOffset = ((int)0x8E5F),
        MaxProgramTextureGatherComponents = ((int)0x8F9F),
    }

    public enum ArbTextureMirroredRepeat : int
    {
        MirroredRepeatArb = ((int)0x8370),
    }

    public enum ArbTextureMultisample : int
    {
        SamplePosition = ((int)0x8E50),
        SampleMask = ((int)0x8E51),
        SampleMaskValue = ((int)0x8E52),
        MaxSampleMaskWords = ((int)0x8E59),
        Texture2DMultisample = ((int)0x9100),
        ProxyTexture2DMultisample = ((int)0x9101),
        Texture2DMultisampleArray = ((int)0x9102),
        ProxyTexture2DMultisampleArray = ((int)0x9103),
        TextureBinding2DMultisample = ((int)0x9104),
        TextureBinding2DMultisampleArray = ((int)0x9105),
        TextureSamples = ((int)0x9106),
        TextureFixedSampleLocations = ((int)0x9107),
        Sampler2DMultisample = ((int)0x9108),
        IntSampler2DMultisample = ((int)0x9109),
        UnsignedIntSampler2DMultisample = ((int)0x910A),
        Sampler2DMultisampleArray = ((int)0x910B),
        IntSampler2DMultisampleArray = ((int)0x910C),
        UnsignedIntSampler2DMultisampleArray = ((int)0x910D),
        MaxColorTextureSamples = ((int)0x910E),
        MaxDepthTextureSamples = ((int)0x910F),
        MaxIntegerSamples = ((int)0x9110),
    }

    public enum ArbTextureNonPowerOfTwo : int
    {
    }

    public enum ArbTextureQueryLod : int
    {
    }

    public enum ArbTextureRectangle : int
    {
        TextureRectangleArb = ((int)0x84F5),
        TextureBindingRectangleArb = ((int)0x84F6),
        ProxyTextureRectangleArb = ((int)0x84F7),
        MaxRectangleTextureSizeArb = ((int)0x84F8),
    }

    public enum ArbTextureRg : int
    {
        Rg = ((int)0x8227),
        RgInteger = ((int)0x8228),
        R8 = ((int)0x8229),
        R16 = ((int)0x822A),
        Rg8 = ((int)0x822B),
        Rg16 = ((int)0x822C),
        R16f = ((int)0x822D),
        R32f = ((int)0x822E),
        Rg16f = ((int)0x822F),
        Rg32f = ((int)0x8230),
        R8i = ((int)0x8231),
        R8ui = ((int)0x8232),
        R16i = ((int)0x8233),
        R16ui = ((int)0x8234),
        R32i = ((int)0x8235),
        R32ui = ((int)0x8236),
        Rg8i = ((int)0x8237),
        Rg8ui = ((int)0x8238),
        Rg16i = ((int)0x8239),
        Rg16ui = ((int)0x823A),
        Rg32i = ((int)0x823B),
        Rg32ui = ((int)0x823C),
    }

    public enum ArbTransposeMatrix : int
    {
        TransposeModelviewMatrixArb = ((int)0x84E3),
        TransposeProjectionMatrixArb = ((int)0x84E4),
        TransposeTextureMatrixArb = ((int)0x84E5),
        TransposeColorMatrixArb = ((int)0x84E6),
    }

    public enum ArbUniformBufferObject : int
    {
        UniformBuffer = ((int)0x8A11),
        UniformBufferBinding = ((int)0x8A28),
        UniformBufferStart = ((int)0x8A29),
        UniformBufferSize = ((int)0x8A2A),
        MaxVertexUniformBlocks = ((int)0x8A2B),
        MaxGeometryUniformBlocks = ((int)0x8A2C),
        MaxFragmentUniformBlocks = ((int)0x8A2D),
        MaxCombinedUniformBlocks = ((int)0x8A2E),
        MaxUniformBufferBindings = ((int)0x8A2F),
        MaxUniformBlockSize = ((int)0x8A30),
        MaxCombinedVertexUniformComponents = ((int)0x8A31),
        MaxCombinedGeometryUniformComponents = ((int)0x8A32),
        MaxCombinedFragmentUniformComponents = ((int)0x8A33),
        UniformBufferOffsetAlignment = ((int)0x8A34),
        ActiveUniformBlockMaxNameLength = ((int)0x8A35),
        ActiveUniformBlocks = ((int)0x8A36),
        UniformType = ((int)0x8A37),
        UniformSize = ((int)0x8A38),
        UniformNameLength = ((int)0x8A39),
        UniformBlockIndex = ((int)0x8A3A),
        UniformOffset = ((int)0x8A3B),
        UniformArrayStride = ((int)0x8A3C),
        UniformMatrixStride = ((int)0x8A3D),
        UniformIsRowMajor = ((int)0x8A3E),
        UniformBlockBinding = ((int)0x8A3F),
        UniformBlockDataSize = ((int)0x8A40),
        UniformBlockNameLength = ((int)0x8A41),
        UniformBlockActiveUniforms = ((int)0x8A42),
        UniformBlockActiveUniformIndices = ((int)0x8A43),
        UniformBlockReferencedByVertexShader = ((int)0x8A44),
        UniformBlockReferencedByGeometryShader = ((int)0x8A45),
        UniformBlockReferencedByFragmentShader = ((int)0x8A46),
        InvalidIndex = unchecked((int)0xFFFFFFFF),
    }

    public enum ArbVertexArrayBgra : int
    {
        Bgra = ((int)0x80E1),
    }

    public enum ArbVertexArrayObject : int
    {
        VertexArrayBinding = ((int)0x85B5),
    }

    public enum ArbVertexBlend : int
    {
        Modelview0Arb = ((int)0x1700),
        Modelview1Arb = ((int)0x850A),
        MaxVertexUnitsArb = ((int)0x86A4),
        ActiveVertexUnitsArb = ((int)0x86A5),
        WeightSumUnityArb = ((int)0x86A6),
        VertexBlendArb = ((int)0x86A7),
        CurrentWeightArb = ((int)0x86A8),
        WeightArrayTypeArb = ((int)0x86A9),
        WeightArrayStrideArb = ((int)0x86AA),
        WeightArraySizeArb = ((int)0x86AB),
        WeightArrayPointerArb = ((int)0x86AC),
        WeightArrayArb = ((int)0x86AD),
        Modelview2Arb = ((int)0x8722),
        Modelview3Arb = ((int)0x8723),
        Modelview4Arb = ((int)0x8724),
        Modelview5Arb = ((int)0x8725),
        Modelview6Arb = ((int)0x8726),
        Modelview7Arb = ((int)0x8727),
        Modelview8Arb = ((int)0x8728),
        Modelview9Arb = ((int)0x8729),
        Modelview10Arb = ((int)0x872A),
        Modelview11Arb = ((int)0x872B),
        Modelview12Arb = ((int)0x872C),
        Modelview13Arb = ((int)0x872D),
        Modelview14Arb = ((int)0x872E),
        Modelview15Arb = ((int)0x872F),
        Modelview16Arb = ((int)0x8730),
        Modelview17Arb = ((int)0x8731),
        Modelview18Arb = ((int)0x8732),
        Modelview19Arb = ((int)0x8733),
        Modelview20Arb = ((int)0x8734),
        Modelview21Arb = ((int)0x8735),
        Modelview22Arb = ((int)0x8736),
        Modelview23Arb = ((int)0x8737),
        Modelview24Arb = ((int)0x8738),
        Modelview25Arb = ((int)0x8739),
        Modelview26Arb = ((int)0x873A),
        Modelview27Arb = ((int)0x873B),
        Modelview28Arb = ((int)0x873C),
        Modelview29Arb = ((int)0x873D),
        Modelview30Arb = ((int)0x873E),
        Modelview31Arb = ((int)0x873F),
    }

    public enum ArbVertexBufferObject : int
    {
        BufferSizeArb = ((int)0x8764),
        BufferUsageArb = ((int)0x8765),
        ArrayBufferArb = ((int)0x8892),
        ElementArrayBufferArb = ((int)0x8893),
        ArrayBufferBindingArb = ((int)0x8894),
        ElementArrayBufferBindingArb = ((int)0x8895),
        VertexArrayBufferBindingArb = ((int)0x8896),
        NormalArrayBufferBindingArb = ((int)0x8897),
        ColorArrayBufferBindingArb = ((int)0x8898),
        IndexArrayBufferBindingArb = ((int)0x8899),
        TextureCoordArrayBufferBindingArb = ((int)0x889A),
        EdgeFlagArrayBufferBindingArb = ((int)0x889B),
        SecondaryColorArrayBufferBindingArb = ((int)0x889C),
        FogCoordinateArrayBufferBindingArb = ((int)0x889D),
        WeightArrayBufferBindingArb = ((int)0x889E),
        VertexAttribArrayBufferBindingArb = ((int)0x889F),
        ReadOnlyArb = ((int)0x88B8),
        WriteOnlyArb = ((int)0x88B9),
        ReadWriteArb = ((int)0x88BA),
        BufferAccessArb = ((int)0x88BB),
        BufferMappedArb = ((int)0x88BC),
        BufferMapPointerArb = ((int)0x88BD),
        StreamDrawArb = ((int)0x88E0),
        StreamReadArb = ((int)0x88E1),
        StreamCopyArb = ((int)0x88E2),
        StaticDrawArb = ((int)0x88E4),
        StaticReadArb = ((int)0x88E5),
        StaticCopyArb = ((int)0x88E6),
        DynamicDrawArb = ((int)0x88E8),
        DynamicReadArb = ((int)0x88E9),
        DynamicCopyArb = ((int)0x88EA),
    }

    public enum ArbVertexProgram : int
    {
        ColorSumArb = ((int)0x8458),
        VertexProgramArb = ((int)0x8620),
        VertexAttribArrayEnabledArb = ((int)0x8622),
        VertexAttribArraySizeArb = ((int)0x8623),
        VertexAttribArrayStrideArb = ((int)0x8624),
        VertexAttribArrayTypeArb = ((int)0x8625),
        CurrentVertexAttribArb = ((int)0x8626),
        ProgramLengthArb = ((int)0x8627),
        ProgramStringArb = ((int)0x8628),
        MaxProgramMatrixStackDepthArb = ((int)0x862E),
        MaxProgramMatricesArb = ((int)0x862F),
        CurrentMatrixStackDepthArb = ((int)0x8640),
        CurrentMatrixArb = ((int)0x8641),
        VertexProgramPointSizeArb = ((int)0x8642),
        VertexProgramTwoSideArb = ((int)0x8643),
        VertexAttribArrayPointerArb = ((int)0x8645),
        ProgramErrorPositionArb = ((int)0x864B),
        ProgramBindingArb = ((int)0x8677),
        MaxVertexAttribsArb = ((int)0x8869),
        VertexAttribArrayNormalizedArb = ((int)0x886A),
        ProgramErrorStringArb = ((int)0x8874),
        ProgramFormatAsciiArb = ((int)0x8875),
        ProgramFormatArb = ((int)0x8876),
        ProgramInstructionsArb = ((int)0x88A0),
        MaxProgramInstructionsArb = ((int)0x88A1),
        ProgramNativeInstructionsArb = ((int)0x88A2),
        MaxProgramNativeInstructionsArb = ((int)0x88A3),
        ProgramTemporariesArb = ((int)0x88A4),
        MaxProgramTemporariesArb = ((int)0x88A5),
        ProgramNativeTemporariesArb = ((int)0x88A6),
        MaxProgramNativeTemporariesArb = ((int)0x88A7),
        ProgramParametersArb = ((int)0x88A8),
        MaxProgramParametersArb = ((int)0x88A9),
        ProgramNativeParametersArb = ((int)0x88AA),
        MaxProgramNativeParametersArb = ((int)0x88AB),
        ProgramAttribsArb = ((int)0x88AC),
        MaxProgramAttribsArb = ((int)0x88AD),
        ProgramNativeAttribsArb = ((int)0x88AE),
        MaxProgramNativeAttribsArb = ((int)0x88AF),
        ProgramAddressRegistersArb = ((int)0x88B0),
        MaxProgramAddressRegistersArb = ((int)0x88B1),
        ProgramNativeAddressRegistersArb = ((int)0x88B2),
        MaxProgramNativeAddressRegistersArb = ((int)0x88B3),
        MaxProgramLocalParametersArb = ((int)0x88B4),
        MaxProgramEnvParametersArb = ((int)0x88B5),
        ProgramUnderNativeLimitsArb = ((int)0x88B6),
        TransposeCurrentMatrixArb = ((int)0x88B7),
        Matrix0Arb = ((int)0x88C0),
        Matrix1Arb = ((int)0x88C1),
        Matrix2Arb = ((int)0x88C2),
        Matrix3Arb = ((int)0x88C3),
        Matrix4Arb = ((int)0x88C4),
        Matrix5Arb = ((int)0x88C5),
        Matrix6Arb = ((int)0x88C6),
        Matrix7Arb = ((int)0x88C7),
        Matrix8Arb = ((int)0x88C8),
        Matrix9Arb = ((int)0x88C9),
        Matrix10Arb = ((int)0x88CA),
        Matrix11Arb = ((int)0x88CB),
        Matrix12Arb = ((int)0x88CC),
        Matrix13Arb = ((int)0x88CD),
        Matrix14Arb = ((int)0x88CE),
        Matrix15Arb = ((int)0x88CF),
        Matrix16Arb = ((int)0x88D0),
        Matrix17Arb = ((int)0x88D1),
        Matrix18Arb = ((int)0x88D2),
        Matrix19Arb = ((int)0x88D3),
        Matrix20Arb = ((int)0x88D4),
        Matrix21Arb = ((int)0x88D5),
        Matrix22Arb = ((int)0x88D6),
        Matrix23Arb = ((int)0x88D7),
        Matrix24Arb = ((int)0x88D8),
        Matrix25Arb = ((int)0x88D9),
        Matrix26Arb = ((int)0x88DA),
        Matrix27Arb = ((int)0x88DB),
        Matrix28Arb = ((int)0x88DC),
        Matrix29Arb = ((int)0x88DD),
        Matrix30Arb = ((int)0x88DE),
        Matrix31Arb = ((int)0x88DF),
    }

    public enum ArbVertexShader : int
    {
        VertexShaderArb = ((int)0x8B31),
        MaxVertexUniformComponentsArb = ((int)0x8B4A),
        MaxVaryingFloatsArb = ((int)0x8B4B),
        MaxVertexTextureImageUnitsArb = ((int)0x8B4C),
        MaxCombinedTextureImageUnitsArb = ((int)0x8B4D),
        ObjectActiveAttributesArb = ((int)0x8B89),
        ObjectActiveAttributeMaxLengthArb = ((int)0x8B8A),
    }

    public enum ArbWindowPos : int
    {
    }

    public enum ArrayCap : int
    {
        VertexArray = ((int)0x8074),
        NormalArray = ((int)0x8075),
        ColorArray = ((int)0x8076),
        IndexArray = ((int)0x8077),
        TextureCoordArray = ((int)0x8078),
        EdgeFlagArray = ((int)0x8079),
        FogCoordArray = ((int)0x8457),
        SecondaryColorArray = ((int)0x845E),
    }

    public enum AssemblyProgramFormatArb : int
    {
        ProgramFormatAsciiArb = ((int)0x8875),
    }

    public enum AssemblyProgramParameterArb : int
    {
        ProgramLength = ((int)0x8627),
        ProgramBinding = ((int)0x8677),
        ProgramAluInstructionsArb = ((int)0x8805),
        ProgramTexInstructionsArb = ((int)0x8806),
        ProgramTexIndirectionsArb = ((int)0x8807),
        ProgramNativeAluInstructionsArb = ((int)0x8808),
        ProgramNativeTexInstructionsArb = ((int)0x8809),
        ProgramNativeTexIndirectionsArb = ((int)0x880A),
        MaxProgramAluInstructionsArb = ((int)0x880B),
        MaxProgramTexInstructionsArb = ((int)0x880C),
        MaxProgramTexIndirectionsArb = ((int)0x880D),
        MaxProgramNativeAluInstructionsArb = ((int)0x880E),
        MaxProgramNativeTexInstructionsArb = ((int)0x880F),
        MaxProgramNativeTexIndirectionsArb = ((int)0x8810),
        ProgramFormat = ((int)0x8876),
        ProgramInstruction = ((int)0x88A0),
        MaxProgramInstructions = ((int)0x88A1),
        ProgramNativeInstructions = ((int)0x88A2),
        MaxProgramNativeInstructions = ((int)0x88A3),
        ProgramTemporaries = ((int)0x88A4),
        MaxProgramTemporaries = ((int)0x88A5),
        ProgramNativeTemporaries = ((int)0x88A6),
        MaxProgramNativeTemporaries = ((int)0x88A7),
        ProgramParameters = ((int)0x88A8),
        MaxProgramParameters = ((int)0x88A9),
        ProgramNativeParameters = ((int)0x88AA),
        MaxProgramNativeParameters = ((int)0x88AB),
        ProgramAttribs = ((int)0x88AC),
        MaxProgramAttribs = ((int)0x88AD),
        ProgramNativeAttribs = ((int)0x88AE),
        MaxProgramNativeAttribs = ((int)0x88AF),
        ProgramAddressRegisters = ((int)0x88B0),
        MaxProgramAddressRegisters = ((int)0x88B1),
        ProgramNativeAddressRegisters = ((int)0x88B2),
        MaxProgramNativeAddressRegisters = ((int)0x88B3),
        MaxProgramLocalParameters = ((int)0x88B4),
        MaxProgramEnvParameters = ((int)0x88B5),
        ProgramUnderNativeLimits = ((int)0x88B6),
    }

    public enum AssemblyProgramStringParameterArb : int
    {
        ProgramString = ((int)0x8628),
    }

    public enum AssemblyProgramTargetArb : int
    {
        VertexProgram = ((int)0x8620),
        FragmentProgram = ((int)0x8804),
        GeometryProgramNv = ((int)0x8C26),
    }

    public enum AtiDrawBuffers : int
    {
        MaxDrawBuffersAti = ((int)0x8824),
        DrawBuffer0Ati = ((int)0x8825),
        DrawBuffer1Ati = ((int)0x8826),
        DrawBuffer2Ati = ((int)0x8827),
        DrawBuffer3Ati = ((int)0x8828),
        DrawBuffer4Ati = ((int)0x8829),
        DrawBuffer5Ati = ((int)0x882A),
        DrawBuffer6Ati = ((int)0x882B),
        DrawBuffer7Ati = ((int)0x882C),
        DrawBuffer8Ati = ((int)0x882D),
        DrawBuffer9Ati = ((int)0x882E),
        DrawBuffer10Ati = ((int)0x882F),
        DrawBuffer11Ati = ((int)0x8830),
        DrawBuffer12Ati = ((int)0x8831),
        DrawBuffer13Ati = ((int)0x8832),
        DrawBuffer14Ati = ((int)0x8833),
        DrawBuffer15Ati = ((int)0x8834),
    }

    public enum AtiElementArray : int
    {
        ElementArrayAti = ((int)0x8768),
        ElementArrayTypeAti = ((int)0x8769),
        ElementArrayPointerAti = ((int)0x876A),
    }

    public enum AtiEnvmapBumpmap : int
    {
        BumpRotMatrixAti = ((int)0x8775),
        BumpRotMatrixSizeAti = ((int)0x8776),
        BumpNumTexUnitsAti = ((int)0x8777),
        BumpTexUnitsAti = ((int)0x8778),
        DudvAti = ((int)0x8779),
        Du8dv8Ati = ((int)0x877A),
        BumpEnvmapAti = ((int)0x877B),
        BumpTargetAti = ((int)0x877C),
    }

    public enum AtiFragmentShader : int
    {
        Gl2XBitAti = ((int)0x00000001),
        RedBitAti = ((int)0x00000001),
        CompBitAti = ((int)0x00000002),
        Gl4XBitAti = ((int)0x00000002),
        GreenBitAti = ((int)0x00000002),
        BlueBitAti = ((int)0x00000004),
        Gl8XBitAti = ((int)0x00000004),
        NegateBitAti = ((int)0x00000004),
        BiasBitAti = ((int)0x00000008),
        HalfBitAti = ((int)0x00000008),
        QuarterBitAti = ((int)0x00000010),
        EighthBitAti = ((int)0x00000020),
        SaturateBitAti = ((int)0x00000040),
        FragmentShaderAti = ((int)0x8920),
        Reg0Ati = ((int)0x8921),
        Reg1Ati = ((int)0x8922),
        Reg2Ati = ((int)0x8923),
        Reg3Ati = ((int)0x8924),
        Reg4Ati = ((int)0x8925),
        Reg5Ati = ((int)0x8926),
        Reg6Ati = ((int)0x8927),
        Reg7Ati = ((int)0x8928),
        Reg8Ati = ((int)0x8929),
        Reg9Ati = ((int)0x892A),
        Reg10Ati = ((int)0x892B),
        Reg11Ati = ((int)0x892C),
        Reg12Ati = ((int)0x892D),
        Reg13Ati = ((int)0x892E),
        Reg14Ati = ((int)0x892F),
        Reg15Ati = ((int)0x8930),
        Reg16Ati = ((int)0x8931),
        Reg17Ati = ((int)0x8932),
        Reg18Ati = ((int)0x8933),
        Reg19Ati = ((int)0x8934),
        Reg20Ati = ((int)0x8935),
        Reg21Ati = ((int)0x8936),
        Reg22Ati = ((int)0x8937),
        Reg23Ati = ((int)0x8938),
        Reg24Ati = ((int)0x8939),
        Reg25Ati = ((int)0x893A),
        Reg26Ati = ((int)0x893B),
        Reg27Ati = ((int)0x893C),
        Reg28Ati = ((int)0x893D),
        Reg29Ati = ((int)0x893E),
        Reg30Ati = ((int)0x893F),
        Reg31Ati = ((int)0x8940),
        Con0Ati = ((int)0x8941),
        Con1Ati = ((int)0x8942),
        Con2Ati = ((int)0x8943),
        Con3Ati = ((int)0x8944),
        Con4Ati = ((int)0x8945),
        Con5Ati = ((int)0x8946),
        Con6Ati = ((int)0x8947),
        Con7Ati = ((int)0x8948),
        Con8Ati = ((int)0x8949),
        Con9Ati = ((int)0x894A),
        Con10Ati = ((int)0x894B),
        Con11Ati = ((int)0x894C),
        Con12Ati = ((int)0x894D),
        Con13Ati = ((int)0x894E),
        Con14Ati = ((int)0x894F),
        Con15Ati = ((int)0x8950),
        Con16Ati = ((int)0x8951),
        Con17Ati = ((int)0x8952),
        Con18Ati = ((int)0x8953),
        Con19Ati = ((int)0x8954),
        Con20Ati = ((int)0x8955),
        Con21Ati = ((int)0x8956),
        Con22Ati = ((int)0x8957),
        Con23Ati = ((int)0x8958),
        Con24Ati = ((int)0x8959),
        Con25Ati = ((int)0x895A),
        Con26Ati = ((int)0x895B),
        Con27Ati = ((int)0x895C),
        Con28Ati = ((int)0x895D),
        Con29Ati = ((int)0x895E),
        Con30Ati = ((int)0x895F),
        Con31Ati = ((int)0x8960),
        MovAti = ((int)0x8961),
        AddAti = ((int)0x8963),
        MulAti = ((int)0x8964),
        SubAti = ((int)0x8965),
        Dot3Ati = ((int)0x8966),
        Dot4Ati = ((int)0x8967),
        MadAti = ((int)0x8968),
        LerpAti = ((int)0x8969),
        CndAti = ((int)0x896A),
        Cnd0Ati = ((int)0x896B),
        Dot2AddAti = ((int)0x896C),
        SecondaryInterpolatorAti = ((int)0x896D),
        NumFragmentRegistersAti = ((int)0x896E),
        NumFragmentConstantsAti = ((int)0x896F),
        NumPassesAti = ((int)0x8970),
        NumInstructionsPerPassAti = ((int)0x8971),
        NumInstructionsTotalAti = ((int)0x8972),
        NumInputInterpolatorComponentsAti = ((int)0x8973),
        NumLoopbackComponentsAti = ((int)0x8974),
        ColorAlphaPairingAti = ((int)0x8975),
        SwizzleStrAti = ((int)0x8976),
        SwizzleStqAti = ((int)0x8977),
        SwizzleStrDrAti = ((int)0x8978),
        SwizzleStqDqAti = ((int)0x8979),
        SwizzleStrqAti = ((int)0x897A),
        SwizzleStrqDqAti = ((int)0x897B),
    }

    public enum AtiMapObjectBuffer : int
    {
    }

    public enum AtiMeminfo : int
    {
        VboFreeMemoryAti = ((int)0x87FB),
        TextureFreeMemoryAti = ((int)0x87FC),
        RenderbufferFreeMemoryAti = ((int)0x87FD),
    }

    public enum AtiPixelFormatFloat : int
    {
        TypeRgbaFloatAti = ((int)0x8820),
        ColorClearUnclampedValueAti = ((int)0x8835),
    }

    public enum AtiPnTriangles : int
    {
        PnTrianglesAti = ((int)0x87F0),
        MaxPnTrianglesTesselationLevelAti = ((int)0x87F1),
        PnTrianglesPointModeAti = ((int)0x87F2),
        PnTrianglesNormalModeAti = ((int)0x87F3),
        PnTrianglesTesselationLevelAti = ((int)0x87F4),
        PnTrianglesPointModeLinearAti = ((int)0x87F5),
        PnTrianglesPointModeCubicAti = ((int)0x87F6),
        PnTrianglesNormalModeLinearAti = ((int)0x87F7),
        PnTrianglesNormalModeQuadraticAti = ((int)0x87F8),
    }

    public enum AtiSeparateStencil : int
    {
        StencilBackFuncAti = ((int)0x8800),
        StencilBackFailAti = ((int)0x8801),
        StencilBackPassDepthFailAti = ((int)0x8802),
        StencilBackPassDepthPassAti = ((int)0x8803),
    }

    public enum AtiTextFragmentShader : int
    {
        TextFragmentShaderAti = ((int)0x8200),
    }

    public enum AtiTextureEnvCombine3 : int
    {
        ModulateAddAti = ((int)0x8744),
        ModulateSignedAddAti = ((int)0x8745),
        ModulateSubtractAti = ((int)0x8746),
    }

    public enum AtiTextureFloat : int
    {
        RgbaFloat32Ati = ((int)0x8814),
        RgbFloat32Ati = ((int)0x8815),
        AlphaFloat32Ati = ((int)0x8816),
        IntensityFloat32Ati = ((int)0x8817),
        LuminanceFloat32Ati = ((int)0x8818),
        LuminanceAlphaFloat32Ati = ((int)0x8819),
        RgbaFloat16Ati = ((int)0x881A),
        RgbFloat16Ati = ((int)0x881B),
        AlphaFloat16Ati = ((int)0x881C),
        IntensityFloat16Ati = ((int)0x881D),
        LuminanceFloat16Ati = ((int)0x881E),
        LuminanceAlphaFloat16Ati = ((int)0x881F),
    }

    public enum AtiTextureMirrorOnce : int
    {
        MirrorClampAti = ((int)0x8742),
        MirrorClampToEdgeAti = ((int)0x8743),
    }

    public enum AtiVertexArrayObject : int
    {
        StaticAti = ((int)0x8760),
        DynamicAti = ((int)0x8761),
        PreserveAti = ((int)0x8762),
        DiscardAti = ((int)0x8763),
        ObjectBufferSizeAti = ((int)0x8764),
        ObjectBufferUsageAti = ((int)0x8765),
        ArrayObjectBufferAti = ((int)0x8766),
        ArrayObjectOffsetAti = ((int)0x8767),
    }

    public enum AtiVertexAttribArrayObject : int
    {
    }

    public enum AtiVertexStreams : int
    {
        MaxVertexStreamsAti = ((int)0x876B),
        VertexStream0Ati = ((int)0x876C),
        VertexStream1Ati = ((int)0x876D),
        VertexStream2Ati = ((int)0x876E),
        VertexStream3Ati = ((int)0x876F),
        VertexStream4Ati = ((int)0x8770),
        VertexStream5Ati = ((int)0x8771),
        VertexStream6Ati = ((int)0x8772),
        VertexStream7Ati = ((int)0x8773),
        VertexSourceAti = ((int)0x8774),
    }

    [Flags]
    public enum AttribMask : int
    {
        CurrentBit = ((int)0x00000001),
        PointBit = ((int)0x00000002),
        LineBit = ((int)0x00000004),
        PolygonBit = ((int)0x00000008),
        PolygonStippleBit = ((int)0x00000010),
        PixelModeBit = ((int)0x00000020),
        LightingBit = ((int)0x00000040),
        FogBit = ((int)0x00000080),
        DepthBufferBit = ((int)0x00000100),
        AccumBufferBit = ((int)0x00000200),
        StencilBufferBit = ((int)0x00000400),
        ViewportBit = ((int)0x00000800),
        TransformBit = ((int)0x00001000),
        EnableBit = ((int)0x00002000),
        ColorBufferBit = ((int)0x00004000),
        HintBit = ((int)0x00008000),
        EvalBit = ((int)0x00010000),
        ListBit = ((int)0x00020000),
        TextureBit = ((int)0x00040000),
        ScissorBit = ((int)0x00080000),
        MultisampleBit = ((int)0x20000000),
        AllAttribBits = unchecked((int)0xFFFFFFFF),
    }

    public enum BeginFeedbackMode : int
    {
        Points = ((int)0x0000),
        Lines = ((int)0x0001),
        Triangles = ((int)0x0004),
    }

    public enum BeginMode : int
    {
        Points = ((int)0x0000),
        Lines = ((int)0x0001),
        LineLoop = ((int)0x0002),
        LineStrip = ((int)0x0003),
        Triangles = ((int)0x0004),
        TriangleStrip = ((int)0x0005),
        TriangleFan = ((int)0x0006),
        Quads = ((int)0x0007),
        QuadStrip = ((int)0x0008),
        Polygon = ((int)0x0009),
        LinesAdjacency = ((int)0xA),
        LineStripAdjacency = ((int)0xB),
        TrianglesAdjacency = ((int)0xC),
        TriangleStripAdjacency = ((int)0xD),
    }

    public enum BlendEquationMode : int
    {
        FuncAdd = ((int)0x8006),
        Min = ((int)0x8007),
        Max = ((int)0x8008),
        FuncSubtract = ((int)0x800A),
        FuncReverseSubtract = ((int)0x800B),
    }

    public enum BlendEquationModeExt : int
    {
        LogicOp = ((int)0x0BF1),
        FuncAddExt = ((int)0x8006),
        MinExt = ((int)0x8007),
        MaxExt = ((int)0x8008),
        FuncSubtractExt = ((int)0x800A),
        FuncReverseSubtractExt = ((int)0x800B),
        AlphaMinSgix = ((int)0x8320),
        AlphaMaxSgix = ((int)0x8321),
    }

    public enum BlendingFactorDest : int
    {
        Zero = ((int)0),
        SrcColor = ((int)0x0300),
        OneMinusSrcColor = ((int)0x0301),
        SrcAlpha = ((int)0x0302),
        OneMinusSrcAlpha = ((int)0x0303),
        DstAlpha = ((int)0x0304),
        OneMinusDstAlpha = ((int)0x0305),
        DstColor = ((int)0x0306),
        OneMinusDstColor = ((int)0x0307),
        ConstantColor = ((int)0x8001),
        ConstantColorExt = ((int)0x8001),
        OneMinusConstantColor = ((int)0x8002),
        OneMinusConstantColorExt = ((int)0x8002),
        ConstantAlpha = ((int)0x8003),
        ConstantAlphaExt = ((int)0x8003),
        OneMinusConstantAlpha = ((int)0x8004),
        OneMinusConstantAlphaExt = ((int)0x8004),
        One = ((int)1),
    }

    public enum BlendingFactorSrc : int
    {
        Zero = ((int)0),
        SrcAlpha = ((int)0x0302),
        OneMinusSrcAlpha = ((int)0x0303),
        DstAlpha = ((int)0x0304),
        OneMinusDstAlpha = ((int)0x0305),
        DstColor = ((int)0x0306),
        OneMinusDstColor = ((int)0x0307),
        SrcAlphaSaturate = ((int)0x0308),
        ConstantColor = ((int)0x8001),
        ConstantColorExt = ((int)0x8001),
        OneMinusConstantColor = ((int)0x8002),
        OneMinusConstantColorExt = ((int)0x8002),
        ConstantAlpha = ((int)0x8003),
        ConstantAlphaExt = ((int)0x8003),
        OneMinusConstantAlpha = ((int)0x8004),
        OneMinusConstantAlphaExt = ((int)0x8004),
        One = ((int)1),
    }

    public enum BlitFramebufferFilter : int
    {
        Nearest = ((int)0x2600),
        Linear = ((int)0x2601),
    }

    public enum Boolean : int
    {
        False = ((int)0),
        True = ((int)1),
    }

    public enum BufferAccess : int
    {
        ReadOnly = ((int)0x88B8),
        WriteOnly = ((int)0x88B9),
        ReadWrite = ((int)0x88BA),
    }

    public enum BufferAccessArb : int
    {
        ReadOnly = ((int)0x88B8),
        WriteOnly = ((int)0x88B9),
        ReadWrite = ((int)0x88BA),
    }

    [Flags]
    public enum BufferAccessMask : int
    {
        MapReadBit = ((int)0x0001),
        MapWriteBit = ((int)0x0002),
        MapInvalidateRangeBit = ((int)0x0004),
        MapInvalidateBufferBit = ((int)0x0008),
        MapFlushExplicitBit = ((int)0x0010),
        MapUnsynchronizedBit = ((int)0x0020),
    }

    public enum BufferParameterApple : int
    {
        BufferSerializedModifyApple = ((int)0x8A12),
        BufferFlushingUnmapApple = ((int)0x8A13),
    }

    public enum BufferParameterName : int
    {
        BufferSize = ((int)0x8764),
        BufferUsage = ((int)0x8765),
        BufferAccess = ((int)0x88BB),
        BufferMapped = ((int)0x88BC),
    }

    public enum BufferParameterNameArb : int
    {
        BufferSize = ((int)0x8764),
        BufferUsage = ((int)0x8765),
        BufferAccess = ((int)0x88BB),
        BufferMapped = ((int)0x88BC),
    }

    public enum BufferPointer : int
    {
        BufferMapPointer = ((int)0x88BD),
    }

    public enum BufferPointerNameArb : int
    {
        BufferMapPointer = ((int)0x88BD),
    }

    public enum BufferTarget : int
    {
        ArrayBuffer = ((int)0x8892),
        ElementArrayBuffer = ((int)0x8893),
        PixelPackBuffer = ((int)0x88EB),
        PixelUnpackBuffer = ((int)0x88EC),
        UniformBuffer = ((int)0x8A11),
        TextureBuffer = ((int)0x8C2A),
        TransformFeedbackBuffer = ((int)0x8C8E),
        CopyReadBuffer = ((int)0x8F36),
        CopyWriteBuffer = ((int)0x8F37),
    }

    public enum BufferTargetArb : int
    {
        ArrayBuffer = ((int)0x8892),
        ElementArrayBuffer = ((int)0x8893),
    }

    public enum BufferUsageArb : int
    {
        StreamDraw = ((int)0x88E0),
        StreamRead = ((int)0x88E1),
        StreamCopy = ((int)0x88E2),
        StaticDraw = ((int)0x88E4),
        StaticRead = ((int)0x88E5),
        StaticCopy = ((int)0x88E6),
        DynamicDraw = ((int)0x88E8),
        DynamicRead = ((int)0x88E9),
        DynamicCopy = ((int)0x88EA),
    }

    public enum BufferUsageHint : int
    {
        StreamDraw = ((int)0x88E0),
        StreamRead = ((int)0x88E1),
        StreamCopy = ((int)0x88E2),
        StaticDraw = ((int)0x88E4),
        StaticRead = ((int)0x88E5),
        StaticCopy = ((int)0x88E6),
        DynamicDraw = ((int)0x88E8),
        DynamicRead = ((int)0x88E9),
        DynamicCopy = ((int)0x88EA),
    }

    public enum ClampColorMode : int
    {
        False = ((int)0),
        FixedOnly = ((int)0x891D),
        True = ((int)1),
    }

    public enum ClampColorTarget : int
    {
        ClampVertexColor = ((int)0x891A),
        ClampFragmentColor = ((int)0x891B),
        ClampReadColor = ((int)0x891C),
    }

    public enum ClearBuffer : int
    {
        Color = ((int)0x1800),
        Depth = ((int)0x1801),
        Stencil = ((int)0x1802),
        DepthStencil = ((int)0x84F9),
    }

    [Flags]
    public enum ClearBufferMask : int
    {
        DepthBufferBit = ((int)0x00000100),
        AccumBufferBit = ((int)0x00000200),
        StencilBufferBit = ((int)0x00000400),
        ColorBufferBit = ((int)0x00004000),
    }

    [Flags]
    public enum ClientAttribMask : int
    {
        ClientPixelStoreBit = ((int)0x00000001),
        ClientVertexArrayBit = ((int)0x00000002),
        ClientAllAttribBits = unchecked((int)0xFFFFFFFF),
    }

    public enum ClipPlaneName : int
    {
        ClipPlane0 = ((int)0x3000),
        ClipPlane1 = ((int)0x3001),
        ClipPlane2 = ((int)0x3002),
        ClipPlane3 = ((int)0x3003),
        ClipPlane4 = ((int)0x3004),
        ClipPlane5 = ((int)0x3005),
    }

    public enum ColorMaterialFace : int
    {
        Front = ((int)0x0404),
        Back = ((int)0x0405),
        FrontAndBack = ((int)0x0408),
    }

    public enum ColorMaterialParameter : int
    {
        Ambient = ((int)0x1200),
        Diffuse = ((int)0x1201),
        Specular = ((int)0x1202),
        Emission = ((int)0x1600),
        AmbientAndDiffuse = ((int)0x1602),
    }

    public enum ColorPointerType : int
    {
        Byte = ((int)0x1400),
        UnsignedByte = ((int)0x1401),
        Short = ((int)0x1402),
        UnsignedShort = ((int)0x1403),
        Int = ((int)0x1404),
        UnsignedInt = ((int)0x1405),
        Float = ((int)0x1406),
        Double = ((int)0x140A),
        HalfFloat = ((int)0x140B),
    }

    public enum ColorTableParameterPName : int
    {
        ColorTableScale = ((int)0x80D6),
        ColorTableBias = ((int)0x80D7),
    }

    public enum ColorTableParameterPNameSgi : int
    {
        ColorTableScaleSgi = ((int)0x80D6),
        ColorTableBiasSgi = ((int)0x80D7),
    }

    public enum ColorTableTarget : int
    {
        ColorTable = ((int)0x80D0),
        PostConvolutionColorTable = ((int)0x80D1),
        PostColorMatrixColorTable = ((int)0x80D2),
        ProxyColorTable = ((int)0x80D3),
        ProxyPostConvolutionColorTable = ((int)0x80D4),
        ProxyPostColorMatrixColorTable = ((int)0x80D5),
    }

    public enum ColorTableTargetSgi : int
    {
        TextureColorTableSgi = ((int)0x80BC),
        ProxyTextureColorTableSgi = ((int)0x80BD),
        ColorTableSgi = ((int)0x80D0),
        PostConvolutionColorTableSgi = ((int)0x80D1),
        PostColorMatrixColorTableSgi = ((int)0x80D2),
        ProxyColorTableSgi = ((int)0x80D3),
        ProxyPostConvolutionColorTableSgi = ((int)0x80D4),
        ProxyPostColorMatrixColorTableSgi = ((int)0x80D5),
    }

    public enum ConditionalRenderType : int
    {
        QueryWait = ((int)0x8E13),
        QueryNoWait = ((int)0x8E14),
        QueryByRegionWait = ((int)0x8E15),
        QueryByRegionNoWait = ((int)0x8E16),
    }

    public enum ConvolutionBorderModeExt : int
    {
        ReduceExt = ((int)0x8016),
    }

    public enum ConvolutionParameter : int
    {
        ConvolutionBorderMode = ((int)0x8013),
        ConvolutionFilterScale = ((int)0x8014),
        ConvolutionFilterBias = ((int)0x8015),
    }

    public enum ConvolutionParameterExt : int
    {
        ConvolutionBorderModeExt = ((int)0x8013),
        ConvolutionFilterScaleExt = ((int)0x8014),
        ConvolutionFilterBiasExt = ((int)0x8015),
    }

    public enum ConvolutionParameterValue : int
    {
        Reduce = ((int)0x8016),
        ConstantBorder = ((int)0x8151),
        ReplicateBorder = ((int)0x8153),
    }

    public enum ConvolutionTarget : int
    {
        Convolution1D = ((int)0x8010),
        Convolution2D = ((int)0x8011),
        Separable2D = ((int)0x8012),
    }

    public enum ConvolutionTargetExt : int
    {
        Convolution1DExt = ((int)0x8010),
        Convolution2DExt = ((int)0x8011),
    }

    public enum CullFaceMode : int
    {
        Front = ((int)0x0404),
        Back = ((int)0x0405),
        FrontAndBack = ((int)0x0408),
    }

    public enum DataType : int
    {
        Byte = ((int)0x1400),
        UnsignedByte = ((int)0x1401),
        Short = ((int)0x1402),
        UnsignedShort = ((int)0x1403),
        Int = ((int)0x1404),
        UnsignedInt = ((int)0x1405),
        Float = ((int)0x1406),
        Gl2Bytes = ((int)0x1407),
        Gl3Bytes = ((int)0x1408),
        Gl4Bytes = ((int)0x1409),
        Double = ((int)0x140A),
        DoubleExt = ((int)0x140A),
    }

    public enum DepthFunction : int
    {
        Never = ((int)0x0200),
        Less = ((int)0x0201),
        Equal = ((int)0x0202),
        Lequal = ((int)0x0203),
        Greater = ((int)0x0204),
        Notequal = ((int)0x0205),
        Gequal = ((int)0x0206),
        Always = ((int)0x0207),
    }

    public enum DrawBufferMode : int
    {
        None = ((int)0),
        FrontLeft = ((int)0x0400),
        FrontRight = ((int)0x0401),
        BackLeft = ((int)0x0402),
        BackRight = ((int)0x0403),
        Front = ((int)0x0404),
        Back = ((int)0x0405),
        Left = ((int)0x0406),
        Right = ((int)0x0407),
        FrontAndBack = ((int)0x0408),
        Aux0 = ((int)0x0409),
        Aux1 = ((int)0x040A),
        Aux2 = ((int)0x040B),
        Aux3 = ((int)0x040C),
        ColorAttachment0 = ((int)0x8CE0),
        ColorAttachment1 = ((int)0x8CE1),
        ColorAttachment2 = ((int)0x8CE2),
        ColorAttachment3 = ((int)0x8CE3),
        ColorAttachment4 = ((int)0x8CE4),
        ColorAttachment5 = ((int)0x8CE5),
        ColorAttachment6 = ((int)0x8CE6),
        ColorAttachment7 = ((int)0x8CE7),
        ColorAttachment8 = ((int)0x8CE8),
        ColorAttachment9 = ((int)0x8CE9),
        ColorAttachment10 = ((int)0x8CEA),
        ColorAttachment11 = ((int)0x8CEB),
        ColorAttachment12 = ((int)0x8CEC),
        ColorAttachment13 = ((int)0x8CED),
        ColorAttachment14 = ((int)0x8CEE),
        ColorAttachment15 = ((int)0x8CEF),
    }

    public enum DrawBuffersEnum : int
    {
        None = ((int)0),
        FrontLeft = ((int)0x0400),
        FrontRight = ((int)0x0401),
        BackLeft = ((int)0x0402),
        BackRight = ((int)0x0403),
        Aux0 = ((int)0x0409),
        Aux1 = ((int)0x040A),
        Aux2 = ((int)0x040B),
        Aux3 = ((int)0x040C),
        ColorAttachment0 = ((int)0x8CE0),
        ColorAttachment1 = ((int)0x8CE1),
        ColorAttachment2 = ((int)0x8CE2),
        ColorAttachment3 = ((int)0x8CE3),
        ColorAttachment4 = ((int)0x8CE4),
        ColorAttachment5 = ((int)0x8CE5),
        ColorAttachment6 = ((int)0x8CE6),
        ColorAttachment7 = ((int)0x8CE7),
        ColorAttachment8 = ((int)0x8CE8),
        ColorAttachment9 = ((int)0x8CE9),
        ColorAttachment10 = ((int)0x8CEA),
        ColorAttachment11 = ((int)0x8CEB),
        ColorAttachment12 = ((int)0x8CEC),
        ColorAttachment13 = ((int)0x8CED),
        ColorAttachment14 = ((int)0x8CEE),
        ColorAttachment15 = ((int)0x8CEF),
    }

    public enum DrawElementsType : int
    {
        UnsignedByte = ((int)0x1401),
        UnsignedShort = ((int)0x1403),
        UnsignedInt = ((int)0x1405),
    }

    public enum EnableCap : int
    {
        PointSmooth = ((int)0x0B10),
        LineSmooth = ((int)0x0B20),
        LineStipple = ((int)0x0B24),
        PolygonSmooth = ((int)0x0B41),
        PolygonStipple = ((int)0x0B42),
        CullFace = ((int)0x0B44),
        Lighting = ((int)0x0B50),
        ColorMaterial = ((int)0x0B57),
        Fog = ((int)0x0B60),
        DepthTest = ((int)0x0B71),
        StencilTest = ((int)0x0B90),
        Normalize = ((int)0x0BA1),
        AlphaTest = ((int)0x0BC0),
        Dither = ((int)0x0BD0),
        Blend = ((int)0x0BE2),
        IndexLogicOp = ((int)0x0BF1),
        ColorLogicOp = ((int)0x0BF2),
        ScissorTest = ((int)0x0C11),
        TextureGenS = ((int)0x0C60),
        TextureGenT = ((int)0x0C61),
        TextureGenR = ((int)0x0C62),
        TextureGenQ = ((int)0x0C63),
        AutoNormal = ((int)0x0D80),
        Map1Color4 = ((int)0x0D90),
        Map1Index = ((int)0x0D91),
        Map1Normal = ((int)0x0D92),
        Map1TextureCoord1 = ((int)0x0D93),
        Map1TextureCoord2 = ((int)0x0D94),
        Map1TextureCoord3 = ((int)0x0D95),
        Map1TextureCoord4 = ((int)0x0D96),
        Map1Vertex3 = ((int)0x0D97),
        Map1Vertex4 = ((int)0x0D98),
        Map2Color4 = ((int)0x0DB0),
        Map2Index = ((int)0x0DB1),
        Map2Normal = ((int)0x0DB2),
        Map2TextureCoord1 = ((int)0x0DB3),
        Map2TextureCoord2 = ((int)0x0DB4),
        Map2TextureCoord3 = ((int)0x0DB5),
        Map2TextureCoord4 = ((int)0x0DB6),
        Map2Vertex3 = ((int)0x0DB7),
        Map2Vertex4 = ((int)0x0DB8),
        Texture1D = ((int)0x0DE0),
        Texture2D = ((int)0x0DE1),
        PolygonOffsetPoint = ((int)0x2A01),
        PolygonOffsetLine = ((int)0x2A02),
        ClipPlane0 = ((int)0x3000),
        ClipPlane1 = ((int)0x3001),
        ClipPlane2 = ((int)0x3002),
        ClipPlane3 = ((int)0x3003),
        ClipPlane4 = ((int)0x3004),
        ClipPlane5 = ((int)0x3005),
        Light0 = ((int)0x4000),
        Light1 = ((int)0x4001),
        Light2 = ((int)0x4002),
        Light3 = ((int)0x4003),
        Light4 = ((int)0x4004),
        Light5 = ((int)0x4005),
        Light6 = ((int)0x4006),
        Light7 = ((int)0x4007),
        Convolution1D = ((int)0x8010),
        Convolution1DExt = ((int)0x8010),
        Convolution2D = ((int)0x8011),
        Convolution2DExt = ((int)0x8011),
        Separable2D = ((int)0x8012),
        Separable2DExt = ((int)0x8012),
        Histogram = ((int)0x8024),
        HistogramExt = ((int)0x8024),
        MinmaxExt = ((int)0x802E),
        PolygonOffsetFill = ((int)0x8037),
        RescaleNormal = ((int)0x803A),
        RescaleNormalExt = ((int)0x803A),
        Texture3DExt = ((int)0x806F),
        VertexArray = ((int)0x8074),
        NormalArray = ((int)0x8075),
        ColorArray = ((int)0x8076),
        IndexArray = ((int)0x8077),
        TextureCoordArray = ((int)0x8078),
        EdgeFlagArray = ((int)0x8079),
        InterlaceSgix = ((int)0x8094),
        Multisample = ((int)0x809D),
        SampleAlphaToCoverage = ((int)0x809E),
        SampleAlphaToMaskSgis = ((int)0x809E),
        SampleAlphaToOne = ((int)0x809F),
        SampleAlphaToOneSgis = ((int)0x809F),
        SampleCoverage = ((int)0x80A0),
        SampleMaskSgis = ((int)0x80A0),
        TextureColorTableSgi = ((int)0x80BC),
        ColorTable = ((int)0x80D0),
        ColorTableSgi = ((int)0x80D0),
        PostConvolutionColorTable = ((int)0x80D1),
        PostConvolutionColorTableSgi = ((int)0x80D1),
        PostColorMatrixColorTable = ((int)0x80D2),
        PostColorMatrixColorTableSgi = ((int)0x80D2),
        Texture4DSgis = ((int)0x8134),
        PixelTexGenSgix = ((int)0x8139),
        SpriteSgix = ((int)0x8148),
        ReferencePlaneSgix = ((int)0x817D),
        IrInstrument1Sgix = ((int)0x817F),
        CalligraphicFragmentSgix = ((int)0x8183),
        FramezoomSgix = ((int)0x818B),
        FogOffsetSgix = ((int)0x8198),
        SharedTexturePaletteExt = ((int)0x81FB),
        AsyncHistogramSgix = ((int)0x832C),
        PixelTextureSgis = ((int)0x8353),
        AsyncTexImageSgix = ((int)0x835C),
        AsyncDrawPixelsSgix = ((int)0x835D),
        AsyncReadPixelsSgix = ((int)0x835E),
        FragmentLightingSgix = ((int)0x8400),
        FragmentColorMaterialSgix = ((int)0x8401),
        FragmentLight0Sgix = ((int)0x840C),
        FragmentLight1Sgix = ((int)0x840D),
        FragmentLight2Sgix = ((int)0x840E),
        FragmentLight3Sgix = ((int)0x840F),
        FragmentLight4Sgix = ((int)0x8410),
        FragmentLight5Sgix = ((int)0x8411),
        FragmentLight6Sgix = ((int)0x8412),
        FragmentLight7Sgix = ((int)0x8413),
        FogCoordArray = ((int)0x8457),
        ColorSum = ((int)0x8458),
        SecondaryColorArray = ((int)0x845E),
        TextureCubeMap = ((int)0x8513),
        ProgramPointSize = ((int)0x8642),
        VertexProgramPointSize = ((int)0x8642),
        VertexProgramTwoSide = ((int)0x8643),
        DepthClamp = ((int)0x864F),
        TextureCubeMapSeamless = ((int)0x884F),
        PointSprite = ((int)0x8861),
        RasterizerDiscard = ((int)0x8C89),
        FramebufferSrgb = ((int)0x8DB9),
        SampleMask = ((int)0x8E51),
        PrimitiveRestart = ((int)0x8F9D),
    }

    public enum ErrorCode : int
    {
        NoError = ((int)0),
        InvalidEnum = ((int)0x0500),
        InvalidValue = ((int)0x0501),
        InvalidOperation = ((int)0x0502),
        StackOverflow = ((int)0x0503),
        StackUnderflow = ((int)0x0504),
        OutOfMemory = ((int)0x0505),
        InvalidFramebufferOperation = ((int)0x0506),
        InvalidFramebufferOperationExt = ((int)0x0506),
        TableTooLargeExt = ((int)0x8031),
        TextureTooLargeExt = ((int)0x8065),
    }

    public enum Ext422Pixels : int
    {
        Gl422Ext = ((int)0x80CC),
        Gl422RevExt = ((int)0x80CD),
        Gl422AverageExt = ((int)0x80CE),
        Gl422RevAverageExt = ((int)0x80CF),
    }

    public enum ExtAbgr : int
    {
        AbgrExt = ((int)0x8000),
    }

    public enum ExtBgra : int
    {
        BgrExt = ((int)0x80E0),
        BgraExt = ((int)0x80E1),
    }

    public enum ExtBindableUniform : int
    {
        MaxVertexBindableUniformsExt = ((int)0x8DE2),
        MaxFragmentBindableUniformsExt = ((int)0x8DE3),
        MaxGeometryBindableUniformsExt = ((int)0x8DE4),
        MaxBindableUniformSizeExt = ((int)0x8DED),
        UniformBufferExt = ((int)0x8DEE),
        UniformBufferBindingExt = ((int)0x8DEF),
    }

    public enum ExtBlendColor : int
    {
        ConstantColor = ((int)0x8001),
        ConstantColorExt = ((int)0x8001),
        OneMinusConstantColor = ((int)0x8002),
        OneMinusConstantColorExt = ((int)0x8002),
        ConstantAlpha = ((int)0x8003),
        ConstantAlphaExt = ((int)0x8003),
        OneMinusConstantAlpha = ((int)0x8004),
        OneMinusConstantAlphaExt = ((int)0x8004),
        BlendColor = ((int)0x8005),
        BlendColorExt = ((int)0x8005),
    }

    public enum ExtBlendEquationSeparate : int
    {
        BlendEquationRgbExt = ((int)0x8009),
        BlendEquationAlphaExt = ((int)0x883D),
    }

    public enum ExtBlendFuncSeparate : int
    {
        BlendDstRgbExt = ((int)0x80C8),
        BlendSrcRgbExt = ((int)0x80C9),
        BlendDstAlphaExt = ((int)0x80CA),
        BlendSrcAlphaExt = ((int)0x80CB),
    }

    public enum ExtBlendLogicOp : int
    {
    }

    public enum ExtBlendMinmax : int
    {
        FuncAdd = ((int)0x8006),
        FuncAddExt = ((int)0x8006),
        Min = ((int)0x8007),
        MinExt = ((int)0x8007),
        Max = ((int)0x8008),
        MaxExt = ((int)0x8008),
        BlendEquation = ((int)0x8009),
        BlendEquationExt = ((int)0x8009),
    }

    public enum ExtBlendSubtract : int
    {
        FuncSubtract = ((int)0x800A),
        FuncSubtractExt = ((int)0x800A),
        FuncReverseSubtract = ((int)0x800B),
        FuncReverseSubtractExt = ((int)0x800B),
    }

    public enum ExtClipVolumeHint : int
    {
        ClipVolumeClippingHintExt = ((int)0x80F0),
    }

    public enum ExtCmyka : int
    {
        CmykExt = ((int)0x800C),
        CmykaExt = ((int)0x800D),
        PackCmykHintExt = ((int)0x800E),
        UnpackCmykHintExt = ((int)0x800F),
    }

    public enum ExtColorSubtable : int
    {
    }

    public enum ExtCompiledVertexArray : int
    {
        ArrayElementLockFirstExt = ((int)0x81A8),
        ArrayElementLockCountExt = ((int)0x81A9),
    }

    public enum ExtConvolution : int
    {
        Convolution1DExt = ((int)0x8010),
        Convolution2DExt = ((int)0x8011),
        Separable2DExt = ((int)0x8012),
        ConvolutionBorderModeExt = ((int)0x8013),
        ConvolutionFilterScaleExt = ((int)0x8014),
        ConvolutionFilterBiasExt = ((int)0x8015),
        ReduceExt = ((int)0x8016),
        ConvolutionFormatExt = ((int)0x8017),
        ConvolutionWidthExt = ((int)0x8018),
        ConvolutionHeightExt = ((int)0x8019),
        MaxConvolutionWidthExt = ((int)0x801A),
        MaxConvolutionHeightExt = ((int)0x801B),
        PostConvolutionRedScaleExt = ((int)0x801C),
        PostConvolutionGreenScaleExt = ((int)0x801D),
        PostConvolutionBlueScaleExt = ((int)0x801E),
        PostConvolutionAlphaScaleExt = ((int)0x801F),
        PostConvolutionRedBiasExt = ((int)0x8020),
        PostConvolutionGreenBiasExt = ((int)0x8021),
        PostConvolutionBlueBiasExt = ((int)0x8022),
        PostConvolutionAlphaBiasExt = ((int)0x8023),
    }

    public enum ExtCoordinateFrame : int
    {
        TangentArrayExt = ((int)0x8439),
        BinormalArrayExt = ((int)0x843A),
        CurrentTangentExt = ((int)0x843B),
        CurrentBinormalExt = ((int)0x843C),
        TangentArrayTypeExt = ((int)0x843E),
        TangentArrayStrideExt = ((int)0x843F),
        BinormalArrayTypeExt = ((int)0x8440),
        BinormalArrayStrideExt = ((int)0x8441),
        TangentArrayPointerExt = ((int)0x8442),
        BinormalArrayPointerExt = ((int)0x8443),
        Map1TangentExt = ((int)0x8444),
        Map2TangentExt = ((int)0x8445),
        Map1BinormalExt = ((int)0x8446),
        Map2BinormalExt = ((int)0x8447),
    }

    public enum ExtCopyTexture : int
    {
    }

    public enum ExtCullVertex : int
    {
        CullVertexExt = ((int)0x81AA),
        CullVertexEyePositionExt = ((int)0x81AB),
        CullVertexObjectPositionExt = ((int)0x81AC),
    }

    public enum ExtDepthBoundsTest : int
    {
        DepthBoundsTestExt = ((int)0x8890),
        DepthBoundsExt = ((int)0x8891),
    }

    public enum ExtDirectStateAccess : int
    {
        ProgramMatrixExt = ((int)0x8E2D),
        TransposeProgramMatrixExt = ((int)0x8E2E),
        ProgramMatrixStackDepthExt = ((int)0x8E2F),
    }

    public enum ExtDrawBuffers2 : int
    {
    }

    public enum ExtDrawInstanced : int
    {
    }

    public enum ExtDrawRangeElements : int
    {
        MaxElementsVerticesExt = ((int)0x80E8),
        MaxElementsIndicesExt = ((int)0x80E9),
    }

    public enum ExtFogCoord : int
    {
        FogCoordinateSourceExt = ((int)0x8450),
        FogCoordinateExt = ((int)0x8451),
        FragmentDepthExt = ((int)0x8452),
        CurrentFogCoordinateExt = ((int)0x8453),
        FogCoordinateArrayTypeExt = ((int)0x8454),
        FogCoordinateArrayStrideExt = ((int)0x8455),
        FogCoordinateArrayPointerExt = ((int)0x8456),
        FogCoordinateArrayExt = ((int)0x8457),
    }

    public enum ExtFramebufferBlit : int
    {
        DrawFramebufferBindingExt = ((int)0x8CA6),
        ReadFramebufferExt = ((int)0x8CA8),
        DrawFramebufferExt = ((int)0x8CA9),
        ReadFramebufferBindingExt = ((int)0x8CAA),
    }

    public enum ExtFramebufferMultisample : int
    {
        RenderbufferSamplesExt = ((int)0x8CAB),
        FramebufferIncompleteMultisampleExt = ((int)0x8D56),
        MaxSamplesExt = ((int)0x8D57),
    }

    public enum ExtFramebufferObject : int
    {
        InvalidFramebufferOperationExt = ((int)0x0506),
        MaxRenderbufferSizeExt = ((int)0x84E8),
        FramebufferBindingExt = ((int)0x8CA6),
        RenderbufferBindingExt = ((int)0x8CA7),
        FramebufferAttachmentObjectTypeExt = ((int)0x8CD0),
        FramebufferAttachmentObjectNameExt = ((int)0x8CD1),
        FramebufferAttachmentTextureLevelExt = ((int)0x8CD2),
        FramebufferAttachmentTextureCubeMapFaceExt = ((int)0x8CD3),
        FramebufferAttachmentTexture3DZoffsetExt = ((int)0x8CD4),
        FramebufferCompleteExt = ((int)0x8CD5),
        FramebufferIncompleteAttachmentExt = ((int)0x8CD6),
        FramebufferIncompleteMissingAttachmentExt = ((int)0x8CD7),
        FramebufferIncompleteDimensionsExt = ((int)0x8CD9),
        FramebufferIncompleteFormatsExt = ((int)0x8CDA),
        FramebufferIncompleteDrawBufferExt = ((int)0x8CDB),
        FramebufferIncompleteReadBufferExt = ((int)0x8CDC),
        FramebufferUnsupportedExt = ((int)0x8CDD),
        MaxColorAttachmentsExt = ((int)0x8CDF),
        ColorAttachment0Ext = ((int)0x8CE0),
        ColorAttachment1Ext = ((int)0x8CE1),
        ColorAttachment2Ext = ((int)0x8CE2),
        ColorAttachment3Ext = ((int)0x8CE3),
        ColorAttachment4Ext = ((int)0x8CE4),
        ColorAttachment5Ext = ((int)0x8CE5),
        ColorAttachment6Ext = ((int)0x8CE6),
        ColorAttachment7Ext = ((int)0x8CE7),
        ColorAttachment8Ext = ((int)0x8CE8),
        ColorAttachment9Ext = ((int)0x8CE9),
        ColorAttachment10Ext = ((int)0x8CEA),
        ColorAttachment11Ext = ((int)0x8CEB),
        ColorAttachment12Ext = ((int)0x8CEC),
        ColorAttachment13Ext = ((int)0x8CED),
        ColorAttachment14Ext = ((int)0x8CEE),
        ColorAttachment15Ext = ((int)0x8CEF),
        DepthAttachmentExt = ((int)0x8D00),
        StencilAttachmentExt = ((int)0x8D20),
        FramebufferExt = ((int)0x8D40),
        RenderbufferExt = ((int)0x8D41),
        RenderbufferWidthExt = ((int)0x8D42),
        RenderbufferHeightExt = ((int)0x8D43),
        RenderbufferInternalFormatExt = ((int)0x8D44),
        StencilIndex1Ext = ((int)0x8D46),
        StencilIndex4Ext = ((int)0x8D47),
        StencilIndex8Ext = ((int)0x8D48),
        StencilIndex16Ext = ((int)0x8D49),
        RenderbufferRedSizeExt = ((int)0x8D50),
        RenderbufferGreenSizeExt = ((int)0x8D51),
        RenderbufferBlueSizeExt = ((int)0x8D52),
        RenderbufferAlphaSizeExt = ((int)0x8D53),
        RenderbufferDepthSizeExt = ((int)0x8D54),
        RenderbufferStencilSizeExt = ((int)0x8D55),
    }

    public enum ExtFramebufferSrgb : int
    {
        FramebufferSrgbExt = ((int)0x8DB9),
        FramebufferSrgbCapableExt = ((int)0x8DBA),
    }

    public enum ExtGeometryShader4 : int
    {
        LinesAdjacencyExt = ((int)0x000A),
        LineStripAdjacencyExt = ((int)0x000B),
        TrianglesAdjacencyExt = ((int)0x000C),
        TriangleStripAdjacencyExt = ((int)0x000D),
        ProgramPointSizeExt = ((int)0x8642),
        MaxVaryingComponentsExt = ((int)0x8B4B),
        MaxGeometryTextureImageUnitsExt = ((int)0x8C29),
        FramebufferAttachmentTextureLayerExt = ((int)0x8CD4),
        FramebufferAttachmentLayeredExt = ((int)0x8DA7),
        FramebufferIncompleteLayerTargetsExt = ((int)0x8DA8),
        FramebufferIncompleteLayerCountExt = ((int)0x8DA9),
        GeometryShaderExt = ((int)0x8DD9),
        GeometryVerticesOutExt = ((int)0x8DDA),
        GeometryInputTypeExt = ((int)0x8DDB),
        GeometryOutputTypeExt = ((int)0x8DDC),
        MaxGeometryVaryingComponentsExt = ((int)0x8DDD),
        MaxVertexVaryingComponentsExt = ((int)0x8DDE),
        MaxGeometryUniformComponentsExt = ((int)0x8DDF),
        MaxGeometryOutputVerticesExt = ((int)0x8DE0),
        MaxGeometryTotalOutputComponentsExt = ((int)0x8DE1),
    }

    public enum ExtGpuProgramParameters : int
    {
    }

    public enum ExtGpuShader4 : int
    {
        Sampler1DArrayExt = ((int)0x8DC0),
        Sampler2DArrayExt = ((int)0x8DC1),
        SamplerBufferExt = ((int)0x8DC2),
        Sampler1DArrayShadowExt = ((int)0x8DC3),
        Sampler2DArrayShadowExt = ((int)0x8DC4),
        SamplerCubeShadowExt = ((int)0x8DC5),
        UnsignedIntVec2Ext = ((int)0x8DC6),
        UnsignedIntVec3Ext = ((int)0x8DC7),
        UnsignedIntVec4Ext = ((int)0x8DC8),
        IntSampler1DExt = ((int)0x8DC9),
        IntSampler2DExt = ((int)0x8DCA),
        IntSampler3DExt = ((int)0x8DCB),
        IntSamplerCubeExt = ((int)0x8DCC),
        IntSampler2DRectExt = ((int)0x8DCD),
        IntSampler1DArrayExt = ((int)0x8DCE),
        IntSampler2DArrayExt = ((int)0x8DCF),
        IntSamplerBufferExt = ((int)0x8DD0),
        UnsignedIntSampler1DExt = ((int)0x8DD1),
        UnsignedIntSampler2DExt = ((int)0x8DD2),
        UnsignedIntSampler3DExt = ((int)0x8DD3),
        UnsignedIntSamplerCubeExt = ((int)0x8DD4),
        UnsignedIntSampler2DRectExt = ((int)0x8DD5),
        UnsignedIntSampler1DArrayExt = ((int)0x8DD6),
        UnsignedIntSampler2DArrayExt = ((int)0x8DD7),
        UnsignedIntSamplerBufferExt = ((int)0x8DD8),
    }

    public enum ExtHistogram : int
    {
        HistogramExt = ((int)0x8024),
        ProxyHistogramExt = ((int)0x8025),
        HistogramWidthExt = ((int)0x8026),
        HistogramFormatExt = ((int)0x8027),
        HistogramRedSizeExt = ((int)0x8028),
        HistogramGreenSizeExt = ((int)0x8029),
        HistogramBlueSizeExt = ((int)0x802A),
        HistogramAlphaSizeExt = ((int)0x802B),
        HistogramLuminanceSize = ((int)0x802C),
        HistogramLuminanceSizeExt = ((int)0x802C),
        HistogramSinkExt = ((int)0x802D),
        MinmaxExt = ((int)0x802E),
        MinmaxFormatExt = ((int)0x802F),
        MinmaxSinkExt = ((int)0x8030),
        TableTooLargeExt = ((int)0x8031),
    }

    public enum ExtIndexArrayFormats : int
    {
        IuiV2fExt = ((int)0x81AD),
        IuiV3fExt = ((int)0x81AE),
        IuiN3fV2fExt = ((int)0x81AF),
        IuiN3fV3fExt = ((int)0x81B0),
        T2fIuiV2fExt = ((int)0x81B1),
        T2fIuiV3fExt = ((int)0x81B2),
        T2fIuiN3fV2fExt = ((int)0x81B3),
        T2fIuiN3fV3fExt = ((int)0x81B4),
    }

    public enum ExtIndexFunc : int
    {
        IndexTestExt = ((int)0x81B5),
        IndexTestFuncExt = ((int)0x81B6),
        IndexTestRefExt = ((int)0x81B7),
    }

    public enum ExtIndexMaterial : int
    {
        IndexMaterialExt = ((int)0x81B8),
        IndexMaterialParameterExt = ((int)0x81B9),
        IndexMaterialFaceExt = ((int)0x81BA),
    }

    public enum ExtIndexTexture : int
    {
    }

    public enum ExtLightTexture : int
    {
        FragmentMaterialExt = ((int)0x8349),
        FragmentNormalExt = ((int)0x834A),
        FragmentColorExt = ((int)0x834C),
        AttenuationExt = ((int)0x834D),
        ShadowAttenuationExt = ((int)0x834E),
        TextureApplicationModeExt = ((int)0x834F),
        TextureLightExt = ((int)0x8350),
        TextureMaterialFaceExt = ((int)0x8351),
        TextureMaterialParameterExt = ((int)0x8352),
        FragmentDepthExt = ((int)0x8452),
    }

    public enum ExtMiscAttribute : int
    {
    }

    public enum ExtMultiDrawArrays : int
    {
    }

    public enum ExtMultisample : int
    {
        MultisampleBitExt = ((int)0x20000000),
        MultisampleExt = ((int)0x809D),
        SampleAlphaToMaskExt = ((int)0x809E),
        SampleAlphaToOneExt = ((int)0x809F),
        SampleMaskExt = ((int)0x80A0),
        Gl1PassExt = ((int)0x80A1),
        Gl2Pass0Ext = ((int)0x80A2),
        Gl2Pass1Ext = ((int)0x80A3),
        Gl4Pass0Ext = ((int)0x80A4),
        Gl4Pass1Ext = ((int)0x80A5),
        Gl4Pass2Ext = ((int)0x80A6),
        Gl4Pass3Ext = ((int)0x80A7),
        SampleBuffersExt = ((int)0x80A8),
        SamplesExt = ((int)0x80A9),
        SampleMaskValueExt = ((int)0x80AA),
        SampleMaskInvertExt = ((int)0x80AB),
        SamplePatternExt = ((int)0x80AC),
    }

    public enum ExtPackedDepthStencil : int
    {
        DepthStencilExt = ((int)0x84F9),
        UnsignedInt248Ext = ((int)0x84FA),
        Depth24Stencil8Ext = ((int)0x88F0),
        TextureStencilSizeExt = ((int)0x88F1),
    }

    public enum ExtPackedFloat : int
    {
        R11fG11fB10fExt = ((int)0x8C3A),
        UnsignedInt10F11F11FRevExt = ((int)0x8C3B),
        RgbaSignedComponentsExt = ((int)0x8C3C),
    }

    public enum ExtPackedPixels : int
    {
        UnsignedByte332Ext = ((int)0x8032),
        UnsignedShort4444Ext = ((int)0x8033),
        UnsignedShort5551Ext = ((int)0x8034),
        UnsignedInt8888Ext = ((int)0x8035),
        UnsignedInt1010102Ext = ((int)0x8036),
        UnsignedByte233RevExt = ((int)0x8362),
        UnsignedShort565Ext = ((int)0x8363),
        UnsignedShort565RevExt = ((int)0x8364),
        UnsignedShort4444RevExt = ((int)0x8365),
        UnsignedShort1555RevExt = ((int)0x8366),
        UnsignedInt8888RevExt = ((int)0x8367),
        UnsignedInt2101010RevExt = ((int)0x8368),
    }

    public enum ExtPalettedTexture : int
    {
        ColorIndex1Ext = ((int)0x80E2),
        ColorIndex2Ext = ((int)0x80E3),
        ColorIndex4Ext = ((int)0x80E4),
        ColorIndex8Ext = ((int)0x80E5),
        ColorIndex12Ext = ((int)0x80E6),
        ColorIndex16Ext = ((int)0x80E7),
        TextureIndexSizeExt = ((int)0x80ED),
    }

    public enum ExtPixelBufferObject : int
    {
        PixelPackBufferExt = ((int)0x88EB),
        PixelUnpackBufferExt = ((int)0x88EC),
        PixelPackBufferBindingExt = ((int)0x88ED),
        PixelUnpackBufferBindingExt = ((int)0x88EF),
    }

    public enum ExtPixelTransform : int
    {
        PixelTransform2DExt = ((int)0x8330),
        PixelMagFilterExt = ((int)0x8331),
        PixelMinFilterExt = ((int)0x8332),
        PixelCubicWeightExt = ((int)0x8333),
        CubicExt = ((int)0x8334),
        AverageExt = ((int)0x8335),
        PixelTransform2DStackDepthExt = ((int)0x8336),
        MaxPixelTransform2DStackDepthExt = ((int)0x8337),
        PixelTransform2DMatrixExt = ((int)0x8338),
    }

    public enum ExtPixelTransformColorTable : int
    {
    }

    public enum ExtPointParameters : int
    {
        PointSizeMinExt = ((int)0x8126),
        PointSizeMaxExt = ((int)0x8127),
        PointFadeThresholdSizeExt = ((int)0x8128),
        DistanceAttenuationExt = ((int)0x8129),
    }

    public enum ExtPolygonOffset : int
    {
        PolygonOffsetExt = ((int)0x8037),
        PolygonOffsetFactorExt = ((int)0x8038),
        PolygonOffsetBiasExt = ((int)0x8039),
    }

    public enum ExtProvokingVertex : int
    {
        QuadsFollowProvokingVertexConventionExt = ((int)0x8E4C),
        FirstVertexConventionExt = ((int)0x8E4D),
        LastVertexConventionExt = ((int)0x8E4E),
        ProvokingVertexExt = ((int)0x8E4F),
    }

    public enum ExtRescaleNormal : int
    {
        RescaleNormalExt = ((int)0x803A),
    }

    public enum ExtSecondaryColor : int
    {
        ColorSumExt = ((int)0x8458),
        CurrentSecondaryColorExt = ((int)0x8459),
        SecondaryColorArraySizeExt = ((int)0x845A),
        SecondaryColorArrayTypeExt = ((int)0x845B),
        SecondaryColorArrayStrideExt = ((int)0x845C),
        SecondaryColorArrayPointerExt = ((int)0x845D),
        SecondaryColorArrayExt = ((int)0x845E),
    }

    public enum ExtSeparateSpecularColor : int
    {
        LightModelColorControlExt = ((int)0x81F8),
        SingleColorExt = ((int)0x81F9),
        SeparateSpecularColorExt = ((int)0x81FA),
    }

    public enum ExtShadowFuncs : int
    {
    }

    public enum ExtSharedTexturePalette : int
    {
        SharedTexturePaletteExt = ((int)0x81FB),
    }

    public enum ExtStencilClearTag : int
    {
        StencilTagBitsExt = ((int)0x88F2),
        StencilClearTagValueExt = ((int)0x88F3),
    }

    public enum ExtStencilTwoSide : int
    {
        StencilTestTwoSideExt = ((int)0x8910),
        ActiveStencilFaceExt = ((int)0x8911),
    }

    public enum ExtStencilWrap : int
    {
        IncrWrapExt = ((int)0x8507),
        DecrWrapExt = ((int)0x8508),
    }

    public enum ExtSubtexture : int
    {
    }

    public enum ExtTexture : int
    {
        Alpha4Ext = ((int)0x803B),
        Alpha8Ext = ((int)0x803C),
        Alpha12Ext = ((int)0x803D),
        Alpha16Ext = ((int)0x803E),
        Luminance4Ext = ((int)0x803F),
        Luminance8Ext = ((int)0x8040),
        Luminance12Ext = ((int)0x8041),
        Luminance16Ext = ((int)0x8042),
        Luminance4Alpha4Ext = ((int)0x8043),
        Luminance6Alpha2Ext = ((int)0x8044),
        Luminance8Alpha8Ext = ((int)0x8045),
        Luminance12Alpha4Ext = ((int)0x8046),
        Luminance12Alpha12Ext = ((int)0x8047),
        Luminance16Alpha16Ext = ((int)0x8048),
        IntensityExt = ((int)0x8049),
        Intensity4Ext = ((int)0x804A),
        Intensity8Ext = ((int)0x804B),
        Intensity12Ext = ((int)0x804C),
        Intensity16Ext = ((int)0x804D),
        Rgb2Ext = ((int)0x804E),
        Rgb4Ext = ((int)0x804F),
        Rgb5Ext = ((int)0x8050),
        Rgb8Ext = ((int)0x8051),
        Rgb10Ext = ((int)0x8052),
        Rgb12Ext = ((int)0x8053),
        Rgb16Ext = ((int)0x8054),
        Rgba2Ext = ((int)0x8055),
        Rgba4Ext = ((int)0x8056),
        Rgb5A1Ext = ((int)0x8057),
        Rgba8Ext = ((int)0x8058),
        Rgb10A2Ext = ((int)0x8059),
        Rgba12Ext = ((int)0x805A),
        Rgba16Ext = ((int)0x805B),
        TextureRedSizeExt = ((int)0x805C),
        TextureGreenSizeExt = ((int)0x805D),
        TextureBlueSizeExt = ((int)0x805E),
        TextureAlphaSizeExt = ((int)0x805F),
        TextureLuminanceSizeExt = ((int)0x8060),
        TextureIntensitySizeExt = ((int)0x8061),
        ReplaceExt = ((int)0x8062),
        ProxyTexture1DExt = ((int)0x8063),
        ProxyTexture2DExt = ((int)0x8064),
        TextureTooLargeExt = ((int)0x8065),
    }

    public enum ExtTexture3D : int
    {
        PackSkipImagesExt = ((int)0x806B),
        PackImageHeightExt = ((int)0x806C),
        UnpackSkipImagesExt = ((int)0x806D),
        UnpackImageHeightExt = ((int)0x806E),
        Texture3DExt = ((int)0x806F),
        ProxyTexture3DExt = ((int)0x8070),
        TextureDepthExt = ((int)0x8071),
        TextureWrapRExt = ((int)0x8072),
        Max3DTextureSizeExt = ((int)0x8073),
    }

    public enum ExtTextureArray : int
    {
        CompareRefDepthToTextureExt = ((int)0x884E),
        MaxArrayTextureLayersExt = ((int)0x88FF),
        Texture1DArrayExt = ((int)0x8C18),
        ProxyTexture1DArrayExt = ((int)0x8C19),
        Texture2DArrayExt = ((int)0x8C1A),
        ProxyTexture2DArrayExt = ((int)0x8C1B),
        TextureBinding1DArrayExt = ((int)0x8C1C),
        TextureBinding2DArrayExt = ((int)0x8C1D),
        FramebufferAttachmentTextureLayerExt = ((int)0x8CD4),
    }

    public enum ExtTextureBufferObject : int
    {
        TextureBufferExt = ((int)0x8C2A),
        MaxTextureBufferSizeExt = ((int)0x8C2B),
        TextureBindingBufferExt = ((int)0x8C2C),
        TextureBufferDataStoreBindingExt = ((int)0x8C2D),
        TextureBufferFormatExt = ((int)0x8C2E),
    }

    public enum ExtTextureCompressionLatc : int
    {
        CompressedLuminanceLatc1Ext = ((int)0x8C70),
        CompressedSignedLuminanceLatc1Ext = ((int)0x8C71),
        CompressedLuminanceAlphaLatc2Ext = ((int)0x8C72),
        CompressedSignedLuminanceAlphaLatc2Ext = ((int)0x8C73),
    }

    public enum ExtTextureCompressionRgtc : int
    {
        CompressedRedRgtc1Ext = ((int)0x8DBB),
        CompressedSignedRedRgtc1Ext = ((int)0x8DBC),
        CompressedRedGreenRgtc2Ext = ((int)0x8DBD),
        CompressedSignedRedGreenRgtc2Ext = ((int)0x8DBE),
    }

    public enum ExtTextureCompressionS3tc : int
    {
        CompressedRgbS3tcDxt1Ext = ((int)0x83F0),
        CompressedRgbaS3tcDxt1Ext = ((int)0x83F1),
        CompressedRgbaS3tcDxt3Ext = ((int)0x83F2),
        CompressedRgbaS3tcDxt5Ext = ((int)0x83F3),
    }

    public enum ExtTextureCubeMap : int
    {
        NormalMapExt = ((int)0x8511),
        ReflectionMapExt = ((int)0x8512),
        TextureCubeMapExt = ((int)0x8513),
        TextureBindingCubeMapExt = ((int)0x8514),
        TextureCubeMapPositiveXExt = ((int)0x8515),
        TextureCubeMapNegativeXExt = ((int)0x8516),
        TextureCubeMapPositiveYExt = ((int)0x8517),
        TextureCubeMapNegativeYExt = ((int)0x8518),
        TextureCubeMapPositiveZExt = ((int)0x8519),
        TextureCubeMapNegativeZExt = ((int)0x851A),
        ProxyTextureCubeMapExt = ((int)0x851B),
        MaxCubeMapTextureSizeExt = ((int)0x851C),
    }

    public enum ExtTextureEnvAdd : int
    {
    }

    public enum ExtTextureEnvCombine : int
    {
        CombineExt = ((int)0x8570),
        CombineRgbExt = ((int)0x8571),
        CombineAlphaExt = ((int)0x8572),
        RgbScaleExt = ((int)0x8573),
        AddSignedExt = ((int)0x8574),
        InterpolateExt = ((int)0x8575),
        ConstantExt = ((int)0x8576),
        PrimaryColorExt = ((int)0x8577),
        PreviousExt = ((int)0x8578),
        Source0RgbExt = ((int)0x8580),
        Source1RgbExt = ((int)0x8581),
        Source2RgbExt = ((int)0x8582),
        Source0AlphaExt = ((int)0x8588),
        Source1AlphaExt = ((int)0x8589),
        Source2AlphaExt = ((int)0x858A),
        Operand0RgbExt = ((int)0x8590),
        Operand1RgbExt = ((int)0x8591),
        Operand2RgbExt = ((int)0x8592),
        Operand0AlphaExt = ((int)0x8598),
        Operand1AlphaExt = ((int)0x8599),
        Operand2AlphaExt = ((int)0x859A),
    }

    public enum ExtTextureEnvDot3 : int
    {
        Dot3RgbExt = ((int)0x8740),
        Dot3RgbaExt = ((int)0x8741),
    }

    public enum ExtTextureFilterAnisotropic : int
    {
        TextureMaxAnisotropyExt = ((int)0x84FE),
        MaxTextureMaxAnisotropyExt = ((int)0x84FF),
    }

    public enum ExtTextureInteger : int
    {
        Rgba32uiExt = ((int)0x8D70),
        Rgb32uiExt = ((int)0x8D71),
        Alpha32uiExt = ((int)0x8D72),
        Intensity32uiExt = ((int)0x8D73),
        Luminance32uiExt = ((int)0x8D74),
        LuminanceAlpha32uiExt = ((int)0x8D75),
        Rgba16uiExt = ((int)0x8D76),
        Rgb16uiExt = ((int)0x8D77),
        Alpha16uiExt = ((int)0x8D78),
        Intensity16uiExt = ((int)0x8D79),
        Luminance16uiExt = ((int)0x8D7A),
        LuminanceAlpha16uiExt = ((int)0x8D7B),
        Rgba8uiExt = ((int)0x8D7C),
        Rgb8uiExt = ((int)0x8D7D),
        Alpha8uiExt = ((int)0x8D7E),
        Intensity8uiExt = ((int)0x8D7F),
        Luminance8uiExt = ((int)0x8D80),
        LuminanceAlpha8uiExt = ((int)0x8D81),
        Rgba32iExt = ((int)0x8D82),
        Rgb32iExt = ((int)0x8D83),
        Alpha32iExt = ((int)0x8D84),
        Intensity32iExt = ((int)0x8D85),
        Luminance32iExt = ((int)0x8D86),
        LuminanceAlpha32iExt = ((int)0x8D87),
        Rgba16iExt = ((int)0x8D88),
        Rgb16iExt = ((int)0x8D89),
        Alpha16iExt = ((int)0x8D8A),
        Intensity16iExt = ((int)0x8D8B),
        Luminance16iExt = ((int)0x8D8C),
        LuminanceAlpha16iExt = ((int)0x8D8D),
        Rgba8iExt = ((int)0x8D8E),
        Rgb8iExt = ((int)0x8D8F),
        Alpha8iExt = ((int)0x8D90),
        Intensity8iExt = ((int)0x8D91),
        Luminance8iExt = ((int)0x8D92),
        LuminanceAlpha8iExt = ((int)0x8D93),
        RedIntegerExt = ((int)0x8D94),
        GreenIntegerExt = ((int)0x8D95),
        BlueIntegerExt = ((int)0x8D96),
        AlphaIntegerExt = ((int)0x8D97),
        RgbIntegerExt = ((int)0x8D98),
        RgbaIntegerExt = ((int)0x8D99),
        BgrIntegerExt = ((int)0x8D9A),
        BgraIntegerExt = ((int)0x8D9B),
        LuminanceIntegerExt = ((int)0x8D9C),
        LuminanceAlphaIntegerExt = ((int)0x8D9D),
        RgbaIntegerModeExt = ((int)0x8D9E),
    }

    public enum ExtTextureLodBias : int
    {
        MaxTextureLodBiasExt = ((int)0x84FD),
        TextureFilterControlExt = ((int)0x8500),
        TextureLodBiasExt = ((int)0x8501),
    }

    public enum ExtTextureMirrorClamp : int
    {
        MirrorClampExt = ((int)0x8742),
        MirrorClampToEdgeExt = ((int)0x8743),
        MirrorClampToBorderExt = ((int)0x8912),
    }

    public enum ExtTextureObject : int
    {
        TexturePriorityExt = ((int)0x8066),
        TextureResidentExt = ((int)0x8067),
        Texture1DBindingExt = ((int)0x8068),
        Texture2DBindingExt = ((int)0x8069),
        Texture3DBindingExt = ((int)0x806A),
    }

    public enum ExtTexturePerturbNormal : int
    {
        PerturbExt = ((int)0x85AE),
        TextureNormalExt = ((int)0x85AF),
    }

    public enum ExtTextureSharedExponent : int
    {
        Rgb9E5Ext = ((int)0x8C3D),
        UnsignedInt5999RevExt = ((int)0x8C3E),
        TextureSharedSizeExt = ((int)0x8C3F),
    }

    public enum ExtTextureSnorm : int
    {
        RgSnorm = ((int)0x8F91),
        RgbSnorm = ((int)0x8F92),
        RgbaSnorm = ((int)0x8F93),
        R8Snorm = ((int)0x8F94),
        Rg8Snorm = ((int)0x8F95),
        Rgb8Snorm = ((int)0x8F96),
        Rgba8Snorm = ((int)0x8F97),
        R16Snorm = ((int)0x8F98),
        Rg16Snorm = ((int)0x8F99),
        Rgb16Snorm = ((int)0x8F9A),
        Rgba16Snorm = ((int)0x8F9B),
        SignedNormalized = ((int)0x8F9C),
        AlphaSnorm = ((int)0x9010),
        LuminanceSnorm = ((int)0x9011),
        LuminanceAlphaSnorm = ((int)0x9012),
        IntensitySnorm = ((int)0x9013),
        Alpha8Snorm = ((int)0x9014),
        Luminance8Snorm = ((int)0x9015),
        Luminance8Alpha8Snorm = ((int)0x9016),
        Intensity8Snorm = ((int)0x9017),
        Alpha16Snorm = ((int)0x9018),
        Luminance16Snorm = ((int)0x9019),
        Luminance16Alpha16Snorm = ((int)0x901A),
        Intensity16Snorm = ((int)0x901B),
    }

    public enum ExtTextureSrgb : int
    {
        SrgbExt = ((int)0x8C40),
        Srgb8Ext = ((int)0x8C41),
        SrgbAlphaExt = ((int)0x8C42),
        Srgb8Alpha8Ext = ((int)0x8C43),
        SluminanceAlphaExt = ((int)0x8C44),
        Sluminance8Alpha8Ext = ((int)0x8C45),
        SluminanceExt = ((int)0x8C46),
        Sluminance8Ext = ((int)0x8C47),
        CompressedSrgbExt = ((int)0x8C48),
        CompressedSrgbAlphaExt = ((int)0x8C49),
        CompressedSluminanceExt = ((int)0x8C4A),
        CompressedSluminanceAlphaExt = ((int)0x8C4B),
        CompressedSrgbS3tcDxt1Ext = ((int)0x8C4C),
        CompressedSrgbAlphaS3tcDxt1Ext = ((int)0x8C4D),
        CompressedSrgbAlphaS3tcDxt3Ext = ((int)0x8C4E),
        CompressedSrgbAlphaS3tcDxt5Ext = ((int)0x8C4F),
    }

    public enum ExtTextureSwizzle : int
    {
        TextureSwizzleRExt = ((int)0x8E42),
        TextureSwizzleGExt = ((int)0x8E43),
        TextureSwizzleBExt = ((int)0x8E44),
        TextureSwizzleAExt = ((int)0x8E45),
        TextureSwizzleRgbaExt = ((int)0x8E46),
    }

    public enum ExtTimerQuery : int
    {
        TimeElapsedExt = ((int)0x88BF),
    }

    public enum ExtTransformFeedback : int
    {
        TransformFeedbackVaryingMaxLengthExt = ((int)0x8C76),
        TransformFeedbackBufferModeExt = ((int)0x8C7F),
        MaxTransformFeedbackSeparateComponentsExt = ((int)0x8C80),
        TransformFeedbackVaryingsExt = ((int)0x8C83),
        TransformFeedbackBufferStartExt = ((int)0x8C84),
        TransformFeedbackBufferSizeExt = ((int)0x8C85),
        PrimitivesGeneratedExt = ((int)0x8C87),
        TransformFeedbackPrimitivesWrittenExt = ((int)0x8C88),
        RasterizerDiscardExt = ((int)0x8C89),
        MaxTransformFeedbackInterleavedComponentsExt = ((int)0x8C8A),
        MaxTransformFeedbackSeparateAttribsExt = ((int)0x8C8B),
        InterleavedAttribsExt = ((int)0x8C8C),
        SeparateAttribsExt = ((int)0x8C8D),
        TransformFeedbackBufferExt = ((int)0x8C8E),
        TransformFeedbackBufferBindingExt = ((int)0x8C8F),
    }

    public enum ExtVertexArray : int
    {
        VertexArrayExt = ((int)0x8074),
        NormalArrayExt = ((int)0x8075),
        ColorArrayExt = ((int)0x8076),
        IndexArrayExt = ((int)0x8077),
        TextureCoordArrayExt = ((int)0x8078),
        EdgeFlagArrayExt = ((int)0x8079),
        VertexArraySizeExt = ((int)0x807A),
        VertexArrayTypeExt = ((int)0x807B),
        VertexArrayStrideExt = ((int)0x807C),
        VertexArrayCountExt = ((int)0x807D),
        NormalArrayTypeExt = ((int)0x807E),
        NormalArrayStrideExt = ((int)0x807F),
        NormalArrayCountExt = ((int)0x8080),
        ColorArraySizeExt = ((int)0x8081),
        ColorArrayTypeExt = ((int)0x8082),
        ColorArrayStrideExt = ((int)0x8083),
        ColorArrayCountExt = ((int)0x8084),
        IndexArrayTypeExt = ((int)0x8085),
        IndexArrayStrideExt = ((int)0x8086),
        IndexArrayCountExt = ((int)0x8087),
        TextureCoordArraySizeExt = ((int)0x8088),
        TextureCoordArrayTypeExt = ((int)0x8089),
        TextureCoordArrayStrideExt = ((int)0x808A),
        TextureCoordArrayCountExt = ((int)0x808B),
        EdgeFlagArrayStrideExt = ((int)0x808C),
        EdgeFlagArrayCountExt = ((int)0x808D),
        VertexArrayPointerExt = ((int)0x808E),
        NormalArrayPointerExt = ((int)0x808F),
        ColorArrayPointerExt = ((int)0x8090),
        IndexArrayPointerExt = ((int)0x8091),
        TextureCoordArrayPointerExt = ((int)0x8092),
        EdgeFlagArrayPointerExt = ((int)0x8093),
    }

    public enum ExtVertexArrayBgra : int
    {
        Bgra = ((int)0x80E1),
    }

    public enum ExtVertexShader : int
    {
        VertexShaderExt = ((int)0x8780),
        VertexShaderBindingExt = ((int)0x8781),
        OpIndexExt = ((int)0x8782),
        OpNegateExt = ((int)0x8783),
        OpDot3Ext = ((int)0x8784),
        OpDot4Ext = ((int)0x8785),
        OpMulExt = ((int)0x8786),
        OpAddExt = ((int)0x8787),
        OpMaddExt = ((int)0x8788),
        OpFracExt = ((int)0x8789),
        OpMaxExt = ((int)0x878A),
        OpMinExt = ((int)0x878B),
        OpSetGeExt = ((int)0x878C),
        OpSetLtExt = ((int)0x878D),
        OpClampExt = ((int)0x878E),
        OpFloorExt = ((int)0x878F),
        OpRoundExt = ((int)0x8790),
        OpExpBase2Ext = ((int)0x8791),
        OpLogBase2Ext = ((int)0x8792),
        OpPowerExt = ((int)0x8793),
        OpRecipExt = ((int)0x8794),
        OpRecipSqrtExt = ((int)0x8795),
        OpSubExt = ((int)0x8796),
        OpCrossProductExt = ((int)0x8797),
        OpMultiplyMatrixExt = ((int)0x8798),
        OpMovExt = ((int)0x8799),
        OutputVertexExt = ((int)0x879A),
        OutputColor0Ext = ((int)0x879B),
        OutputColor1Ext = ((int)0x879C),
        OutputTextureCoord0Ext = ((int)0x879D),
        OutputTextureCoord1Ext = ((int)0x879E),
        OutputTextureCoord2Ext = ((int)0x879F),
        OutputTextureCoord3Ext = ((int)0x87A0),
        OutputTextureCoord4Ext = ((int)0x87A1),
        OutputTextureCoord5Ext = ((int)0x87A2),
        OutputTextureCoord6Ext = ((int)0x87A3),
        OutputTextureCoord7Ext = ((int)0x87A4),
        OutputTextureCoord8Ext = ((int)0x87A5),
        OutputTextureCoord9Ext = ((int)0x87A6),
        OutputTextureCoord10Ext = ((int)0x87A7),
        OutputTextureCoord11Ext = ((int)0x87A8),
        OutputTextureCoord12Ext = ((int)0x87A9),
        OutputTextureCoord13Ext = ((int)0x87AA),
        OutputTextureCoord14Ext = ((int)0x87AB),
        OutputTextureCoord15Ext = ((int)0x87AC),
        OutputTextureCoord16Ext = ((int)0x87AD),
        OutputTextureCoord17Ext = ((int)0x87AE),
        OutputTextureCoord18Ext = ((int)0x87AF),
        OutputTextureCoord19Ext = ((int)0x87B0),
        OutputTextureCoord20Ext = ((int)0x87B1),
        OutputTextureCoord21Ext = ((int)0x87B2),
        OutputTextureCoord22Ext = ((int)0x87B3),
        OutputTextureCoord23Ext = ((int)0x87B4),
        OutputTextureCoord24Ext = ((int)0x87B5),
        OutputTextureCoord25Ext = ((int)0x87B6),
        OutputTextureCoord26Ext = ((int)0x87B7),
        OutputTextureCoord27Ext = ((int)0x87B8),
        OutputTextureCoord28Ext = ((int)0x87B9),
        OutputTextureCoord29Ext = ((int)0x87BA),
        OutputTextureCoord30Ext = ((int)0x87BB),
        OutputTextureCoord31Ext = ((int)0x87BC),
        OutputFogExt = ((int)0x87BD),
        ScalarExt = ((int)0x87BE),
        VectorExt = ((int)0x87BF),
        MatrixExt = ((int)0x87C0),
        VariantExt = ((int)0x87C1),
        InvariantExt = ((int)0x87C2),
        LocalConstantExt = ((int)0x87C3),
        LocalExt = ((int)0x87C4),
        MaxVertexShaderInstructionsExt = ((int)0x87C5),
        MaxVertexShaderVariantsExt = ((int)0x87C6),
        MaxVertexShaderInvariantsExt = ((int)0x87C7),
        MaxVertexShaderLocalConstantsExt = ((int)0x87C8),
        MaxVertexShaderLocalsExt = ((int)0x87C9),
        MaxOptimizedVertexShaderInstructionsExt = ((int)0x87CA),
        MaxOptimizedVertexShaderVariantsExt = ((int)0x87CB),
        MaxOptimizedVertexShaderLocalConstantsExt = ((int)0x87CC),
        MaxOptimizedVertexShaderInvariantsExt = ((int)0x87CD),
        MaxOptimizedVertexShaderLocalsExt = ((int)0x87CE),
        VertexShaderInstructionsExt = ((int)0x87CF),
        VertexShaderVariantsExt = ((int)0x87D0),
        VertexShaderInvariantsExt = ((int)0x87D1),
        VertexShaderLocalConstantsExt = ((int)0x87D2),
        VertexShaderLocalsExt = ((int)0x87D3),
        VertexShaderOptimizedExt = ((int)0x87D4),
        XExt = ((int)0x87D5),
        YExt = ((int)0x87D6),
        ZExt = ((int)0x87D7),
        WExt = ((int)0x87D8),
        NegativeXExt = ((int)0x87D9),
        NegativeYExt = ((int)0x87DA),
        NegativeZExt = ((int)0x87DB),
        NegativeWExt = ((int)0x87DC),
        ZeroExt = ((int)0x87DD),
        OneExt = ((int)0x87DE),
        NegativeOneExt = ((int)0x87DF),
        NormalizedRangeExt = ((int)0x87E0),
        FullRangeExt = ((int)0x87E1),
        CurrentVertexExt = ((int)0x87E2),
        MvpMatrixExt = ((int)0x87E3),
        VariantValueExt = ((int)0x87E4),
        VariantDatatypeExt = ((int)0x87E5),
        VariantArrayStrideExt = ((int)0x87E6),
        VariantArrayTypeExt = ((int)0x87E7),
        VariantArrayExt = ((int)0x87E8),
        VariantArrayPointerExt = ((int)0x87E9),
        InvariantValueExt = ((int)0x87EA),
        InvariantDatatypeExt = ((int)0x87EB),
        LocalConstantValueExt = ((int)0x87EC),
        LocalConstantDatatypeExt = ((int)0x87ED),
    }

    public enum ExtVertexWeighting : int
    {
        Modelview0StackDepthExt = ((int)0x0BA3),
        Modelview0MatrixExt = ((int)0x0BA6),
        Modelview0Ext = ((int)0x1700),
        Modelview1StackDepthExt = ((int)0x8502),
        Modelview1MatrixExt = ((int)0x8506),
        VertexWeightingExt = ((int)0x8509),
        Modelview1Ext = ((int)0x850A),
        CurrentVertexWeightExt = ((int)0x850B),
        VertexWeightArrayExt = ((int)0x850C),
        VertexWeightArraySizeExt = ((int)0x850D),
        VertexWeightArrayTypeExt = ((int)0x850E),
        VertexWeightArrayStrideExt = ((int)0x850F),
        VertexWeightArrayPointerExt = ((int)0x8510),
    }

    public enum FeedBackToken : int
    {
        PassThroughToken = ((int)0x0700),
        PointToken = ((int)0x0701),
        LineToken = ((int)0x0702),
        PolygonToken = ((int)0x0703),
        BitmapToken = ((int)0x0704),
        DrawPixelToken = ((int)0x0705),
        CopyPixelToken = ((int)0x0706),
        LineResetToken = ((int)0x0707),
    }

    public enum FeedbackType : int
    {
        Gl2D = ((int)0x0600),
        Gl3D = ((int)0x0601),
        Gl3DColor = ((int)0x0602),
        Gl3DColorTexture = ((int)0x0603),
        Gl4DColorTexture = ((int)0x0604),
    }

    [Flags]
    public enum FfdMaskSgix : int
    {
        TextureDeformationBitSgix = ((int)0x00000001),
        GeometryDeformationBitSgix = ((int)0x00000002),
    }

    public enum FfdTargetSgix : int
    {
        GeometryDeformationSgix = ((int)0x8194),
        TextureDeformationSgix = ((int)0x8195),
    }

    public enum FogMode : int
    {
        Exp = ((int)0x0800),
        Exp2 = ((int)0x0801),
        Linear = ((int)0x2601),
        FogFuncSgis = ((int)0x812A),
        FogCoord = ((int)0x8451),
        FragmentDepth = ((int)0x8452),
    }

    public enum FogParameter : int
    {
        FogIndex = ((int)0x0B61),
        FogDensity = ((int)0x0B62),
        FogStart = ((int)0x0B63),
        FogEnd = ((int)0x0B64),
        FogMode = ((int)0x0B65),
        FogColor = ((int)0x0B66),
        FogOffsetValueSgix = ((int)0x8199),
        FogCoordSrc = ((int)0x8450),
    }

    public enum FogPointerType : int
    {
        Float = ((int)0x1406),
        Double = ((int)0x140A),
        HalfFloat = ((int)0x140B),
    }

    public enum FragmentLightModelParameterSgix : int
    {
        FragmentLightModelLocalViewerSgix = ((int)0x8408),
        FragmentLightModelTwoSideSgix = ((int)0x8409),
        FragmentLightModelAmbientSgix = ((int)0x840A),
        FragmentLightModelNormalInterpolationSgix = ((int)0x840B),
    }

    public enum FramebufferAttachment : int
    {
        DepthStencilAttachment = ((int)0x821A),
        ColorAttachment0 = ((int)0x8CE0),
        ColorAttachment0Ext = ((int)0x8CE0),
        ColorAttachment1 = ((int)0x8CE1),
        ColorAttachment1Ext = ((int)0x8CE1),
        ColorAttachment2 = ((int)0x8CE2),
        ColorAttachment2Ext = ((int)0x8CE2),
        ColorAttachment3 = ((int)0x8CE3),
        ColorAttachment3Ext = ((int)0x8CE3),
        ColorAttachment4 = ((int)0x8CE4),
        ColorAttachment4Ext = ((int)0x8CE4),
        ColorAttachment5 = ((int)0x8CE5),
        ColorAttachment5Ext = ((int)0x8CE5),
        ColorAttachment6 = ((int)0x8CE6),
        ColorAttachment6Ext = ((int)0x8CE6),
        ColorAttachment7 = ((int)0x8CE7),
        ColorAttachment7Ext = ((int)0x8CE7),
        ColorAttachment8 = ((int)0x8CE8),
        ColorAttachment8Ext = ((int)0x8CE8),
        ColorAttachment9 = ((int)0x8CE9),
        ColorAttachment9Ext = ((int)0x8CE9),
        ColorAttachment10 = ((int)0x8CEA),
        ColorAttachment10Ext = ((int)0x8CEA),
        ColorAttachment11 = ((int)0x8CEB),
        ColorAttachment11Ext = ((int)0x8CEB),
        ColorAttachment12 = ((int)0x8CEC),
        ColorAttachment12Ext = ((int)0x8CEC),
        ColorAttachment13 = ((int)0x8CED),
        ColorAttachment13Ext = ((int)0x8CED),
        ColorAttachment14 = ((int)0x8CEE),
        ColorAttachment14Ext = ((int)0x8CEE),
        ColorAttachment15 = ((int)0x8CEF),
        ColorAttachment15Ext = ((int)0x8CEF),
        DepthAttachment = ((int)0x8D00),
        DepthAttachmentExt = ((int)0x8D00),
        StencilAttachment = ((int)0x8D20),
        StencilAttachmentExt = ((int)0x8D20),
    }

    public enum FramebufferAttachmentComponentType : int
    {
        Int = ((int)0x1404),
        Float = ((int)0x1406),
        UnsignedNormalized = ((int)0x8C17),
    }

    public enum FramebufferAttachmentObjectType : int
    {
        None = ((int)0),
        Texture = ((int)0x1702),
        FramebufferDefault = ((int)0x8218),
        Renderbuffer = ((int)0x8D41),
    }

    public enum FramebufferErrorCode : int
    {
        FramebufferUndefined = ((int)0x8219),
        FramebufferComplete = ((int)0x8CD5),
        FramebufferCompleteExt = ((int)0x8CD5),
        FramebufferIncompleteAttachment = ((int)0x8CD6),
        FramebufferIncompleteAttachmentExt = ((int)0x8CD6),
        FramebufferIncompleteMissingAttachment = ((int)0x8CD7),
        FramebufferIncompleteMissingAttachmentExt = ((int)0x8CD7),
        FramebufferIncompleteDimensionsExt = ((int)0x8CD9),
        FramebufferIncompleteFormatsExt = ((int)0x8CDA),
        FramebufferIncompleteDrawBuffer = ((int)0x8CDB),
        FramebufferIncompleteDrawBufferExt = ((int)0x8CDB),
        FramebufferIncompleteReadBuffer = ((int)0x8CDC),
        FramebufferIncompleteReadBufferExt = ((int)0x8CDC),
        FramebufferUnsupported = ((int)0x8CDD),
        FramebufferUnsupportedExt = ((int)0x8CDD),
        FramebufferIncompleteMultisample = ((int)0x8D56),
        FramebufferIncompleteLayerTargets = ((int)0x8DA8),
        FramebufferIncompleteLayerCount = ((int)0x8DA9),
    }

    public enum FramebufferParameterName : int
    {
        FramebufferAttachmentColorEncoding = ((int)0x8210),
        FramebufferAttachmentComponentType = ((int)0x8211),
        FramebufferAttachmentRedSize = ((int)0x8212),
        FramebufferAttachmentGreenSize = ((int)0x8213),
        FramebufferAttachmentBlueSize = ((int)0x8214),
        FramebufferAttachmentAlphaSize = ((int)0x8215),
        FramebufferAttachmentDepthSize = ((int)0x8216),
        FramebufferAttachmentStencilSize = ((int)0x8217),
        FramebufferAttachmentObjectType = ((int)0x8CD0),
        FramebufferAttachmentObjectTypeExt = ((int)0x8CD0),
        FramebufferAttachmentObjectName = ((int)0x8CD1),
        FramebufferAttachmentObjectNameExt = ((int)0x8CD1),
        FramebufferAttachmentTextureLevel = ((int)0x8CD2),
        FramebufferAttachmentTextureLevelExt = ((int)0x8CD2),
        FramebufferAttachmentTextureCubeMapFace = ((int)0x8CD3),
        FramebufferAttachmentTextureCubeMapFaceExt = ((int)0x8CD3),
        FramebufferAttachmentTexture3DZoffsetExt = ((int)0x8CD4),
        FramebufferAttachmentTextureLayer = ((int)0x8CD4),
        FramebufferAttachmentLayered = ((int)0x8DA7),
    }

    public enum FramebufferTarget : int
    {
        ReadFramebuffer = ((int)0x8CA8),
        DrawFramebuffer = ((int)0x8CA9),
        Framebuffer = ((int)0x8D40),
        FramebufferExt = ((int)0x8D40),
    }

    public enum FrontFaceDirection : int
    {
        Cw = ((int)0x0900),
        Ccw = ((int)0x0901),
    }

    public enum GenerateMipmapTarget : int
    {
        Texture1D = ((int)0x0DE0),
        Texture2D = ((int)0x0DE1),
        Texture3D = ((int)0x806F),
        TextureCubeMap = ((int)0x8513),
        Texture1DArray = ((int)0x8C18),
        Texture2DArray = ((int)0x8C1A),
        Texture2DMultisample = ((int)0x9100),
        Texture2DMultisampleArray = ((int)0x9102),
    }

    public enum GetColorTableParameterPName : int
    {
        ColorTableScale = ((int)0x80D6),
        ColorTableBias = ((int)0x80D7),
        ColorTableFormat = ((int)0x80D8),
        ColorTableWidth = ((int)0x80D9),
        ColorTableRedSize = ((int)0x80DA),
        ColorTableGreenSize = ((int)0x80DB),
        ColorTableBlueSize = ((int)0x80DC),
        ColorTableAlphaSize = ((int)0x80DD),
        ColorTableLuminanceSize = ((int)0x80DE),
        ColorTableIntensitySize = ((int)0x80DF),
    }

    public enum GetColorTableParameterPNameSgi : int
    {
        ColorTableScaleSgi = ((int)0x80D6),
        ColorTableBiasSgi = ((int)0x80D7),
        ColorTableFormatSgi = ((int)0x80D8),
        ColorTableWidthSgi = ((int)0x80D9),
        ColorTableRedSizeSgi = ((int)0x80DA),
        ColorTableGreenSizeSgi = ((int)0x80DB),
        ColorTableBlueSizeSgi = ((int)0x80DC),
        ColorTableAlphaSizeSgi = ((int)0x80DD),
        ColorTableLuminanceSizeSgi = ((int)0x80DE),
        ColorTableIntensitySizeSgi = ((int)0x80DF),
    }

    public enum GetConvolutionParameter : int
    {
        ConvolutionBorderModeExt = ((int)0x8013),
        ConvolutionFilterScaleExt = ((int)0x8014),
        ConvolutionFilterBiasExt = ((int)0x8015),
        ConvolutionFormatExt = ((int)0x8017),
        ConvolutionWidthExt = ((int)0x8018),
        ConvolutionHeightExt = ((int)0x8019),
        MaxConvolutionWidthExt = ((int)0x801A),
        MaxConvolutionHeightExt = ((int)0x801B),
    }

    public enum GetConvolutionParameterPName : int
    {
        ConvolutionBorderMode = ((int)0x8013),
        ConvolutionFilterScale = ((int)0x8014),
        ConvolutionFilterBias = ((int)0x8015),
        ConvolutionFormat = ((int)0x8017),
        ConvolutionWidth = ((int)0x8018),
        ConvolutionHeight = ((int)0x8019),
        MaxConvolutionWidth = ((int)0x801A),
        MaxConvolutionHeight = ((int)0x801B),
        ConvolutionBorderColor = ((int)0x8154),
    }

    public enum GetHistogramParameterPName : int
    {
        HistogramWidth = ((int)0x8026),
        HistogramFormat = ((int)0x8027),
        HistogramRedSize = ((int)0x8028),
        HistogramGreenSize = ((int)0x8029),
        HistogramBlueSize = ((int)0x802A),
        HistogramAlphaSize = ((int)0x802B),
        HistogramLuminanceSize = ((int)0x802C),
        HistogramSink = ((int)0x802D),
    }

    public enum GetHistogramParameterPNameExt : int
    {
        HistogramWidthExt = ((int)0x8026),
        HistogramFormatExt = ((int)0x8027),
        HistogramRedSizeExt = ((int)0x8028),
        HistogramGreenSizeExt = ((int)0x8029),
        HistogramBlueSizeExt = ((int)0x802A),
        HistogramAlphaSizeExt = ((int)0x802B),
        HistogramLuminanceSizeExt = ((int)0x802C),
        HistogramSinkExt = ((int)0x802D),
    }

    public enum GetIndexedPName : int
    {
        UniformBufferBinding = ((int)0x8A28),
        UniformBufferStart = ((int)0x8A29),
        UniformBufferSize = ((int)0x8A2A),
        TransformFeedbackBufferStart = ((int)0x8C84),
        TransformFeedbackBufferSize = ((int)0x8C85),
        TransformFeedbackBufferBinding = ((int)0x8C8F),
        SampleMaskValue = ((int)0x8E52),
    }

    public enum GetMapQuery : int
    {
        Coeff = ((int)0x0A00),
        Order = ((int)0x0A01),
        Domain = ((int)0x0A02),
    }

    public enum GetMinmaxParameterPName : int
    {
        MinmaxFormat = ((int)0x802F),
        MinmaxSink = ((int)0x8030),
    }

    public enum GetMinmaxParameterPNameExt : int
    {
        MinmaxFormatExt = ((int)0x802F),
        MinmaxSinkExt = ((int)0x8030),
    }

    public enum GetMultisamplePName : int
    {
        SamplePosition = ((int)0x8E50),
    }

    public enum GetPixelMap : int
    {
        PixelMapIToI = ((int)0x0C70),
        PixelMapSToS = ((int)0x0C71),
        PixelMapIToR = ((int)0x0C72),
        PixelMapIToG = ((int)0x0C73),
        PixelMapIToB = ((int)0x0C74),
        PixelMapIToA = ((int)0x0C75),
        PixelMapRToR = ((int)0x0C76),
        PixelMapGToG = ((int)0x0C77),
        PixelMapBToB = ((int)0x0C78),
        PixelMapAToA = ((int)0x0C79),
    }

    public enum GetPName : int
    {
        CurrentColor = ((int)0x0B00),
        CurrentIndex = ((int)0x0B01),
        CurrentNormal = ((int)0x0B02),
        CurrentTextureCoords = ((int)0x0B03),
        CurrentRasterColor = ((int)0x0B04),
        CurrentRasterIndex = ((int)0x0B05),
        CurrentRasterTextureCoords = ((int)0x0B06),
        CurrentRasterPosition = ((int)0x0B07),
        CurrentRasterPositionValid = ((int)0x0B08),
        CurrentRasterDistance = ((int)0x0B09),
        PointSmooth = ((int)0x0B10),
        PointSize = ((int)0x0B11),
        PointSizeRange = ((int)0x0B12),
        SmoothPointSizeRange = ((int)0x0B12),
        PointSizeGranularity = ((int)0x0B13),
        SmoothPointSizeGranularity = ((int)0x0B13),
        LineSmooth = ((int)0x0B20),
        LineWidth = ((int)0x0B21),
        LineWidthRange = ((int)0x0B22),
        SmoothLineWidthRange = ((int)0x0B22),
        LineWidthGranularity = ((int)0x0B23),
        SmoothLineWidthGranularity = ((int)0x0B23),
        LineStipple = ((int)0x0B24),
        LineStipplePattern = ((int)0x0B25),
        LineStippleRepeat = ((int)0x0B26),
        ListMode = ((int)0x0B30),
        MaxListNesting = ((int)0x0B31),
        ListBase = ((int)0x0B32),
        ListIndex = ((int)0x0B33),
        PolygonMode = ((int)0x0B40),
        PolygonSmooth = ((int)0x0B41),
        PolygonStipple = ((int)0x0B42),
        EdgeFlag = ((int)0x0B43),
        CullFace = ((int)0x0B44),
        CullFaceMode = ((int)0x0B45),
        FrontFace = ((int)0x0B46),
        Lighting = ((int)0x0B50),
        LightModelLocalViewer = ((int)0x0B51),
        LightModelTwoSide = ((int)0x0B52),
        LightModelAmbient = ((int)0x0B53),
        ShadeModel = ((int)0x0B54),
        ColorMaterialFace = ((int)0x0B55),
        ColorMaterialParameter = ((int)0x0B56),
        ColorMaterial = ((int)0x0B57),
        Fog = ((int)0x0B60),
        FogIndex = ((int)0x0B61),
        FogDensity = ((int)0x0B62),
        FogStart = ((int)0x0B63),
        FogEnd = ((int)0x0B64),
        FogMode = ((int)0x0B65),
        FogColor = ((int)0x0B66),
        DepthRange = ((int)0x0B70),
        DepthTest = ((int)0x0B71),
        DepthWritemask = ((int)0x0B72),
        DepthClearValue = ((int)0x0B73),
        DepthFunc = ((int)0x0B74),
        AccumClearValue = ((int)0x0B80),
        StencilTest = ((int)0x0B90),
        StencilClearValue = ((int)0x0B91),
        StencilFunc = ((int)0x0B92),
        StencilValueMask = ((int)0x0B93),
        StencilFail = ((int)0x0B94),
        StencilPassDepthFail = ((int)0x0B95),
        StencilPassDepthPass = ((int)0x0B96),
        StencilRef = ((int)0x0B97),
        StencilWritemask = ((int)0x0B98),
        MatrixMode = ((int)0x0BA0),
        Normalize = ((int)0x0BA1),
        Viewport = ((int)0x0BA2),
        ModelviewStackDepth = ((int)0x0BA3),
        ProjectionStackDepth = ((int)0x0BA4),
        TextureStackDepth = ((int)0x0BA5),
        ModelviewMatrix = ((int)0x0BA6),
        ProjectionMatrix = ((int)0x0BA7),
        TextureMatrix = ((int)0x0BA8),
        AttribStackDepth = ((int)0x0BB0),
        ClientAttribStackDepth = ((int)0x0BB1),
        AlphaTest = ((int)0x0BC0),
        AlphaTestFunc = ((int)0x0BC1),
        AlphaTestRef = ((int)0x0BC2),
        Dither = ((int)0x0BD0),
        BlendDst = ((int)0x0BE0),
        BlendSrc = ((int)0x0BE1),
        Blend = ((int)0x0BE2),
        LogicOpMode = ((int)0x0BF0),
        IndexLogicOp = ((int)0x0BF1),
        LogicOp = ((int)0x0BF1),
        ColorLogicOp = ((int)0x0BF2),
        AuxBuffers = ((int)0x0C00),
        DrawBuffer = ((int)0x0C01),
        ReadBuffer = ((int)0x0C02),
        ScissorBox = ((int)0x0C10),
        ScissorTest = ((int)0x0C11),
        IndexClearValue = ((int)0x0C20),
        IndexWritemask = ((int)0x0C21),
        ColorClearValue = ((int)0x0C22),
        ColorWritemask = ((int)0x0C23),
        IndexMode = ((int)0x0C30),
        RgbaMode = ((int)0x0C31),
        Doublebuffer = ((int)0x0C32),
        Stereo = ((int)0x0C33),
        RenderMode = ((int)0x0C40),
        PerspectiveCorrectionHint = ((int)0x0C50),
        PointSmoothHint = ((int)0x0C51),
        LineSmoothHint = ((int)0x0C52),
        PolygonSmoothHint = ((int)0x0C53),
        FogHint = ((int)0x0C54),
        TextureGenS = ((int)0x0C60),
        TextureGenT = ((int)0x0C61),
        TextureGenR = ((int)0x0C62),
        TextureGenQ = ((int)0x0C63),
        PixelMapIToISize = ((int)0x0CB0),
        PixelMapSToSSize = ((int)0x0CB1),
        PixelMapIToRSize = ((int)0x0CB2),
        PixelMapIToGSize = ((int)0x0CB3),
        PixelMapIToBSize = ((int)0x0CB4),
        PixelMapIToASize = ((int)0x0CB5),
        PixelMapRToRSize = ((int)0x0CB6),
        PixelMapGToGSize = ((int)0x0CB7),
        PixelMapBToBSize = ((int)0x0CB8),
        PixelMapAToASize = ((int)0x0CB9),
        UnpackSwapBytes = ((int)0x0CF0),
        UnpackLsbFirst = ((int)0x0CF1),
        UnpackRowLength = ((int)0x0CF2),
        UnpackSkipRows = ((int)0x0CF3),
        UnpackSkipPixels = ((int)0x0CF4),
        UnpackAlignment = ((int)0x0CF5),
        PackSwapBytes = ((int)0x0D00),
        PackLsbFirst = ((int)0x0D01),
        PackRowLength = ((int)0x0D02),
        PackSkipRows = ((int)0x0D03),
        PackSkipPixels = ((int)0x0D04),
        PackAlignment = ((int)0x0D05),
        MapColor = ((int)0x0D10),
        MapStencil = ((int)0x0D11),
        IndexShift = ((int)0x0D12),
        IndexOffset = ((int)0x0D13),
        RedScale = ((int)0x0D14),
        RedBias = ((int)0x0D15),
        ZoomX = ((int)0x0D16),
        ZoomY = ((int)0x0D17),
        GreenScale = ((int)0x0D18),
        GreenBias = ((int)0x0D19),
        BlueScale = ((int)0x0D1A),
        BlueBias = ((int)0x0D1B),
        AlphaScale = ((int)0x0D1C),
        AlphaBias = ((int)0x0D1D),
        DepthScale = ((int)0x0D1E),
        DepthBias = ((int)0x0D1F),
        MaxEvalOrder = ((int)0x0D30),
        MaxLights = ((int)0x0D31),
        MaxClipPlanes = ((int)0x0D32),
        MaxTextureSize = ((int)0x0D33),
        MaxPixelMapTable = ((int)0x0D34),
        MaxAttribStackDepth = ((int)0x0D35),
        MaxModelviewStackDepth = ((int)0x0D36),
        MaxNameStackDepth = ((int)0x0D37),
        MaxProjectionStackDepth = ((int)0x0D38),
        MaxTextureStackDepth = ((int)0x0D39),
        MaxViewportDims = ((int)0x0D3A),
        MaxClientAttribStackDepth = ((int)0x0D3B),
        SubpixelBits = ((int)0x0D50),
        IndexBits = ((int)0x0D51),
        RedBits = ((int)0x0D52),
        GreenBits = ((int)0x0D53),
        BlueBits = ((int)0x0D54),
        AlphaBits = ((int)0x0D55),
        DepthBits = ((int)0x0D56),
        StencilBits = ((int)0x0D57),
        AccumRedBits = ((int)0x0D58),
        AccumGreenBits = ((int)0x0D59),
        AccumBlueBits = ((int)0x0D5A),
        AccumAlphaBits = ((int)0x0D5B),
        NameStackDepth = ((int)0x0D70),
        AutoNormal = ((int)0x0D80),
        Map1Color4 = ((int)0x0D90),
        Map1Index = ((int)0x0D91),
        Map1Normal = ((int)0x0D92),
        Map1TextureCoord1 = ((int)0x0D93),
        Map1TextureCoord2 = ((int)0x0D94),
        Map1TextureCoord3 = ((int)0x0D95),
        Map1TextureCoord4 = ((int)0x0D96),
        Map1Vertex3 = ((int)0x0D97),
        Map1Vertex4 = ((int)0x0D98),
        Map2Color4 = ((int)0x0DB0),
        Map2Index = ((int)0x0DB1),
        Map2Normal = ((int)0x0DB2),
        Map2TextureCoord1 = ((int)0x0DB3),
        Map2TextureCoord2 = ((int)0x0DB4),
        Map2TextureCoord3 = ((int)0x0DB5),
        Map2TextureCoord4 = ((int)0x0DB6),
        Map2Vertex3 = ((int)0x0DB7),
        Map2Vertex4 = ((int)0x0DB8),
        Map1GridDomain = ((int)0x0DD0),
        Map1GridSegments = ((int)0x0DD1),
        Map2GridDomain = ((int)0x0DD2),
        Map2GridSegments = ((int)0x0DD3),
        Texture1D = ((int)0x0DE0),
        Texture2D = ((int)0x0DE1),
        FeedbackBufferSize = ((int)0x0DF1),
        FeedbackBufferType = ((int)0x0DF2),
        SelectionBufferSize = ((int)0x0DF4),
        PolygonOffsetUnits = ((int)0x2A00),
        PolygonOffsetPoint = ((int)0x2A01),
        PolygonOffsetLine = ((int)0x2A02),
        ClipPlane0 = ((int)0x3000),
        ClipPlane1 = ((int)0x3001),
        ClipPlane2 = ((int)0x3002),
        ClipPlane3 = ((int)0x3003),
        ClipPlane4 = ((int)0x3004),
        ClipPlane5 = ((int)0x3005),
        Light0 = ((int)0x4000),
        Light1 = ((int)0x4001),
        Light2 = ((int)0x4002),
        Light3 = ((int)0x4003),
        Light4 = ((int)0x4004),
        Light5 = ((int)0x4005),
        Light6 = ((int)0x4006),
        Light7 = ((int)0x4007),
        BlendColorExt = ((int)0x8005),
        BlendEquationExt = ((int)0x8009),
        BlendEquationRgb = ((int)0x8009),
        PackCmykHintExt = ((int)0x800E),
        UnpackCmykHintExt = ((int)0x800F),
        Convolution1DExt = ((int)0x8010),
        Convolution2DExt = ((int)0x8011),
        Separable2DExt = ((int)0x8012),
        PostConvolutionRedScaleExt = ((int)0x801C),
        PostConvolutionGreenScaleExt = ((int)0x801D),
        PostConvolutionBlueScaleExt = ((int)0x801E),
        PostConvolutionAlphaScaleExt = ((int)0x801F),
        PostConvolutionRedBiasExt = ((int)0x8020),
        PostConvolutionGreenBiasExt = ((int)0x8021),
        PostConvolutionBlueBiasExt = ((int)0x8022),
        PostConvolutionAlphaBiasExt = ((int)0x8023),
        HistogramExt = ((int)0x8024),
        MinmaxExt = ((int)0x802E),
        PolygonOffsetFill = ((int)0x8037),
        PolygonOffsetFactor = ((int)0x8038),
        PolygonOffsetBiasExt = ((int)0x8039),
        RescaleNormalExt = ((int)0x803A),
        TextureBinding1D = ((int)0x8068),
        TextureBinding2D = ((int)0x8069),
        Texture3DBindingExt = ((int)0x806A),
        TextureBinding3D = ((int)0x806A),
        PackSkipImagesExt = ((int)0x806B),
        PackImageHeightExt = ((int)0x806C),
        UnpackSkipImagesExt = ((int)0x806D),
        UnpackImageHeightExt = ((int)0x806E),
        Texture3DExt = ((int)0x806F),
        Max3DTextureSize = ((int)0x8073),
        Max3DTextureSizeExt = ((int)0x8073),
        VertexArray = ((int)0x8074),
        NormalArray = ((int)0x8075),
        ColorArray = ((int)0x8076),
        IndexArray = ((int)0x8077),
        TextureCoordArray = ((int)0x8078),
        EdgeFlagArray = ((int)0x8079),
        VertexArraySize = ((int)0x807A),
        VertexArrayType = ((int)0x807B),
        VertexArrayStride = ((int)0x807C),
        VertexArrayCountExt = ((int)0x807D),
        NormalArrayType = ((int)0x807E),
        NormalArrayStride = ((int)0x807F),
        NormalArrayCountExt = ((int)0x8080),
        ColorArraySize = ((int)0x8081),
        ColorArrayType = ((int)0x8082),
        ColorArrayStride = ((int)0x8083),
        ColorArrayCountExt = ((int)0x8084),
        IndexArrayType = ((int)0x8085),
        IndexArrayStride = ((int)0x8086),
        IndexArrayCountExt = ((int)0x8087),
        TextureCoordArraySize = ((int)0x8088),
        TextureCoordArrayType = ((int)0x8089),
        TextureCoordArrayStride = ((int)0x808A),
        TextureCoordArrayCountExt = ((int)0x808B),
        EdgeFlagArrayStride = ((int)0x808C),
        EdgeFlagArrayCountExt = ((int)0x808D),
        InterlaceSgix = ((int)0x8094),
        DetailTexture2DBindingSgis = ((int)0x8096),
        Multisample = ((int)0x809D),
        MultisampleSgis = ((int)0x809D),
        SampleAlphaToCoverage = ((int)0x809E),
        SampleAlphaToMaskSgis = ((int)0x809E),
        SampleAlphaToOne = ((int)0x809F),
        SampleAlphaToOneSgis = ((int)0x809F),
        SampleCoverage = ((int)0x80A0),
        SampleMaskSgis = ((int)0x80A0),
        SampleBuffers = ((int)0x80A8),
        SampleBuffersSgis = ((int)0x80A8),
        Samples = ((int)0x80A9),
        SamplesSgis = ((int)0x80A9),
        SampleCoverageValue = ((int)0x80AA),
        SampleMaskValueSgis = ((int)0x80AA),
        SampleCoverageInvert = ((int)0x80AB),
        SampleMaskInvertSgis = ((int)0x80AB),
        SamplePatternSgis = ((int)0x80AC),
        ColorMatrixSgi = ((int)0x80B1),
        ColorMatrixStackDepthSgi = ((int)0x80B2),
        MaxColorMatrixStackDepthSgi = ((int)0x80B3),
        PostColorMatrixRedScaleSgi = ((int)0x80B4),
        PostColorMatrixGreenScaleSgi = ((int)0x80B5),
        PostColorMatrixBlueScaleSgi = ((int)0x80B6),
        PostColorMatrixAlphaScaleSgi = ((int)0x80B7),
        PostColorMatrixRedBiasSgi = ((int)0x80B8),
        PostColorMatrixGreenBiasSgi = ((int)0x80B9),
        PostColorMatrixBlueBiasSgi = ((int)0x80BA),
        PostColorMatrixAlphaBiasSgi = ((int)0x80BB),
        TextureColorTableSgi = ((int)0x80BC),
        BlendDstRgb = ((int)0x80C8),
        BlendSrcRgb = ((int)0x80C9),
        BlendDstAlpha = ((int)0x80CA),
        BlendSrcAlpha = ((int)0x80CB),
        ColorTableSgi = ((int)0x80D0),
        PostConvolutionColorTableSgi = ((int)0x80D1),
        PostColorMatrixColorTableSgi = ((int)0x80D2),
        MaxElementsVertices = ((int)0x80E8),
        MaxElementsIndices = ((int)0x80E9),
        PointSizeMin = ((int)0x8126),
        PointSizeMinSgis = ((int)0x8126),
        PointSizeMax = ((int)0x8127),
        PointSizeMaxSgis = ((int)0x8127),
        PointFadeThresholdSize = ((int)0x8128),
        PointFadeThresholdSizeSgis = ((int)0x8128),
        DistanceAttenuationSgis = ((int)0x8129),
        PointDistanceAttenuation = ((int)0x8129),
        FogFuncPointsSgis = ((int)0x812B),
        MaxFogFuncPointsSgis = ((int)0x812C),
        PackSkipVolumesSgis = ((int)0x8130),
        PackImageDepthSgis = ((int)0x8131),
        UnpackSkipVolumesSgis = ((int)0x8132),
        UnpackImageDepthSgis = ((int)0x8133),
        Texture4DSgis = ((int)0x8134),
        Max4DTextureSizeSgis = ((int)0x8138),
        PixelTexGenSgix = ((int)0x8139),
        PixelTileBestAlignmentSgix = ((int)0x813E),
        PixelTileCacheIncrementSgix = ((int)0x813F),
        PixelTileWidthSgix = ((int)0x8140),
        PixelTileHeightSgix = ((int)0x8141),
        PixelTileGridWidthSgix = ((int)0x8142),
        PixelTileGridHeightSgix = ((int)0x8143),
        PixelTileGridDepthSgix = ((int)0x8144),
        PixelTileCacheSizeSgix = ((int)0x8145),
        SpriteSgix = ((int)0x8148),
        SpriteModeSgix = ((int)0x8149),
        SpriteAxisSgix = ((int)0x814A),
        SpriteTranslationSgix = ((int)0x814B),
        Texture4DBindingSgis = ((int)0x814F),
        MaxClipmapDepthSgix = ((int)0x8177),
        MaxClipmapVirtualDepthSgix = ((int)0x8178),
        PostTextureFilterBiasRangeSgix = ((int)0x817B),
        PostTextureFilterScaleRangeSgix = ((int)0x817C),
        ReferencePlaneSgix = ((int)0x817D),
        ReferencePlaneEquationSgix = ((int)0x817E),
        IrInstrument1Sgix = ((int)0x817F),
        InstrumentMeasurementsSgix = ((int)0x8181),
        CalligraphicFragmentSgix = ((int)0x8183),
        FramezoomSgix = ((int)0x818B),
        FramezoomFactorSgix = ((int)0x818C),
        MaxFramezoomFactorSgix = ((int)0x818D),
        GenerateMipmapHint = ((int)0x8192),
        GenerateMipmapHintSgis = ((int)0x8192),
        DeformationsMaskSgix = ((int)0x8196),
        FogOffsetSgix = ((int)0x8198),
        FogOffsetValueSgix = ((int)0x8199),
        LightModelColorControl = ((int)0x81F8),
        SharedTexturePaletteExt = ((int)0x81FB),
        MajorVersion = ((int)0x821B),
        MinorVersion = ((int)0x821C),
        NumExtensions = ((int)0x821D),
        ContextFlags = ((int)0x821E),
        ConvolutionHintSgix = ((int)0x8316),
        AsyncMarkerSgix = ((int)0x8329),
        PixelTexGenModeSgix = ((int)0x832B),
        AsyncHistogramSgix = ((int)0x832C),
        MaxAsyncHistogramSgix = ((int)0x832D),
        PixelTextureSgis = ((int)0x8353),
        AsyncTexImageSgix = ((int)0x835C),
        AsyncDrawPixelsSgix = ((int)0x835D),
        AsyncReadPixelsSgix = ((int)0x835E),
        MaxAsyncTexImageSgix = ((int)0x835F),
        MaxAsyncDrawPixelsSgix = ((int)0x8360),
        MaxAsyncReadPixelsSgix = ((int)0x8361),
        VertexPreclipSgix = ((int)0x83EE),
        VertexPreclipHintSgix = ((int)0x83EF),
        FragmentLightingSgix = ((int)0x8400),
        FragmentColorMaterialSgix = ((int)0x8401),
        FragmentColorMaterialFaceSgix = ((int)0x8402),
        FragmentColorMaterialParameterSgix = ((int)0x8403),
        MaxFragmentLightsSgix = ((int)0x8404),
        MaxActiveLightsSgix = ((int)0x8405),
        LightEnvModeSgix = ((int)0x8407),
        FragmentLightModelLocalViewerSgix = ((int)0x8408),
        FragmentLightModelTwoSideSgix = ((int)0x8409),
        FragmentLightModelAmbientSgix = ((int)0x840A),
        FragmentLightModelNormalInterpolationSgix = ((int)0x840B),
        FragmentLight0Sgix = ((int)0x840C),
        PackResampleSgix = ((int)0x842C),
        UnpackResampleSgix = ((int)0x842D),
        CurrentFogCoord = ((int)0x8453),
        FogCoordArrayType = ((int)0x8454),
        FogCoordArrayStride = ((int)0x8455),
        ColorSum = ((int)0x8458),
        CurrentSecondaryColor = ((int)0x8459),
        SecondaryColorArraySize = ((int)0x845A),
        SecondaryColorArrayType = ((int)0x845B),
        SecondaryColorArrayStride = ((int)0x845C),
        CurrentRasterSecondaryColor = ((int)0x845F),
        AliasedPointSizeRange = ((int)0x846D),
        AliasedLineWidthRange = ((int)0x846E),
        ActiveTexture = ((int)0x84E0),
        ClientActiveTexture = ((int)0x84E1),
        MaxTextureUnits = ((int)0x84E2),
        TransposeModelviewMatrix = ((int)0x84E3),
        TransposeProjectionMatrix = ((int)0x84E4),
        TransposeTextureMatrix = ((int)0x84E5),
        TransposeColorMatrix = ((int)0x84E6),
        MaxRenderbufferSize = ((int)0x84E8),
        MaxRenderbufferSizeExt = ((int)0x84E8),
        TextureCompressionHint = ((int)0x84EF),
        TextureBindingRectangle = ((int)0x84F6),
        MaxRectangleTextureSize = ((int)0x84F8),
        MaxTextureLodBias = ((int)0x84FD),
        TextureCubeMap = ((int)0x8513),
        TextureBindingCubeMap = ((int)0x8514),
        MaxCubeMapTextureSize = ((int)0x851C),
        PackSubsampleRateSgix = ((int)0x85A0),
        UnpackSubsampleRateSgix = ((int)0x85A1),
        VertexArrayBinding = ((int)0x85B5),
        ProgramPointSize = ((int)0x8642),
        DepthClamp = ((int)0x864F),
        NumCompressedTextureFormats = ((int)0x86A2),
        CompressedTextureFormats = ((int)0x86A3),
        StencilBackFunc = ((int)0x8800),
        StencilBackFail = ((int)0x8801),
        StencilBackPassDepthFail = ((int)0x8802),
        StencilBackPassDepthPass = ((int)0x8803),
        RgbaFloatMode = ((int)0x8820),
        MaxDrawBuffers = ((int)0x8824),
        DrawBuffer0 = ((int)0x8825),
        DrawBuffer1 = ((int)0x8826),
        DrawBuffer2 = ((int)0x8827),
        DrawBuffer3 = ((int)0x8828),
        DrawBuffer4 = ((int)0x8829),
        DrawBuffer5 = ((int)0x882A),
        DrawBuffer6 = ((int)0x882B),
        DrawBuffer7 = ((int)0x882C),
        DrawBuffer8 = ((int)0x882D),
        DrawBuffer9 = ((int)0x882E),
        DrawBuffer10 = ((int)0x882F),
        DrawBuffer11 = ((int)0x8830),
        DrawBuffer12 = ((int)0x8831),
        DrawBuffer13 = ((int)0x8832),
        DrawBuffer14 = ((int)0x8833),
        DrawBuffer15 = ((int)0x8834),
        BlendEquationAlpha = ((int)0x883D),
        TextureCubeMapSeamless = ((int)0x884F),
        PointSprite = ((int)0x8861),
        MaxVertexAttribs = ((int)0x8869),
        MaxTextureCoords = ((int)0x8871),
        MaxTextureImageUnits = ((int)0x8872),
        ArrayBufferBinding = ((int)0x8894),
        ElementArrayBufferBinding = ((int)0x8895),
        VertexArrayBufferBinding = ((int)0x8896),
        NormalArrayBufferBinding = ((int)0x8897),
        ColorArrayBufferBinding = ((int)0x8898),
        IndexArrayBufferBinding = ((int)0x8899),
        TextureCoordArrayBufferBinding = ((int)0x889A),
        EdgeFlagArrayBufferBinding = ((int)0x889B),
        SecondaryColorArrayBufferBinding = ((int)0x889C),
        FogCoordArrayBufferBinding = ((int)0x889D),
        WeightArrayBufferBinding = ((int)0x889E),
        VertexAttribArrayBufferBinding = ((int)0x889F),
        PixelPackBufferBinding = ((int)0x88ED),
        PixelUnpackBufferBinding = ((int)0x88EF),
        MaxArrayTextureLayers = ((int)0x88FF),
        MinProgramTexelOffset = ((int)0x8904),
        MaxProgramTexelOffset = ((int)0x8905),
        ClampVertexColor = ((int)0x891A),
        ClampFragmentColor = ((int)0x891B),
        ClampReadColor = ((int)0x891C),
        MaxVertexUniformBlocks = ((int)0x8A2B),
        MaxGeometryUniformBlocks = ((int)0x8A2C),
        MaxFragmentUniformBlocks = ((int)0x8A2D),
        MaxCombinedUniformBlocks = ((int)0x8A2E),
        MaxUniformBufferBindings = ((int)0x8A2F),
        MaxUniformBlockSize = ((int)0x8A30),
        MaxCombinedVertexUniformComponents = ((int)0x8A31),
        MaxCombinedGeometryUniformComponents = ((int)0x8A32),
        MaxCombinedFragmentUniformComponents = ((int)0x8A33),
        UniformBufferOffsetAlignment = ((int)0x8A34),
        MaxFragmentUniformComponents = ((int)0x8B49),
        MaxVertexUniformComponents = ((int)0x8B4A),
        MaxVaryingComponents = ((int)0x8B4B),
        MaxVaryingFloats = ((int)0x8B4B),
        MaxVertexTextureImageUnits = ((int)0x8B4C),
        MaxCombinedTextureImageUnits = ((int)0x8B4D),
        FragmentShaderDerivativeHint = ((int)0x8B8B),
        CurrentProgram = ((int)0x8B8D),
        TextureBinding1DArray = ((int)0x8C1C),
        TextureBinding2DArray = ((int)0x8C1D),
        MaxGeometryTextureImageUnits = ((int)0x8C29),
        MaxTransformFeedbackSeparateComponents = ((int)0x8C80),
        MaxTransformFeedbackInterleavedComponents = ((int)0x8C8A),
        MaxTransformFeedbackSeparateAttribs = ((int)0x8C8B),
        StencilBackRef = ((int)0x8CA3),
        StencilBackValueMask = ((int)0x8CA4),
        StencilBackWritemask = ((int)0x8CA5),
        DrawFramebufferBinding = ((int)0x8CA6),
        FramebufferBinding = ((int)0x8CA6),
        FramebufferBindingExt = ((int)0x8CA6),
        RenderbufferBinding = ((int)0x8CA7),
        RenderbufferBindingExt = ((int)0x8CA7),
        ReadFramebufferBinding = ((int)0x8CAA),
        MaxColorAttachments = ((int)0x8CDF),
        MaxColorAttachmentsExt = ((int)0x8CDF),
        MaxSamples = ((int)0x8D57),
        FramebufferSrgb = ((int)0x8DB9),
        MaxGeometryVaryingComponents = ((int)0x8DDD),
        MaxVertexVaryingComponents = ((int)0x8DDE),
        MaxGeometryUniformComponents = ((int)0x8DDF),
        MaxGeometryOutputVertices = ((int)0x8DE0),
        MaxGeometryTotalOutputComponents = ((int)0x8DE1),
        QuadsFollowProvokingVertexConvention = ((int)0x8E4C),
        ProvokingVertex = ((int)0x8E4F),
        SampleMask = ((int)0x8E51),
        MaxSampleMaskWords = ((int)0x8E59),
        TextureBinding2DMultisample = ((int)0x9104),
        TextureBinding2DMultisampleArray = ((int)0x9105),
        MaxColorTextureSamples = ((int)0x910E),
        MaxDepthTextureSamples = ((int)0x910F),
        MaxIntegerSamples = ((int)0x9110),
    }

    public enum GetPointervPName : int
    {
        FeedbackBufferPointer = ((int)0x0DF0),
        SelectionBufferPointer = ((int)0x0DF3),
        VertexArrayPointer = ((int)0x808E),
        NormalArrayPointer = ((int)0x808F),
        ColorArrayPointer = ((int)0x8090),
        IndexArrayPointer = ((int)0x8091),
        TextureCoordArrayPointer = ((int)0x8092),
        EdgeFlagArrayPointer = ((int)0x8093),
        InstrumentBufferPointerSgix = ((int)0x8180),
        FogCoordArrayPointer = ((int)0x8456),
        SecondaryColorArrayPointer = ((int)0x845D),
    }

    public enum GetQueryObjectParam : int
    {
        QueryResult = ((int)0x8866),
        QueryResultAvailable = ((int)0x8867),
    }

    public enum GetQueryParam : int
    {
        QueryCounterBits = ((int)0x8864),
        CurrentQuery = ((int)0x8865),
    }

    public enum GetTextureParameter : int
    {
        TextureWidth = ((int)0x1000),
        TextureHeight = ((int)0x1001),
        TextureComponents = ((int)0x1003),
        TextureInternalFormat = ((int)0x1003),
        TextureBorderColor = ((int)0x1004),
        TextureBorder = ((int)0x1005),
        TextureMagFilter = ((int)0x2800),
        TextureMinFilter = ((int)0x2801),
        TextureWrapS = ((int)0x2802),
        TextureWrapT = ((int)0x2803),
        TextureRedSize = ((int)0x805C),
        TextureGreenSize = ((int)0x805D),
        TextureBlueSize = ((int)0x805E),
        TextureAlphaSize = ((int)0x805F),
        TextureLuminanceSize = ((int)0x8060),
        TextureIntensitySize = ((int)0x8061),
        TexturePriority = ((int)0x8066),
        TextureResident = ((int)0x8067),
        TextureDepth = ((int)0x8071),
        TextureDepthExt = ((int)0x8071),
        TextureWrapR = ((int)0x8072),
        TextureWrapRExt = ((int)0x8072),
        DetailTextureLevelSgis = ((int)0x809A),
        DetailTextureModeSgis = ((int)0x809B),
        DetailTextureFuncPointsSgis = ((int)0x809C),
        SharpenTextureFuncPointsSgis = ((int)0x80B0),
        ShadowAmbientSgix = ((int)0x80BF),
        DualTextureSelectSgis = ((int)0x8124),
        QuadTextureSelectSgis = ((int)0x8125),
        Texture4DsizeSgis = ((int)0x8136),
        TextureWrapQSgis = ((int)0x8137),
        TextureMinLod = ((int)0x813A),
        TextureMinLodSgis = ((int)0x813A),
        TextureMaxLod = ((int)0x813B),
        TextureMaxLodSgis = ((int)0x813B),
        TextureBaseLevel = ((int)0x813C),
        TextureBaseLevelSgis = ((int)0x813C),
        TextureMaxLevel = ((int)0x813D),
        TextureMaxLevelSgis = ((int)0x813D),
        TextureFilter4SizeSgis = ((int)0x8147),
        TextureClipmapCenterSgix = ((int)0x8171),
        TextureClipmapFrameSgix = ((int)0x8172),
        TextureClipmapOffsetSgix = ((int)0x8173),
        TextureClipmapVirtualDepthSgix = ((int)0x8174),
        TextureClipmapLodOffsetSgix = ((int)0x8175),
        TextureClipmapDepthSgix = ((int)0x8176),
        PostTextureFilterBiasSgix = ((int)0x8179),
        PostTextureFilterScaleSgix = ((int)0x817A),
        TextureLodBiasSSgix = ((int)0x818E),
        TextureLodBiasTSgix = ((int)0x818F),
        TextureLodBiasRSgix = ((int)0x8190),
        GenerateMipmap = ((int)0x8191),
        GenerateMipmapSgis = ((int)0x8191),
        TextureCompareSgix = ((int)0x819A),
        TextureCompareOperatorSgix = ((int)0x819B),
        TextureLequalRSgix = ((int)0x819C),
        TextureGequalRSgix = ((int)0x819D),
        TextureMaxClampSSgix = ((int)0x8369),
        TextureMaxClampTSgix = ((int)0x836A),
        TextureMaxClampRSgix = ((int)0x836B),
        TextureCompressedImageSize = ((int)0x86A0),
        TextureCompressed = ((int)0x86A1),
        TextureDepthSize = ((int)0x884A),
        DepthTextureMode = ((int)0x884B),
        TextureCompareMode = ((int)0x884C),
        TextureCompareFunc = ((int)0x884D),
        TextureStencilSize = ((int)0x88F1),
        TextureRedType = ((int)0x8C10),
        TextureGreenType = ((int)0x8C11),
        TextureBlueType = ((int)0x8C12),
        TextureAlphaType = ((int)0x8C13),
        TextureLuminanceType = ((int)0x8C14),
        TextureIntensityType = ((int)0x8C15),
        TextureDepthType = ((int)0x8C16),
        TextureSharedSize = ((int)0x8C3F),
        TextureSamples = ((int)0x9106),
        TextureFixedSampleLocations = ((int)0x9107),
    }

    public enum Gl3DfxMultisample : int
    {
        MultisampleBit3Dfx = ((int)0x20000000),
        Multisample3Dfx = ((int)0x86B2),
        SampleBuffers3Dfx = ((int)0x86B3),
        Samples3Dfx = ((int)0x86B4),
    }

    public enum Gl3DfxTbuffer : int
    {
    }

    public enum Gl3DfxTextureCompressionFxt1 : int
    {
        CompressedRgbFxt13Dfx = ((int)0x86B0),
        CompressedRgbaFxt13Dfx = ((int)0x86B1),
    }

    public enum GremedyFrameTerminator : int
    {
    }

    public enum GremedyStringMarker : int
    {
    }

    public enum HintMode : int
    {
        DontCare = ((int)0x1100),
        Fastest = ((int)0x1101),
        Nicest = ((int)0x1102),
    }

    public enum HintTarget : int
    {
        PerspectiveCorrectionHint = ((int)0x0C50),
        PointSmoothHint = ((int)0x0C51),
        LineSmoothHint = ((int)0x0C52),
        PolygonSmoothHint = ((int)0x0C53),
        FogHint = ((int)0x0C54),
        PackCmykHintExt = ((int)0x800E),
        UnpackCmykHintExt = ((int)0x800F),
        TextureMultiBufferHintSgix = ((int)0x812E),
        GenerateMipmapHint = ((int)0x8192),
        GenerateMipmapHintSgis = ((int)0x8192),
        ConvolutionHintSgix = ((int)0x8316),
        VertexPreclipHintSgix = ((int)0x83EF),
        TextureCompressionHint = ((int)0x84EF),
        FragmentShaderDerivativeHint = ((int)0x8B8B),
    }

    public enum HistogramTarget : int
    {
        Histogram = ((int)0x8024),
        ProxyHistogram = ((int)0x8025),
    }

    public enum HistogramTargetExt : int
    {
        HistogramExt = ((int)0x8024),
        ProxyHistogramExt = ((int)0x8025),
    }

    public enum HpConvolutionBorderModes : int
    {
        IgnoreBorderHp = ((int)0x8150),
        ConstantBorderHp = ((int)0x8151),
        ReplicateBorderHp = ((int)0x8153),
        ConvolutionBorderColorHp = ((int)0x8154),
    }

    public enum HpImageTransform : int
    {
        ImageScaleXHp = ((int)0x8155),
        ImageScaleYHp = ((int)0x8156),
        ImageTranslateXHp = ((int)0x8157),
        ImageTranslateYHp = ((int)0x8158),
        ImageRotateAngleHp = ((int)0x8159),
        ImageRotateOriginXHp = ((int)0x815A),
        ImageRotateOriginYHp = ((int)0x815B),
        ImageMagFilterHp = ((int)0x815C),
        ImageMinFilterHp = ((int)0x815D),
        ImageCubicWeightHp = ((int)0x815E),
        CubicHp = ((int)0x815F),
        AverageHp = ((int)0x8160),
        ImageTransform2DHp = ((int)0x8161),
        PostImageTransformColorTableHp = ((int)0x8162),
        ProxyPostImageTransformColorTableHp = ((int)0x8163),
    }

    public enum HpOcclusionTest : int
    {
        OcclusionTestHp = ((int)0x8165),
        OcclusionTestResultHp = ((int)0x8166),
    }

    public enum HpTextureLighting : int
    {
        TextureLightingModeHp = ((int)0x8167),
        TexturePostSpecularHp = ((int)0x8168),
        TexturePreSpecularHp = ((int)0x8169),
    }

    public enum IbmCullVertex : int
    {
        CullVertexIbm = ((int)103050),
    }

    public enum IbmMultimodeDrawArrays : int
    {
    }

    public enum IbmRasterposClip : int
    {
        RasterPositionUnclippedIbm = ((int)0x19262),
    }

    public enum IbmTextureMirroredRepeat : int
    {
        MirroredRepeatIbm = ((int)0x8370),
    }

    public enum IbmVertexArrayLists : int
    {
        VertexArrayListIbm = ((int)103070),
        NormalArrayListIbm = ((int)103071),
        ColorArrayListIbm = ((int)103072),
        IndexArrayListIbm = ((int)103073),
        TextureCoordArrayListIbm = ((int)103074),
        EdgeFlagArrayListIbm = ((int)103075),
        FogCoordinateArrayListIbm = ((int)103076),
        SecondaryColorArrayListIbm = ((int)103077),
        VertexArrayListStrideIbm = ((int)103080),
        NormalArrayListStrideIbm = ((int)103081),
        ColorArrayListStrideIbm = ((int)103082),
        IndexArrayListStrideIbm = ((int)103083),
        TextureCoordArrayListStrideIbm = ((int)103084),
        EdgeFlagArrayListStrideIbm = ((int)103085),
        FogCoordinateArrayListStrideIbm = ((int)103086),
        SecondaryColorArrayListStrideIbm = ((int)103087),
    }

    public enum IndexedEnableCap : int
    {
        Blend = ((int)0x0BE2),
    }

    public enum IndexPointerType : int
    {
        Short = ((int)0x1402),
        Int = ((int)0x1404),
        Float = ((int)0x1406),
        Double = ((int)0x140A),
    }

    public enum IngrColorClamp : int
    {
        RedMinClampIngr = ((int)0x8560),
        GreenMinClampIngr = ((int)0x8561),
        BlueMinClampIngr = ((int)0x8562),
        AlphaMinClampIngr = ((int)0x8563),
        RedMaxClampIngr = ((int)0x8564),
        GreenMaxClampIngr = ((int)0x8565),
        BlueMaxClampIngr = ((int)0x8566),
        AlphaMaxClampIngr = ((int)0x8567),
    }

    public enum IngrInterlaceRead : int
    {
        InterlaceReadIngr = ((int)0x8568),
    }

    public enum IngrPaletteBuffer : int
    {
    }

    public enum IntelParallelArrays : int
    {
        ParallelArraysIntel = ((int)0x83F4),
        VertexArrayParallelPointersIntel = ((int)0x83F5),
        NormalArrayParallelPointersIntel = ((int)0x83F6),
        ColorArrayParallelPointersIntel = ((int)0x83F7),
        TextureCoordArrayParallelPointersIntel = ((int)0x83F8),
    }

    public enum IntelTextureScissor : int
    {
    }

    public enum InterleavedArrayFormat : int
    {
        V2f = ((int)0x2A20),
        V3f = ((int)0x2A21),
        C4ubV2f = ((int)0x2A22),
        C4ubV3f = ((int)0x2A23),
        C3fV3f = ((int)0x2A24),
        N3fV3f = ((int)0x2A25),
        C4fN3fV3f = ((int)0x2A26),
        T2fV3f = ((int)0x2A27),
        T4fV4f = ((int)0x2A28),
        T2fC4ubV3f = ((int)0x2A29),
        T2fC3fV3f = ((int)0x2A2A),
        T2fN3fV3f = ((int)0x2A2B),
        T2fC4fN3fV3f = ((int)0x2A2C),
        T4fC4fN3fV4f = ((int)0x2A2D),
    }

    public enum LightEnvModeSgix : int
    {
        Add = ((int)0x0104),
        Replace = ((int)0x1E01),
        Modulate = ((int)0x2100),
    }

    public enum LightEnvParameterSgix : int
    {
        LightEnvModeSgix = ((int)0x8407),
    }

    public enum LightModelColorControl : int
    {
        SingleColor = ((int)0x81F9),
        SeparateSpecularColor = ((int)0x81FA),
    }

    public enum LightModelParameter : int
    {
        LightModelLocalViewer = ((int)0x0B51),
        LightModelTwoSide = ((int)0x0B52),
        LightModelAmbient = ((int)0x0B53),
        LightModelColorControl = ((int)0x81F8),
    }

    public enum LightName : int
    {
        Light0 = ((int)0x4000),
        Light1 = ((int)0x4001),
        Light2 = ((int)0x4002),
        Light3 = ((int)0x4003),
        Light4 = ((int)0x4004),
        Light5 = ((int)0x4005),
        Light6 = ((int)0x4006),
        Light7 = ((int)0x4007),
        FragmentLight0Sgix = ((int)0x840C),
        FragmentLight1Sgix = ((int)0x840D),
        FragmentLight2Sgix = ((int)0x840E),
        FragmentLight3Sgix = ((int)0x840F),
        FragmentLight4Sgix = ((int)0x8410),
        FragmentLight5Sgix = ((int)0x8411),
        FragmentLight6Sgix = ((int)0x8412),
        FragmentLight7Sgix = ((int)0x8413),
    }

    public enum LightParameter : int
    {
        Ambient = ((int)0x1200),
        Diffuse = ((int)0x1201),
        Specular = ((int)0x1202),
        Position = ((int)0x1203),
        SpotDirection = ((int)0x1204),
        SpotExponent = ((int)0x1205),
        SpotCutoff = ((int)0x1206),
        ConstantAttenuation = ((int)0x1207),
        LinearAttenuation = ((int)0x1208),
        QuadraticAttenuation = ((int)0x1209),
    }

    public enum ListMode : int
    {
        Compile = ((int)0x1300),
        CompileAndExecute = ((int)0x1301),
    }

    public enum ListNameType : int
    {
        Byte = ((int)0x1400),
        UnsignedByte = ((int)0x1401),
        Short = ((int)0x1402),
        UnsignedShort = ((int)0x1403),
        Int = ((int)0x1404),
        UnsignedInt = ((int)0x1405),
        Float = ((int)0x1406),
        Gl2Bytes = ((int)0x1407),
        Gl3Bytes = ((int)0x1408),
        Gl4Bytes = ((int)0x1409),
    }

    public enum ListParameterName : int
    {
        ListPrioritySgix = ((int)0x8182),
    }

    public enum LogicOp : int
    {
        Clear = ((int)0x1500),
        And = ((int)0x1501),
        AndReverse = ((int)0x1502),
        Copy = ((int)0x1503),
        AndInverted = ((int)0x1504),
        Noop = ((int)0x1505),
        Xor = ((int)0x1506),
        Or = ((int)0x1507),
        Nor = ((int)0x1508),
        Equiv = ((int)0x1509),
        Invert = ((int)0x150A),
        OrReverse = ((int)0x150B),
        CopyInverted = ((int)0x150C),
        OrInverted = ((int)0x150D),
        Nand = ((int)0x150E),
        Set = ((int)0x150F),
    }

    public enum MapTarget : int
    {
        Map1Color4 = ((int)0x0D90),
        Map1Index = ((int)0x0D91),
        Map1Normal = ((int)0x0D92),
        Map1TextureCoord1 = ((int)0x0D93),
        Map1TextureCoord2 = ((int)0x0D94),
        Map1TextureCoord3 = ((int)0x0D95),
        Map1TextureCoord4 = ((int)0x0D96),
        Map1Vertex3 = ((int)0x0D97),
        Map1Vertex4 = ((int)0x0D98),
        Map2Color4 = ((int)0x0DB0),
        Map2Index = ((int)0x0DB1),
        Map2Normal = ((int)0x0DB2),
        Map2TextureCoord1 = ((int)0x0DB3),
        Map2TextureCoord2 = ((int)0x0DB4),
        Map2TextureCoord3 = ((int)0x0DB5),
        Map2TextureCoord4 = ((int)0x0DB6),
        Map2Vertex3 = ((int)0x0DB7),
        Map2Vertex4 = ((int)0x0DB8),
        GeometryDeformationSgix = ((int)0x8194),
        TextureDeformationSgix = ((int)0x8195),
    }

    public enum MaterialFace : int
    {
        Front = ((int)0x0404),
        Back = ((int)0x0405),
        FrontAndBack = ((int)0x0408),
    }

    public enum MaterialParameter : int
    {
        Ambient = ((int)0x1200),
        Diffuse = ((int)0x1201),
        Specular = ((int)0x1202),
        Emission = ((int)0x1600),
        Shininess = ((int)0x1601),
        AmbientAndDiffuse = ((int)0x1602),
        ColorIndexes = ((int)0x1603),
    }

    public enum MatrixMode : int
    {
        Modelview = ((int)0x1700),
        Projection = ((int)0x1701),
        Texture = ((int)0x1702),
        Color = ((int)0x1800),
    }

    public enum MatrixModeArb : int
    {
        Modelview = ((int)0x1700),
        Projection = ((int)0x1701),
        Texture = ((int)0x1702),
        Color = ((int)0x1800),
        Matrix0 = ((int)0x88C0),
        Matrix1 = ((int)0x88C1),
        Matrix2 = ((int)0x88C2),
        Matrix3 = ((int)0x88C3),
        Matrix4 = ((int)0x88C4),
        Matrix5 = ((int)0x88C5),
        Matrix6 = ((int)0x88C6),
        Matrix7 = ((int)0x88C7),
        Matrix8 = ((int)0x88C8),
        Matrix9 = ((int)0x88C9),
        Matrix10 = ((int)0x88CA),
        Matrix11 = ((int)0x88CB),
        Matrix12 = ((int)0x88CC),
        Matrix13 = ((int)0x88CD),
        Matrix14 = ((int)0x88CE),
        Matrix15 = ((int)0x88CF),
        Matrix16 = ((int)0x88D0),
        Matrix17 = ((int)0x88D1),
        Matrix18 = ((int)0x88D2),
        Matrix19 = ((int)0x88D3),
        Matrix20 = ((int)0x88D4),
        Matrix21 = ((int)0x88D5),
        Matrix22 = ((int)0x88D6),
        Matrix23 = ((int)0x88D7),
        Matrix24 = ((int)0x88D8),
        Matrix25 = ((int)0x88D9),
        Matrix26 = ((int)0x88DA),
        Matrix27 = ((int)0x88DB),
        Matrix28 = ((int)0x88DC),
        Matrix29 = ((int)0x88DD),
        Matrix30 = ((int)0x88DE),
        Matrix31 = ((int)0x88DF),
    }

    public enum MesaPackInvert : int
    {
        PackInvertMesa = ((int)0x8758),
    }

    public enum MesaResizeBuffers : int
    {
    }

    public enum MesaWindowPos : int
    {
    }

    public enum MesaxTextureStack : int
    {
        Texture1DStackMesax = ((int)0x8759),
        Texture2DStackMesax = ((int)0x875A),
        ProxyTexture1DStackMesax = ((int)0x875B),
        ProxyTexture2DStackMesax = ((int)0x875C),
        Texture1DStackBindingMesax = ((int)0x875D),
        Texture2DStackBindingMesax = ((int)0x875E),
    }

    public enum MesaYcbcrTexture : int
    {
        UnsignedShort88Mesa = ((int)0x85BA),
        UnsignedShort88RevMesa = ((int)0x85BB),
        YcbcrMesa = ((int)0x8757),
    }

    public enum MeshMode1 : int
    {
        Point = ((int)0x1B00),
        Line = ((int)0x1B01),
    }

    public enum MeshMode2 : int
    {
        Point = ((int)0x1B00),
        Line = ((int)0x1B01),
        Fill = ((int)0x1B02),
    }

    public enum MinmaxTarget : int
    {
        Minmax = ((int)0x802E),
    }

    public enum MinmaxTargetExt : int
    {
        MinmaxExt = ((int)0x802E),
    }

    public enum NormalPointerType : int
    {
        Byte = ((int)0x1400),
        Short = ((int)0x1402),
        Int = ((int)0x1404),
        Float = ((int)0x1406),
        Double = ((int)0x140A),
        HalfFloat = ((int)0x140B),
    }

    public enum NvBlendSquare : int
    {
    }

    public enum NvConditionalRender : int
    {
        QueryWaitNv = ((int)0x8E13),
        QueryNoWaitNv = ((int)0x8E14),
        QueryByRegionWaitNv = ((int)0x8E15),
        QueryByRegionNoWaitNv = ((int)0x8E16),
    }

    public enum NvCopyDepthToColor : int
    {
        DepthStencilToRgbaNv = ((int)0x886E),
        DepthStencilToBgraNv = ((int)0x886F),
    }

    public enum NvDepthBufferFloat : int
    {
        DepthComponent32fNv = ((int)0x8DAB),
        Depth32fStencil8Nv = ((int)0x8DAC),
        Float32UnsignedInt248RevNv = ((int)0x8DAD),
        DepthBufferFloatModeNv = ((int)0x8DAF),
    }

    public enum NvDepthClamp : int
    {
        DepthClampNv = ((int)0x864F),
    }

    public enum NvEvaluators : int
    {
        Eval2DNv = ((int)0x86C0),
        EvalTriangular2DNv = ((int)0x86C1),
        MapTessellationNv = ((int)0x86C2),
        MapAttribUOrderNv = ((int)0x86C3),
        MapAttribVOrderNv = ((int)0x86C4),
        EvalFractionalTessellationNv = ((int)0x86C5),
        EvalVertexAttrib0Nv = ((int)0x86C6),
        EvalVertexAttrib1Nv = ((int)0x86C7),
        EvalVertexAttrib2Nv = ((int)0x86C8),
        EvalVertexAttrib3Nv = ((int)0x86C9),
        EvalVertexAttrib4Nv = ((int)0x86CA),
        EvalVertexAttrib5Nv = ((int)0x86CB),
        EvalVertexAttrib6Nv = ((int)0x86CC),
        EvalVertexAttrib7Nv = ((int)0x86CD),
        EvalVertexAttrib8Nv = ((int)0x86CE),
        EvalVertexAttrib9Nv = ((int)0x86CF),
        EvalVertexAttrib10Nv = ((int)0x86D0),
        EvalVertexAttrib11Nv = ((int)0x86D1),
        EvalVertexAttrib12Nv = ((int)0x86D2),
        EvalVertexAttrib13Nv = ((int)0x86D3),
        EvalVertexAttrib14Nv = ((int)0x86D4),
        EvalVertexAttrib15Nv = ((int)0x86D5),
        MaxMapTessellationNv = ((int)0x86D6),
        MaxRationalEvalOrderNv = ((int)0x86D7),
    }

    public enum NvExplicitMultisample : int
    {
        SamplePositionNv = ((int)0x8E50),
        SampleMaskNv = ((int)0x8E51),
        SampleMaskValueNv = ((int)0x8E52),
        TextureBindingRenderbufferNv = ((int)0x8E53),
        TextureRenderbufferDataStoreBindingNv = ((int)0x8E54),
        TextureRenderbufferNv = ((int)0x8E55),
        SamplerRenderbufferNv = ((int)0x8E56),
        IntSamplerRenderbufferNv = ((int)0x8E57),
        UnsignedIntSamplerRenderbufferNv = ((int)0x8E58),
        MaxSampleMaskWordsNv = ((int)0x8E59),
    }

    public enum NvFence : int
    {
        AllCompletedNv = ((int)0x84F2),
        FenceStatusNv = ((int)0x84F3),
        FenceConditionNv = ((int)0x84F4),
    }

    public enum NvFloatBuffer : int
    {
        FloatRNv = ((int)0x8880),
        FloatRgNv = ((int)0x8881),
        FloatRgbNv = ((int)0x8882),
        FloatRgbaNv = ((int)0x8883),
        FloatR16Nv = ((int)0x8884),
        FloatR32Nv = ((int)0x8885),
        FloatRg16Nv = ((int)0x8886),
        FloatRg32Nv = ((int)0x8887),
        FloatRgb16Nv = ((int)0x8888),
        FloatRgb32Nv = ((int)0x8889),
        FloatRgba16Nv = ((int)0x888A),
        FloatRgba32Nv = ((int)0x888B),
        TextureFloatComponentsNv = ((int)0x888C),
        FloatClearColorValueNv = ((int)0x888D),
        FloatRgbaModeNv = ((int)0x888E),
    }

    public enum NvFogDistance : int
    {
        EyePlane = ((int)0x2502),
        FogDistanceModeNv = ((int)0x855A),
        EyeRadialNv = ((int)0x855B),
        EyePlaneAbsoluteNv = ((int)0x855C),
    }

    public enum NvFragmentProgram : int
    {
        MaxFragmentProgramLocalParametersNv = ((int)0x8868),
        FragmentProgramNv = ((int)0x8870),
        MaxTextureCoordsNv = ((int)0x8871),
        MaxTextureImageUnitsNv = ((int)0x8872),
        FragmentProgramBindingNv = ((int)0x8873),
        ProgramErrorStringNv = ((int)0x8874),
    }

    public enum NvFragmentProgram2 : int
    {
        MaxProgramExecInstructionsNv = ((int)0x88F4),
        MaxProgramCallDepthNv = ((int)0x88F5),
        MaxProgramIfDepthNv = ((int)0x88F6),
        MaxProgramLoopDepthNv = ((int)0x88F7),
        MaxProgramLoopCountNv = ((int)0x88F8),
    }

    public enum NvFragmentProgram4 : int
    {
    }

    public enum NvFragmentProgramOption : int
    {
    }

    public enum NvFramebufferMultisampleCoverage : int
    {
        RenderbufferCoverageSamplesNv = ((int)0x8CAB),
        RenderbufferColorSamplesNv = ((int)0x8E10),
        MaxMultisampleCoverageModesNv = ((int)0x8E11),
        MultisampleCoverageModesNv = ((int)0x8E12),
    }

    public enum NvGeometryProgram4 : int
    {
        LinesAdjacencyExt = ((int)0x000A),
        LineStripAdjacencyExt = ((int)0x000B),
        TrianglesAdjacencyExt = ((int)0x000C),
        TriangleStripAdjacencyExt = ((int)0x000D),
        ProgramPointSizeExt = ((int)0x8642),
        GeometryProgramNv = ((int)0x8C26),
        MaxProgramOutputVerticesNv = ((int)0x8C27),
        MaxProgramTotalOutputComponentsNv = ((int)0x8C28),
        MaxGeometryTextureImageUnitsExt = ((int)0x8C29),
        FramebufferAttachmentTextureLayerExt = ((int)0x8CD4),
        FramebufferAttachmentLayeredExt = ((int)0x8DA7),
        FramebufferIncompleteLayerTargetsExt = ((int)0x8DA8),
        FramebufferIncompleteLayerCountExt = ((int)0x8DA9),
        GeometryVerticesOutExt = ((int)0x8DDA),
        GeometryInputTypeExt = ((int)0x8DDB),
        GeometryOutputTypeExt = ((int)0x8DDC),
    }

    public enum NvGeometryShader4 : int
    {
    }

    public enum NvGpuProgram4 : int
    {
        MinProgramTexelOffsetNv = ((int)0x8904),
        MaxProgramTexelOffsetNv = ((int)0x8905),
        ProgramAttribComponentsNv = ((int)0x8906),
        ProgramResultComponentsNv = ((int)0x8907),
        MaxProgramAttribComponentsNv = ((int)0x8908),
        MaxProgramResultComponentsNv = ((int)0x8909),
        MaxProgramGenericAttribsNv = ((int)0x8DA5),
        MaxProgramGenericResultsNv = ((int)0x8DA6),
    }

    public enum NvHalfFloat : int
    {
        HalfFloatNv = ((int)0x140B),
    }

    public enum NvLightMaxExponent : int
    {
        MaxShininessNv = ((int)0x8504),
        MaxSpotExponentNv = ((int)0x8505),
    }

    public enum NvMultisampleFilterHint : int
    {
        MultisampleFilterHintNv = ((int)0x8534),
    }

    public enum NvOcclusionQuery : int
    {
        PixelCounterBitsNv = ((int)0x8864),
        CurrentOcclusionQueryIdNv = ((int)0x8865),
        PixelCountNv = ((int)0x8866),
        PixelCountAvailableNv = ((int)0x8867),
    }

    public enum NvPackedDepthStencil : int
    {
        DepthStencilNv = ((int)0x84F9),
        UnsignedInt248Nv = ((int)0x84FA),
    }

    public enum NvParameterBufferObject : int
    {
        MaxProgramParameterBufferBindingsNv = ((int)0x8DA0),
        MaxProgramParameterBufferSizeNv = ((int)0x8DA1),
        VertexProgramParameterBufferNv = ((int)0x8DA2),
        GeometryProgramParameterBufferNv = ((int)0x8DA3),
        FragmentProgramParameterBufferNv = ((int)0x8DA4),
    }

    public enum NvPixelDataRange : int
    {
        WritePixelDataRangeNv = ((int)0x8878),
        ReadPixelDataRangeNv = ((int)0x8879),
        WritePixelDataRangeLengthNv = ((int)0x887A),
        ReadPixelDataRangeLengthNv = ((int)0x887B),
        WritePixelDataRangePointerNv = ((int)0x887C),
        ReadPixelDataRangePointerNv = ((int)0x887D),
    }

    public enum NvPointSprite : int
    {
        PointSpriteNv = ((int)0x8861),
        CoordReplaceNv = ((int)0x8862),
        PointSpriteRModeNv = ((int)0x8863),
    }

    public enum NvPresentVideo : int
    {
        FrameNv = ((int)0x8E26),
        FieldsNv = ((int)0x8E27),
        CurrentTimeNv = ((int)0x8E28),
        NumFillStreamsNv = ((int)0x8E29),
        PresentTimeNv = ((int)0x8E2A),
        PresentDurationNv = ((int)0x8E2B),
    }

    public enum NvPrimitiveRestart : int
    {
        PrimitiveRestartNv = ((int)0x8558),
        PrimitiveRestartIndexNv = ((int)0x8559),
    }

    public enum NvRegisterCombiners : int
    {
        None = ((int)0),
        Zero = ((int)0),
        Fog = ((int)0x0B60),
        Texture0Arb = ((int)0x84C0),
        Texture1Arb = ((int)0x84C1),
        RegisterCombinersNv = ((int)0x8522),
        VariableANv = ((int)0x8523),
        VariableBNv = ((int)0x8524),
        VariableCNv = ((int)0x8525),
        VariableDNv = ((int)0x8526),
        VariableENv = ((int)0x8527),
        VariableFNv = ((int)0x8528),
        VariableGNv = ((int)0x8529),
        ConstantColor0Nv = ((int)0x852A),
        ConstantColor1Nv = ((int)0x852B),
        PrimaryColorNv = ((int)0x852C),
        SecondaryColorNv = ((int)0x852D),
        Spare0Nv = ((int)0x852E),
        Spare1Nv = ((int)0x852F),
        DiscardNv = ((int)0x8530),
        ETimesFNv = ((int)0x8531),
        Spare0PlusSecondaryColorNv = ((int)0x8532),
        UnsignedIdentityNv = ((int)0x8536),
        UnsignedInvertNv = ((int)0x8537),
        ExpandNormalNv = ((int)0x8538),
        ExpandNegateNv = ((int)0x8539),
        HalfBiasNormalNv = ((int)0x853A),
        HalfBiasNegateNv = ((int)0x853B),
        SignedIdentityNv = ((int)0x853C),
        SignedNegateNv = ((int)0x853D),
        ScaleByTwoNv = ((int)0x853E),
        ScaleByFourNv = ((int)0x853F),
        ScaleByOneHalfNv = ((int)0x8540),
        BiasByNegativeOneHalfNv = ((int)0x8541),
        CombinerInputNv = ((int)0x8542),
        CombinerMappingNv = ((int)0x8543),
        CombinerComponentUsageNv = ((int)0x8544),
        CombinerAbDotProductNv = ((int)0x8545),
        CombinerCdDotProductNv = ((int)0x8546),
        CombinerMuxSumNv = ((int)0x8547),
        CombinerScaleNv = ((int)0x8548),
        CombinerBiasNv = ((int)0x8549),
        CombinerAbOutputNv = ((int)0x854A),
        CombinerCdOutputNv = ((int)0x854B),
        CombinerSumOutputNv = ((int)0x854C),
        MaxGeneralCombinersNv = ((int)0x854D),
        NumGeneralCombinersNv = ((int)0x854E),
        ColorSumClampNv = ((int)0x854F),
        Combiner0Nv = ((int)0x8550),
        Combiner1Nv = ((int)0x8551),
        Combiner2Nv = ((int)0x8552),
        Combiner3Nv = ((int)0x8553),
        Combiner4Nv = ((int)0x8554),
        Combiner5Nv = ((int)0x8555),
        Combiner6Nv = ((int)0x8556),
        Combiner7Nv = ((int)0x8557),
    }

    public enum NvRegisterCombiners2 : int
    {
        PerStageConstantsNv = ((int)0x8535),
    }

    public enum NvTexgenEmboss : int
    {
        EmbossLightNv = ((int)0x855D),
        EmbossConstantNv = ((int)0x855E),
        EmbossMapNv = ((int)0x855F),
    }

    public enum NvTexgenReflection : int
    {
        NormalMapNv = ((int)0x8511),
        ReflectionMapNv = ((int)0x8512),
    }

    public enum NvTextureCompressionVtc : int
    {
    }

    public enum NvTextureEnvCombine4 : int
    {
        Combine4Nv = ((int)0x8503),
        Source3RgbNv = ((int)0x8583),
        Source3AlphaNv = ((int)0x858B),
        Operand3RgbNv = ((int)0x8593),
        Operand3AlphaNv = ((int)0x859B),
    }

    public enum NvTextureExpandNormal : int
    {
        TextureUnsignedRemapModeNv = ((int)0x888F),
    }

    public enum NvTextureRectangle : int
    {
        TextureRectangleNv = ((int)0x84F5),
        TextureBindingRectangleNv = ((int)0x84F6),
        ProxyTextureRectangleNv = ((int)0x84F7),
        MaxRectangleTextureSizeNv = ((int)0x84F8),
    }

    public enum NvTextureShader : int
    {
        OffsetTextureRectangleNv = ((int)0x864C),
        OffsetTextureRectangleScaleNv = ((int)0x864D),
        DotProductTextureRectangleNv = ((int)0x864E),
        RgbaUnsignedDotProductMappingNv = ((int)0x86D9),
        UnsignedIntS8S888Nv = ((int)0x86DA),
        UnsignedInt88S8S8RevNv = ((int)0x86DB),
        DsdtMagIntensityNv = ((int)0x86DC),
        ShaderConsistentNv = ((int)0x86DD),
        TextureShaderNv = ((int)0x86DE),
        ShaderOperationNv = ((int)0x86DF),
        CullModesNv = ((int)0x86E0),
        OffsetTexture2DMatrixNv = ((int)0x86E1),
        OffsetTextureMatrixNv = ((int)0x86E1),
        OffsetTexture2DScaleNv = ((int)0x86E2),
        OffsetTextureScaleNv = ((int)0x86E2),
        OffsetTexture2DBiasNv = ((int)0x86E3),
        OffsetTextureBiasNv = ((int)0x86E3),
        PreviousTextureInputNv = ((int)0x86E4),
        ConstEyeNv = ((int)0x86E5),
        PassThroughNv = ((int)0x86E6),
        CullFragmentNv = ((int)0x86E7),
        OffsetTexture2DNv = ((int)0x86E8),
        DependentArTexture2DNv = ((int)0x86E9),
        DependentGbTexture2DNv = ((int)0x86EA),
        DotProductNv = ((int)0x86EC),
        DotProductDepthReplaceNv = ((int)0x86ED),
        DotProductTexture2DNv = ((int)0x86EE),
        DotProductTextureCubeMapNv = ((int)0x86F0),
        DotProductDiffuseCubeMapNv = ((int)0x86F1),
        DotProductReflectCubeMapNv = ((int)0x86F2),
        DotProductConstEyeReflectCubeMapNv = ((int)0x86F3),
        HiloNv = ((int)0x86F4),
        DsdtNv = ((int)0x86F5),
        DsdtMagNv = ((int)0x86F6),
        DsdtMagVibNv = ((int)0x86F7),
        Hilo16Nv = ((int)0x86F8),
        SignedHiloNv = ((int)0x86F9),
        SignedHilo16Nv = ((int)0x86FA),
        SignedRgbaNv = ((int)0x86FB),
        SignedRgba8Nv = ((int)0x86FC),
        SignedRgbNv = ((int)0x86FE),
        SignedRgb8Nv = ((int)0x86FF),
        SignedLuminanceNv = ((int)0x8701),
        SignedLuminance8Nv = ((int)0x8702),
        SignedLuminanceAlphaNv = ((int)0x8703),
        SignedLuminance8Alpha8Nv = ((int)0x8704),
        SignedAlphaNv = ((int)0x8705),
        SignedAlpha8Nv = ((int)0x8706),
        SignedIntensityNv = ((int)0x8707),
        SignedIntensity8Nv = ((int)0x8708),
        Dsdt8Nv = ((int)0x8709),
        Dsdt8Mag8Nv = ((int)0x870A),
        Dsdt8Mag8Intensity8Nv = ((int)0x870B),
        SignedRgbUnsignedAlphaNv = ((int)0x870C),
        SignedRgb8UnsignedAlpha8Nv = ((int)0x870D),
        HiScaleNv = ((int)0x870E),
        LoScaleNv = ((int)0x870F),
        DsScaleNv = ((int)0x8710),
        DtScaleNv = ((int)0x8711),
        MagnitudeScaleNv = ((int)0x8712),
        VibranceScaleNv = ((int)0x8713),
        HiBiasNv = ((int)0x8714),
        LoBiasNv = ((int)0x8715),
        DsBiasNv = ((int)0x8716),
        DtBiasNv = ((int)0x8717),
        MagnitudeBiasNv = ((int)0x8718),
        VibranceBiasNv = ((int)0x8719),
        TextureBorderValuesNv = ((int)0x871A),
        TextureHiSizeNv = ((int)0x871B),
        TextureLoSizeNv = ((int)0x871C),
        TextureDsSizeNv = ((int)0x871D),
        TextureDtSizeNv = ((int)0x871E),
        TextureMagSizeNv = ((int)0x871F),
    }

    public enum NvTextureShader2 : int
    {
        DotProductTexture3DNv = ((int)0x86EF),
    }

    public enum NvTextureShader3 : int
    {
        OffsetProjectiveTexture2DNv = ((int)0x8850),
        OffsetProjectiveTexture2DScaleNv = ((int)0x8851),
        OffsetProjectiveTextureRectangleNv = ((int)0x8852),
        OffsetProjectiveTextureRectangleScaleNv = ((int)0x8853),
        OffsetHiloTexture2DNv = ((int)0x8854),
        OffsetHiloTextureRectangleNv = ((int)0x8855),
        OffsetHiloProjectiveTexture2DNv = ((int)0x8856),
        OffsetHiloProjectiveTextureRectangleNv = ((int)0x8857),
        DependentHiloTexture2DNv = ((int)0x8858),
        DependentRgbTexture3DNv = ((int)0x8859),
        DependentRgbTextureCubeMapNv = ((int)0x885A),
        DotProductPassThroughNv = ((int)0x885B),
        DotProductTexture1DNv = ((int)0x885C),
        DotProductAffineDepthReplaceNv = ((int)0x885D),
        Hilo8Nv = ((int)0x885E),
        SignedHilo8Nv = ((int)0x885F),
        ForceBlueToOneNv = ((int)0x8860),
    }

    public enum NvTransformFeedback : int
    {
        BackPrimaryColorNv = ((int)0x8C77),
        BackSecondaryColorNv = ((int)0x8C78),
        TextureCoordNv = ((int)0x8C79),
        ClipDistanceNv = ((int)0x8C7A),
        VertexIdNv = ((int)0x8C7B),
        PrimitiveIdNv = ((int)0x8C7C),
        GenericAttribNv = ((int)0x8C7D),
        TransformFeedbackAttribsNv = ((int)0x8C7E),
        TransformFeedbackBufferModeNv = ((int)0x8C7F),
        MaxTransformFeedbackSeparateComponentsNv = ((int)0x8C80),
        ActiveVaryingsNv = ((int)0x8C81),
        ActiveVaryingMaxLengthNv = ((int)0x8C82),
        TransformFeedbackVaryingsNv = ((int)0x8C83),
        TransformFeedbackBufferStartNv = ((int)0x8C84),
        TransformFeedbackBufferSizeNv = ((int)0x8C85),
        TransformFeedbackRecordNv = ((int)0x8C86),
        PrimitivesGeneratedNv = ((int)0x8C87),
        TransformFeedbackPrimitivesWrittenNv = ((int)0x8C88),
        RasterizerDiscardNv = ((int)0x8C89),
        MaxTransformFeedbackInterleavedAttribsNv = ((int)0x8C8A),
        MaxTransformFeedbackSeparateAttribsNv = ((int)0x8C8B),
        InterleavedAttribsNv = ((int)0x8C8C),
        SeparateAttribsNv = ((int)0x8C8D),
        TransformFeedbackBufferNv = ((int)0x8C8E),
        TransformFeedbackBufferBindingNv = ((int)0x8C8F),
    }

    public enum NvTransformFeedback2 : int
    {
        TransformFeedbackNv = ((int)0x8E22),
        TransformFeedbackBufferPausedNv = ((int)0x8E23),
        TransformFeedbackBufferActiveNv = ((int)0x8E24),
        TransformFeedbackBindingNv = ((int)0x8E25),
    }

    public enum NvVertexArrayRange : int
    {
        VertexArrayRangeNv = ((int)0x851D),
        VertexArrayRangeLengthNv = ((int)0x851E),
        VertexArrayRangeValidNv = ((int)0x851F),
        MaxVertexArrayRangeElementNv = ((int)0x8520),
        VertexArrayRangePointerNv = ((int)0x8521),
    }

    public enum NvVertexArrayRange2 : int
    {
        VertexArrayRangeWithoutFlushNv = ((int)0x8533),
    }

    public enum NvVertexProgram : int
    {
        VertexProgramNv = ((int)0x8620),
        VertexStateProgramNv = ((int)0x8621),
        AttribArraySizeNv = ((int)0x8623),
        AttribArrayStrideNv = ((int)0x8624),
        AttribArrayTypeNv = ((int)0x8625),
        CurrentAttribNv = ((int)0x8626),
        ProgramLengthNv = ((int)0x8627),
        ProgramStringNv = ((int)0x8628),
        ModelviewProjectionNv = ((int)0x8629),
        IdentityNv = ((int)0x862A),
        InverseNv = ((int)0x862B),
        TransposeNv = ((int)0x862C),
        InverseTransposeNv = ((int)0x862D),
        MaxTrackMatrixStackDepthNv = ((int)0x862E),
        MaxTrackMatricesNv = ((int)0x862F),
        Matrix0Nv = ((int)0x8630),
        Matrix1Nv = ((int)0x8631),
        Matrix2Nv = ((int)0x8632),
        Matrix3Nv = ((int)0x8633),
        Matrix4Nv = ((int)0x8634),
        Matrix5Nv = ((int)0x8635),
        Matrix6Nv = ((int)0x8636),
        Matrix7Nv = ((int)0x8637),
        CurrentMatrixStackDepthNv = ((int)0x8640),
        CurrentMatrixNv = ((int)0x8641),
        VertexProgramPointSizeNv = ((int)0x8642),
        VertexProgramTwoSideNv = ((int)0x8643),
        ProgramParameterNv = ((int)0x8644),
        AttribArrayPointerNv = ((int)0x8645),
        ProgramTargetNv = ((int)0x8646),
        ProgramResidentNv = ((int)0x8647),
        TrackMatrixNv = ((int)0x8648),
        TrackMatrixTransformNv = ((int)0x8649),
        VertexProgramBindingNv = ((int)0x864A),
        ProgramErrorPositionNv = ((int)0x864B),
        VertexAttribArray0Nv = ((int)0x8650),
        VertexAttribArray1Nv = ((int)0x8651),
        VertexAttribArray2Nv = ((int)0x8652),
        VertexAttribArray3Nv = ((int)0x8653),
        VertexAttribArray4Nv = ((int)0x8654),
        VertexAttribArray5Nv = ((int)0x8655),
        VertexAttribArray6Nv = ((int)0x8656),
        VertexAttribArray7Nv = ((int)0x8657),
        VertexAttribArray8Nv = ((int)0x8658),
        VertexAttribArray9Nv = ((int)0x8659),
        VertexAttribArray10Nv = ((int)0x865A),
        VertexAttribArray11Nv = ((int)0x865B),
        VertexAttribArray12Nv = ((int)0x865C),
        VertexAttribArray13Nv = ((int)0x865D),
        VertexAttribArray14Nv = ((int)0x865E),
        VertexAttribArray15Nv = ((int)0x865F),
        Map1VertexAttrib04Nv = ((int)0x8660),
        Map1VertexAttrib14Nv = ((int)0x8661),
        Map1VertexAttrib24Nv = ((int)0x8662),
        Map1VertexAttrib34Nv = ((int)0x8663),
        Map1VertexAttrib44Nv = ((int)0x8664),
        Map1VertexAttrib54Nv = ((int)0x8665),
        Map1VertexAttrib64Nv = ((int)0x8666),
        Map1VertexAttrib74Nv = ((int)0x8667),
        Map1VertexAttrib84Nv = ((int)0x8668),
        Map1VertexAttrib94Nv = ((int)0x8669),
        Map1VertexAttrib104Nv = ((int)0x866A),
        Map1VertexAttrib114Nv = ((int)0x866B),
        Map1VertexAttrib124Nv = ((int)0x866C),
        Map1VertexAttrib134Nv = ((int)0x866D),
        Map1VertexAttrib144Nv = ((int)0x866E),
        Map1VertexAttrib154Nv = ((int)0x866F),
        Map2VertexAttrib04Nv = ((int)0x8670),
        Map2VertexAttrib14Nv = ((int)0x8671),
        Map2VertexAttrib24Nv = ((int)0x8672),
        Map2VertexAttrib34Nv = ((int)0x8673),
        Map2VertexAttrib44Nv = ((int)0x8674),
        Map2VertexAttrib54Nv = ((int)0x8675),
        Map2VertexAttrib64Nv = ((int)0x8676),
        Map2VertexAttrib74Nv = ((int)0x8677),
        Map2VertexAttrib84Nv = ((int)0x8678),
        Map2VertexAttrib94Nv = ((int)0x8679),
        Map2VertexAttrib104Nv = ((int)0x867A),
        Map2VertexAttrib114Nv = ((int)0x867B),
        Map2VertexAttrib124Nv = ((int)0x867C),
        Map2VertexAttrib134Nv = ((int)0x867D),
        Map2VertexAttrib144Nv = ((int)0x867E),
        Map2VertexAttrib154Nv = ((int)0x867F),
    }

    public enum NvVertexProgram11 : int
    {
    }

    public enum NvVertexProgram2 : int
    {
    }

    public enum NvVertexProgram2Option : int
    {
        MaxProgramExecInstructionsNv = ((int)0x88F4),
        MaxProgramCallDepthNv = ((int)0x88F5),
    }

    public enum NvVertexProgram3 : int
    {
        MaxVertexTextureImageUnitsArb = ((int)0x8B4C),
    }

    public enum NvVertexProgram4 : int
    {
        VertexAttribArrayIntegerNv = ((int)0x88FD),
    }

    public enum OesReadFormat : int
    {
        ImplementationColorReadTypeOes = ((int)0x8B9A),
        ImplementationColorReadFormatOes = ((int)0x8B9B),
    }

    public enum OmlInterlace : int
    {
        InterlaceOml = ((int)0x8980),
        InterlaceReadOml = ((int)0x8981),
    }

    public enum OmlResample : int
    {
        PackResampleOml = ((int)0x8984),
        UnpackResampleOml = ((int)0x8985),
        ResampleReplicateOml = ((int)0x8986),
        ResampleZeroFillOml = ((int)0x8987),
        ResampleAverageOml = ((int)0x8988),
        ResampleDecimateOml = ((int)0x8989),
    }

    public enum OmlSubsample : int
    {
        FormatSubsample2424Oml = ((int)0x8982),
        FormatSubsample244244Oml = ((int)0x8983),
    }

    public enum PgiMiscHints : int
    {
        PreferDoublebufferHintPgi = ((int)0x1A1F8),
        ConserveMemoryHintPgi = ((int)0x1A1FD),
        ReclaimMemoryHintPgi = ((int)0x1A1FE),
        NativeGraphicsHandlePgi = ((int)0x1A202),
        NativeGraphicsBeginHintPgi = ((int)0x1A203),
        NativeGraphicsEndHintPgi = ((int)0x1A204),
        AlwaysFastHintPgi = ((int)0x1A20C),
        AlwaysSoftHintPgi = ((int)0x1A20D),
        AllowDrawObjHintPgi = ((int)0x1A20E),
        AllowDrawWinHintPgi = ((int)0x1A20F),
        AllowDrawFrgHintPgi = ((int)0x1A210),
        AllowDrawMemHintPgi = ((int)0x1A211),
        StrictDepthfuncHintPgi = ((int)0x1A216),
        StrictLightingHintPgi = ((int)0x1A217),
        StrictScissorHintPgi = ((int)0x1A218),
        FullStippleHintPgi = ((int)0x1A219),
        ClipNearHintPgi = ((int)0x1A220),
        ClipFarHintPgi = ((int)0x1A221),
        WideLineHintPgi = ((int)0x1A222),
        BackNormalsHintPgi = ((int)0x1A223),
    }

    public enum PgiVertexHints : int
    {
        Vertex23BitPgi = ((int)0x00000004),
        Vertex4BitPgi = ((int)0x00000008),
        Color3BitPgi = ((int)0x00010000),
        Color4BitPgi = ((int)0x00020000),
        EdgeflagBitPgi = ((int)0x00040000),
        IndexBitPgi = ((int)0x00080000),
        MatAmbientBitPgi = ((int)0x00100000),
        MatAmbientAndDiffuseBitPgi = ((int)0x00200000),
        MatDiffuseBitPgi = ((int)0x00400000),
        MatEmissionBitPgi = ((int)0x00800000),
        MatColorIndexesBitPgi = ((int)0x01000000),
        MatShininessBitPgi = ((int)0x02000000),
        MatSpecularBitPgi = ((int)0x04000000),
        NormalBitPgi = ((int)0x08000000),
        Texcoord1BitPgi = ((int)0x10000000),
        VertexDataHintPgi = ((int)0x1A22A),
        VertexConsistentHintPgi = ((int)0x1A22B),
        MaterialSideHintPgi = ((int)0x1A22C),
        MaxVertexHintPgi = ((int)0x1A22D),
        Texcoord2BitPgi = ((int)0x20000000),
        Texcoord3BitPgi = ((int)0x40000000),
        Texcoord4BitPgi = unchecked((int)0x80000000),
    }

    public enum PixelCopyType : int
    {
        Color = ((int)0x1800),
        Depth = ((int)0x1801),
        Stencil = ((int)0x1802),
    }

    public enum PixelFormat : int
    {
        ColorIndex = ((int)0x1900),
        StencilIndex = ((int)0x1901),
        DepthComponent = ((int)0x1902),
        Red = ((int)0x1903),
        Green = ((int)0x1904),
        Blue = ((int)0x1905),
        Alpha = ((int)0x1906),
        Rgb = ((int)0x1907),
        Rgba = ((int)0x1908),
        Luminance = ((int)0x1909),
        LuminanceAlpha = ((int)0x190A),
        AbgrExt = ((int)0x8000),
        CmykExt = ((int)0x800C),
        CmykaExt = ((int)0x800D),
        Bgr = ((int)0x80E0),
        Bgra = ((int)0x80E1),
        Ycrcb422Sgix = ((int)0x81BB),
        Ycrcb444Sgix = ((int)0x81BC),
        Rg = ((int)0x8227),
        RgInteger = ((int)0x8228),
        DepthStencil = ((int)0x84F9),
        RedInteger = ((int)0x8D94),
        GreenInteger = ((int)0x8D95),
        BlueInteger = ((int)0x8D96),
        AlphaInteger = ((int)0x8D97),
        RgbInteger = ((int)0x8D98),
        RgbaInteger = ((int)0x8D99),
        BgrInteger = ((int)0x8D9A),
        BgraInteger = ((int)0x8D9B),
    }

    public enum PixelInternalFormat : int
    {
        DepthComponent = ((int)0x1902),
        Alpha = ((int)0x1906),
        Rgb = ((int)0x1907),
        Rgba = ((int)0x1908),
        Luminance = ((int)0x1909),
        LuminanceAlpha = ((int)0x190A),
        R3G3B2 = ((int)0x2A10),
        Alpha4 = ((int)0x803B),
        Alpha8 = ((int)0x803C),
        Alpha12 = ((int)0x803D),
        Alpha16 = ((int)0x803E),
        Luminance4 = ((int)0x803F),
        Luminance8 = ((int)0x8040),
        Luminance12 = ((int)0x8041),
        Luminance16 = ((int)0x8042),
        Luminance4Alpha4 = ((int)0x8043),
        Luminance6Alpha2 = ((int)0x8044),
        Luminance8Alpha8 = ((int)0x8045),
        Luminance12Alpha4 = ((int)0x8046),
        Luminance12Alpha12 = ((int)0x8047),
        Luminance16Alpha16 = ((int)0x8048),
        Intensity = ((int)0x8049),
        Intensity4 = ((int)0x804A),
        Intensity8 = ((int)0x804B),
        Intensity12 = ((int)0x804C),
        Intensity16 = ((int)0x804D),
        Rgb2Ext = ((int)0x804E),
        Rgb4 = ((int)0x804F),
        Rgb5 = ((int)0x8050),
        Rgb8 = ((int)0x8051),
        Rgb10 = ((int)0x8052),
        Rgb12 = ((int)0x8053),
        Rgb16 = ((int)0x8054),
        Rgba2 = ((int)0x8055),
        Rgba4 = ((int)0x8056),
        Rgb5A1 = ((int)0x8057),
        Rgba8 = ((int)0x8058),
        Rgb10A2 = ((int)0x8059),
        Rgba12 = ((int)0x805A),
        Rgba16 = ((int)0x805B),
        DualAlpha4Sgis = ((int)0x8110),
        DualAlpha8Sgis = ((int)0x8111),
        DualAlpha12Sgis = ((int)0x8112),
        DualAlpha16Sgis = ((int)0x8113),
        DualLuminance4Sgis = ((int)0x8114),
        DualLuminance8Sgis = ((int)0x8115),
        DualLuminance12Sgis = ((int)0x8116),
        DualLuminance16Sgis = ((int)0x8117),
        DualIntensity4Sgis = ((int)0x8118),
        DualIntensity8Sgis = ((int)0x8119),
        DualIntensity12Sgis = ((int)0x811A),
        DualIntensity16Sgis = ((int)0x811B),
        DualLuminanceAlpha4Sgis = ((int)0x811C),
        DualLuminanceAlpha8Sgis = ((int)0x811D),
        QuadAlpha4Sgis = ((int)0x811E),
        QuadAlpha8Sgis = ((int)0x811F),
        QuadLuminance4Sgis = ((int)0x8120),
        QuadLuminance8Sgis = ((int)0x8121),
        QuadIntensity4Sgis = ((int)0x8122),
        QuadIntensity8Sgis = ((int)0x8123),
        DepthComponent16 = ((int)0x81a5),
        DepthComponent16Sgix = ((int)0x81A5),
        DepthComponent24 = ((int)0x81a6),
        DepthComponent24Sgix = ((int)0x81A6),
        DepthComponent32 = ((int)0x81a7),
        DepthComponent32Sgix = ((int)0x81A7),
        CompressedRed = ((int)0x8225),
        CompressedRg = ((int)0x8226),
        R8 = ((int)0x8229),
        R16 = ((int)0x822A),
        Rg8 = ((int)0x822B),
        Rg16 = ((int)0x822C),
        R16f = ((int)0x822D),
        R32f = ((int)0x822E),
        Rg16f = ((int)0x822F),
        Rg32f = ((int)0x8230),
        R8i = ((int)0x8231),
        R8ui = ((int)0x8232),
        R16i = ((int)0x8233),
        R16ui = ((int)0x8234),
        R32i = ((int)0x8235),
        R32ui = ((int)0x8236),
        Rg8i = ((int)0x8237),
        Rg8ui = ((int)0x8238),
        Rg16i = ((int)0x8239),
        Rg16ui = ((int)0x823A),
        Rg32i = ((int)0x823B),
        Rg32ui = ((int)0x823C),
        CompressedRgbS3tcDxt1Ext = ((int)0x83F0),
        CompressedRgbaS3tcDxt1Ext = ((int)0x83F1),
        CompressedRgbaS3tcDxt3Ext = ((int)0x83F2),
        CompressedRgbaS3tcDxt5Ext = ((int)0x83F3),
        CompressedAlpha = ((int)0x84E9),
        CompressedLuminance = ((int)0x84EA),
        CompressedLuminanceAlpha = ((int)0x84EB),
        CompressedIntensity = ((int)0x84EC),
        CompressedRgb = ((int)0x84ED),
        CompressedRgba = ((int)0x84EE),
        DepthStencil = ((int)0x84F9),
        Rgba32f = ((int)0x8814),
        Rgb32f = ((int)0x8815),
        Rgba16f = ((int)0x881A),
        Rgb16f = ((int)0x881B),
        Depth24Stencil8 = ((int)0x88F0),
        R11fG11fB10f = ((int)0x8C3A),
        Rgb9E5 = ((int)0x8C3D),
        Srgb = ((int)0x8C40),
        Srgb8 = ((int)0x8C41),
        SrgbAlpha = ((int)0x8C42),
        Srgb8Alpha8 = ((int)0x8C43),
        SluminanceAlpha = ((int)0x8C44),
        Sluminance8Alpha8 = ((int)0x8C45),
        Sluminance = ((int)0x8C46),
        Sluminance8 = ((int)0x8C47),
        CompressedSrgb = ((int)0x8C48),
        CompressedSrgbAlpha = ((int)0x8C49),
        CompressedSluminance = ((int)0x8C4A),
        CompressedSluminanceAlpha = ((int)0x8C4B),
        CompressedSrgbS3tcDxt1Ext = ((int)0x8C4C),
        CompressedSrgbAlphaS3tcDxt1Ext = ((int)0x8C4D),
        CompressedSrgbAlphaS3tcDxt3Ext = ((int)0x8C4E),
        CompressedSrgbAlphaS3tcDxt5Ext = ((int)0x8C4F),
        DepthComponent32f = ((int)0x8CAC),
        Depth32fStencil8 = ((int)0x8CAD),
        Rgba32ui = ((int)0x8D70),
        Rgb32ui = ((int)0x8D71),
        Rgba16ui = ((int)0x8D76),
        Rgb16ui = ((int)0x8D77),
        Rgba8ui = ((int)0x8D7C),
        Rgb8ui = ((int)0x8D7D),
        Rgba32i = ((int)0x8D82),
        Rgb32i = ((int)0x8D83),
        Rgba16i = ((int)0x8D88),
        Rgb16i = ((int)0x8D89),
        Rgba8i = ((int)0x8D8E),
        Rgb8i = ((int)0x8D8F),
        Float32UnsignedInt248Rev = ((int)0x8DAD),
        CompressedRedRgtc1 = ((int)0x8DBB),
        CompressedSignedRedRgtc1 = ((int)0x8DBC),
        CompressedRgRgtc2 = ((int)0x8DBD),
        CompressedSignedRgRgtc2 = ((int)0x8DBE),
        One = ((int)1),
        Two = ((int)2),
        Three = ((int)3),
        Four = ((int)4),
    }

    public enum PixelMap : int
    {
        PixelMapIToI = ((int)0x0C70),
        PixelMapSToS = ((int)0x0C71),
        PixelMapIToR = ((int)0x0C72),
        PixelMapIToG = ((int)0x0C73),
        PixelMapIToB = ((int)0x0C74),
        PixelMapIToA = ((int)0x0C75),
        PixelMapRToR = ((int)0x0C76),
        PixelMapGToG = ((int)0x0C77),
        PixelMapBToB = ((int)0x0C78),
        PixelMapAToA = ((int)0x0C79),
    }

    public enum PixelStoreParameter : int
    {
        UnpackSwapBytes = ((int)0x0CF0),
        UnpackLsbFirst = ((int)0x0CF1),
        UnpackRowLength = ((int)0x0CF2),
        UnpackSkipRows = ((int)0x0CF3),
        UnpackSkipPixels = ((int)0x0CF4),
        UnpackAlignment = ((int)0x0CF5),
        PackSwapBytes = ((int)0x0D00),
        PackLsbFirst = ((int)0x0D01),
        PackRowLength = ((int)0x0D02),
        PackSkipRows = ((int)0x0D03),
        PackSkipPixels = ((int)0x0D04),
        PackAlignment = ((int)0x0D05),
        PackSkipImages = ((int)0x806B),
        PackSkipImagesExt = ((int)0x806B),
        PackImageHeight = ((int)0x806C),
        PackImageHeightExt = ((int)0x806C),
        UnpackSkipImages = ((int)0x806D),
        UnpackSkipImagesExt = ((int)0x806D),
        UnpackImageHeight = ((int)0x806E),
        UnpackImageHeightExt = ((int)0x806E),
        PackSkipVolumesSgis = ((int)0x8130),
        PackImageDepthSgis = ((int)0x8131),
        UnpackSkipVolumesSgis = ((int)0x8132),
        UnpackImageDepthSgis = ((int)0x8133),
        PixelTileWidthSgix = ((int)0x8140),
        PixelTileHeightSgix = ((int)0x8141),
        PixelTileGridWidthSgix = ((int)0x8142),
        PixelTileGridHeightSgix = ((int)0x8143),
        PixelTileGridDepthSgix = ((int)0x8144),
        PixelTileCacheSizeSgix = ((int)0x8145),
        PackResampleSgix = ((int)0x842C),
        UnpackResampleSgix = ((int)0x842D),
        PackSubsampleRateSgix = ((int)0x85A0),
        UnpackSubsampleRateSgix = ((int)0x85A1),
    }

    public enum PixelStoreResampleMode : int
    {
        ResampleReplicateSgix = ((int)0x842E),
        ResampleZeroFillSgix = ((int)0x842F),
        ResampleDecimateSgix = ((int)0x8430),
    }

    public enum PixelStoreSubsampleRate : int
    {
        PixelSubsample4444Sgix = ((int)0x85A2),
        PixelSubsample2424Sgix = ((int)0x85A3),
        PixelSubsample4242Sgix = ((int)0x85A4),
    }

    public enum PixelTexGenMode : int
    {
        None = ((int)0),
        Rgb = ((int)0x1907),
        Rgba = ((int)0x1908),
        Luminance = ((int)0x1909),
        LuminanceAlpha = ((int)0x190A),
        PixelTexGenAlphaReplaceSgix = ((int)0x8187),
        PixelTexGenAlphaNoReplaceSgix = ((int)0x8188),
        PixelTexGenAlphaLsSgix = ((int)0x8189),
        PixelTexGenAlphaMsSgix = ((int)0x818A),
    }

    public enum PixelTexGenParameterNameSgis : int
    {
        PixelFragmentRgbSourceSgis = ((int)0x8354),
        PixelFragmentAlphaSourceSgis = ((int)0x8355),
    }

    public enum PixelTransferParameter : int
    {
        MapColor = ((int)0x0D10),
        MapStencil = ((int)0x0D11),
        IndexShift = ((int)0x0D12),
        IndexOffset = ((int)0x0D13),
        RedScale = ((int)0x0D14),
        RedBias = ((int)0x0D15),
        GreenScale = ((int)0x0D18),
        GreenBias = ((int)0x0D19),
        BlueScale = ((int)0x0D1A),
        BlueBias = ((int)0x0D1B),
        AlphaScale = ((int)0x0D1C),
        AlphaBias = ((int)0x0D1D),
        DepthScale = ((int)0x0D1E),
        DepthBias = ((int)0x0D1F),
        PostConvolutionRedScaleExt = ((int)0x801C),
        PostConvolutionGreenScaleExt = ((int)0x801D),
        PostConvolutionBlueScaleExt = ((int)0x801E),
        PostConvolutionAlphaScaleExt = ((int)0x801F),
        PostConvolutionRedBiasExt = ((int)0x8020),
        PostConvolutionGreenBiasExt = ((int)0x8021),
        PostConvolutionBlueBiasExt = ((int)0x8022),
        PostConvolutionAlphaBiasExt = ((int)0x8023),
        PostColorMatrixRedScaleSgi = ((int)0x80B4),
        PostColorMatrixGreenScaleSgi = ((int)0x80B5),
        PostColorMatrixBlueScaleSgi = ((int)0x80B6),
        PostColorMatrixAlphaScaleSgi = ((int)0x80B7),
        PostColorMatrixRedBiasSgi = ((int)0x80B8),
        PostColorMatrixGreenBiasSgi = ((int)0x80B9),
        PostColorMatrixBlueBiasSgi = ((int)0x80BA),
        PostColorMatrixAlphaBiasSgi = ((int)0x80BB),
    }

    public enum PixelType : int
    {
        Byte = ((int)0x1400),
        UnsignedByte = ((int)0x1401),
        Short = ((int)0x1402),
        UnsignedShort = ((int)0x1403),
        Int = ((int)0x1404),
        UnsignedInt = ((int)0x1405),
        Float = ((int)0x1406),
        HalfFloat = ((int)0x140B),
        Bitmap = ((int)0x1A00),
        UnsignedByte332 = ((int)0x8032),
        UnsignedByte332Ext = ((int)0x8032),
        UnsignedShort4444 = ((int)0x8033),
        UnsignedShort4444Ext = ((int)0x8033),
        UnsignedShort5551 = ((int)0x8034),
        UnsignedShort5551Ext = ((int)0x8034),
        UnsignedInt8888 = ((int)0x8035),
        UnsignedInt8888Ext = ((int)0x8035),
        UnsignedInt1010102 = ((int)0x8036),
        UnsignedInt1010102Ext = ((int)0x8036),
        UnsignedByte233Reversed = ((int)0x8362),
        UnsignedShort565 = ((int)0x8363),
        UnsignedShort565Reversed = ((int)0x8364),
        UnsignedShort4444Reversed = ((int)0x8365),
        UnsignedShort1555Reversed = ((int)0x8366),
        UnsignedInt8888Reversed = ((int)0x8367),
        UnsignedInt2101010Reversed = ((int)0x8368),
        UnsignedInt248 = ((int)0x84FA),
        UnsignedInt10F11F11FRev = ((int)0x8C3B),
        UnsignedInt5999Rev = ((int)0x8C3E),
        Float32UnsignedInt248Rev = ((int)0x8DAD),
    }

    public enum PointParameterName : int
    {
        PointSizeMin = ((int)0x8126),
        PointSizeMax = ((int)0x8127),
        PointFadeThresholdSize = ((int)0x8128),
        PointDistanceAttenuation = ((int)0x8129),
        PointSpriteCoordOrigin = ((int)0x8CA0),
    }

    public enum PointParameterNameSgis : int
    {
        PointSizeMinSgis = ((int)0x8126),
        PointSizeMaxSgis = ((int)0x8127),
        PointFadeThresholdSizeSgis = ((int)0x8128),
        DistanceAttenuationSgis = ((int)0x8129),
    }

    public enum PointSpriteCoordOriginParameter : int
    {
        LowerLeft = ((int)0x8CA1),
        UpperLeft = ((int)0x8CA2),
    }

    public enum PolygonMode : int
    {
        Point = ((int)0x1B00),
        Line = ((int)0x1B01),
        Fill = ((int)0x1B02),
    }

    public enum ProgramParameter : int
    {
        ActiveUniformBlockMaxNameLength = ((int)0x8A35),
        ActiveUniformBlocks = ((int)0x8A36),
        DeleteStatus = ((int)0x8B80),
        LinkStatus = ((int)0x8B82),
        ValidateStatus = ((int)0x8B83),
        InfoLogLength = ((int)0x8B84),
        AttachedShaders = ((int)0x8B85),
        ActiveUniforms = ((int)0x8B86),
        ActiveUniformMaxLength = ((int)0x8B87),
        ActiveAttributes = ((int)0x8B89),
        ActiveAttributeMaxLength = ((int)0x8B8A),
        TransformFeedbackVaryingMaxLength = ((int)0x8C76),
        TransformFeedbackBufferMode = ((int)0x8C7F),
        TransformFeedbackVaryings = ((int)0x8C83),
        GeometryVerticesOut = ((int)0x8DDA),
        GeometryInputType = ((int)0x8DDB),
        GeometryOutputType = ((int)0x8DDC),
    }

    public enum ProvokingVertexMode : int
    {
        FirstVertexConvention = ((int)0x8E4D),
        LastVertexConvention = ((int)0x8E4E),
    }

    public enum QueryTarget : int
    {
        SamplesPassed = ((int)0x8914),
        PrimitivesGenerated = ((int)0x8C87),
        TransformFeedbackPrimitivesWritten = ((int)0x8C88),
    }

    public enum ReadBufferMode : int
    {
        FrontLeft = ((int)0x0400),
        FrontRight = ((int)0x0401),
        BackLeft = ((int)0x0402),
        BackRight = ((int)0x0403),
        Front = ((int)0x0404),
        Back = ((int)0x0405),
        Left = ((int)0x0406),
        Right = ((int)0x0407),
        Aux0 = ((int)0x0409),
        Aux1 = ((int)0x040A),
        Aux2 = ((int)0x040B),
        Aux3 = ((int)0x040C),
        ColorAttachment0 = ((int)0x8CE0),
        ColorAttachment1 = ((int)0x8CE1),
        ColorAttachment2 = ((int)0x8CE2),
        ColorAttachment3 = ((int)0x8CE3),
        ColorAttachment4 = ((int)0x8CE4),
        ColorAttachment5 = ((int)0x8CE5),
        ColorAttachment6 = ((int)0x8CE6),
        ColorAttachment7 = ((int)0x8CE7),
        ColorAttachment8 = ((int)0x8CE8),
        ColorAttachment9 = ((int)0x8CE9),
        ColorAttachment10 = ((int)0x8CEA),
        ColorAttachment11 = ((int)0x8CEB),
        ColorAttachment12 = ((int)0x8CEC),
        ColorAttachment13 = ((int)0x8CED),
        ColorAttachment14 = ((int)0x8CEE),
        ColorAttachment15 = ((int)0x8CEF),
    }

    public enum RenderbufferParameterName : int
    {
        RenderbufferSamples = ((int)0x8CAB),
        RenderbufferWidth = ((int)0x8D42),
        RenderbufferWidthExt = ((int)0x8D42),
        RenderbufferHeight = ((int)0x8D43),
        RenderbufferHeightExt = ((int)0x8D43),
        RenderbufferInternalFormat = ((int)0x8D44),
        RenderbufferInternalFormatExt = ((int)0x8D44),
        RenderbufferRedSize = ((int)0x8D50),
        RenderbufferRedSizeExt = ((int)0x8D50),
        RenderbufferGreenSize = ((int)0x8D51),
        RenderbufferGreenSizeExt = ((int)0x8D51),
        RenderbufferBlueSize = ((int)0x8D52),
        RenderbufferBlueSizeExt = ((int)0x8D52),
        RenderbufferAlphaSize = ((int)0x8D53),
        RenderbufferAlphaSizeExt = ((int)0x8D53),
        RenderbufferDepthSize = ((int)0x8D54),
        RenderbufferDepthSizeExt = ((int)0x8D54),
        RenderbufferStencilSize = ((int)0x8D55),
        RenderbufferStencilSizeExt = ((int)0x8D55),
    }

    public enum RenderbufferStorage : int
    {
        R3G3B2 = ((int)0x2A10),
        Alpha4 = ((int)0x803B),
        Alpha8 = ((int)0x803C),
        Alpha12 = ((int)0x803D),
        Alpha16 = ((int)0x803E),
        Rgb4 = ((int)0x804F),
        Rgb5 = ((int)0x8050),
        Rgb8 = ((int)0x8051),
        Rgb10 = ((int)0x8052),
        Rgb12 = ((int)0x8053),
        Rgb16 = ((int)0x8054),
        Rgba2 = ((int)0x8055),
        Rgba4 = ((int)0x8056),
        Rgba8 = ((int)0x8058),
        Rgb10A2 = ((int)0x8059),
        Rgba12 = ((int)0x805A),
        Rgba16 = ((int)0x805B),
        DepthComponent16 = ((int)0x81a5),
        DepthComponent24 = ((int)0x81a6),
        DepthComponent32 = ((int)0x81a7),
        R8 = ((int)0x8229),
        R16 = ((int)0x822A),
        Rg8 = ((int)0x822B),
        Rg16 = ((int)0x822C),
        R16f = ((int)0x822D),
        R32f = ((int)0x822E),
        Rg16f = ((int)0x822F),
        Rg32f = ((int)0x8230),
        R8i = ((int)0x8231),
        R8ui = ((int)0x8232),
        R16i = ((int)0x8233),
        R16ui = ((int)0x8234),
        R32i = ((int)0x8235),
        R32ui = ((int)0x8236),
        Rg8i = ((int)0x8237),
        Rg8ui = ((int)0x8238),
        Rg16i = ((int)0x8239),
        Rg16ui = ((int)0x823A),
        Rg32i = ((int)0x823B),
        Rg32ui = ((int)0x823C),
        Rgba32f = ((int)0x8814),
        Rgb32f = ((int)0x8815),
        Rgba16f = ((int)0x881A),
        Rgb16f = ((int)0x881B),
        Depth24Stencil8 = ((int)0x88F0),
        R11fG11fB10f = ((int)0x8C3A),
        Rgb9E5 = ((int)0x8C3D),
        Srgb8 = ((int)0x8C41),
        Srgb8Alpha8 = ((int)0x8C43),
        DepthComponent32f = ((int)0x8CAC),
        Depth32fStencil8 = ((int)0x8CAD),
        StencilIndex1 = ((int)0x8D46),
        StencilIndex1Ext = ((int)0x8D46),
        StencilIndex4 = ((int)0x8D47),
        StencilIndex4Ext = ((int)0x8D47),
        StencilIndex8 = ((int)0x8D48),
        StencilIndex8Ext = ((int)0x8D48),
        StencilIndex16 = ((int)0x8D49),
        StencilIndex16Ext = ((int)0x8D49),
        Rgba32ui = ((int)0x8D70),
        Rgb32ui = ((int)0x8D71),
        Rgba16ui = ((int)0x8D76),
        Rgb16ui = ((int)0x8D77),
        Rgba8ui = ((int)0x8D7C),
        Rgb8ui = ((int)0x8D7D),
        Rgba32i = ((int)0x8D82),
        Rgb32i = ((int)0x8D83),
        Rgba16i = ((int)0x8D88),
        Rgb16i = ((int)0x8D89),
        Rgba8i = ((int)0x8D8E),
        Rgb8i = ((int)0x8D8F),
    }

    public enum RenderbufferTarget : int
    {
        Renderbuffer = ((int)0x8D41),
        RenderbufferExt = ((int)0x8D41),
    }

    public enum RenderingMode : int
    {
        Render = ((int)0x1C00),
        Feedback = ((int)0x1C01),
        Select = ((int)0x1C02),
    }

    public enum RendScreenCoordinates : int
    {
        ScreenCoordinatesRend = ((int)0x8490),
        InvertedScreenWRend = ((int)0x8491),
    }

    public enum S3S3tc : int
    {
        RgbS3tc = ((int)0x83A0),
        Rgb4S3tc = ((int)0x83A1),
        RgbaS3tc = ((int)0x83A2),
        Rgba4S3tc = ((int)0x83A3),
    }

    public enum SamplePatternSgis : int
    {
        Gl1PassSgis = ((int)0x80A1),
        Gl2Pass0Sgis = ((int)0x80A2),
        Gl2Pass1Sgis = ((int)0x80A3),
        Gl4Pass0Sgis = ((int)0x80A4),
        Gl4Pass1Sgis = ((int)0x80A5),
        Gl4Pass2Sgis = ((int)0x80A6),
        Gl4Pass3Sgis = ((int)0x80A7),
    }

    public enum SeparableTarget : int
    {
        Separable2D = ((int)0x8012),
    }

    public enum SeparableTargetExt : int
    {
        Separable2DExt = ((int)0x8012),
    }

    public enum SgiColorMatrix : int
    {
        ColorMatrixSgi = ((int)0x80B1),
        ColorMatrixStackDepthSgi = ((int)0x80B2),
        MaxColorMatrixStackDepthSgi = ((int)0x80B3),
        PostColorMatrixRedScaleSgi = ((int)0x80B4),
        PostColorMatrixGreenScaleSgi = ((int)0x80B5),
        PostColorMatrixBlueScaleSgi = ((int)0x80B6),
        PostColorMatrixAlphaScaleSgi = ((int)0x80B7),
        PostColorMatrixRedBiasSgi = ((int)0x80B8),
        PostColorMatrixGreenBiasSgi = ((int)0x80B9),
        PostColorMatrixBlueBiasSgi = ((int)0x80BA),
        PostColorMatrixAlphaBiasSgi = ((int)0x80BB),
    }

    public enum SgiColorTable : int
    {
        ColorTableSgi = ((int)0x80D0),
        PostConvolutionColorTableSgi = ((int)0x80D1),
        PostColorMatrixColorTableSgi = ((int)0x80D2),
        ProxyColorTableSgi = ((int)0x80D3),
        ProxyPostConvolutionColorTableSgi = ((int)0x80D4),
        ProxyPostColorMatrixColorTableSgi = ((int)0x80D5),
        ColorTableScaleSgi = ((int)0x80D6),
        ColorTableBiasSgi = ((int)0x80D7),
        ColorTableFormatSgi = ((int)0x80D8),
        ColorTableWidthSgi = ((int)0x80D9),
        ColorTableRedSizeSgi = ((int)0x80DA),
        ColorTableGreenSizeSgi = ((int)0x80DB),
        ColorTableBlueSizeSgi = ((int)0x80DC),
        ColorTableAlphaSizeSgi = ((int)0x80DD),
        ColorTableLuminanceSizeSgi = ((int)0x80DE),
        ColorTableIntensitySizeSgi = ((int)0x80DF),
    }

    public enum SgiDepthPassInstrument : int
    {
        DepthPassInstrumentSgix = ((int)0x8310),
        DepthPassInstrumentCountersSgix = ((int)0x8311),
        DepthPassInstrumentMaxSgix = ((int)0x8312),
    }

    public enum SgisDetailTexture : int
    {
        DetailTexture2DSgis = ((int)0x8095),
        DetailTexture2DBindingSgis = ((int)0x8096),
        LinearDetailSgis = ((int)0x8097),
        LinearDetailAlphaSgis = ((int)0x8098),
        LinearDetailColorSgis = ((int)0x8099),
        DetailTextureLevelSgis = ((int)0x809A),
        DetailTextureModeSgis = ((int)0x809B),
        DetailTextureFuncPointsSgis = ((int)0x809C),
    }

    public enum SgisFogFunction : int
    {
        FogFuncSgis = ((int)0x812A),
        FogFuncPointsSgis = ((int)0x812B),
        MaxFogFuncPointsSgis = ((int)0x812C),
    }

    public enum SgisGenerateMipmap : int
    {
        GenerateMipmapSgis = ((int)0x8191),
        GenerateMipmapHintSgis = ((int)0x8192),
        GeometryDeformationSgix = ((int)0x8194),
        TextureDeformationSgix = ((int)0x8195),
        DeformationsMaskSgix = ((int)0x8196),
        MaxDeformationOrderSgix = ((int)0x8197),
    }

    public enum SgisMultisample : int
    {
        MultisampleSgis = ((int)0x809D),
        SampleAlphaToMaskSgis = ((int)0x809E),
        SampleAlphaToOneSgis = ((int)0x809F),
        SampleMaskSgis = ((int)0x80A0),
        Gl1PassSgis = ((int)0x80A1),
        Gl2Pass0Sgis = ((int)0x80A2),
        Gl2Pass1Sgis = ((int)0x80A3),
        Gl4Pass0Sgis = ((int)0x80A4),
        Gl4Pass1Sgis = ((int)0x80A5),
        Gl4Pass2Sgis = ((int)0x80A6),
        Gl4Pass3Sgis = ((int)0x80A7),
        SampleBuffersSgis = ((int)0x80A8),
        SamplesSgis = ((int)0x80A9),
        SampleMaskValueSgis = ((int)0x80AA),
        SampleMaskInvertSgis = ((int)0x80AB),
        SamplePatternSgis = ((int)0x80AC),
    }

    public enum SgisPixelTexture : int
    {
        PixelTextureSgis = ((int)0x8353),
        PixelFragmentRgbSourceSgis = ((int)0x8354),
        PixelFragmentAlphaSourceSgis = ((int)0x8355),
        PixelGroupColorSgis = ((int)0x8356),
    }

    public enum SgisPointLineTexgen : int
    {
        EyeDistanceToPointSgis = ((int)0x81F0),
        ObjectDistanceToPointSgis = ((int)0x81F1),
        EyeDistanceToLineSgis = ((int)0x81F2),
        ObjectDistanceToLineSgis = ((int)0x81F3),
        EyePointSgis = ((int)0x81F4),
        ObjectPointSgis = ((int)0x81F5),
        EyeLineSgis = ((int)0x81F6),
        ObjectLineSgis = ((int)0x81F7),
    }

    public enum SgisPointParameters : int
    {
        PointSizeMinSgis = ((int)0x8126),
        PointSizeMaxSgis = ((int)0x8127),
        PointFadeThresholdSizeSgis = ((int)0x8128),
        DistanceAttenuationSgis = ((int)0x8129),
    }

    public enum SgisSharpenTexture : int
    {
        LinearSharpenSgis = ((int)0x80AD),
        LinearSharpenAlphaSgis = ((int)0x80AE),
        LinearSharpenColorSgis = ((int)0x80AF),
        SharpenTextureFuncPointsSgis = ((int)0x80B0),
    }

    public enum SgisTexture4D : int
    {
        PackSkipVolumesSgis = ((int)0x8130),
        PackImageDepthSgis = ((int)0x8131),
        UnpackSkipVolumesSgis = ((int)0x8132),
        UnpackImageDepthSgis = ((int)0x8133),
        Texture4DSgis = ((int)0x8134),
        ProxyTexture4DSgis = ((int)0x8135),
        Texture4DsizeSgis = ((int)0x8136),
        TextureWrapQSgis = ((int)0x8137),
        Max4DTextureSizeSgis = ((int)0x8138),
        Texture4DBindingSgis = ((int)0x814F),
    }

    public enum SgisTextureBorderClamp : int
    {
        ClampToBorderSgis = ((int)0x812D),
    }

    [Flags]
    public enum SgisTextureColorMask : int
    {
        TextureColorWritemaskSgis = ((int)0x81EF),
    }

    public enum SgisTextureEdgeClamp : int
    {
        ClampToEdgeSgis = ((int)0x812F),
    }

    public enum SgisTextureFilter4 : int
    {
        Filter4Sgis = ((int)0x8146),
        TextureFilter4SizeSgis = ((int)0x8147),
    }

    public enum SgisTextureLod : int
    {
        TextureMinLodSgis = ((int)0x813A),
        TextureMaxLodSgis = ((int)0x813B),
        TextureBaseLevelSgis = ((int)0x813C),
        TextureMaxLevelSgis = ((int)0x813D),
    }

    public enum SgisTextureSelect : int
    {
        DualAlpha4Sgis = ((int)0x8110),
        DualAlpha8Sgis = ((int)0x8111),
        DualAlpha12Sgis = ((int)0x8112),
        DualAlpha16Sgis = ((int)0x8113),
        DualLuminance4Sgis = ((int)0x8114),
        DualLuminance8Sgis = ((int)0x8115),
        DualLuminance12Sgis = ((int)0x8116),
        DualLuminance16Sgis = ((int)0x8117),
        DualIntensity4Sgis = ((int)0x8118),
        DualIntensity8Sgis = ((int)0x8119),
        DualIntensity12Sgis = ((int)0x811A),
        DualIntensity16Sgis = ((int)0x811B),
        DualLuminanceAlpha4Sgis = ((int)0x811C),
        DualLuminanceAlpha8Sgis = ((int)0x811D),
        QuadAlpha4Sgis = ((int)0x811E),
        QuadAlpha8Sgis = ((int)0x811F),
        QuadLuminance4Sgis = ((int)0x8120),
        QuadLuminance8Sgis = ((int)0x8121),
        QuadIntensity4Sgis = ((int)0x8122),
        QuadIntensity8Sgis = ((int)0x8123),
        DualTextureSelectSgis = ((int)0x8124),
        QuadTextureSelectSgis = ((int)0x8125),
    }

    public enum SgiTextureColorTable : int
    {
        TextureColorTableSgi = ((int)0x80BC),
        ProxyTextureColorTableSgi = ((int)0x80BD),
    }

    public enum SgixAsync : int
    {
        AsyncMarkerSgix = ((int)0x8329),
    }

    public enum SgixAsyncHistogram : int
    {
        AsyncHistogramSgix = ((int)0x832C),
        MaxAsyncHistogramSgix = ((int)0x832D),
    }

    public enum SgixAsyncPixel : int
    {
        AsyncTexImageSgix = ((int)0x835C),
        AsyncDrawPixelsSgix = ((int)0x835D),
        AsyncReadPixelsSgix = ((int)0x835E),
        MaxAsyncTexImageSgix = ((int)0x835F),
        MaxAsyncDrawPixelsSgix = ((int)0x8360),
        MaxAsyncReadPixelsSgix = ((int)0x8361),
    }

    public enum SgixBlendAlphaMinmax : int
    {
        AlphaMinSgix = ((int)0x8320),
        AlphaMaxSgix = ((int)0x8321),
        AsyncMarkerSgix = ((int)0x8329),
    }

    public enum SgixCalligraphicFragment : int
    {
        CalligraphicFragmentSgix = ((int)0x8183),
    }

    public enum SgixClipmap : int
    {
        LinearClipmapLinearSgix = ((int)0x8170),
        TextureClipmapCenterSgix = ((int)0x8171),
        TextureClipmapFrameSgix = ((int)0x8172),
        TextureClipmapOffsetSgix = ((int)0x8173),
        TextureClipmapVirtualDepthSgix = ((int)0x8174),
        TextureClipmapLodOffsetSgix = ((int)0x8175),
        TextureClipmapDepthSgix = ((int)0x8176),
        MaxClipmapDepthSgix = ((int)0x8177),
        MaxClipmapVirtualDepthSgix = ((int)0x8178),
        NearestClipmapNearestSgix = ((int)0x844D),
        NearestClipmapLinearSgix = ((int)0x844E),
        LinearClipmapNearestSgix = ((int)0x844F),
    }

    public enum SgixConvolutionAccuracy : int
    {
        ConvolutionHintSgix = ((int)0x8316),
    }

    public enum SgixDepthTexture : int
    {
        DepthComponent16Sgix = ((int)0x81A5),
        DepthComponent24Sgix = ((int)0x81A6),
        DepthComponent32Sgix = ((int)0x81A7),
    }

    public enum SgixFlushRaster : int
    {
    }

    public enum SgixFogOffset : int
    {
        FogOffsetSgix = ((int)0x8198),
        FogOffsetValueSgix = ((int)0x8199),
    }

    public enum SgixFogScale : int
    {
        FogScaleSgix = ((int)0x81FC),
        FogScaleValueSgix = ((int)0x81FD),
    }

    public enum SgixFragmentLighting : int
    {
        FragmentLightingSgix = ((int)0x8400),
        FragmentColorMaterialSgix = ((int)0x8401),
        FragmentColorMaterialFaceSgix = ((int)0x8402),
        FragmentColorMaterialParameterSgix = ((int)0x8403),
        MaxFragmentLightsSgix = ((int)0x8404),
        MaxActiveLightsSgix = ((int)0x8405),
        CurrentRasterNormalSgix = ((int)0x8406),
        LightEnvModeSgix = ((int)0x8407),
        FragmentLightModelLocalViewerSgix = ((int)0x8408),
        FragmentLightModelTwoSideSgix = ((int)0x8409),
        FragmentLightModelAmbientSgix = ((int)0x840A),
        FragmentLightModelNormalInterpolationSgix = ((int)0x840B),
        FragmentLight0Sgix = ((int)0x840C),
        FragmentLight1Sgix = ((int)0x840D),
        FragmentLight2Sgix = ((int)0x840E),
        FragmentLight3Sgix = ((int)0x840F),
        FragmentLight4Sgix = ((int)0x8410),
        FragmentLight5Sgix = ((int)0x8411),
        FragmentLight6Sgix = ((int)0x8412),
        FragmentLight7Sgix = ((int)0x8413),
    }

    public enum SgixFramezoom : int
    {
        FramezoomSgix = ((int)0x818B),
        FramezoomFactorSgix = ((int)0x818C),
        MaxFramezoomFactorSgix = ((int)0x818D),
    }

    public enum SgixImpactPixelTexture : int
    {
        PixelTexGenQCeilingSgix = ((int)0x8184),
        PixelTexGenQRoundSgix = ((int)0x8185),
        PixelTexGenQFloorSgix = ((int)0x8186),
        PixelTexGenAlphaReplaceSgix = ((int)0x8187),
        PixelTexGenAlphaNoReplaceSgix = ((int)0x8188),
        PixelTexGenAlphaLsSgix = ((int)0x8189),
        PixelTexGenAlphaMsSgix = ((int)0x818A),
    }

    public enum SgixInstruments : int
    {
        InstrumentBufferPointerSgix = ((int)0x8180),
        InstrumentMeasurementsSgix = ((int)0x8181),
    }

    public enum SgixInterlace : int
    {
        InterlaceSgix = ((int)0x8094),
    }

    public enum SgixIrInstrument1 : int
    {
        IrInstrument1Sgix = ((int)0x817F),
    }

    public enum SgixListPriority : int
    {
        ListPrioritySgix = ((int)0x8182),
    }

    public enum SgixPixelTexture : int
    {
        PixelTexGenSgix = ((int)0x8139),
        PixelTexGenModeSgix = ((int)0x832B),
    }

    public enum SgixPixelTiles : int
    {
        PixelTileBestAlignmentSgix = ((int)0x813E),
        PixelTileCacheIncrementSgix = ((int)0x813F),
        PixelTileWidthSgix = ((int)0x8140),
        PixelTileHeightSgix = ((int)0x8141),
        PixelTileGridWidthSgix = ((int)0x8142),
        PixelTileGridHeightSgix = ((int)0x8143),
        PixelTileGridDepthSgix = ((int)0x8144),
        PixelTileCacheSizeSgix = ((int)0x8145),
    }

    public enum SgixPolynomialFfd : int
    {
        GeometryDeformationSgix = ((int)0x8194),
        TextureDeformationSgix = ((int)0x8195),
        DeformationsMaskSgix = ((int)0x8196),
        MaxDeformationOrderSgix = ((int)0x8197),
    }

    public enum SgixReferencePlane : int
    {
        ReferencePlaneSgix = ((int)0x817D),
        ReferencePlaneEquationSgix = ((int)0x817E),
    }

    public enum SgixResample : int
    {
        PackResampleSgix = ((int)0x842C),
        UnpackResampleSgix = ((int)0x842D),
        ResampleReplicateSgix = ((int)0x842E),
        ResampleZeroFillSgix = ((int)0x842F),
        ResampleDecimateSgix = ((int)0x8430),
    }

    public enum SgixScalebiasHint : int
    {
        ScalebiasHintSgix = ((int)0x8322),
    }

    public enum SgixShadow : int
    {
        TextureCompareSgix = ((int)0x819A),
        TextureCompareOperatorSgix = ((int)0x819B),
        TextureLequalRSgix = ((int)0x819C),
        TextureGequalRSgix = ((int)0x819D),
    }

    public enum SgixShadowAmbient : int
    {
        ShadowAmbientSgix = ((int)0x80BF),
    }

    public enum SgixSprite : int
    {
        SpriteSgix = ((int)0x8148),
        SpriteModeSgix = ((int)0x8149),
        SpriteAxisSgix = ((int)0x814A),
        SpriteTranslationSgix = ((int)0x814B),
        SpriteAxialSgix = ((int)0x814C),
        SpriteObjectAlignedSgix = ((int)0x814D),
        SpriteEyeAlignedSgix = ((int)0x814E),
    }

    public enum SgixSubsample : int
    {
        PackSubsampleRateSgix = ((int)0x85A0),
        UnpackSubsampleRateSgix = ((int)0x85A1),
        PixelSubsample4444Sgix = ((int)0x85A2),
        PixelSubsample2424Sgix = ((int)0x85A3),
        PixelSubsample4242Sgix = ((int)0x85A4),
    }

    public enum SgixTagSampleBuffer : int
    {
    }

    public enum SgixTextureAddEnv : int
    {
        TextureEnvBiasSgix = ((int)0x80BE),
    }

    public enum SgixTextureCoordinateClamp : int
    {
        TextureMaxClampSSgix = ((int)0x8369),
        TextureMaxClampTSgix = ((int)0x836A),
        TextureMaxClampRSgix = ((int)0x836B),
        FogFactorToAlphaSgix = ((int)0x836F),
    }

    public enum SgixTextureLodBias : int
    {
        TextureLodBiasSSgix = ((int)0x818E),
        TextureLodBiasTSgix = ((int)0x818F),
        TextureLodBiasRSgix = ((int)0x8190),
    }

    public enum SgixTextureMultiBuffer : int
    {
        TextureMultiBufferHintSgix = ((int)0x812E),
    }

    public enum SgixTextureScaleBias : int
    {
        PostTextureFilterBiasSgix = ((int)0x8179),
        PostTextureFilterScaleSgix = ((int)0x817A),
        PostTextureFilterBiasRangeSgix = ((int)0x817B),
        PostTextureFilterScaleRangeSgix = ((int)0x817C),
    }

    public enum SgixVertexPreclip : int
    {
        VertexPreclipSgix = ((int)0x83EE),
        VertexPreclipHintSgix = ((int)0x83EF),
    }

    public enum SgixYcrcb : int
    {
        Ycrcb422Sgix = ((int)0x81BB),
        Ycrcb444Sgix = ((int)0x81BC),
    }

    public enum SgixYcrcba : int
    {
        YcrcbSgix = ((int)0x8318),
        YcrcbaSgix = ((int)0x8319),
    }

    public enum SgixYcrcbSubsample : int
    {
        PackSubsampleRateSgix = ((int)0x85A0),
        UnpackSubsampleRateSgix = ((int)0x85A1),
        PixelSubsample4444Sgix = ((int)0x85A2),
        PixelSubsample2424Sgix = ((int)0x85A3),
        PixelSubsample4242Sgix = ((int)0x85A4),
    }

    public enum ShaderParameter : int
    {
        ShaderType = ((int)0x8B4F),
        DeleteStatus = ((int)0x8B80),
        CompileStatus = ((int)0x8B81),
        InfoLogLength = ((int)0x8B84),
        ShaderSourceLength = ((int)0x8B88),
    }

    public enum ShaderType : int
    {
        FragmentShader = ((int)0x8B30),
        VertexShader = ((int)0x8B31),
        GeometryShader = ((int)0x8DD9),
        GeometryShaderExt = ((int)0x8DD9),
    }

    public enum ShadingModel : int
    {
        Flat = ((int)0x1D00),
        Smooth = ((int)0x1D01),
    }

    public enum SizedInternalFormat : int
    {
        Rgba8 = ((int)0x8058),
        Rgba16 = ((int)0x805B),
        R8 = ((int)0x8229),
        R16 = ((int)0x822A),
        Rg8 = ((int)0x822B),
        Rg16 = ((int)0x822C),
        R16f = ((int)0x822D),
        R32f = ((int)0x822E),
        Rg16f = ((int)0x822F),
        Rg32f = ((int)0x8230),
        R8i = ((int)0x8231),
        R8ui = ((int)0x8232),
        R16i = ((int)0x8233),
        R16ui = ((int)0x8234),
        R32i = ((int)0x8235),
        R32ui = ((int)0x8236),
        Rg8i = ((int)0x8237),
        Rg8ui = ((int)0x8238),
        Rg16i = ((int)0x8239),
        Rg16ui = ((int)0x823A),
        Rg32i = ((int)0x823B),
        Rg32ui = ((int)0x823C),
        Rgba32f = ((int)0x8814),
        Rgba16f = ((int)0x881A),
        Rgba32ui = ((int)0x8D70),
        Rgba16ui = ((int)0x8D76),
        Rgba8ui = ((int)0x8D7C),
        Rgba32i = ((int)0x8D82),
        Rgba16i = ((int)0x8D88),
        Rgba8i = ((int)0x8D8E),
    }

    public enum StencilFace : int
    {
        Front = ((int)0x0404),
        Back = ((int)0x0405),
        FrontAndBack = ((int)0x0408),
    }

    public enum StencilFunction : int
    {
        Never = ((int)0x0200),
        Less = ((int)0x0201),
        Equal = ((int)0x0202),
        Lequal = ((int)0x0203),
        Greater = ((int)0x0204),
        Notequal = ((int)0x0205),
        Gequal = ((int)0x0206),
        Always = ((int)0x0207),
    }

    public enum StencilOp : int
    {
        Zero = ((int)0),
        Invert = ((int)0x150A),
        Keep = ((int)0x1E00),
        Replace = ((int)0x1E01),
        Incr = ((int)0x1E02),
        Decr = ((int)0x1E03),
        IncrWrap = ((int)0x8507),
        DecrWrap = ((int)0x8508),
    }

    public enum StringName : int
    {
        Vendor = ((int)0x1F00),
        Renderer = ((int)0x1F01),
        Version = ((int)0x1F02),
        Extensions = ((int)0x1F03),
        ShadingLanguageVersion = ((int)0x8B8C),
    }

    public enum SunConvolutionBorderModes : int
    {
        WrapBorderSun = ((int)0x81D4),
    }

    public enum SunGlobalAlpha : int
    {
        GlobalAlphaSun = ((int)0x81D9),
        GlobalAlphaFactorSun = ((int)0x81DA),
    }

    public enum SunMeshArray : int
    {
        QuadMeshSun = ((int)0x8614),
        TriangleMeshSun = ((int)0x8615),
    }

    public enum SunSliceAccum : int
    {
        SliceAccumSun = ((int)0x85CC),
    }

    public enum SunTriangleList : int
    {
        RestartSun = ((int)0x0001),
        ReplaceMiddleSun = ((int)0x0002),
        ReplaceOldestSun = ((int)0x0003),
        TriangleListSun = ((int)0x81D7),
        ReplacementCodeSun = ((int)0x81D8),
        ReplacementCodeArraySun = ((int)0x85C0),
        ReplacementCodeArrayTypeSun = ((int)0x85C1),
        ReplacementCodeArrayStrideSun = ((int)0x85C2),
        ReplacementCodeArrayPointerSun = ((int)0x85C3),
        R1uiV3fSun = ((int)0x85C4),
        R1uiC4ubV3fSun = ((int)0x85C5),
        R1uiC3fV3fSun = ((int)0x85C6),
        R1uiN3fV3fSun = ((int)0x85C7),
        R1uiC4fN3fV3fSun = ((int)0x85C8),
        R1uiT2fV3fSun = ((int)0x85C9),
        R1uiT2fN3fV3fSun = ((int)0x85CA),
        R1uiT2fC4fN3fV3fSun = ((int)0x85CB),
    }

    public enum SunVertex : int
    {
    }

    public enum SunxConstantData : int
    {
        UnpackConstantDataSunx = ((int)0x81D5),
        TextureConstantDataSunx = ((int)0x81D6),
    }

    public enum TexCoordPointerType : int
    {
        Short = ((int)0x1402),
        Int = ((int)0x1404),
        Float = ((int)0x1406),
        Double = ((int)0x140A),
        HalfFloat = ((int)0x140B),
    }

    public enum TextureBufferTarget : int
    {
        TextureBuffer = ((int)0x8C2A),
    }

    public enum TextureCompareMode : int
    {
        CompareRefToTexture = ((int)0x884E),
        CompareRToTexture = ((int)0x884E),
    }

    public enum TextureCoordName : int
    {
        S = ((int)0x2000),
        T = ((int)0x2001),
        R = ((int)0x2002),
        Q = ((int)0x2003),
    }

    public enum TextureEnvMode : int
    {
        Add = ((int)0x0104),
        Blend = ((int)0x0BE2),
        Replace = ((int)0x1e01),
        Modulate = ((int)0x2100),
        Decal = ((int)0x2101),
        ReplaceExt = ((int)0x8062),
        TextureEnvBiasSgix = ((int)0x80BE),
        Combine = ((int)0x8570),
    }

    public enum TextureEnvModeCombine : int
    {
        Add = ((int)0x0104),
        Replace = ((int)0x1E01),
        Modulate = ((int)0x2100),
        Subtract = ((int)0x84E7),
        AddSigned = ((int)0x8574),
        Interpolate = ((int)0x8575),
        Dot3Rgb = ((int)0x86AE),
        Dot3Rgba = ((int)0x86AF),
    }

    public enum TextureEnvModeOperandAlpha : int
    {
        SrcAlpha = ((int)0x0302),
        OneMinusSrcAlpha = ((int)0x0303),
    }

    public enum TextureEnvModeOperandRgb : int
    {
        SrcColor = ((int)0x0300),
        OneMinusSrcColor = ((int)0x0301),
        SrcAlpha = ((int)0x0302),
        OneMinusSrcAlpha = ((int)0x0303),
    }

    public enum TextureEnvModePointSprite : int
    {
        False = ((int)0),
        True = ((int)1),
    }

    public enum TextureEnvModeScale : int
    {
        One = ((int)1),
        Two = ((int)2),
        Four = ((int)4),
    }

    public enum TextureEnvModeSource : int
    {
        Texture = ((int)0x1702),
        Texture0 = ((int)0x84C0),
        Texture1 = ((int)0x84C1),
        Texture2 = ((int)0x84C2),
        Texture3 = ((int)0x84C3),
        Texture4 = ((int)0x84C4),
        Texture5 = ((int)0x84C5),
        Texture6 = ((int)0x84C6),
        Texture7 = ((int)0x84C7),
        Texture8 = ((int)0x84C8),
        Texture9 = ((int)0x84C9),
        Texture10 = ((int)0x84CA),
        Texture11 = ((int)0x84CB),
        Texture12 = ((int)0x84CC),
        Texture13 = ((int)0x84CD),
        Texture14 = ((int)0x84CE),
        Texture15 = ((int)0x84CF),
        Texture16 = ((int)0x84D0),
        Texture17 = ((int)0x84D1),
        Texture18 = ((int)0x84D2),
        Texture19 = ((int)0x84D3),
        Texture20 = ((int)0x84D4),
        Texture21 = ((int)0x84D5),
        Texture22 = ((int)0x84D6),
        Texture23 = ((int)0x84D7),
        Texture24 = ((int)0x84D8),
        Texture25 = ((int)0x84D9),
        Texture26 = ((int)0x84DA),
        Texture27 = ((int)0x84DB),
        Texture28 = ((int)0x84DC),
        Texture29 = ((int)0x84DD),
        Texture30 = ((int)0x84DE),
        Texture31 = ((int)0x84DF),
        Constant = ((int)0x8576),
        PrimaryColor = ((int)0x8577),
        Previous = ((int)0x8578),
    }

    public enum TextureEnvParameter : int
    {
        AlphaScale = ((int)0x0D1C),
        TextureEnvMode = ((int)0x2200),
        TextureEnvColor = ((int)0x2201),
        TextureLodBias = ((int)0x8501),
        CombineRgb = ((int)0x8571),
        CombineAlpha = ((int)0x8572),
        RgbScale = ((int)0x8573),
        Source0Rgb = ((int)0x8580),
        Src1Rgb = ((int)0x8581),
        Src2Rgb = ((int)0x8582),
        Src0Alpha = ((int)0x8588),
        Src1Alpha = ((int)0x8589),
        Src2Alpha = ((int)0x858A),
        Operand0Rgb = ((int)0x8590),
        Operand1Rgb = ((int)0x8591),
        Operand2Rgb = ((int)0x8592),
        Operand0Alpha = ((int)0x8598),
        Operand1Alpha = ((int)0x8599),
        Operand2Alpha = ((int)0x859A),
        CoordReplace = ((int)0x8862),
    }

    public enum TextureEnvTarget : int
    {
        TextureEnv = ((int)0x2300),
        TextureFilterControl = ((int)0x8500),
        PointSprite = ((int)0x8861),
    }

    public enum TextureFilterFuncSgis : int
    {
        Filter4Sgis = ((int)0x8146),
    }

    public enum TextureGenMode : int
    {
        EyeLinear = ((int)0x2400),
        ObjectLinear = ((int)0x2401),
        SphereMap = ((int)0x2402),
        EyeDistanceToPointSgis = ((int)0x81F0),
        ObjectDistanceToPointSgis = ((int)0x81F1),
        EyeDistanceToLineSgis = ((int)0x81F2),
        ObjectDistanceToLineSgis = ((int)0x81F3),
        NormalMap = ((int)0x8511),
        ReflectionMap = ((int)0x8512),
    }

    public enum TextureGenParameter : int
    {
        TextureGenMode = ((int)0x2500),
        ObjectPlane = ((int)0x2501),
        EyePlane = ((int)0x2502),
        EyePointSgis = ((int)0x81F4),
        ObjectPointSgis = ((int)0x81F5),
        EyeLineSgis = ((int)0x81F6),
        ObjectLineSgis = ((int)0x81F7),
    }

    public enum TextureMagFilter : int
    {
        Nearest = ((int)0x2600),
        Linear = ((int)0x2601),
        LinearDetailSgis = ((int)0x8097),
        LinearDetailAlphaSgis = ((int)0x8098),
        LinearDetailColorSgis = ((int)0x8099),
        LinearSharpenSgis = ((int)0x80AD),
        LinearSharpenAlphaSgis = ((int)0x80AE),
        LinearSharpenColorSgis = ((int)0x80AF),
        Filter4Sgis = ((int)0x8146),
        PixelTexGenQCeilingSgix = ((int)0x8184),
        PixelTexGenQRoundSgix = ((int)0x8185),
        PixelTexGenQFloorSgix = ((int)0x8186),
    }

    public enum TextureMinFilter : int
    {
        Nearest = ((int)0x2600),
        Linear = ((int)0x2601),
        NearestMipmapNearest = ((int)0x2700),
        LinearMipmapNearest = ((int)0x2701),
        NearestMipmapLinear = ((int)0x2702),
        LinearMipmapLinear = ((int)0x2703),
        Filter4Sgis = ((int)0x8146),
        LinearClipmapLinearSgix = ((int)0x8170),
        PixelTexGenQCeilingSgix = ((int)0x8184),
        PixelTexGenQRoundSgix = ((int)0x8185),
        PixelTexGenQFloorSgix = ((int)0x8186),
        NearestClipmapNearestSgix = ((int)0x844D),
        NearestClipmapLinearSgix = ((int)0x844E),
        LinearClipmapNearestSgix = ((int)0x844F),
    }

    public enum TextureParameterName : int
    {
        TextureBorderColor = ((int)0x1004),
        Red = ((int)0x1903),
        TextureMagFilter = ((int)0x2800),
        TextureMinFilter = ((int)0x2801),
        TextureWrapS = ((int)0x2802),
        TextureWrapT = ((int)0x2803),
        TexturePriority = ((int)0x8066),
        TextureDepth = ((int)0x8071),
        TextureWrapR = ((int)0x8072),
        TextureWrapRExt = ((int)0x8072),
        DetailTextureLevelSgis = ((int)0x809A),
        DetailTextureModeSgis = ((int)0x809B),
        ShadowAmbientSgix = ((int)0x80BF),
        TextureCompareFailValue = ((int)0x80BF),
        DualTextureSelectSgis = ((int)0x8124),
        QuadTextureSelectSgis = ((int)0x8125),
        ClampToBorder = ((int)0x812D),
        ClampToEdge = ((int)0x812F),
        TextureWrapQSgis = ((int)0x8137),
        TextureMinLod = ((int)0x813A),
        TextureMaxLod = ((int)0x813B),
        TextureBaseLevel = ((int)0x813C),
        TextureMaxLevel = ((int)0x813D),
        TextureClipmapCenterSgix = ((int)0x8171),
        TextureClipmapFrameSgix = ((int)0x8172),
        TextureClipmapOffsetSgix = ((int)0x8173),
        TextureClipmapVirtualDepthSgix = ((int)0x8174),
        TextureClipmapLodOffsetSgix = ((int)0x8175),
        TextureClipmapDepthSgix = ((int)0x8176),
        PostTextureFilterBiasSgix = ((int)0x8179),
        PostTextureFilterScaleSgix = ((int)0x817A),
        TextureLodBiasSSgix = ((int)0x818E),
        TextureLodBiasTSgix = ((int)0x818F),
        TextureLodBiasRSgix = ((int)0x8190),
        GenerateMipmap = ((int)0x8191),
        GenerateMipmapSgis = ((int)0x8191),
        TextureCompareSgix = ((int)0x819A),
        TextureCompareOperatorSgix = ((int)0x819B),
        TextureMaxClampSSgix = ((int)0x8369),
        TextureMaxClampTSgix = ((int)0x836A),
        TextureMaxClampRSgix = ((int)0x836B),
        TextureLodBias = ((int)0x8501),
        DepthTextureMode = ((int)0x884B),
        TextureCompareMode = ((int)0x884C),
        TextureCompareFunc = ((int)0x884D),
    }

    public enum TextureTarget : int
    {
        Texture1D = ((int)0x0DE0),
        Texture2D = ((int)0x0DE1),
        ProxyTexture1D = ((int)0x8063),
        ProxyTexture2D = ((int)0x8064),
        Texture3D = ((int)0x806F),
        ProxyTexture3D = ((int)0x8070),
        DetailTexture2DSgis = ((int)0x8095),
        Texture4DSgis = ((int)0x8134),
        ProxyTexture4DSgis = ((int)0x8135),
        TextureMinLod = ((int)0x813A),
        TextureMaxLod = ((int)0x813B),
        TextureBaseLevel = ((int)0x813C),
        TextureMaxLevel = ((int)0x813D),
        TextureRectangle = ((int)0x84F5),
        TextureRectangleArb = ((int)0x84F5),
        TextureRectangleNv = ((int)0x84F5),
        ProxyTextureRectangle = ((int)0x84F7),
        TextureCubeMap = ((int)0x8513),
        TextureBindingCubeMap = ((int)0x8514),
        TextureCubeMapPositiveX = ((int)0x8515),
        TextureCubeMapNegativeX = ((int)0x8516),
        TextureCubeMapPositiveY = ((int)0x8517),
        TextureCubeMapNegativeY = ((int)0x8518),
        TextureCubeMapPositiveZ = ((int)0x8519),
        TextureCubeMapNegativeZ = ((int)0x851A),
        ProxyTextureCubeMap = ((int)0x851B),
        Texture1DArray = ((int)0x8C18),
        ProxyTexture1DArray = ((int)0x8C19),
        Texture2DArray = ((int)0x8C1A),
        ProxyTexture2DArray = ((int)0x8C1B),
        TextureBuffer = ((int)0x8C2A),
        Texture2DMultisample = ((int)0x9100),
        ProxyTexture2DMultisample = ((int)0x9101),
        Texture2DMultisampleArray = ((int)0x9102),
        ProxyTexture2DMultisampleArray = ((int)0x9103),
    }

    public enum TextureTargetMultisample : int
    {
        Texture2DMultisample = ((int)0x9100),
        ProxyTexture2DMultisample = ((int)0x9101),
        Texture2DMultisampleArray = ((int)0x9102),
        ProxyTexture2DMultisampleArray = ((int)0x9103),
    }

    public enum TextureUnit : int
    {
        Texture0 = ((int)0x84C0),
        Texture1 = ((int)0x84C1),
        Texture2 = ((int)0x84C2),
        Texture3 = ((int)0x84C3),
        Texture4 = ((int)0x84C4),
        Texture5 = ((int)0x84C5),
        Texture6 = ((int)0x84C6),
        Texture7 = ((int)0x84C7),
        Texture8 = ((int)0x84C8),
        Texture9 = ((int)0x84C9),
        Texture10 = ((int)0x84CA),
        Texture11 = ((int)0x84CB),
        Texture12 = ((int)0x84CC),
        Texture13 = ((int)0x84CD),
        Texture14 = ((int)0x84CE),
        Texture15 = ((int)0x84CF),
        Texture16 = ((int)0x84D0),
        Texture17 = ((int)0x84D1),
        Texture18 = ((int)0x84D2),
        Texture19 = ((int)0x84D3),
        Texture20 = ((int)0x84D4),
        Texture21 = ((int)0x84D5),
        Texture22 = ((int)0x84D6),
        Texture23 = ((int)0x84D7),
        Texture24 = ((int)0x84D8),
        Texture25 = ((int)0x84D9),
        Texture26 = ((int)0x84DA),
        Texture27 = ((int)0x84DB),
        Texture28 = ((int)0x84DC),
        Texture29 = ((int)0x84DD),
        Texture30 = ((int)0x84DE),
        Texture31 = ((int)0x84DF),
    }

    public enum TextureWrapMode : int
    {
        Clamp = ((int)0x2900),
        Repeat = ((int)0x2901),
        ClampToBorder = ((int)0x812D),
        ClampToEdge = ((int)0x812F),
        MirroredRepeat = ((int)0x8370),
    }

    public enum TransformFeedbackMode : int
    {
        InterleavedAttribs = ((int)0x8C8C),
        SeparateAttribs = ((int)0x8C8D),
    }

    public enum Version11 : int
    {
        False = ((int)0),
        NoError = ((int)0),
        None = ((int)0),
        Zero = ((int)0),
        Points = ((int)0x0000),
        DepthBufferBit = ((int)0x00000100),
        StencilBufferBit = ((int)0x00000400),
        ColorBufferBit = ((int)0x00004000),
        Lines = ((int)0x0001),
        LineLoop = ((int)0x0002),
        LineStrip = ((int)0x0003),
        Triangles = ((int)0x0004),
        TriangleStrip = ((int)0x0005),
        TriangleFan = ((int)0x0006),
        Never = ((int)0x0200),
        Less = ((int)0x0201),
        Equal = ((int)0x0202),
        Lequal = ((int)0x0203),
        Greater = ((int)0x0204),
        Notequal = ((int)0x0205),
        Gequal = ((int)0x0206),
        Always = ((int)0x0207),
        SrcColor = ((int)0x0300),
        OneMinusSrcColor = ((int)0x0301),
        SrcAlpha = ((int)0x0302),
        OneMinusSrcAlpha = ((int)0x0303),
        DstAlpha = ((int)0x0304),
        OneMinusDstAlpha = ((int)0x0305),
        DstColor = ((int)0x0306),
        OneMinusDstColor = ((int)0x0307),
        SrcAlphaSaturate = ((int)0x0308),
        FrontLeft = ((int)0x0400),
        FrontRight = ((int)0x0401),
        BackLeft = ((int)0x0402),
        BackRight = ((int)0x0403),
        Front = ((int)0x0404),
        Back = ((int)0x0405),
        Left = ((int)0x0406),
        Right = ((int)0x0407),
        FrontAndBack = ((int)0x0408),
        InvalidEnum = ((int)0x0500),
        InvalidValue = ((int)0x0501),
        InvalidOperation = ((int)0x0502),
        OutOfMemory = ((int)0x0505),
        Cw = ((int)0x0900),
        Ccw = ((int)0x0901),
        PointSize = ((int)0x0B11),
        PointSizeRange = ((int)0x0B12),
        PointSizeGranularity = ((int)0x0B13),
        LineSmooth = ((int)0x0B20),
        LineWidth = ((int)0x0B21),
        LineWidthRange = ((int)0x0B22),
        LineWidthGranularity = ((int)0x0B23),
        PolygonSmooth = ((int)0x0B41),
        CullFace = ((int)0x0B44),
        CullFaceMode = ((int)0x0B45),
        FrontFace = ((int)0x0B46),
        DepthRange = ((int)0x0B70),
        DepthTest = ((int)0x0B71),
        DepthWritemask = ((int)0x0B72),
        DepthClearValue = ((int)0x0B73),
        DepthFunc = ((int)0x0B74),
        StencilTest = ((int)0x0B90),
        StencilClearValue = ((int)0x0B91),
        StencilFunc = ((int)0x0B92),
        StencilValueMask = ((int)0x0B93),
        StencilFail = ((int)0x0B94),
        StencilPassDepthFail = ((int)0x0B95),
        StencilPassDepthPass = ((int)0x0B96),
        StencilRef = ((int)0x0B97),
        StencilWritemask = ((int)0x0B98),
        Viewport = ((int)0x0BA2),
        Dither = ((int)0x0BD0),
        BlendDst = ((int)0x0BE0),
        BlendSrc = ((int)0x0BE1),
        Blend = ((int)0x0BE2),
        LogicOpMode = ((int)0x0BF0),
        ColorLogicOp = ((int)0x0BF2),
        DrawBuffer = ((int)0x0C01),
        ReadBuffer = ((int)0x0C02),
        ScissorBox = ((int)0x0C10),
        ScissorTest = ((int)0x0C11),
        ColorClearValue = ((int)0x0C22),
        ColorWritemask = ((int)0x0C23),
        Doublebuffer = ((int)0x0C32),
        Stereo = ((int)0x0C33),
        LineSmoothHint = ((int)0x0C52),
        PolygonSmoothHint = ((int)0x0C53),
        UnpackSwapBytes = ((int)0x0CF0),
        UnpackLsbFirst = ((int)0x0CF1),
        UnpackRowLength = ((int)0x0CF2),
        UnpackSkipRows = ((int)0x0CF3),
        UnpackSkipPixels = ((int)0x0CF4),
        UnpackAlignment = ((int)0x0CF5),
        PackSwapBytes = ((int)0x0D00),
        PackLsbFirst = ((int)0x0D01),
        PackRowLength = ((int)0x0D02),
        PackSkipRows = ((int)0x0D03),
        PackSkipPixels = ((int)0x0D04),
        PackAlignment = ((int)0x0D05),
        MaxTextureSize = ((int)0x0D33),
        MaxViewportDims = ((int)0x0D3A),
        SubpixelBits = ((int)0x0D50),
        Texture1D = ((int)0x0DE0),
        Texture2D = ((int)0x0DE1),
        TextureWidth = ((int)0x1000),
        TextureHeight = ((int)0x1001),
        TextureInternalFormat = ((int)0x1003),
        TextureBorderColor = ((int)0x1004),
        TextureBorder = ((int)0x1005),
        DontCare = ((int)0x1100),
        Fastest = ((int)0x1101),
        Nicest = ((int)0x1102),
        Byte = ((int)0x1400),
        UnsignedByte = ((int)0x1401),
        Short = ((int)0x1402),
        UnsignedShort = ((int)0x1403),
        Int = ((int)0x1404),
        UnsignedInt = ((int)0x1405),
        Float = ((int)0x1406),
        Double = ((int)0x140A),
        Clear = ((int)0x1500),
        And = ((int)0x1501),
        AndReverse = ((int)0x1502),
        Copy = ((int)0x1503),
        AndInverted = ((int)0x1504),
        Noop = ((int)0x1505),
        Xor = ((int)0x1506),
        Or = ((int)0x1507),
        Nor = ((int)0x1508),
        Equiv = ((int)0x1509),
        Invert = ((int)0x150A),
        OrReverse = ((int)0x150B),
        CopyInverted = ((int)0x150C),
        OrInverted = ((int)0x150D),
        Nand = ((int)0x150E),
        Set = ((int)0x150F),
        Texture = ((int)0x1702),
        Color = ((int)0x1800),
        Depth = ((int)0x1801),
        Stencil = ((int)0x1802),
        StencilIndex = ((int)0x1901),
        DepthComponent = ((int)0x1902),
        Red = ((int)0x1903),
        Green = ((int)0x1904),
        Blue = ((int)0x1905),
        Alpha = ((int)0x1906),
        Rgb = ((int)0x1907),
        Rgba = ((int)0x1908),
        Point = ((int)0x1B00),
        Line = ((int)0x1B01),
        Fill = ((int)0x1B02),
        Keep = ((int)0x1E00),
        Replace = ((int)0x1E01),
        Incr = ((int)0x1E02),
        Decr = ((int)0x1E03),
        Vendor = ((int)0x1F00),
        Renderer = ((int)0x1F01),
        Version = ((int)0x1F02),
        Extensions = ((int)0x1F03),
        Nearest = ((int)0x2600),
        Linear = ((int)0x2601),
        NearestMipmapNearest = ((int)0x2700),
        LinearMipmapNearest = ((int)0x2701),
        NearestMipmapLinear = ((int)0x2702),
        LinearMipmapLinear = ((int)0x2703),
        TextureMagFilter = ((int)0x2800),
        TextureMinFilter = ((int)0x2801),
        TextureWrapS = ((int)0x2802),
        TextureWrapT = ((int)0x2803),
        Repeat = ((int)0x2901),
        PolygonOffsetUnits = ((int)0x2A00),
        PolygonOffsetPoint = ((int)0x2A01),
        PolygonOffsetLine = ((int)0x2A02),
        R3G3B2 = ((int)0x2A10),
        PolygonOffsetFill = ((int)0x8037),
        PolygonOffsetFactor = ((int)0x8038),
        Rgb4 = ((int)0x804F),
        Rgb5 = ((int)0x8050),
        Rgb8 = ((int)0x8051),
        Rgb10 = ((int)0x8052),
        Rgb12 = ((int)0x8053),
        Rgb16 = ((int)0x8054),
        Rgba2 = ((int)0x8055),
        Rgba4 = ((int)0x8056),
        Rgb5A1 = ((int)0x8057),
        Rgba8 = ((int)0x8058),
        Rgb10A2 = ((int)0x8059),
        Rgba12 = ((int)0x805A),
        Rgba16 = ((int)0x805B),
        TextureRedSize = ((int)0x805C),
        TextureGreenSize = ((int)0x805D),
        TextureBlueSize = ((int)0x805E),
        TextureAlphaSize = ((int)0x805F),
        ProxyTexture1D = ((int)0x8063),
        ProxyTexture2D = ((int)0x8064),
        TextureBinding1D = ((int)0x8068),
        TextureBinding2D = ((int)0x8069),
        One = ((int)1),
        True = ((int)1),
    }

    public enum Version11Deprecated : int
    {
        ClientPixelStoreBit = ((int)0x00000001),
        CurrentBit = ((int)0x00000001),
        ClientVertexArrayBit = ((int)0x00000002),
        PointBit = ((int)0x00000002),
        LineBit = ((int)0x00000004),
        PolygonBit = ((int)0x00000008),
        PolygonStippleBit = ((int)0x00000010),
        PixelModeBit = ((int)0x00000020),
        LightingBit = ((int)0x00000040),
        FogBit = ((int)0x00000080),
        AccumBufferBit = ((int)0x00000200),
        ViewportBit = ((int)0x00000800),
        TransformBit = ((int)0x00001000),
        EnableBit = ((int)0x00002000),
        HintBit = ((int)0x00008000),
        EvalBit = ((int)0x00010000),
        ListBit = ((int)0x00020000),
        TextureBit = ((int)0x00040000),
        Quads = ((int)0x0007),
        QuadStrip = ((int)0x0008),
        ScissorBit = ((int)0x00080000),
        Polygon = ((int)0x0009),
        Accum = ((int)0x0100),
        Load = ((int)0x0101),
        Return = ((int)0x0102),
        Mult = ((int)0x0103),
        Add = ((int)0x0104),
        Aux0 = ((int)0x0409),
        Aux1 = ((int)0x040A),
        Aux2 = ((int)0x040B),
        Aux3 = ((int)0x040C),
        StackOverflow = ((int)0x0503),
        StackUnderflow = ((int)0x0504),
        Gl2D = ((int)0x0600),
        Gl3D = ((int)0x0601),
        Gl3DColor = ((int)0x0602),
        Gl3DColorTexture = ((int)0x0603),
        Gl4DColorTexture = ((int)0x0604),
        PassThroughToken = ((int)0x0700),
        PointToken = ((int)0x0701),
        LineToken = ((int)0x0702),
        PolygonToken = ((int)0x0703),
        BitmapToken = ((int)0x0704),
        DrawPixelToken = ((int)0x0705),
        CopyPixelToken = ((int)0x0706),
        LineResetToken = ((int)0x0707),
        Exp = ((int)0x0800),
        Exp2 = ((int)0x0801),
        Coeff = ((int)0x0A00),
        Order = ((int)0x0A01),
        Domain = ((int)0x0A02),
        CurrentColor = ((int)0x0B00),
        CurrentIndex = ((int)0x0B01),
        CurrentNormal = ((int)0x0B02),
        CurrentTextureCoords = ((int)0x0B03),
        CurrentRasterColor = ((int)0x0B04),
        CurrentRasterIndex = ((int)0x0B05),
        CurrentRasterTextureCoords = ((int)0x0B06),
        CurrentRasterPosition = ((int)0x0B07),
        CurrentRasterPositionValid = ((int)0x0B08),
        CurrentRasterDistance = ((int)0x0B09),
        PointSmooth = ((int)0x0B10),
        LineStipple = ((int)0x0B24),
        LineStipplePattern = ((int)0x0B25),
        LineStippleRepeat = ((int)0x0B26),
        ListMode = ((int)0x0B30),
        MaxListNesting = ((int)0x0B31),
        ListBase = ((int)0x0B32),
        ListIndex = ((int)0x0B33),
        PolygonMode = ((int)0x0B40),
        PolygonStipple = ((int)0x0B42),
        EdgeFlag = ((int)0x0B43),
        Lighting = ((int)0x0B50),
        LightModelLocalViewer = ((int)0x0B51),
        LightModelTwoSide = ((int)0x0B52),
        LightModelAmbient = ((int)0x0B53),
        ShadeModel = ((int)0x0B54),
        ColorMaterialFace = ((int)0x0B55),
        ColorMaterialParameter = ((int)0x0B56),
        ColorMaterial = ((int)0x0B57),
        Fog = ((int)0x0B60),
        FogIndex = ((int)0x0B61),
        FogDensity = ((int)0x0B62),
        FogStart = ((int)0x0B63),
        FogEnd = ((int)0x0B64),
        FogMode = ((int)0x0B65),
        FogColor = ((int)0x0B66),
        AccumClearValue = ((int)0x0B80),
        MatrixMode = ((int)0x0BA0),
        Normalize = ((int)0x0BA1),
        ModelviewStackDepth = ((int)0x0BA3),
        ProjectionStackDepth = ((int)0x0BA4),
        TextureStackDepth = ((int)0x0BA5),
        ModelviewMatrix = ((int)0x0BA6),
        ProjectionMatrix = ((int)0x0BA7),
        TextureMatrix = ((int)0x0BA8),
        AttribStackDepth = ((int)0x0BB0),
        ClientAttribStackDepth = ((int)0x0BB1),
        AlphaTest = ((int)0x0BC0),
        AlphaTestFunc = ((int)0x0BC1),
        AlphaTestRef = ((int)0x0BC2),
        IndexLogicOp = ((int)0x0BF1),
        LogicOp = ((int)0x0BF1),
        AuxBuffers = ((int)0x0C00),
        IndexClearValue = ((int)0x0C20),
        IndexWritemask = ((int)0x0C21),
        IndexMode = ((int)0x0C30),
        RgbaMode = ((int)0x0C31),
        RenderMode = ((int)0x0C40),
        PerspectiveCorrectionHint = ((int)0x0C50),
        PointSmoothHint = ((int)0x0C51),
        FogHint = ((int)0x0C54),
        TextureGenS = ((int)0x0C60),
        TextureGenT = ((int)0x0C61),
        TextureGenR = ((int)0x0C62),
        TextureGenQ = ((int)0x0C63),
        PixelMapIToI = ((int)0x0C70),
        PixelMapSToS = ((int)0x0C71),
        PixelMapIToR = ((int)0x0C72),
        PixelMapIToG = ((int)0x0C73),
        PixelMapIToB = ((int)0x0C74),
        PixelMapIToA = ((int)0x0C75),
        PixelMapRToR = ((int)0x0C76),
        PixelMapGToG = ((int)0x0C77),
        PixelMapBToB = ((int)0x0C78),
        PixelMapAToA = ((int)0x0C79),
        PixelMapIToISize = ((int)0x0CB0),
        PixelMapSToSSize = ((int)0x0CB1),
        PixelMapIToRSize = ((int)0x0CB2),
        PixelMapIToGSize = ((int)0x0CB3),
        PixelMapIToBSize = ((int)0x0CB4),
        PixelMapIToASize = ((int)0x0CB5),
        PixelMapRToRSize = ((int)0x0CB6),
        PixelMapGToGSize = ((int)0x0CB7),
        PixelMapBToBSize = ((int)0x0CB8),
        PixelMapAToASize = ((int)0x0CB9),
        MapColor = ((int)0x0D10),
        MapStencil = ((int)0x0D11),
        IndexShift = ((int)0x0D12),
        IndexOffset = ((int)0x0D13),
        RedScale = ((int)0x0D14),
        RedBias = ((int)0x0D15),
        ZoomX = ((int)0x0D16),
        ZoomY = ((int)0x0D17),
        GreenScale = ((int)0x0D18),
        GreenBias = ((int)0x0D19),
        BlueScale = ((int)0x0D1A),
        BlueBias = ((int)0x0D1B),
        AlphaScale = ((int)0x0D1C),
        AlphaBias = ((int)0x0D1D),
        DepthScale = ((int)0x0D1E),
        DepthBias = ((int)0x0D1F),
        MaxEvalOrder = ((int)0x0D30),
        MaxLights = ((int)0x0D31),
        MaxClipPlanes = ((int)0x0D32),
        MaxPixelMapTable = ((int)0x0D34),
        MaxAttribStackDepth = ((int)0x0D35),
        MaxModelviewStackDepth = ((int)0x0D36),
        MaxNameStackDepth = ((int)0x0D37),
        MaxProjectionStackDepth = ((int)0x0D38),
        MaxTextureStackDepth = ((int)0x0D39),
        MaxClientAttribStackDepth = ((int)0x0D3B),
        IndexBits = ((int)0x0D51),
        RedBits = ((int)0x0D52),
        GreenBits = ((int)0x0D53),
        BlueBits = ((int)0x0D54),
        AlphaBits = ((int)0x0D55),
        DepthBits = ((int)0x0D56),
        StencilBits = ((int)0x0D57),
        AccumRedBits = ((int)0x0D58),
        AccumGreenBits = ((int)0x0D59),
        AccumBlueBits = ((int)0x0D5A),
        AccumAlphaBits = ((int)0x0D5B),
        NameStackDepth = ((int)0x0D70),
        AutoNormal = ((int)0x0D80),
        Map1Color4 = ((int)0x0D90),
        Map1Index = ((int)0x0D91),
        Map1Normal = ((int)0x0D92),
        Map1TextureCoord1 = ((int)0x0D93),
        Map1TextureCoord2 = ((int)0x0D94),
        Map1TextureCoord3 = ((int)0x0D95),
        Map1TextureCoord4 = ((int)0x0D96),
        Map1Vertex3 = ((int)0x0D97),
        Map1Vertex4 = ((int)0x0D98),
        Map2Color4 = ((int)0x0DB0),
        Map2Index = ((int)0x0DB1),
        Map2Normal = ((int)0x0DB2),
        Map2TextureCoord1 = ((int)0x0DB3),
        Map2TextureCoord2 = ((int)0x0DB4),
        Map2TextureCoord3 = ((int)0x0DB5),
        Map2TextureCoord4 = ((int)0x0DB6),
        Map2Vertex3 = ((int)0x0DB7),
        Map2Vertex4 = ((int)0x0DB8),
        Map1GridDomain = ((int)0x0DD0),
        Map1GridSegments = ((int)0x0DD1),
        Map2GridDomain = ((int)0x0DD2),
        Map2GridSegments = ((int)0x0DD3),
        FeedbackBufferPointer = ((int)0x0DF0),
        FeedbackBufferSize = ((int)0x0DF1),
        FeedbackBufferType = ((int)0x0DF2),
        SelectionBufferPointer = ((int)0x0DF3),
        SelectionBufferSize = ((int)0x0DF4),
        TextureComponents = ((int)0x1003),
        Ambient = ((int)0x1200),
        Diffuse = ((int)0x1201),
        Specular = ((int)0x1202),
        Position = ((int)0x1203),
        SpotDirection = ((int)0x1204),
        SpotExponent = ((int)0x1205),
        SpotCutoff = ((int)0x1206),
        ConstantAttenuation = ((int)0x1207),
        LinearAttenuation = ((int)0x1208),
        QuadraticAttenuation = ((int)0x1209),
        Compile = ((int)0x1300),
        CompileAndExecute = ((int)0x1301),
        Gl2Bytes = ((int)0x1407),
        Gl3Bytes = ((int)0x1408),
        Gl4Bytes = ((int)0x1409),
        Emission = ((int)0x1600),
        Shininess = ((int)0x1601),
        AmbientAndDiffuse = ((int)0x1602),
        ColorIndexes = ((int)0x1603),
        Modelview = ((int)0x1700),
        Projection = ((int)0x1701),
        ColorIndex = ((int)0x1900),
        Luminance = ((int)0x1909),
        LuminanceAlpha = ((int)0x190A),
        Bitmap = ((int)0x1A00),
        Render = ((int)0x1C00),
        Feedback = ((int)0x1C01),
        Select = ((int)0x1C02),
        Flat = ((int)0x1D00),
        Smooth = ((int)0x1D01),
        S = ((int)0x2000),
        T = ((int)0x2001),
        R = ((int)0x2002),
        Q = ((int)0x2003),
        Modulate = ((int)0x2100),
        Decal = ((int)0x2101),
        TextureEnvMode = ((int)0x2200),
        TextureEnvColor = ((int)0x2201),
        TextureEnv = ((int)0x2300),
        EyeLinear = ((int)0x2400),
        ObjectLinear = ((int)0x2401),
        SphereMap = ((int)0x2402),
        TextureGenMode = ((int)0x2500),
        ObjectPlane = ((int)0x2501),
        EyePlane = ((int)0x2502),
        Clamp = ((int)0x2900),
        V2f = ((int)0x2A20),
        V3f = ((int)0x2A21),
        C4ubV2f = ((int)0x2A22),
        C4ubV3f = ((int)0x2A23),
        C3fV3f = ((int)0x2A24),
        N3fV3f = ((int)0x2A25),
        C4fN3fV3f = ((int)0x2A26),
        T2fV3f = ((int)0x2A27),
        T4fV4f = ((int)0x2A28),
        T2fC4ubV3f = ((int)0x2A29),
        T2fC3fV3f = ((int)0x2A2A),
        T2fN3fV3f = ((int)0x2A2B),
        T2fC4fN3fV3f = ((int)0x2A2C),
        T4fC4fN3fV4f = ((int)0x2A2D),
        ClipPlane0 = ((int)0x3000),
        ClipPlane1 = ((int)0x3001),
        ClipPlane2 = ((int)0x3002),
        ClipPlane3 = ((int)0x3003),
        ClipPlane4 = ((int)0x3004),
        ClipPlane5 = ((int)0x3005),
        Light0 = ((int)0x4000),
        Light1 = ((int)0x4001),
        Light2 = ((int)0x4002),
        Light3 = ((int)0x4003),
        Light4 = ((int)0x4004),
        Light5 = ((int)0x4005),
        Light6 = ((int)0x4006),
        Light7 = ((int)0x4007),
        Alpha4 = ((int)0x803B),
        Alpha8 = ((int)0x803C),
        Alpha12 = ((int)0x803D),
        Alpha16 = ((int)0x803E),
        Luminance4 = ((int)0x803F),
        Luminance8 = ((int)0x8040),
        Luminance12 = ((int)0x8041),
        Luminance16 = ((int)0x8042),
        Luminance4Alpha4 = ((int)0x8043),
        Luminance6Alpha2 = ((int)0x8044),
        Luminance8Alpha8 = ((int)0x8045),
        Luminance12Alpha4 = ((int)0x8046),
        Luminance12Alpha12 = ((int)0x8047),
        Luminance16Alpha16 = ((int)0x8048),
        Intensity = ((int)0x8049),
        Intensity4 = ((int)0x804A),
        Intensity8 = ((int)0x804B),
        Intensity12 = ((int)0x804C),
        Intensity16 = ((int)0x804D),
        TextureLuminanceSize = ((int)0x8060),
        TextureIntensitySize = ((int)0x8061),
        TexturePriority = ((int)0x8066),
        TextureResident = ((int)0x8067),
        VertexArray = ((int)0x8074),
        NormalArray = ((int)0x8075),
        ColorArray = ((int)0x8076),
        IndexArray = ((int)0x8077),
        TextureCoordArray = ((int)0x8078),
        EdgeFlagArray = ((int)0x8079),
        VertexArraySize = ((int)0x807A),
        VertexArrayType = ((int)0x807B),
        VertexArrayStride = ((int)0x807C),
        NormalArrayType = ((int)0x807E),
        NormalArrayStride = ((int)0x807F),
        ColorArraySize = ((int)0x8081),
        ColorArrayType = ((int)0x8082),
        ColorArrayStride = ((int)0x8083),
        IndexArrayType = ((int)0x8085),
        IndexArrayStride = ((int)0x8086),
        TextureCoordArraySize = ((int)0x8088),
        TextureCoordArrayType = ((int)0x8089),
        TextureCoordArrayStride = ((int)0x808A),
        EdgeFlagArrayStride = ((int)0x808C),
        VertexArrayPointer = ((int)0x808E),
        NormalArrayPointer = ((int)0x808F),
        ColorArrayPointer = ((int)0x8090),
        IndexArrayPointer = ((int)0x8091),
        TextureCoordArrayPointer = ((int)0x8092),
        EdgeFlagArrayPointer = ((int)0x8093),
        AllAttribBits = unchecked((int)0xFFFFFFFF),
        ClientAllAttribBits = unchecked((int)0xFFFFFFFF),
    }

    public enum Version12 : int
    {
        SmoothPointSizeRange = ((int)0x0B12),
        SmoothPointSizeGranularity = ((int)0x0B13),
        SmoothLineWidthRange = ((int)0x0B22),
        SmoothLineWidthGranularity = ((int)0x0B23),
        ConstantColor = ((int)0x8001),
        OneMinusConstantColor = ((int)0x8002),
        ConstantAlpha = ((int)0x8003),
        OneMinusConstantAlpha = ((int)0x8004),
        BlendColor = ((int)0x8005),
        Convolution1D = ((int)0x8010),
        Convolution2D = ((int)0x8011),
        Separable2D = ((int)0x8012),
        ConvolutionBorderMode = ((int)0x8013),
        ConvolutionFilterScale = ((int)0x8014),
        ConvolutionFilterBias = ((int)0x8015),
        Reduce = ((int)0x8016),
        ConvolutionFormat = ((int)0x8017),
        ConvolutionWidth = ((int)0x8018),
        ConvolutionHeight = ((int)0x8019),
        MaxConvolutionWidth = ((int)0x801A),
        MaxConvolutionHeight = ((int)0x801B),
        PostConvolutionRedScale = ((int)0x801C),
        PostConvolutionGreenScale = ((int)0x801D),
        PostConvolutionBlueScale = ((int)0x801E),
        PostConvolutionAlphaScale = ((int)0x801F),
        PostConvolutionRedBias = ((int)0x8020),
        PostConvolutionGreenBias = ((int)0x8021),
        PostConvolutionBlueBias = ((int)0x8022),
        PostConvolutionAlphaBias = ((int)0x8023),
        Histogram = ((int)0x8024),
        ProxyHistogram = ((int)0x8025),
        HistogramWidth = ((int)0x8026),
        HistogramFormat = ((int)0x8027),
        HistogramRedSize = ((int)0x8028),
        HistogramGreenSize = ((int)0x8029),
        HistogramBlueSize = ((int)0x802A),
        HistogramAlphaSize = ((int)0x802B),
        HistogramSink = ((int)0x802D),
        Minmax = ((int)0x802E),
        MinmaxFormat = ((int)0x802F),
        MinmaxSink = ((int)0x8030),
        TableTooLarge = ((int)0x8031),
        UnsignedByte332 = ((int)0x8032),
        UnsignedShort4444 = ((int)0x8033),
        UnsignedShort5551 = ((int)0x8034),
        UnsignedInt8888 = ((int)0x8035),
        UnsignedInt1010102 = ((int)0x8036),
        RescaleNormal = ((int)0x803A),
        TextureBinding3D = ((int)0x806A),
        PackSkipImages = ((int)0x806B),
        PackImageHeight = ((int)0x806C),
        UnpackSkipImages = ((int)0x806D),
        UnpackImageHeight = ((int)0x806E),
        Texture3D = ((int)0x806F),
        ProxyTexture3D = ((int)0x8070),
        TextureDepth = ((int)0x8071),
        TextureWrapR = ((int)0x8072),
        Max3DTextureSize = ((int)0x8073),
        ColorMatrix = ((int)0x80B1),
        ColorMatrixStackDepth = ((int)0x80B2),
        MaxColorMatrixStackDepth = ((int)0x80B3),
        PostColorMatrixRedScale = ((int)0x80B4),
        PostColorMatrixGreenScale = ((int)0x80B5),
        PostColorMatrixBlueScale = ((int)0x80B6),
        PostColorMatrixAlphaScale = ((int)0x80B7),
        PostColorMatrixRedBias = ((int)0x80B8),
        PostColorMatrixGreenBias = ((int)0x80B9),
        PostColorMatrixBlueBias = ((int)0x80BA),
        PostColorMatrixAlphaBias = ((int)0x80BB),
        ColorTable = ((int)0x80D0),
        PostConvolutionColorTable = ((int)0x80D1),
        PostColorMatrixColorTable = ((int)0x80D2),
        ProxyColorTable = ((int)0x80D3),
        ProxyPostConvolutionColorTable = ((int)0x80D4),
        ProxyPostColorMatrixColorTable = ((int)0x80D5),
        ColorTableScale = ((int)0x80D6),
        ColorTableBias = ((int)0x80D7),
        ColorTableFormat = ((int)0x80D8),
        ColorTableWidth = ((int)0x80D9),
        ColorTableRedSize = ((int)0x80DA),
        ColorTableGreenSize = ((int)0x80DB),
        ColorTableBlueSize = ((int)0x80DC),
        ColorTableAlphaSize = ((int)0x80DD),
        ColorTableLuminanceSize = ((int)0x80DE),
        ColorTableIntensitySize = ((int)0x80DF),
        Bgr = ((int)0x80E0),
        Bgra = ((int)0x80E1),
        MaxElementsVertices = ((int)0x80E8),
        MaxElementsIndices = ((int)0x80E9),
        ClampToEdge = ((int)0x812F),
        TextureMinLod = ((int)0x813A),
        TextureMaxLod = ((int)0x813B),
        TextureBaseLevel = ((int)0x813C),
        TextureMaxLevel = ((int)0x813D),
        ConstantBorder = ((int)0x8151),
        ReplicateBorder = ((int)0x8153),
        ConvolutionBorderColor = ((int)0x8154),
        LightModelColorControl = ((int)0x81F8),
        SingleColor = ((int)0x81F9),
        SeparateSpecularColor = ((int)0x81FA),
        UnsignedByte233Rev = ((int)0x8362),
        UnsignedShort565 = ((int)0x8363),
        UnsignedShort565Rev = ((int)0x8364),
        UnsignedShort4444Rev = ((int)0x8365),
        UnsignedShort1555Rev = ((int)0x8366),
        UnsignedInt8888Rev = ((int)0x8367),
        UnsignedInt2101010Rev = ((int)0x8368),
        AliasedPointSizeRange = ((int)0x846D),
        AliasedLineWidthRange = ((int)0x846E),
    }

    public enum Version12Deprecated : int
    {
        RescaleNormal = ((int)0x803A),
        LightModelColorControl = ((int)0x81F8),
        SingleColor = ((int)0x81F9),
        SeparateSpecularColor = ((int)0x81FA),
        AliasedPointSizeRange = ((int)0x846D),
    }

    public enum Version13 : int
    {
        Multisample = ((int)0x809D),
        SampleAlphaToCoverage = ((int)0x809E),
        SampleAlphaToOne = ((int)0x809F),
        SampleCoverage = ((int)0x80A0),
        SampleBuffers = ((int)0x80A8),
        Samples = ((int)0x80A9),
        SampleCoverageValue = ((int)0x80AA),
        SampleCoverageInvert = ((int)0x80AB),
        ClampToBorder = ((int)0x812D),
        Texture0 = ((int)0x84C0),
        Texture1 = ((int)0x84C1),
        Texture2 = ((int)0x84C2),
        Texture3 = ((int)0x84C3),
        Texture4 = ((int)0x84C4),
        Texture5 = ((int)0x84C5),
        Texture6 = ((int)0x84C6),
        Texture7 = ((int)0x84C7),
        Texture8 = ((int)0x84C8),
        Texture9 = ((int)0x84C9),
        Texture10 = ((int)0x84CA),
        Texture11 = ((int)0x84CB),
        Texture12 = ((int)0x84CC),
        Texture13 = ((int)0x84CD),
        Texture14 = ((int)0x84CE),
        Texture15 = ((int)0x84CF),
        Texture16 = ((int)0x84D0),
        Texture17 = ((int)0x84D1),
        Texture18 = ((int)0x84D2),
        Texture19 = ((int)0x84D3),
        Texture20 = ((int)0x84D4),
        Texture21 = ((int)0x84D5),
        Texture22 = ((int)0x84D6),
        Texture23 = ((int)0x84D7),
        Texture24 = ((int)0x84D8),
        Texture25 = ((int)0x84D9),
        Texture26 = ((int)0x84DA),
        Texture27 = ((int)0x84DB),
        Texture28 = ((int)0x84DC),
        Texture29 = ((int)0x84DD),
        Texture30 = ((int)0x84DE),
        Texture31 = ((int)0x84DF),
        ActiveTexture = ((int)0x84E0),
        CompressedRgb = ((int)0x84ED),
        CompressedRgba = ((int)0x84EE),
        TextureCompressionHint = ((int)0x84EF),
        TextureCubeMap = ((int)0x8513),
        TextureBindingCubeMap = ((int)0x8514),
        TextureCubeMapPositiveX = ((int)0x8515),
        TextureCubeMapNegativeX = ((int)0x8516),
        TextureCubeMapPositiveY = ((int)0x8517),
        TextureCubeMapNegativeY = ((int)0x8518),
        TextureCubeMapPositiveZ = ((int)0x8519),
        TextureCubeMapNegativeZ = ((int)0x851A),
        ProxyTextureCubeMap = ((int)0x851B),
        MaxCubeMapTextureSize = ((int)0x851C),
        TextureCompressedImageSize = ((int)0x86A0),
        TextureCompressed = ((int)0x86A1),
        NumCompressedTextureFormats = ((int)0x86A2),
        CompressedTextureFormats = ((int)0x86A3),
    }

    public enum Version13Deprecated : int
    {
        MultisampleBit = ((int)0x20000000),
        ClientActiveTexture = ((int)0x84E1),
        MaxTextureUnits = ((int)0x84E2),
        TransposeModelviewMatrix = ((int)0x84E3),
        TransposeProjectionMatrix = ((int)0x84E4),
        TransposeTextureMatrix = ((int)0x84E5),
        TransposeColorMatrix = ((int)0x84E6),
        Subtract = ((int)0x84E7),
        CompressedAlpha = ((int)0x84E9),
        CompressedLuminance = ((int)0x84EA),
        CompressedLuminanceAlpha = ((int)0x84EB),
        CompressedIntensity = ((int)0x84EC),
        NormalMap = ((int)0x8511),
        ReflectionMap = ((int)0x8512),
        Combine = ((int)0x8570),
        CombineRgb = ((int)0x8571),
        CombineAlpha = ((int)0x8572),
        RgbScale = ((int)0x8573),
        AddSigned = ((int)0x8574),
        Interpolate = ((int)0x8575),
        Constant = ((int)0x8576),
        PrimaryColor = ((int)0x8577),
        Previous = ((int)0x8578),
        Source0Rgb = ((int)0x8580),
        Source1Rgb = ((int)0x8581),
        Source2Rgb = ((int)0x8582),
        Source0Alpha = ((int)0x8588),
        Source1Alpha = ((int)0x8589),
        Source2Alpha = ((int)0x858A),
        Operand0Rgb = ((int)0x8590),
        Operand1Rgb = ((int)0x8591),
        Operand2Rgb = ((int)0x8592),
        Operand0Alpha = ((int)0x8598),
        Operand1Alpha = ((int)0x8599),
        Operand2Alpha = ((int)0x859A),
        Dot3Rgb = ((int)0x86AE),
        Dot3Rgba = ((int)0x86AF),
    }

    public enum Version14 : int
    {
        BlendDstRgb = ((int)0x80C8),
        BlendSrcRgb = ((int)0x80C9),
        BlendDstAlpha = ((int)0x80CA),
        BlendSrcAlpha = ((int)0x80CB),
        PointSizeMin = ((int)0x8126),
        PointSizeMax = ((int)0x8127),
        PointFadeThresholdSize = ((int)0x8128),
        PointDistanceAttenuation = ((int)0x8129),
        GenerateMipmap = ((int)0x8191),
        GenerateMipmapHint = ((int)0x8192),
        DepthComponent16 = ((int)0x81A5),
        DepthComponent24 = ((int)0x81A6),
        DepthComponent32 = ((int)0x81A7),
        MirroredRepeat = ((int)0x8370),
        MaxTextureLodBias = ((int)0x84FD),
        TextureLodBias = ((int)0x8501),
        IncrWrap = ((int)0x8507),
        DecrWrap = ((int)0x8508),
        TextureDepthSize = ((int)0x884A),
        TextureCompareMode = ((int)0x884C),
        TextureCompareFunc = ((int)0x884D),
    }

    public enum Version14Deprecated : int
    {
        PointSizeMin = ((int)0x8126),
        PointSizeMax = ((int)0x8127),
        PointDistanceAttenuation = ((int)0x8129),
        GenerateMipmap = ((int)0x8191),
        GenerateMipmapHint = ((int)0x8192),
        FogCoordinateSource = ((int)0x8450),
        FogCoordinate = ((int)0x8451),
        FragmentDepth = ((int)0x8452),
        CurrentFogCoordinate = ((int)0x8453),
        FogCoordinateArrayType = ((int)0x8454),
        FogCoordinateArrayStride = ((int)0x8455),
        FogCoordinateArrayPointer = ((int)0x8456),
        FogCoordinateArray = ((int)0x8457),
        ColorSum = ((int)0x8458),
        CurrentSecondaryColor = ((int)0x8459),
        SecondaryColorArraySize = ((int)0x845A),
        SecondaryColorArrayType = ((int)0x845B),
        SecondaryColorArrayStride = ((int)0x845C),
        SecondaryColorArrayPointer = ((int)0x845D),
        SecondaryColorArray = ((int)0x845E),
        TextureFilterControl = ((int)0x8500),
        DepthTextureMode = ((int)0x884B),
        CompareRToTexture = ((int)0x884E),
    }

    public enum Version15 : int
    {
        BufferSize = ((int)0x8764),
        BufferUsage = ((int)0x8765),
        QueryCounterBits = ((int)0x8864),
        CurrentQuery = ((int)0x8865),
        QueryResult = ((int)0x8866),
        QueryResultAvailable = ((int)0x8867),
        ArrayBuffer = ((int)0x8892),
        ElementArrayBuffer = ((int)0x8893),
        ArrayBufferBinding = ((int)0x8894),
        ElementArrayBufferBinding = ((int)0x8895),
        VertexAttribArrayBufferBinding = ((int)0x889F),
        ReadOnly = ((int)0x88B8),
        WriteOnly = ((int)0x88B9),
        ReadWrite = ((int)0x88BA),
        BufferAccess = ((int)0x88BB),
        BufferMapped = ((int)0x88BC),
        BufferMapPointer = ((int)0x88BD),
        StreamDraw = ((int)0x88E0),
        StreamRead = ((int)0x88E1),
        StreamCopy = ((int)0x88E2),
        StaticDraw = ((int)0x88E4),
        StaticRead = ((int)0x88E5),
        StaticCopy = ((int)0x88E6),
        DynamicDraw = ((int)0x88E8),
        DynamicRead = ((int)0x88E9),
        DynamicCopy = ((int)0x88EA),
        SamplesPassed = ((int)0x8914),
    }

    public enum Version15Deprecated : int
    {
        FogCoordSrc = ((int)0x8450),
        FogCoord = ((int)0x8451),
        CurrentFogCoord = ((int)0x8453),
        FogCoordArrayType = ((int)0x8454),
        FogCoordArrayStride = ((int)0x8455),
        FogCoordArrayPointer = ((int)0x8456),
        FogCoordArray = ((int)0x8457),
        Src0Rgb = ((int)0x8580),
        Src1Rgb = ((int)0x8581),
        Src2Rgb = ((int)0x8582),
        Src0Alpha = ((int)0x8588),
        Src1Alpha = ((int)0x8589),
        Src2Alpha = ((int)0x858A),
        VertexArrayBufferBinding = ((int)0x8896),
        NormalArrayBufferBinding = ((int)0x8897),
        ColorArrayBufferBinding = ((int)0x8898),
        IndexArrayBufferBinding = ((int)0x8899),
        TextureCoordArrayBufferBinding = ((int)0x889A),
        EdgeFlagArrayBufferBinding = ((int)0x889B),
        SecondaryColorArrayBufferBinding = ((int)0x889C),
        FogCoordArrayBufferBinding = ((int)0x889D),
        FogCoordinateArrayBufferBinding = ((int)0x889D),
        WeightArrayBufferBinding = ((int)0x889E),
    }

    public enum Version20 : int
    {
        BlendEquationRgb = ((int)0x8009),
        VertexAttribArrayEnabled = ((int)0x8622),
        VertexAttribArraySize = ((int)0x8623),
        VertexAttribArrayStride = ((int)0x8624),
        VertexAttribArrayType = ((int)0x8625),
        CurrentVertexAttrib = ((int)0x8626),
        VertexProgramPointSize = ((int)0x8642),
        VertexAttribArrayPointer = ((int)0x8645),
        StencilBackFunc = ((int)0x8800),
        StencilBackFail = ((int)0x8801),
        StencilBackPassDepthFail = ((int)0x8802),
        StencilBackPassDepthPass = ((int)0x8803),
        MaxDrawBuffers = ((int)0x8824),
        DrawBuffer0 = ((int)0x8825),
        DrawBuffer1 = ((int)0x8826),
        DrawBuffer2 = ((int)0x8827),
        DrawBuffer3 = ((int)0x8828),
        DrawBuffer4 = ((int)0x8829),
        DrawBuffer5 = ((int)0x882A),
        DrawBuffer6 = ((int)0x882B),
        DrawBuffer7 = ((int)0x882C),
        DrawBuffer8 = ((int)0x882D),
        DrawBuffer9 = ((int)0x882E),
        DrawBuffer10 = ((int)0x882F),
        DrawBuffer11 = ((int)0x8830),
        DrawBuffer12 = ((int)0x8831),
        DrawBuffer13 = ((int)0x8832),
        DrawBuffer14 = ((int)0x8833),
        DrawBuffer15 = ((int)0x8834),
        BlendEquationAlpha = ((int)0x883D),
        MaxVertexAttribs = ((int)0x8869),
        VertexAttribArrayNormalized = ((int)0x886A),
        MaxTextureImageUnits = ((int)0x8872),
        FragmentShader = ((int)0x8B30),
        VertexShader = ((int)0x8B31),
        MaxFragmentUniformComponents = ((int)0x8B49),
        MaxVertexUniformComponents = ((int)0x8B4A),
        MaxVaryingFloats = ((int)0x8B4B),
        MaxVertexTextureImageUnits = ((int)0x8B4C),
        MaxCombinedTextureImageUnits = ((int)0x8B4D),
        ShaderType = ((int)0x8B4F),
        FloatVec2 = ((int)0x8B50),
        FloatVec3 = ((int)0x8B51),
        FloatVec4 = ((int)0x8B52),
        IntVec2 = ((int)0x8B53),
        IntVec3 = ((int)0x8B54),
        IntVec4 = ((int)0x8B55),
        Bool = ((int)0x8B56),
        BoolVec2 = ((int)0x8B57),
        BoolVec3 = ((int)0x8B58),
        BoolVec4 = ((int)0x8B59),
        FloatMat2 = ((int)0x8B5A),
        FloatMat3 = ((int)0x8B5B),
        FloatMat4 = ((int)0x8B5C),
        Sampler1D = ((int)0x8B5D),
        Sampler2D = ((int)0x8B5E),
        Sampler3D = ((int)0x8B5F),
        SamplerCube = ((int)0x8B60),
        Sampler1DShadow = ((int)0x8B61),
        Sampler2DShadow = ((int)0x8B62),
        DeleteStatus = ((int)0x8B80),
        CompileStatus = ((int)0x8B81),
        LinkStatus = ((int)0x8B82),
        ValidateStatus = ((int)0x8B83),
        InfoLogLength = ((int)0x8B84),
        AttachedShaders = ((int)0x8B85),
        ActiveUniforms = ((int)0x8B86),
        ActiveUniformMaxLength = ((int)0x8B87),
        ShaderSourceLength = ((int)0x8B88),
        ActiveAttributes = ((int)0x8B89),
        ActiveAttributeMaxLength = ((int)0x8B8A),
        FragmentShaderDerivativeHint = ((int)0x8B8B),
        ShadingLanguageVersion = ((int)0x8B8C),
        CurrentProgram = ((int)0x8B8D),
        PointSpriteCoordOrigin = ((int)0x8CA0),
        LowerLeft = ((int)0x8CA1),
        UpperLeft = ((int)0x8CA2),
        StencilBackRef = ((int)0x8CA3),
        StencilBackValueMask = ((int)0x8CA4),
        StencilBackWritemask = ((int)0x8CA5),
    }

    public enum Version20Deprecated : int
    {
        VertexProgramTwoSide = ((int)0x8643),
        PointSprite = ((int)0x8861),
        CoordReplace = ((int)0x8862),
        MaxTextureCoords = ((int)0x8871),
    }

    public enum Version21 : int
    {
        PixelPackBuffer = ((int)0x88EB),
        PixelUnpackBuffer = ((int)0x88EC),
        PixelPackBufferBinding = ((int)0x88ED),
        PixelUnpackBufferBinding = ((int)0x88EF),
        FloatMat2x3 = ((int)0x8B65),
        FloatMat2x4 = ((int)0x8B66),
        FloatMat3x2 = ((int)0x8B67),
        FloatMat3x4 = ((int)0x8B68),
        FloatMat4x2 = ((int)0x8B69),
        FloatMat4x3 = ((int)0x8B6A),
        Srgb = ((int)0x8C40),
        Srgb8 = ((int)0x8C41),
        SrgbAlpha = ((int)0x8C42),
        Srgb8Alpha8 = ((int)0x8C43),
        CompressedSrgb = ((int)0x8C48),
        CompressedSrgbAlpha = ((int)0x8C49),
    }

    public enum Version21Deprecated : int
    {
        CurrentRasterSecondaryColor = ((int)0x845F),
        SluminanceAlpha = ((int)0x8C44),
        Sluminance8Alpha8 = ((int)0x8C45),
        Sluminance = ((int)0x8C46),
        Sluminance8 = ((int)0x8C47),
        CompressedSluminance = ((int)0x8C4A),
        CompressedSluminanceAlpha = ((int)0x8C4B),
    }

    public enum Version30 : int
    {
        ContextFlagForwardCompatibleBit = ((int)0x0001),
        MapReadBit = ((int)0x0001),
        MapWriteBit = ((int)0x0002),
        MapInvalidateRangeBit = ((int)0x0004),
        MapInvalidateBufferBit = ((int)0x0008),
        MapFlushExplicitBit = ((int)0x0010),
        MapUnsynchronizedBit = ((int)0x0020),
        InvalidFramebufferOperation = ((int)0x0506),
        MaxClipDistances = ((int)0x0D32),
        HalfFloat = ((int)0x140B),
        ClipDistance0 = ((int)0x3000),
        ClipDistance1 = ((int)0x3001),
        ClipDistance2 = ((int)0x3002),
        ClipDistance3 = ((int)0x3003),
        ClipDistance4 = ((int)0x3004),
        ClipDistance5 = ((int)0x3005),
        ClipDistance6 = ((int)0x3006),
        ClipDistance7 = ((int)0x3007),
        FramebufferAttachmentColorEncoding = ((int)0x8210),
        FramebufferAttachmentComponentType = ((int)0x8211),
        FramebufferAttachmentRedSize = ((int)0x8212),
        FramebufferAttachmentGreenSize = ((int)0x8213),
        FramebufferAttachmentBlueSize = ((int)0x8214),
        FramebufferAttachmentAlphaSize = ((int)0x8215),
        FramebufferAttachmentDepthSize = ((int)0x8216),
        FramebufferAttachmentStencilSize = ((int)0x8217),
        FramebufferDefault = ((int)0x8218),
        FramebufferUndefined = ((int)0x8219),
        DepthStencilAttachment = ((int)0x821A),
        MajorVersion = ((int)0x821B),
        MinorVersion = ((int)0x821C),
        NumExtensions = ((int)0x821D),
        ContextFlags = ((int)0x821E),
        DepthBuffer = ((int)0x8223),
        StencilBuffer = ((int)0x8224),
        CompressedRed = ((int)0x8225),
        CompressedRg = ((int)0x8226),
        Rg = ((int)0x8227),
        RgInteger = ((int)0x8228),
        R8 = ((int)0x8229),
        R16 = ((int)0x822A),
        Rg8 = ((int)0x822B),
        Rg16 = ((int)0x822C),
        R16f = ((int)0x822D),
        R32f = ((int)0x822E),
        Rg16f = ((int)0x822F),
        Rg32f = ((int)0x8230),
        R8i = ((int)0x8231),
        R8ui = ((int)0x8232),
        R16i = ((int)0x8233),
        R16ui = ((int)0x8234),
        R32i = ((int)0x8235),
        R32ui = ((int)0x8236),
        Rg8i = ((int)0x8237),
        Rg8ui = ((int)0x8238),
        Rg16i = ((int)0x8239),
        Rg16ui = ((int)0x823A),
        Rg32i = ((int)0x823B),
        Rg32ui = ((int)0x823C),
        MaxRenderbufferSize = ((int)0x84E8),
        DepthStencil = ((int)0x84F9),
        UnsignedInt248 = ((int)0x84FA),
        VertexArrayBinding = ((int)0x85B5),
        Rgba32f = ((int)0x8814),
        Rgb32f = ((int)0x8815),
        Rgba16f = ((int)0x881A),
        Rgb16f = ((int)0x881B),
        CompareRefToTexture = ((int)0x884E),
        Depth24Stencil8 = ((int)0x88F0),
        TextureStencilSize = ((int)0x88F1),
        VertexAttribArrayInteger = ((int)0x88FD),
        MaxArrayTextureLayers = ((int)0x88FF),
        MinProgramTexelOffset = ((int)0x8904),
        MaxProgramTexelOffset = ((int)0x8905),
        ClampReadColor = ((int)0x891C),
        FixedOnly = ((int)0x891D),
        MaxVaryingComponents = ((int)0x8B4B),
        TextureRedType = ((int)0x8C10),
        TextureGreenType = ((int)0x8C11),
        TextureBlueType = ((int)0x8C12),
        TextureAlphaType = ((int)0x8C13),
        TextureDepthType = ((int)0x8C16),
        UnsignedNormalized = ((int)0x8C17),
        Texture1DArray = ((int)0x8C18),
        ProxyTexture1DArray = ((int)0x8C19),
        Texture2DArray = ((int)0x8C1A),
        ProxyTexture2DArray = ((int)0x8C1B),
        TextureBinding1DArray = ((int)0x8C1C),
        TextureBinding2DArray = ((int)0x8C1D),
        R11fG11fB10f = ((int)0x8C3A),
        UnsignedInt10F11F11FRev = ((int)0x8C3B),
        Rgb9E5 = ((int)0x8C3D),
        UnsignedInt5999Rev = ((int)0x8C3E),
        TextureSharedSize = ((int)0x8C3F),
        TransformFeedbackVaryingMaxLength = ((int)0x8C76),
        TransformFeedbackBufferMode = ((int)0x8C7F),
        MaxTransformFeedbackSeparateComponents = ((int)0x8C80),
        TransformFeedbackVaryings = ((int)0x8C83),
        TransformFeedbackBufferStart = ((int)0x8C84),
        TransformFeedbackBufferSize = ((int)0x8C85),
        PrimitivesGenerated = ((int)0x8C87),
        TransformFeedbackPrimitivesWritten = ((int)0x8C88),
        RasterizerDiscard = ((int)0x8C89),
        MaxTransformFeedbackInterleavedComponents = ((int)0x8C8A),
        MaxTransformFeedbackSeparateAttribs = ((int)0x8C8B),
        InterleavedAttribs = ((int)0x8C8C),
        SeparateAttribs = ((int)0x8C8D),
        TransformFeedbackBuffer = ((int)0x8C8E),
        TransformFeedbackBufferBinding = ((int)0x8C8F),
        DrawFramebufferBinding = ((int)0x8CA6),
        FramebufferBinding = ((int)0x8CA6),
        RenderbufferBinding = ((int)0x8CA7),
        ReadFramebuffer = ((int)0x8CA8),
        DrawFramebuffer = ((int)0x8CA9),
        ReadFramebufferBinding = ((int)0x8CAA),
        RenderbufferSamples = ((int)0x8CAB),
        DepthComponent32f = ((int)0x8CAC),
        Depth32fStencil8 = ((int)0x8CAD),
        FramebufferAttachmentObjectType = ((int)0x8CD0),
        FramebufferAttachmentObjectName = ((int)0x8CD1),
        FramebufferAttachmentTextureLevel = ((int)0x8CD2),
        FramebufferAttachmentTextureCubeMapFace = ((int)0x8CD3),
        FramebufferAttachmentTextureLayer = ((int)0x8CD4),
        FramebufferComplete = ((int)0x8CD5),
        FramebufferIncompleteAttachment = ((int)0x8CD6),
        FramebufferIncompleteMissingAttachment = ((int)0x8CD7),
        FramebufferIncompleteDrawBuffer = ((int)0x8CDB),
        FramebufferIncompleteReadBuffer = ((int)0x8CDC),
        FramebufferUnsupported = ((int)0x8CDD),
        MaxColorAttachments = ((int)0x8CDF),
        ColorAttachment0 = ((int)0x8CE0),
        ColorAttachment1 = ((int)0x8CE1),
        ColorAttachment2 = ((int)0x8CE2),
        ColorAttachment3 = ((int)0x8CE3),
        ColorAttachment4 = ((int)0x8CE4),
        ColorAttachment5 = ((int)0x8CE5),
        ColorAttachment6 = ((int)0x8CE6),
        ColorAttachment7 = ((int)0x8CE7),
        ColorAttachment8 = ((int)0x8CE8),
        ColorAttachment9 = ((int)0x8CE9),
        ColorAttachment10 = ((int)0x8CEA),
        ColorAttachment11 = ((int)0x8CEB),
        ColorAttachment12 = ((int)0x8CEC),
        ColorAttachment13 = ((int)0x8CED),
        ColorAttachment14 = ((int)0x8CEE),
        ColorAttachment15 = ((int)0x8CEF),
        DepthAttachment = ((int)0x8D00),
        StencilAttachment = ((int)0x8D20),
        Framebuffer = ((int)0x8D40),
        Renderbuffer = ((int)0x8D41),
        RenderbufferWidth = ((int)0x8D42),
        RenderbufferHeight = ((int)0x8D43),
        RenderbufferInternalFormat = ((int)0x8D44),
        StencilIndex1 = ((int)0x8D46),
        StencilIndex4 = ((int)0x8D47),
        StencilIndex8 = ((int)0x8D48),
        StencilIndex16 = ((int)0x8D49),
        RenderbufferRedSize = ((int)0x8D50),
        RenderbufferGreenSize = ((int)0x8D51),
        RenderbufferBlueSize = ((int)0x8D52),
        RenderbufferAlphaSize = ((int)0x8D53),
        RenderbufferDepthSize = ((int)0x8D54),
        RenderbufferStencilSize = ((int)0x8D55),
        FramebufferIncompleteMultisample = ((int)0x8D56),
        MaxSamples = ((int)0x8D57),
        Rgba32ui = ((int)0x8D70),
        Rgb32ui = ((int)0x8D71),
        Rgba16ui = ((int)0x8D76),
        Rgb16ui = ((int)0x8D77),
        Rgba8ui = ((int)0x8D7C),
        Rgb8ui = ((int)0x8D7D),
        Rgba32i = ((int)0x8D82),
        Rgb32i = ((int)0x8D83),
        Rgba16i = ((int)0x8D88),
        Rgb16i = ((int)0x8D89),
        Rgba8i = ((int)0x8D8E),
        Rgb8i = ((int)0x8D8F),
        RedInteger = ((int)0x8D94),
        GreenInteger = ((int)0x8D95),
        BlueInteger = ((int)0x8D96),
        RgbInteger = ((int)0x8D98),
        RgbaInteger = ((int)0x8D99),
        BgrInteger = ((int)0x8D9A),
        BgraInteger = ((int)0x8D9B),
        Float32UnsignedInt248Rev = ((int)0x8DAD),
        FramebufferSrgb = ((int)0x8DB9),
        CompressedRedRgtc1 = ((int)0x8DBB),
        CompressedSignedRedRgtc1 = ((int)0x8DBC),
        CompressedRgRgtc2 = ((int)0x8DBD),
        CompressedSignedRgRgtc2 = ((int)0x8DBE),
        Sampler1DArray = ((int)0x8DC0),
        Sampler2DArray = ((int)0x8DC1),
        Sampler1DArrayShadow = ((int)0x8DC3),
        Sampler2DArrayShadow = ((int)0x8DC4),
        SamplerCubeShadow = ((int)0x8DC5),
        UnsignedIntVec2 = ((int)0x8DC6),
        UnsignedIntVec3 = ((int)0x8DC7),
        UnsignedIntVec4 = ((int)0x8DC8),
        IntSampler1D = ((int)0x8DC9),
        IntSampler2D = ((int)0x8DCA),
        IntSampler3D = ((int)0x8DCB),
        IntSamplerCube = ((int)0x8DCC),
        IntSampler1DArray = ((int)0x8DCE),
        IntSampler2DArray = ((int)0x8DCF),
        UnsignedIntSampler1D = ((int)0x8DD1),
        UnsignedIntSampler2D = ((int)0x8DD2),
        UnsignedIntSampler3D = ((int)0x8DD3),
        UnsignedIntSamplerCube = ((int)0x8DD4),
        UnsignedIntSampler1DArray = ((int)0x8DD6),
        UnsignedIntSampler2DArray = ((int)0x8DD7),
        QueryWait = ((int)0x8E13),
        QueryNoWait = ((int)0x8E14),
        QueryByRegionWait = ((int)0x8E15),
        QueryByRegionNoWait = ((int)0x8E16),
        BufferAccessFlags = ((int)0x911F),
        BufferMapLength = ((int)0x9120),
        BufferMapOffset = ((int)0x9121),
    }

    public enum Version30Deprecated : int
    {
        ClampVertexColor = ((int)0x891A),
        ClampFragmentColor = ((int)0x891B),
        AlphaInteger = ((int)0x8D97),
    }

    public enum Version31 : int
    {
        TextureRectangle = ((int)0x84F5),
        TextureBindingRectangle = ((int)0x84F6),
        ProxyTextureRectangle = ((int)0x84F7),
        MaxRectangleTextureSize = ((int)0x84F8),
        UniformBuffer = ((int)0x8A11),
        UniformBufferBinding = ((int)0x8A28),
        UniformBufferStart = ((int)0x8A29),
        UniformBufferSize = ((int)0x8A2A),
        MaxVertexUniformBlocks = ((int)0x8A2B),
        MaxFragmentUniformBlocks = ((int)0x8A2D),
        MaxCombinedUniformBlocks = ((int)0x8A2E),
        MaxUniformBufferBindings = ((int)0x8A2F),
        MaxUniformBlockSize = ((int)0x8A30),
        MaxCombinedVertexUniformComponents = ((int)0x8A31),
        MaxCombinedFragmentUniformComponents = ((int)0x8A33),
        UniformBufferOffsetAlignment = ((int)0x8A34),
        ActiveUniformBlockMaxNameLength = ((int)0x8A35),
        ActiveUniformBlocks = ((int)0x8A36),
        UniformType = ((int)0x8A37),
        UniformSize = ((int)0x8A38),
        UniformNameLength = ((int)0x8A39),
        UniformBlockIndex = ((int)0x8A3A),
        UniformOffset = ((int)0x8A3B),
        UniformArrayStride = ((int)0x8A3C),
        UniformMatrixStride = ((int)0x8A3D),
        UniformIsRowMajor = ((int)0x8A3E),
        UniformBlockBinding = ((int)0x8A3F),
        UniformBlockDataSize = ((int)0x8A40),
        UniformBlockNameLength = ((int)0x8A41),
        UniformBlockActiveUniforms = ((int)0x8A42),
        UniformBlockActiveUniformIndices = ((int)0x8A43),
        UniformBlockReferencedByVertexShader = ((int)0x8A44),
        UniformBlockReferencedByFragmentShader = ((int)0x8A46),
        Sampler2DRect = ((int)0x8B63),
        Sampler2DRectShadow = ((int)0x8B64),
        TextureBuffer = ((int)0x8C2A),
        MaxTextureBufferSize = ((int)0x8C2B),
        TextureBindingBuffer = ((int)0x8C2C),
        TextureBufferDataStoreBinding = ((int)0x8C2D),
        TextureBufferFormat = ((int)0x8C2E),
        SamplerBuffer = ((int)0x8DC2),
        IntSampler2DRect = ((int)0x8DCD),
        IntSamplerBuffer = ((int)0x8DD0),
        UnsignedIntSampler2DRect = ((int)0x8DD5),
        UnsignedIntSamplerBuffer = ((int)0x8DD8),
        CopyReadBuffer = ((int)0x8F36),
        CopyWriteBuffer = ((int)0x8F37),
        RedSnorm = ((int)0x8F90),
        RgSnorm = ((int)0x8F91),
        RgbSnorm = ((int)0x8F92),
        RgbaSnorm = ((int)0x8F93),
        R8Snorm = ((int)0x8F94),
        Rg8Snorm = ((int)0x8F95),
        Rgb8Snorm = ((int)0x8F96),
        Rgba8Snorm = ((int)0x8F97),
        R16Snorm = ((int)0x8F98),
        Rg16Snorm = ((int)0x8F99),
        Rgb16Snorm = ((int)0x8F9A),
        Rgba16Snorm = ((int)0x8F9B),
        SignedNormalized = ((int)0x8F9C),
        PrimitiveRestart = ((int)0x8F9D),
        PrimitiveRestartIndex = ((int)0x8F9E),
        InvalidIndex = unchecked((int)0xFFFFFFFF),
    }

    public enum Version32 : int
    {
        ContextCoreProfileBit = ((int)0x00000001),
        SyncFlushCommandsBit = ((int)0x00000001),
        ContextCompatibilityProfileBit = ((int)0x00000002),
        LinesAdjacency = ((int)0x000A),
        LineStripAdjacency = ((int)0x000B),
        TrianglesAdjacency = ((int)0x000C),
        TriangleStripAdjacency = ((int)0x000D),
        ProgramPointSize = ((int)0x8642),
        DepthClamp = ((int)0x864F),
        TextureCubeMapSeamless = ((int)0x884F),
        GeometryVerticesOut = ((int)0x8916),
        GeometryInputType = ((int)0x8917),
        GeometryOutputType = ((int)0x8918),
        MaxVaryingComponents = ((int)0x8B4B),
        MaxGeometryTextureImageUnits = ((int)0x8C29),
        FramebufferAttachmentTextureLayer = ((int)0x8CD4),
        FramebufferAttachmentLayered = ((int)0x8DA7),
        FramebufferIncompleteLayerTargets = ((int)0x8DA8),
        GeometryShader = ((int)0x8DD9),
        MaxGeometryUniformComponents = ((int)0x8DDF),
        MaxGeometryOutputVertices = ((int)0x8DE0),
        MaxGeometryTotalOutputComponents = ((int)0x8DE1),
        QuadsFollowProvokingVertexConvention = ((int)0x8E4C),
        FirstVertexConvention = ((int)0x8E4D),
        LastVertexConvention = ((int)0x8E4E),
        ProvokingVertex = ((int)0x8E4F),
        SamplePosition = ((int)0x8E50),
        SampleMask = ((int)0x8E51),
        SampleMaskValue = ((int)0x8E52),
        MaxSampleMaskWords = ((int)0x8E59),
        Texture2DMultisample = ((int)0x9100),
        ProxyTexture2DMultisample = ((int)0x9101),
        Texture2DMultisampleArray = ((int)0x9102),
        ProxyTexture2DMultisampleArray = ((int)0x9103),
        TextureBinding2DMultisample = ((int)0x9104),
        TextureBinding2DMultisampleArray = ((int)0x9105),
        TextureSamples = ((int)0x9106),
        TextureFixedSampleLocations = ((int)0x9107),
        Sampler2DMultisample = ((int)0x9108),
        IntSampler2DMultisample = ((int)0x9109),
        UnsignedIntSampler2DMultisample = ((int)0x910A),
        Sampler2DMultisampleArray = ((int)0x910B),
        IntSampler2DMultisampleArray = ((int)0x910C),
        UnsignedIntSampler2DMultisampleArray = ((int)0x910D),
        MaxColorTextureSamples = ((int)0x910E),
        MaxDepthTextureSamples = ((int)0x910F),
        MaxIntegerSamples = ((int)0x9110),
        MaxServerWaitTimeout = ((int)0x9111),
        ObjectType = ((int)0x9112),
        SyncCondition = ((int)0x9113),
        SyncStatus = ((int)0x9114),
        SyncFlags = ((int)0x9115),
        SyncFence = ((int)0x9116),
        SyncGpuCommandsComplete = ((int)0x9117),
        Unsignaled = ((int)0x9118),
        Signaled = ((int)0x9119),
        AlreadySignaled = ((int)0x911A),
        TimeoutExpired = ((int)0x911B),
        ConditionSatisfied = ((int)0x911C),
        WaitFailed = ((int)0x911D),
        MaxVertexOutputComponents = ((int)0x9122),
        MaxGeometryInputComponents = ((int)0x9123),
        MaxGeometryOutputComponents = ((int)0x9124),
        MaxFragmentInputComponents = ((int)0x9125),
        ContextProfileMask = ((int)0x9126),
        TimeoutIgnored = unchecked((int)0xFFFFFFFFFFFFFFFF),
    }

    public enum VertexAttribIPointerType : int
    {
        Byte = ((int)0x1400),
        UnsignedByte = ((int)0x1401),
        Short = ((int)0x1402),
        UnsignedShort = ((int)0x1403),
        Int = ((int)0x1404),
        UnsignedInt = ((int)0x1405),
    }

    public enum VertexAttribParameter : int
    {
        ArrayEnabled = ((int)0x8622),
        ArraySize = ((int)0x8623),
        ArrayStride = ((int)0x8624),
        ArrayType = ((int)0x8625),
        CurrentVertexAttrib = ((int)0x8626),
        ArrayNormalized = ((int)0x886A),
        VertexAttribArrayInteger = ((int)0x88FD),
    }

    public enum VertexAttribParameterArb : int
    {
        ArrayEnabled = ((int)0x8622),
        ArraySize = ((int)0x8623),
        ArrayStride = ((int)0x8624),
        ArrayType = ((int)0x8625),
        CurrentVertexAttrib = ((int)0x8626),
        ArrayNormalized = ((int)0x886A),
        ArrayDivisor = ((int)0x88FE),
    }

    public enum VertexAttribPointerParameter : int
    {
        ArrayPointer = ((int)0x8645),
    }

    public enum VertexAttribPointerParameterArb : int
    {
        ArrayPointer = ((int)0x8645),
    }

    public enum VertexAttribPointerType : int
    {
        Byte = ((int)0x1400),
        UnsignedByte = ((int)0x1401),
        Short = ((int)0x1402),
        UnsignedShort = ((int)0x1403),
        Int = ((int)0x1404),
        UnsignedInt = ((int)0x1405),
        Float = ((int)0x1406),
        Double = ((int)0x140A),
        HalfFloat = ((int)0x140B),
    }

    public enum VertexAttribPointerTypeArb : int
    {
        Byte = ((int)0x1400),
        UnsignedByte = ((int)0x1401),
        Short = ((int)0x1402),
        UnsignedShort = ((int)0x1403),
        Int = ((int)0x1404),
        UnsignedInt = ((int)0x1405),
        Float = ((int)0x1406),
        Double = ((int)0x140A),
    }

    public enum VertexPointerType : int
    {
        Short = ((int)0x1402),
        Int = ((int)0x1404),
        Float = ((int)0x1406),
        Double = ((int)0x140A),
        HalfFloat = ((int)0x140B),
    }

    public enum WinPhongShading : int
    {
        PhongWin = ((int)0x80EA),
        PhongHintWin = ((int)0x80EB),
    }

    public enum WinSpecularFog : int
    {
        FogSpecularTextureWin = ((int)0x80EC),
    }

}
