# Please do not change this widgets module for Quisk.  Instead copy
# it to your own quisk_widgets.py and make changes there.
#
# This module is used to add extra widgets to the QUISK screen.

import wx.lib.stattext
import _quisk as QS
import math
import chas_rx1 as CHASRX1

class BottomWidgets:	# Add extra widgets to the bottom of the screen
  def __init__(self, app, hardware, conf, frame, gbs, vertBox):
    self.hardware = hardware
######	SPOT BUTTON
#    b = app.QuiskCycleCheckbutton(frame, self.OnBtnSpot,
#       ('Spot', 'Spot -6db', 'Spot 0db'), color=conf.color_test)
#
#    gbs.Add(b, (4, 0), flag=wx.EXPAND)
#    b = app.QuiskCycleCheckbutton(frame, self.OnBtnFDX,
#        ('HALF', 'FULL'), color=conf.color_test)
#    gbs.Add(b, (4, 1), flag=wx.EXPAND)
    b = app.QuiskCycleCheckbutton(frame, self.OnBtnPGA,		# WB4JFI added for PGA Gain 
        ('PGA 0dB', 'PGA 1dB', 'PGA 2.5dB', 'PGA 4dB', 'PGA 6dB', 'PGA 8.5dB', 'PGA 12dB'),
        color=conf.color_test)
    b.SetIndex(6)
    gbs.Add(b, (4, 0), flag=wx.EXPAND)
    b = app.QuiskCycleCheckbutton(frame, self.OnBtnPREAMP,	# WB4JFI added for Preamp/Bypass
        ('PRE + LPF', 'BYPASS'), color=conf.color_test)
    gbs.Add(b, (4, 1), flag=wx.EXPAND)
    b = app.QuiskCycleCheckbutton(frame, self.OnBtnPREHILO,
        ('PRE HIGH', 'PRE LOW'), color=conf.color_test)
    gbs.Add(b, (4, 2), flag=wx.EXPAND)
    b = app.QuiskCycleCheckbutton(frame, self.OnBtnSLOPE,
        ('PRE POS', 'PRE NEG'), color=conf.color_test)
    gbs.Add(b, (4, 3), flag=wx.EXPAND)
#  Horizontal slider for setting Preamp gain - label first
    lab = wx.StaticText(frame, -1, 'Preamp', style=wx.ALIGN_CENTER)
    gbs.Add(lab, (5,0), flag=wx.EXPAND)
#  and now the Horizontal slider itself
    sl = wx.Slider(frame, -1, 2047, 0, 4095)			# parent, -1, initial, min, max
    gbs.Add(sl, (5,1), (1, 5), flag=wx.EXPAND)			# was (5,1), (1,5)
    sl.Bind(wx.EVT_SCROLL, self.OnPreamp)
#  CPU Load display on lower-right
#    lab = wx.StaticText(frame, -1, 'CPU load', style=wx.ALIGN_CENTER)
#    gbs.Add(lab, (4,10), flag=wx.EXPAND)
#  CPU Load display itself - in a window
#   self.cpu_load = t = wx.lib.stattext.GenStaticText(frame, -1, '',
#           style=wx.ST_NO_AUTORESIZE|wx.RAISED_BORDER)
#    font = wx.Font(12, wx.FONTFAMILY_SWISS, wx.NORMAL, wx.FONTWEIGHT_NORMAL)
#    t.SetFont(font)
#    w, h = t.GetTextExtent("W")
#    t.SetBackgroundColour(conf.color_freq)
#    gbs.Add(self.cpu_load, (4, 11), (1, 1), flag=wx.EXPAND)
#    self.UpdateCpu(1)
#
#    # RIT button
#    self.ritButton = QuiskCheckbutton(frame, self.OnBtnRit, "RIT")
#    gbs.Add(self.ritButton, (0, 7), flag=wx.ALIGN_CENTER)
#
#
#    app.BtnRfGain.Disable()				# WB4JFI - disable original SDR-IQ gain button
#
    b = app.QuiskCheckbutton(frame, self.OnBtnIMD, text='IMD', color=conf.color_test)
    b.Disable()
    gbs.Add(b, (4, 12), flag=wx.EXPAND)
#  def OnBtnFDX(self, btn):
#    if btn.GetValue():
#      self.hardware.FreezeTxFreq(1)
#      QS.set_fdx(1)
#    else:
#      self.hardware.FreezeTxFreq(0)
#      QS.set_fdx(0)
  def OnBtnPGA(self, event):
    btn = event.GetEventObject()
#    print "PGA: %d" % (btn.index)
    CHASRX1.pga_gain_chas_rx1(btn.index)
  def OnBtnPREAMP(self, event):			# WB4JFI added for Charleston Rx Preamp/Bypass
    btn = event.GetEventObject()
    if btn.GetValue():
      CHASRX1.rf_path_chas_rx1(0)
    else:
      CHASRX1.rf_path_chas_rx1(1)
  def OnBtnPREHILO(self, event):		# WB4JFI added for Charleston Rx Preamp Hi/Lo gain
    btn = event.GetEventObject()
    if btn.GetValue():
      CHASRX1.lna_range_chas_rx1(0)
    else:
      CHASRX1.lna_range_chas_rx1(1)
  def OnBtnSLOPE(self, event):			# WB4JFI added for Charleston Rx Preamp Pos/Neg slope
    btn = event.GetEventObject()
    if btn.GetValue():
      CHASRX1.lna_slope_chas_rx1(1)
    else:
      CHASRX1.lna_slope_chas_rx1(0)
  def OnBtnIMD(self, btn):
      QS.set_rx_mode(1)
  def OnPreamp(self, event):			# WB4JFI added for Charleston Rx Preamp gain amount
      CHASRX1.lna_gain_chas_rx1(event.GetPosition())
#
####	SPOT BUTTON
#  def OnBtnSpot(self, event):
#    btn = event.GetEventObject()
#    QS.set_spot_mode(btn.index)
#    self.hardware.anttuner.OnSpot(btn.index)
#     self.ritFreq = value
#      QS.set_tune(self.txFreq + self.ritFreq, self.txFreq)
#      QS.set_sidetone(self.sidetone_volume, self.ritFreq, conf.keyupDelay)
#
#  def UpdateCpu(self, param1):	# Called by Hardware
#    cpu=0.86 #param1
#    text = "   %.1f" % (cpu * 100)
#    self.cpu_load.SetLabel(text)
#
