package net.sf.saxon.lib;

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


/**
 * FeatureKeys defines a set of constants, representing the names of Saxon configuration
 * options which can be supplied to the Saxon implementations of the JAXP
 * interfaces TransformerFactory, SchemaFactory, Validator, and ValidationHandler,
 * and to other interfaces such as the s9api {@link net.sf.saxon.s9api.Processor}
 *
 * @author Michael H. Kay
 */

public abstract class FeatureKeys {

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>ALLOW_EXTERNAL_FUNCTIONS determines whether calls to reflexive external functions are
     *                 allowed. More specifically, if set to <b>false</b> it disallows all of the
     *                 following:</p>
     * <ul>
     * <li>Calls to reflexive Java extension functions</li>
     * <li>Use of the XSLT system-property() function to access Java system properties</li>
     * <li>Use of a relative URI in the <code>xsl:result-document</code> instruction</li>
     * <li>Calls to XSLT extension instructions</li></ul>
     * <p>The default value is <b>true</b>. The setting <b>false</b> is recommended in an
     *                 environment where untrusted stylesheets may be executed.</p>
     * <p>This option does not disable use of the <code>doc()</code> function or similar
     *                 functions to access the filestore of the machine where the transformation or query
     *                 is running. That should be done using a user-supplied <code>URIResolver</code></p>
     * <p>Note that integrated extension functions are trusted; calls to such functions are
     *                 allowed even if this configuration option is false. In cases where an integrated
     *                 extension function is used to load and execute untrusted code, it should check this
     *                 configuration option before doing so.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@allowExternalFunctions</i></p>
     * <p><i>Corresponding option on command line: -ext</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#isAllowExternalFunctions
     * @see net.sf.saxon.Configuration#setAllowExternalFunctions
     **/


    public final static String ALLOW_EXTERNAL_FUNCTIONS = 
        "http://saxon.sf.net/feature/allow-external-functions";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>ALLOW_MULTITHREADING determines whether multi-threading is allowed.</p>
     * <p>If true (the default), the presence of the attribute <code>saxon:threads="N"</code>
     *                 on an <code>xsl:for-each</code> instruction, when running under Saxon-EE, causes
     *                 multi-threaded execution. If set to false, the value of the
     *                     <code>saxon:threads</code> argument is ignored.</p>
     * <p>The default value is true if Saxon-EE is in use, false otherwise.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@allowMultithreading</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#isMultiThreading
     * @see net.sf.saxon.Configuration#setMultiThreading
     **/


    public final static String ALLOW_MULTITHREADING = 
        "http://saxon.sf.net/feature/allow-multithreading";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>ALLOW_OLD_JAVA_URI_FORMAT determines whether extension function calls to
     *                 dynamically-loaded Java extension functions may use the URI format supported in
     *                 older Saxon releases.</p>
     * <p>If the value is false (the default), the only URI format accepted is (for example)
     *                 "java:java.util.Date" - that is, a URI consisting of the string "java:" followed by
     *                 the Java qualified class name of the class containing the implementation of the
     *                 extension function.</p>
     * <p>If the value is true, then in addition to this format, the following are accepted:
     *                 (a) the Java class name on its own ("java.util.Date"), and (b) any URI in which the
     *                 Java class name follows the last "/" character (for example
     *                 "http://my.com/extensions/java.util.Date"). This last format was originally provided
     *                 for compatibility with xt and xalan, but it causes problems because it leads to
     *                 unnecessary attempts to load spurious classes when the user did not intend the URI
     *                 to represent a dynamically-loaded Java class.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@allowOldJavaUriFormat</i></p>
     * <p><i>Applies to Saxon editions: PE EE</i></p>
     **/


    public final static String ALLOW_OLD_JAVA_URI_FORMAT = 
        "http://saxon.sf.net/feature/allow-old-java-uri-format";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>ASSERTIONS_CAN_SEE_COMMENTS determines whether comment and processing instructions
     *             in a document being validated are visible to assertions in an XSD 1.1 schema.</p>
     * <p>If the value is false (the default), comments and processing instructions are
     *             stripped from the view of the document that is made visible to the XPath expression
     *             that implements the assertion. If this creates adjacent text nodes, they are collapsed
     *             into a single text node.</p>
     * <p>If the value is true, then comments and processing instructions are
     *             visible to the XPath assertion.</p>     *
     * <p><i>Corresponding attribute in configuration file: xsd/@assertionsCanSeeComments</i></p>
     * <p><i>Applies to Saxon editions: PE EE</i></p>
     **/


    public final static String ASSERTIONS_CAN_SEE_COMMENTS = 
        "http://saxon.sf.net/feature/assertionsCanSeeComments";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Instance of net.sf.saxon.lib.CollationURIResolver</p>
     *
     * <p>The supplied <code>CollationURIResolver</code> is used to process any collation URIs
     *                 found in the query or stylesheet, returning an object of class
     *                     <link>StringCollator</link> that implements the requested collation.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@collationUriResolver</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getCollationURIResolver
     * @see net.sf.saxon.Configuration#setCollationURIResolver
     **/


    public final static String COLLATION_URI_RESOLVER = 
        "http://saxon.sf.net/feature/collation-uri-resolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Name of class implementing net.sf.saxon.lib.CollationURIResolver</p>
     *
     * <p>The supplied class is instantiated and the resulting instance is used as the value of
     *                 the <link>FeatureKeys#COLLATION_URI_RESOLVER</link> property.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@collationUriResolver</i></p>
     * <p><i>Applies to Saxon editions: </i></p>
     * @see net.sf.saxon.Configuration#getCollationURIResolver
     * @see net.sf.saxon.Configuration#setCollationURIResolver
     **/


    public final static String COLLATION_URI_RESOLVER_CLASS = 
        "http://saxon.sf.net/feature/collation-uri-resolver-class";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Instance of net.sf.saxon.lib.CollectionURIResolver</p>
     *
     * <p>The supplied <code>CollectionURIResolver</code> is used to process any URIs used in
     *                 calls to the <code>collection()</code> function. The
     *                     <code>CollectionURIResolver</code> may either return a sequence of URIs (which
     *                 are then resolved in the same way as URIs passed to the <code>doc()</code>
     *                 function), or it may return a sequence of (typically document) nodes.</p>     *
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getCollectionURIResolver
     * @see net.sf.saxon.Configuration#setCollectionURIResolver
     **/


    public final static String COLLECTION_URI_RESOLVER = 
        "http://saxon.sf.net/feature/collection-uri-resolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Name of class implementing net.sf.saxon.lib.CollectionURIResolver</p>
     *
     * <p>The supplied class is instantiated and the resulting instance is used as the value of
     *                 the <link>FeatureKeys#COLLECTION_URI_RESOLVER</link> property.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@collectionUriResolver</i></p>
     * <p><i>Corresponding option on command line: -cr</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getCollectionURIResolver
     * @see net.sf.saxon.Configuration#setCollectionURIResolver
     **/


    public final static String COLLECTION_URI_RESOLVER_CLASS = 
        "http://saxon.sf.net/feature/collection-uri-resolver-class";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>If run-time tracing of stylesheet or query execution is required, then the code must
     *             be compiled with tracing enabled. Default is false. This option causes code to be
     *             compiled that makes calls to a <link>net.sf.saxon.lib.TraceListener</link>, but this has
     *             no effect unless a <code>TraceListener</code> is registered at execution time.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@compileWithTracing</i></p>
     * <p><i>Corresponding option on command line: automatically set when -T is present</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#isCompileWithTracing
     * @see net.sf.saxon.Configuration#setCompileWithTracing
     **/


    public final static String COMPILE_WITH_TRACING = 
        "http://saxon.sf.net/feature/compile-with-tracing";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: instance of class net.sf.saxon.Configuration</p>
     *
     * <p>This attribute cannot be set on the <link>net.sf.saxon.Configuration</link> itself,
     *                 but it can be set on various JAXP factory objects such as a TransformerFactory or
     *                 DocumentBuilderFactory, to ensure that several such factories use the same
     *                 Configuration. Note that other configuration options are held in the Configuration
     *                 object, so setting this attribute will cancel all others that have been set. Also,
     *                 if two factories share the same configuration, then setting an attribute on one
     *                 affects all the others.</p>     *
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     **/


    public final static String CONFIGURATION = 
        "http://saxon.sf.net/feature/configuration";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: filename</p>
     *
     * <p>Defines a configuration file to be applied to the configuration. This attribute cannot
     *             be set on the <link>net.sf.saxon.Configuration</link> itself, but it can be set on
     *             various JAXP factory objects such as a <code>TransformerFactory</code> or
     *                 <code>DocumentBuilderFactory</code>. It is particularly useful when running
     *             transformations via the Ant xslt task, where it can be set as follows to define all
     *             configuration settings: </p>
     * <p>
     *           &lt;factory name="net.sf.saxon.TransformerFactoryImpl"&gt;
     * 	 		  &lt;attribute name="http://saxon.sf.net/feature/configuration-file"
     *                         value="c:/saxon/config.xml"/&gt;
     *            &lt;/factory&gt;
     *       </p>     *
     * <p><i>Corresponding option on command line: -config:filename</i></p>
     * <p><i>Applies to Saxon editions: PE EE</i></p>
     **/


    public final static String CONFIGURATION_FILE = 
        "http://saxon.sf.net/feature/configuration-file";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This option is set to indicate that bytecode generation should be run in debugging mode. This
     *                 will be used only during Saxon product development; the setting should not be enabled
     *                 by users (and may not work in the released product).</p>     *
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#isDebugBytecode
     * @see net.sf.saxon.Configuration#setDebugBytecode
     **/


    public final static String DEBUG_BYTE_CODE = 
        "http://saxon.sf.net/feature/debugByteCode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Absolute URI (collation URI)</p>
     *
     * <p>This option determines the collation that is used for comparing strings when no
     *                 explicit collation is requested. It is not necessary for this collation to exist (or
     *                 to have been registered) when setting this option; it only needs to exist by the
     *                 time it is used.</p>
     * <p>In XSLT it is possible to override this setting using the
     *                     <code>[xsl:]default-collation</code> attribute on any stylesheet element. In
     *                 XQuery, it can be overridden using the <code>declare default collation</code>
     *                 declaration in the query prolog, or via a setter method in class
     *                     <link>net.sf.saxon.query.StaticQueryContext</link>.</p>
     * <p>If no value is specified, the Unicode codepoint collation is used.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@defaultCollation</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#getDefaultCollationName
     * @see net.sf.saxon.query.StaticQueryContext#declareDefaultCollation
     **/


    public final static String DEFAULT_COLLATION = 
        "http://saxon.sf.net/feature/defaultCollation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Absolute URI (collection URI)</p>
     *
     * <p> This determines the collection that is used when the <code>fn:collection()</code>
     *                 function is called with no arguments; the effect is the same as if it were called
     *                 passing the URI that is the value of this configuration property.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@defaultCollection</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getDefaultCollection
     * @see net.sf.saxon.Configuration#setDefaultCollection
     **/


    public final static String DEFAULT_COLLECTION = 
        "http://saxon.sf.net/feature/defaultCollection";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string (ISO 3166 country code)</p>
     *
     * <p> This determines the country that is used by <code>format-date()</code> and similar
     *                 functions if no country code is supplied explicitly. If no value is given for this
     *                 property, the default is taken from the Java Locale, which in turn typically depends
     *                 on settings for the current user in the operating system.</p>     *
     * <p><i>Corresponding attribute in configuration file: localizations/@defaultCountry</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getDefaultCountry
     * @see net.sf.saxon.Configuration#setDefaultCountry
     **/


    public final static String DEFAULT_COUNTRY = 
        "http://saxon.sf.net/feature/defaultCountry";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string (ISO language code, following the same rules as for xml:lang)</p>
     *
     * <p>This option determines the language that is used by <code>format-date()</code>,
     *                     <code>xsl:number</code> and similar constructs if no language code is supplied
     *                 explicitly. If no value is given for this property, the default is taken from the
     *                 Java Locale, which in turn typically depends on settings for the current user in the
     *                 operating system.</p>     *
     * <p><i>Corresponding attribute in configuration file: localizations/@defaultLanguage</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getDefaultLanguage
     * @see net.sf.saxon.Configuration#setDefaultLanguage
     **/


    public final static String DEFAULT_LANGUAGE = 
        "http://saxon.sf.net/feature/defaultLanguage";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This option is set to indicate that bytecode generation should be run in display mode. This
     *                 will be used only during Saxon product development; the setting should not be enabled
     *                 by users (and may not work in the released product).</p>     *
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#isDisplayBytecode
     * @see net.sf.saxon.Configuration#setDisplayBytecode
     **/


    public final static String DISPLAY_BYTE_CODE = 
        "http://saxon.sf.net/feature/displayByteCode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>If true, the XML parser is requested to perform validation of source documents
     *                 against their DTD. Default is false.</p>
     * <p>This option establishes a default for use whenever source documents (not stylesheets
     *                 or schema documents) are parsed. The option can be overridden for individual
     *                 documents by setting the <link>net.sf.saxon.lib.ParseOptions</link> for that
     *                 individual document, for example from a <code>URIResolver</code>.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@dtdValidation</i></p>
     * <p><i>Corresponding option on command line: -dtd:(on|off|recover)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#isValidation
     * @see net.sf.saxon.Configuration#setValidation
     **/


    public final static String DTD_VALIDATION = 
        "http://saxon.sf.net/feature/validation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This option determines whether DTD validation failures should be treated as
     *                 recoverable. If the option is set, a validation failure is reported as a warning
     *                 rather than an error. The default is false.</p>
     * <p>This option establishes a default for use whenever source documents (not stylesheets
     *                 or schema documents) are parsed. The option can be overridden for individual
     *                 documents by setting the <link>net.sf.saxon.lib.ParseOptions</link> for that
     *                 individual document, for example from a <code>URIResolver</code>.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@dtdValidationRecoverable</i></p>
     * <p><i>Corresponding option on command line: -dtd:(on|off|recover)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.lib.ParseOptions#isContinueAfterValidationErrors
     * @see net.sf.saxon.lib.ParseOptions#setContinueAfterValidationErrors
     **/


    public final static String DTD_VALIDATION_RECOVERABLE = 
        "http://saxon.sf.net/feature/dtd-validation-recoverable";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Name of class implementing org.xml.sax.EntityResolver</p>
     *
     * <p>The supplied class is instantiated and the resulting EntityResolver
     *                 is used whenever Saxon itself creates an XMLReader
     *                 for parsing source documents. It is not used with a user-supplied
     *                 XMLReader.</p>
     * <p>The default value is <link>net.sf.saxon.lib.EntityResolver</link>.
     *             This is an entity resolver that recognizes the names of many standard W3C DTDs
     *             and external entity files, and resolves them against local copies
     *             issued with the Saxon software, to avoid the need to fetch them from the web.</p>
     * <p>The property can be set to a zero-length string, in which case no EntityResolver
     *                 will be used.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@entityResolver</i></p>
     * <p><i>Applies to Saxon editions: </i></p>
     * @see net.sf.saxon.lib.ParseOptions#getEntityResolver
     * @see net.sf.saxon.lib.ParseOptions#setEntityResolver
     **/


    public final static String ENTITY_RESOLVER_CLASS = 
        "http://saxon.sf.net/feature/entityResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Name of class implementing org.xml.sax.ErrorListener</p>
     *
     * <p>ERROR_LISTENER_CLASS is the name of the class used to implement the JAXP
     *                     <code>ErrorListener</code>. This is used both at compile time and at run-time.
     *                 Currently if this option is specified, the class is instantiated, and the same
     *                 instance is used for all processes running under this configuration. This may change
     *                 in future so that a new instance is created for each compilation or evaluation.</p>
     * <p>Finer control can be obtained by setting the <code>ErrorListener</code> for a
     *                 specific XSLT or XQuery compilation or evaluation.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@errorListener</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getErrorListener
     * @see net.sf.saxon.Configuration#setErrorListener
     **/


    public final static String ERROR_LISTENER_CLASS = 
        "http://saxon.sf.net/feature/errorListenerClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>EXPAND_ATTRIBUTE_DEFAULTS determines whether fixed and default values defined in a
     *                 schema or DTD will be expanded (both on input and on output documents, if validation
     *                 is requested). By default (and for conformance with the specification) validation
     *                 against a DTD or schema will cause default values defined in the schema or DTD to be
     *                 inserted into the document. Setting this feature to false suppresses this behavior.
     *                 In the case of DTD-defined defaults this only works if the XML parser reports
     *                 whether each attribute was specified in the source or generated by expanding a
     *                 default value. Not all XML parsers report this information.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@expandAttributeDefaults</i></p>
     * <p><i>Corresponding option on command line: -expand:(on|off)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#isExpandAttributeDefaults
     * @see net.sf.saxon.Configuration#setExpandAttributeDefaults
     **/


    public final static String EXPAND_ATTRIBUTE_DEFAULTS = 
        "http://saxon.sf.net/feature/expandAttributeDefaults";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>By default, Saxon-EE attempts to generate Java bytecode for evaluation of
     *                 parts of a query or stylesheet that are amenable to such treatment. Setting this option
     *                 to false disables this.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@generateByteCode</i></p>
     * <p><i>Corresponding option on command line: can be switched off using -generateByteCode:no</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#isGenerateByteCode
     * @see net.sf.saxon.Configuration#setGenerateByteCode
     **/


    public final static String GENERATE_BYTE_CODE = 
        "http://saxon.sf.net/feature/generateByteCode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>LAZY_CONSTRUCTION_MODE determines whether temporary trees are constructed * lazily.
     *                 The default setting is false; there are a few situations (but not many) where
     *                 setting this * to true can give a performance benefit (especially a memory
     *                 saving).</p>
     * <p>The option is most likely to be effective when executing XQuery in "pull" mode, that
     *                 is, when the client calls the query processor to deliver the result as a stream of
     *                 nodes, rather than running the query and piping the results into a serializer.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@lazyConstructionMode</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#isLazyConstructionMode
     * @see net.sf.saxon.Configuration#setLazyConstructionMode
     **/


    public final static String LAZY_CONSTRUCTION_MODE = 
        "http://saxon.sf.net/feature/lazyConstructionMode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: filename</p>
     *
     * <p>LICENSE_FILE_LOCATION holds the filename in which the Saxon license file is held.
     *                 This is the full file name, for example "c:/saxon/license/license.lic". Setting this
     *                 property causes Saxon to immediately read the specified file and register the
     *                 license data, assuming it can be found at this location. The property is not
     *                 recognized for reading, and it is not recognized for writing except in Saxon-PE and
     *                 Saxon-EE.</p>     *
     * <p><i>Applies to Saxon editions: PE EE</i></p>
     **/


    public final static String LICENSE_FILE_LOCATION = 
        "http://saxon.sf.net/feature/licenseFileLocation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>Default is false. If true, line and column number information is retained for all
     *                 source documents. This information is accessible using the
     *                     <code>saxon:line-number()</code> and <code>saxon:column-number()</code>
     *                 extension functions.</p>
     * <p>Note that the information is only as good as the XML parser supplies. SAX parsers
     *                 generally report the position of an element node using the line and column number of
     *                 the "&gt;" character that forms the last character of the start tag.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@lineNumbering</i></p>
     * <p><i>Corresponding option on command line: -l:(on|off)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#isLineNumbering
     * @see net.sf.saxon.Configuration#setLineNumbering
     **/


    public final static String LINE_NUMBERING = 
        "http://saxon.sf.net/feature/linenumbering";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Name of class implementing net.sf.saxon.event.Receiver</p>
     *
     * <p>Use the specified Receiver to process the output from <code>xsl:message</code>. The
     *                 class must implement the <code>net.sf.saxon.event.Receiver</code> interface. This
     *                 interface is similar to a SAX <code>ContentHandler</code>, in that it takes a stream
     *                 of events to generate output.</p>
     * <p> By default the standard XML emitter is used, configured to write to the standard
     *                 error stream, and to include no XML declaration. </p>
     * <p>In general the content of a message is an XML fragment. Each message is output as a
     *                 new document. The sequence of calls to this Receiver is as follows: there is a
     *                 single <code>open()</code> call at the start of the transformation, and a single
     *                     <code>close()</code> call at the end; and each evaluation of an
     *                     <code>xsl:message</code> instruction starts with a <code>startDocument()</code>
     *                 call and ends with <code>endDocument()</code>. </p>
     * <p>The <code>startDocument()</code> event has a <code>properties</code> argument
     *                 indicating whether <code>terminate="yes"</code> was specified, and the
     *                     <code>locationId</code> on calls such as <code>startElement()</code> and
     *                     <code>characters()</code> can be used to identify the location in the stylesheet
     *                 where the message data originated (this is achieved by passing the supplied
     *                     <code>locationId</code> in a call to
     *                     <code>getPipelineConfiguration().getLocator().getSystemId(locationId)</code>, or
     *                 to <code>getLineNumber()</code> on the same object). </p>
     * <p>Select the class <code>net.sf.saxon.event.MessageWarner</code> to have
     *                     <code>xsl:message</code> output notified to the JAXP <code>ErrorListener</code>,
     *                 as described in the JAXP documentation.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@messageReceiver</i></p>
     * <p><i>Corresponding option on command line: -m:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getMessageEmitterClass
     * @see net.sf.saxon.Configuration#setMessageEmitterClass
     **/


    public final static String MESSAGE_EMITTER_CLASS = 
        "http://saxon.sf.net/feature/messageEmitterClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Instance of net.sf.saxon.lib.ModuleURIResolver</p>
     *
     * <p>Affects XQuery only. An instance of a user-written class implementing Saxon's
     *                     <link>net.sf.saxon.lib.ModuleURIResolver</link> interface. This is used to
     *                 process any URIs used in <code>import module</code> directives in XQuery.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@moduleUriResolver</i></p>
     * <p><i>Corresponding option on command line: -mr:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getModuleURIResolver
     * @see net.sf.saxon.Configuration#setModuleURIResolver
     **/


    public final static String MODULE_URI_RESOLVER = 
        "http://saxon.sf.net/feature/moduleURIResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Name of class implementing net.sf.saxon.lib.ModuleURIResolver</p>
     *
     * <p>Affects XQuery only. The name of a user-written class implementing Saxon's
     *                     <link>net.sf.saxon.lib.ModuleURIResolver</link> interface. This is used to
     *                 process any URIs used in <code>import module</code> directives in XQuery.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@moduleUriResolver</i></p>
     * <p><i>Corresponding option on command line: -mr:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getModuleURIResolver
     * @see net.sf.saxon.Configuration#setModuleURIResolver
     **/


    public final static String MODULE_URI_RESOLVER_CLASS = 
        "http://saxon.sf.net/feature/moduleURIResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>Affects schema construction (whether for standalone validation, or in the context of XSLT or XQuery).
     *                If set to true, the schema processor always attempts to fetch a schema document appearing
     *                in an <code>xs:import</code> directive, whether or not a schema for that namespace has already
     *                been loaded. Note that this setting might cause spurious errors due to like-named schema
     *                components being loaded more than once. With the default setting (false), <code>xs:import</code> directives do not cause
     *                a schema document to be loaded if the schema already contains components for the specified
     *                target namespace.</p>     *
     * <p><i>Corresponding attribute in configuration file: xsd/@multipleSchemaImports</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     **/


    public final static String MULTIPLE_SCHEMA_IMPORTS = 
        "http://saxon.sf.net/feature/multipleSchemaImports";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Instance of net.sf.saxon.om.NamePool</p>
     *
     * <p>Indicates that the supplied <code>NamePool</code> should be used as the target
     *                 (run-time) NamePool by all stylesheets compiled (using <code>newTemplates()</code>)
     *                 after this call on <code>setAttribute</code>. Normally a single system-allocated
     *                     <code>NamePool</code> is used for all stylesheets compiled while the Java VM
     *                 remains loaded; this attribute allows user control over the allocation of name
     *                 pools. Note that source trees used as input to a transformation must be built using
     *                 the same <code>NamePool</code> that is used when the stylesheet is compiled: this
     *                 will happen automatically if the input to a transformation is supplied as a
     *                     <code>SAXSource</code> or <code>StreamSource</code> but it is under user control
     *                 if you build the source tree yourself.</p>     *
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getNamePool
     * @see net.sf.saxon.Configuration#setNamePool
     **/


    public final static String NAME_POOL = 
        "http://saxon.sf.net/feature/namePool";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: A string containing two integers, comma-separated</p>
     *
     * <p>OCCURRENCE_LIMITS determines the largest values of <code>minOccurs</code> and
     *                     <code>maxOccurs</code> that can be accommodated when compiling an "expanded"
     *                 finite state machine to represent an XSD content model grammar. These limits do not
     *                 apply in the common cases where the grammar can be implemented using a counting
     *                 finite-state-machine, but in those cases where this is not possible, any
     *                     <code>minOccurs</code> value greater than the first integer is reduced to the
     *                 value of the first integer, and any <code>maxOccurs</code> value greater than the
     *                 second integer is treated as "unbounded".</p>     *
     * <p><i>Corresponding attribute in configuration file: xsd/@occurrenceLimits</i></p>
     * <p><i>Corresponding option on command line: -limits:min,max</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see com.saxonica.config.EnterpriseConfiguration#getOccurrenceLimits
     * @see com.saxonica.config.EnterpriseConfiguration#setOccurrenceLimits
     **/


    public final static String OCCURRENCE_LIMITS = 
        "http://saxon.sf.net/feature/occurrenceLimits";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: integer (0..10)</p>
     *
     * <p>A string whose value is an integer in the range 0 (no optimization) to 10 (full
     *                 optimization); currently all values other than 0 result in full optimization but
     *                 this is likely to change in future. The default is full optimization; this feature
     *                 allows optimization to be suppressed in cases where reducing compile time is
     *                 important, or where optimization gets in the way of debugging, or causes extension
     *                 functions with side-effects to behave unpredictably. (Note however, that even with
     *                 no optimization, lazy evaluation may still cause the evaluation order to be not as
     *                 expected.) </p>     *
     * <p><i>Corresponding attribute in configuration file: global/@optimizationLevel</i></p>
     * <p><i>Corresponding option on command line: -opt:integer</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.expr.parser.Optimizer#getOptimizationLevel
     * @see net.sf.saxon.expr.parser.Optimizer#setOptimizationLevel
     **/


    public final static String OPTIMIZATION_LEVEL = 
        "http://saxon.sf.net/feature/optimizationLevel";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Instance of net.sf.saxon.lib.OutputURIResolver</p>
     *
     * <p>The supplied <code>OutputURIResolver</code> will be used to resolve URIs of secondary
     *                 result documents selected in the <code>href</code> attribute of the
     *                     <code>xsl:result-document</code> instruction</p>     *
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getOutputURIResolver
     * @see net.sf.saxon.Configuration#setOutputURIResolver
     **/


    public final static String OUTPUT_URI_RESOLVER = 
        "http://saxon.sf.net/feature/outputURIResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Name of class implementing net.sf.saxon.lib.OutputURIResolver</p>
     *
     * <p>The supplied class will be instantiated, and the resulting
     *                     <code>OutputURIResolver</code> will be used to resolve URIs of secondary result
     *                 documents selected in the <code>href</code> attribute of the
     *                     <code>xsl:result-document</code> instruction</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@outputUriResolver</i></p>
     * <p><i>Corresponding option on command line: -or:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     **/


    public final static String OUTPUT_URI_RESOLVER_CLASS = 
        "http://saxon.sf.net/feature/outputURIResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>If true, calls on the <code>doc()</code> and <code>document()</code> functions, if
     *                 their arguments are known at compile time, will be evaluated at compile time, and
     *                 the resulting document will be stored as part of the Saxon
     *                     <link>net.sf.saxon.Configuration</link> and shared by all queries and
     *                 transformations running within that <code>Configuration</code>. This is useful for
     *                 reference documents that have stable content and are used by many different queries
     *                 and transformations. The default is false, which means each query or transformation
     *                 will reload the document from disk.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@preEvaluateDocFunction</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     **/


    public final static String PRE_EVALUATE_DOC_FUNCTION = 
        "http://saxon.sf.net/feature/preEvaluateDocFunction";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This option has no effect on the Java platform. The default is <b>true</b>. When
     *                 running on the .NET platform, if the option is true it causes the Apache Xerces
     *                 parser (cross-compiled using IKVMC) to be used in preference to the .NET XML parser.
     *                 If false the .NET XML parser (<code>System.Xml.XmlTextReader</code>) is used. One
     *                 reason for using this option is that the .NET XML parser does not report ID
     *                 attributes, which means that the id() function does not work.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@preferJaxpParser</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     **/


    public final static String PREFER_JAXP_PARSER = 
        "http://saxon.sf.net/feature/preferJaxpParser";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>True if the the standard URI resolver is to recognize query parameters included in
     *                 the URI (for example, <code>?val=strict</code>). Such parameters can then be used in
     *                 URIs passed to the <code>doc()</code> or <code>document()</code> functions. For
     *                 details of the query parameters available, see <xref>Source
     *                     Documents</xref>. The default is false.</p>
     * <p>This option has no effect if a user-supplied <code>URIResolver</code> is in use,
     *                 unless the user-supplied <code>URIResolver</code> chooses to inherit this
     *                 functionality from the standard <code>URIResolver</code>.</p>
     * <p>Allowed parameters include <code>validation=strict|lax|strip</code> to perform schema
     *                 validation, <code>strip-space=yes|ignorable|no</code> to control whitespace
     *                 stripping, and <code>xinclude=yes|no</code> to control whether XInclude processing
     *                 takes place (assuming the XML parser supports it).</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@recognizeUriQueryParameters</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     **/


    public final static String RECOGNIZE_URI_QUERY_PARAMETERS = 
        "http://saxon.sf.net/feature/recognize-uri-query-parameters";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: integer (0..2)</p>
     *
     * <p>An Integer, one of <link>net.sf.saxon.Configuration#RECOVER_SILENTLY</link>,
     *                     <link>net.sf.saxon.Configuration#RECOVER_WITH_WARNINGS</link>, or
     *                     <link>net.sf.saxon.Configuration#DO_NOT_RECOVER</link>. Indicates the policy for
     *                 handling dynamic errors that the XSLT specification defines as recoverable. 0 means
     *                 recover silently; 1 means recover after signalling a warning to the
     *                     <code>ErrorListener</code>; 2 means treat the error as fatal. An example of a
     *                 recoverable error is when two template rules match the same node.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@recoveryPolicy</i></p>
     * <p><i>Corresponding option on command line: -warnings:(silent|recover|fatal)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getRecoveryPolicy
     * @see net.sf.saxon.Configuration#setRecoveryPolicy
     **/


    public final static String RECOVERY_POLICY = 
        "http://saxon.sf.net/feature/recoveryPolicy";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string ("recoverSilently", "recoverWithWarnings", or "doNotRecover")</p>
     *
     * <p>Indicates the policy for handling dynamic errors that the XSLT specification defines
     *                 as recoverable. "recoverSilently" means recover silently; "recoverWithWarnings"
     *                 means recover after signalling a warning to the <code>ErrorListener</code>;
     *                 "doNotRecover" means treat the error as fatal. An example of a recoverable error is
     *                 when two template rules match the same node. </p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@recoveryPolicy</i></p>
     * <p><i>Corresponding option on command line: -warnings:(silent|recover|fatal)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getRecoveryPolicy
     * @see net.sf.saxon.Configuration#setRecoveryPolicy
     **/


    public final static String RECOVERY_POLICY_NAME = 
        "http://saxon.sf.net/feature/recoveryPolicyName";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: An instance of the class net.sf.saxon.lib.SchemaURIResolver</p>
     *
     * <p>The supplied <code>SchemaURIResolver</code> will be used to resolve URIs of schema
     *                 documents referenced in <code>xsl:import-schema</code> declarations in XSLT,
     *                     <code>import schema</code> in XQuery, references from one schema document to
     *                 another using <code>xs:include</code> or <code>xs:import</code>, and references from
     *                 an instance document to a schema using <code>xsi:schemaLocation</code>.</p>     *
     * <p><i>Corresponding attribute in configuration file: xsd/@schemaUriResolver</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#getSchemaURIResolver
     * @see net.sf.saxon.Configuration#setSchemaURIResolver
     **/


    public final static String SCHEMA_URI_RESOLVER = 
        "http://saxon.sf.net/feature/schemaURIResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: The name of a class that implements
            net.sf.saxon.lib.SchemaURIResolver</p>
     *
     * <p>The name of a class that implements the interface <code>SchemaURIResolver</code>;
     *                 this class will be instantiated and the resulting instance will be used as the value
     *                 of the <link>FeatureKeys#SCHEMA_URI_RESOLVER</link> property.</p>     *
     * <p><i>Corresponding attribute in configuration file: xsd/@schemaUriResolver</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#getSchemaURIResolver
     * @see net.sf.saxon.Configuration#setSchemaURIResolver
     **/


    public final static String SCHEMA_URI_RESOLVER_CLASS = 
        "http://saxon.sf.net/feature/schemaURIResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: integer (Validation.STRIP, Validation.PRESERVE,
                Validation.LAX, or  Validation.STRICT</p>
     *
     * <p>Indicates whether and how schema validation should be applied to source
     *                 documents.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@schemaValidation</i></p>
     * <p><i>Corresponding option on command line: -val:(strict|lax|strip|preserve)</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#getSchemaValidationMode
     * @see net.sf.saxon.Configuration#setSchemaValidationMode
     **/


    public final static String SCHEMA_VALIDATION = 
        "http://saxon.sf.net/feature/schema-validation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string ("strict", "lax", "preserve", or "skip")</p>
     *
     * <p>Indicates whether and how schema validation should be applied to source
     *                 documents.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@schemaValidation</i></p>
     * <p><i>Corresponding option on command line: -val:(strict|lax|strip|preserve)</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#getSchemaValidationMode
     * @see net.sf.saxon.Configuration#setSchemaValidationMode
     **/


    public final static String SCHEMA_VALIDATION_MODE = 
        "http://saxon.sf.net/feature/schema-validation-mode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: The name of a class that extends the net.sf.saxon.lib.SerializerFactor
            class</p>
     *
     * <p>The class will be instantiated and the resulting <code>SerializerFactory</code> will
     *                 be used to create the serialization pipeline for XSLT and XQuery results. By
     *                 subclassing the standard <code>SerializerFactory</code> it is possible to customize
     *                 many aspects of the output produced by the Serializer, or to introduce new
     *                 serialization methods and parameters.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@serializerFactory</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getSerializerFactory
     * @see net.sf.saxon.Configuration#setSerializerFactory
     **/


    public final static String SERIALIZER_FACTORY_CLASS = 
        "http://saxon.sf.net/feature/serializerFactoryClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: The name of a class that implements the org.xml.sax.XMLReader
            interface</p>
     *
     * <p>The class will be instantiated and the resulting <code>XMLReader</code> will be used
     *                 to parse source documents (that is, the principal source document plus any secondary
     *                 source documents read using the <code>doc()</code>, <code>document()</code>, or
     *                     <code>collection()</code> function)</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@sourceParser</i></p>
     * <p><i>Corresponding option on command line: -x:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getSourceParserClass
     * @see net.sf.saxon.Configuration#setSourceParserClass
     **/


    public final static String SOURCE_PARSER_CLASS = 
        "http://saxon.sf.net/feature/sourceParserClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: The name of a class that implements the org.xml.sax.XMLReader
            interface</p>
     *
     * <p>On interfaces that allow a <code>org.xml.sax.Source</code> to be supplied, if a kind
     *                 of <code>Source</code> is provided that Saxon does not recognize, it will be passed
     *                 to the user-supplied <code>SourceResolver</code>, which has the opportunity to
     *                 convert it to a kind of <code>Source</code> that Saxon does recognize. This allows
     *                 new kinds of input to be supplied as input to Saxon's query, transformation, and
     *                 validation engines.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@sourceResolver</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getSourceResolver
     * @see net.sf.saxon.Configuration#setSourceResolver
     **/


    public final static String SOURCE_RESOLVER_CLASS = 
        "http://saxon.sf.net/feature/sourceResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: filename</p>
     *
     * <p>STANDARD_ERROR_OUTPUT_FILE is the name of a file to which Saxon will redirect output
     *                 that would otherwise go to the operating system standard error stream (System.err).
     *                 This is the fallback destination for various tracing and diagnostic output. In some
     *                 cases a more specific mechanism exists to select the destination for particular
     *                 kinds of output.</p>
     * <p>Note that this property is write-only, and cannot be set from the configuration
     *                 file.</p>     *
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#setStandardErrorOutput
     **/


    public final static String STANDARD_ERROR_OUTPUT_FILE = 
        "http://saxon.sf.net/feature/standardErrorOutputFile";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string ("all", "none", or "ignorable")</p>
     *
     * <p>Indicates whether all whitespace, no whitespace, or whitespace in elements defined in
     *                 a DTD or schema as having element-only content should be stripped from source
     *                 documents. The default is "ignorable". This whitespace stripping is additional to
     *                 any stripping done as a result of the <code>xsl:strip-space</code> declaration in an
     *                 XSLT stylesheet.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@stripWhitespace</i></p>
     * <p><i>Corresponding option on command line: -strip:(all|none|ignorable)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getStripsWhiteSpace
     * @see net.sf.saxon.Configuration#setStripsWhiteSpace
     **/


    public final static String STRIP_WHITESPACE = 
        "http://saxon.sf.net/feature/strip-whitespace";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: The name of a class that implements the org.xml.sax.XMLReader
            interface</p>
     *
     * <p>The class will be instantiated, and the resulting <code>XMLReader</code> will be used
     *             to parse stylesheet documents (that is, the principal stylesheet module plus any
     *             secondary source documents read using xsl:include or xsl:import) and also schema
     *             documents.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@sourceParser</i></p>
     * <p><i>Corresponding option on command line: -y:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getSourceParserClass
     * @see net.sf.saxon.Configuration#setSourceParserClass
     **/


    public final static String STYLE_PARSER_CLASS = 
        "http://saxon.sf.net/feature/sourceParserClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This is set to true to suppress the warning otherwise issued by command-line interfaces
     *                 indicating that an evaluation license is in use and is due to expire in a set number of days.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@suppressEvaluationExpiryWarning</i></p>
     * <p><i>Applies to Saxon editions: PE EE</i></p>
     **/


    public final static String SUPPRESS_EVALUATION_EXPIRY_WARNING = 
        "http://saxon.sf.net/feature/suppressEvaluationExpiryWarning";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This is set to true to cause basic timing and tracing information is to be output to
     *                 the standard error output stream. The name of the feature is poorly chosen, since
     *                 much of the information that is output has nothing to do with timing, for example
     *                 the names of output files for <code>xsl:result-document</code> are traced.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@timing</i></p>
     * <p><i>Corresponding option on command line: -t</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#isTiming
     * @see net.sf.saxon.Configuration#setTiming
     **/


    public final static String TIMING = 
        "http://saxon.sf.net/feature/timing";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>If this option is set, Saxon will output (to the standard error output) progress
     *                 information about its attempts to locate and disambiguate references to reflexive
     *                 Java extension functions. This is useful for diagnostics if the XQuery or XSLT
     *                 compiler is failing to locate user-written extension functions.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@traceExternalFunctions</i></p>
     * <p><i>Corresponding option on command line: -TJ</i></p>
     * <p><i>Applies to Saxon editions: PE EE</i></p>
     * @see net.sf.saxon.Configuration#isTraceExternalFunctions
     * @see net.sf.saxon.Configuration#setTraceExternalFunctions
     **/


    public final static String TRACE_EXTERNAL_FUNCTIONS = 
        "http://saxon.sf.net/feature/trace-external-functions";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>If this option is set, Saxon will output (to the standard error output) detailed
     *                 information about the rewrites to the expression tree made by the optimizer. This
     *                 information is mainly useful for internal system debugging, but it is also possible
     *                 to digest it to analyze the ways in which the expression has been optimized for the
     *                 purpose of performance analysis and tuning.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@traceOptimizerDecisions</i></p>
     * <p><i>Corresponding option on command line: -explain</i></p>
     * <p><i>Applies to Saxon editions: PE EE</i></p>
     * @see net.sf.saxon.Configuration#isOptimizerTracing
     * @see net.sf.saxon.Configuration#setOptimizerTracing
     **/


    public final static String TRACE_OPTIMIZER_DECISIONS = 
        "http://saxon.sf.net/feature/trace-optimizer-decisions";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: An instance of the class net.sf.saxon.lib.TraceListener</p>
     *
     * <p>The <code>TraceListener</code> will be notified of significant events occurring
     *                 during a query or transformation, for tracing or debugging purposes.</p>
     * <p>Setting a <code>TraceListener</code> automatically sets the
     *                     <link>FeatureKeys#COMPILE_WITH_TRACING</link> option.</p>
     * <p>Avoid this option if more than one transformation or query is running concurrently:
     *                 use the feature <link>FeatureKeys#TRACE_LISTENER_CLASS</link> instead.
     *                 Alternatively, it is possible to set a <code>TraceListener</code> for an individual
     *                 query or transformation.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@traceListener</i></p>
     * <p><i>Corresponding option on command line: -TL:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getTraceListener
     * @see net.sf.saxon.Configuration#setTraceListener
     **/


    public final static String TRACE_LISTENER = 
        "http://saxon.sf.net/feature/traceListener";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: The name of a class that implements net.sf.saxon.lib.TraceListener</p>
     *
     * <p>The class will be instantiated once for each query or transformation, and the
     *                 resulting <code>TraceListener</code> will be notified of significant events
     *                 occurring during that query or transformation, for tracing or debugging
     *                 purposes.</p>
     * <p>Setting a <code>TraceListener</code> automatically sets the
     *                     <link>FeatureKeys#COMPILE_WITH_TRACING</link> option.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@traceListener</i></p>
     * <p><i>Corresponding option on command line: -TL:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getTraceListenerClass
     * @see net.sf.saxon.Configuration#setTraceListenerClass
     **/


    public final static String TRACE_LISTENER_CLASS = 
        "http://saxon.sf.net/feature/traceListenerClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: integer (net.sf.saxon.event.Builder#STANDARD_TREE or
                net.sf.saxon.event.Builder#TINY_TREE or or
                net.sf.saxon.event.Builder#TINY_TREE_CONDENSED)</p>
     *
     * <p>Selects an implementation of the Saxon tree model. The default is
     *                     <code>TINY_TREE</code>.</p>
     * <p>For running XQuery Update, use the linked tree, because it is the only implementation
     *                 that is updateable.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@treeModel</i></p>
     * <p><i>Corresponding option on command line: -tree:(linked|tiny|tinyc)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getTreeModel
     * @see net.sf.saxon.Configuration#setTreeModel
     **/


    public final static String TREE_MODEL = 
        "http://saxon.sf.net/feature/treeModel";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string ("linkedTree" or "tinyTree" or "tinyTreeCondensed")</p>
     *
     * <p>Selects an implementation of the Saxon tree model. The default is
     *                     <code>tinyTree</code>.</p>
     * <p>For running XQuery Update, use the linked tree, because it is the only implementation
     *                 that is updateable.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@treeModel</i></p>
     * <p><i>Corresponding option on command line: -tree:(linked|tiny|tinyc)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getTreeModel
     * @see net.sf.saxon.Configuration#setTreeModel
     **/


    public final static String TREE_MODEL_NAME = 
        "http://saxon.sf.net/feature/treeModelName";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Name of a class that implements javax.xml.transform.URIResolver</p>
     *
     * <p>An instance of the specified <code>URIResolver</code> class will be created, and used
     *                 to resolve (dereference) all URIs specifed in calls to the <code>doc()</code> and
     *                     <code>document()</code> functions, as well as URIs used in
     *                     <code>xsl:include</code> and <code>xsl:import</code> and location hints for
     *                 XQuery modules and XSD schema documents.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@uriResolver</i></p>
     * <p><i>Corresponding option on command line: -r:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getURIResolver
     * @see net.sf.saxon.Configuration#setURIResolver
     **/


    public final static String URI_RESOLVER_CLASS = 
        "http://saxon.sf.net/feature/uriResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This option determines whether a <code>TransformerHandler</code> created with this
     *                     <code>TransformerFactory</code> or <code>Configuration</code> recognizes the
     *                 JAXP-defined processing instructions <code>Result.PI_DISABLE_OUTPUT_ESCAPING</code>
     *                 and <code>Result.PI_ENABLE_OUTPUT_ESCAPING</code> in the input stream as
     *                 instructions to disable or to re-enable output escaping. The default value is
     *                     <b>false</b>.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@usePiDisableOutputEscaping</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     **/


    public final static String USE_PI_DISABLE_OUTPUT_ESCAPING = 
        "http://saxon.sf.net/feature/use-pi-disable-output-escaping";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This option is relevant only when the TinyTree is used; it determines whether (for a
     *                 validated document) a cache will be maintained containing the typed values of nodes.
     *                 Typed values are held in the cache only for elements and attributes whose type is
     *                 other than string, untypedAtomic, or anyURI. The default value is true. Setting this
     *                 value to false can reduce memory requirements at the cost of requiring recomputation
     *                 of typed values on each access.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@useTypedValueCache</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#useTypedValueCache
     **/


    public final static String USE_TYPED_VALUE_CACHE = 
        "http://saxon.sf.net/feature/use-typed-value-cache";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This option determines whether or not to use the <code>xsi:schemaLocation</code>
     *                     and<code> xsi:noNamespaceSchemaLocation</code> attributes in an instance
     *                 document to locate a schema for validation.</p>
     * <p>Note, these attribute are only consulted if validation is requested; the presence of
     *                 one of these attributes never by itself triggers validation.</p>     *
     * <p><i>Corresponding attribute in configuration file: xsd/@useXsiSchemaLocation</i></p>
     * <p><i>Corresponding option on command line: -xsiloc:(on|off)</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.lib.ParseOptions#isUseXsiSchemaLocation
     * @see net.sf.saxon.lib.ParseOptions#setUseXsiSchemaLocation
     **/


    public final static String USE_XSI_SCHEMA_LOCATION = 
        "http://saxon.sf.net/feature/useXsiSchemaLocation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This option determines whether non-fatal validation errors in XQuery or XSLT result
     *                 documents should result in comments being inserted into the result tree. The
     *                 command-line flag <code>-outval:recover</code> sets both this option and the
     *                     <link>FeatureKeys#VALIDATION_WARNINGS</link> option.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@validationComments</i></p>
     * <p><i>Corresponding option on command line: -outval:recover</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.lib.ParseOptions#isAddCommentsAfterValidationErrors
     * @see net.sf.saxon.lib.ParseOptions#setAddCommentsAfterValidationErrors
     **/


    public final static String VALIDATION_COMMENTS = 
        "http://saxon.sf.net/feature/validation-comments";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This option indicates (if true) that errors occuring while validating a final result
     *                 tree are to be treated as warnings rather than fatal errors. Although the XSLT and
     *                 XQuery specifications state that validation errors are fatal, this switch can be
     *                 useful during debugging because it enables the invalid output to be inspected.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@validationWarnings</i></p>
     * <p><i>Corresponding option on command line: -outval:recover</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.Configuration#isValidationWarnings
     * @see net.sf.saxon.Configuration#setValidationWarnings
     **/


    public final static String VALIDATION_WARNINGS = 
        "http://saxon.sf.net/feature/validation-warnings";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>Indicates whether a warning message should be notified (to the
     *                     <code>ErrorListener</code>) if running Saxon against an XSLT stylesheet that
     *                 specifies <code>version="1.0"</code>. The warning that an XSLT 1.0 stylesheet is
     *                 being processed using an XSLT 2.0 processor is output by default (because the W3C
     *                 specification requires it), but it may be suppressed using this option.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@versionWarning</i></p>
     * <p><i>Corresponding option on command line: -versmsg:(on|off)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#isVersionWarning
     * @see net.sf.saxon.Configuration#setVersionWarning
     **/


    public final static String VERSION_WARNING = 
        "http://saxon.sf.net/feature/version-warning";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>Indicates whether source documents should have any XInclude directives expanded. The
     *                 default is false. The option applies to all input XML documents, including
     *                 stylesheets and schema documents. It can be overridden for individual documents
     *                 using the <link>net.sf.saxon.lib.ParseOptions</link> class.</p>
     * <p>This option relies on support in the underlying XML parser. If the XML parser does
     *                 not support XInclude processing, the option is ignored.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@versionWarning</i></p>
     * <p><i>Corresponding option on command line: -versmsg:(on|off)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#isXIncludeAware
     * @see net.sf.saxon.Configuration#setXIncludeAware
     **/


    public final static String XINCLUDE = 
        "http://saxon.sf.net/feature/xinclude-aware";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string ("1.0" or "1.1")</p>
     *
     * <p>This determines the XML version used by the Configuration.</p>
     * <p>Note that source documents specifying xml version="1.0" or "1.1" are accepted
     *                 regardless of this setting. The effect of this switch is to change the validation
     *                 rules for types such as <code>xs:Name</code> and <code>xs:NCName</code>, to change
     *                 the characters allowed in names within XPath expressions (etc.), to change the
     *                 meaning of <code>\i</code> and <code>\c</code> in regular expressions, and to
     *                 determine whether the serializer allows XML 1.1 documents to be constructed. </p>
     * <p>The default is currently 1.0, but may change.</p>     *
     * <p><i>Corresponding attribute in configuration file: global/@versionOfXml</i></p>
     * <p><i>Corresponding option on command line: -xmlversion:(1.0|1.1)</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.Configuration#getXMLVersion
     * @see net.sf.saxon.Configuration#setXMLVersion
     **/


    public final static String XML_VERSION = 
        "http://saxon.sf.net/feature/xml-version";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>Determines whether XQuery Update syntax is accepted. If true, update syntax is
     *                 accepted, if false, it is not accepted. Setting the value to true does not mean that
     *                 the query has to use update syntax, only that it may do so.</p>
     * <p>Note that XQuery Update syntax and XQuery 3.0 syntax cannot currently be mixed.</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>
     * <p>On the command line, this option is combined with the option "discard" which
     *                 indicates that updates are allowed, but the updates are not written back to
     *                 filestore. This does not correspond to any option in the Java API, where writing an
     *                 updated document back to filestore only happens if explicitly requested.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@allowUpdate</i></p>
     * <p><i>Corresponding option on command line: -update:(on|off|discard)</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#isUpdatingEnabled
     * @see net.sf.saxon.s9api.XQueryCompiler#isUpdatingEnabled
     * @see net.sf.saxon.query.StaticQueryContext#setUpdatingEnabled
     * @see net.sf.saxon.s9api.XQueryCompiler#setUpdatingEnabled
     **/


    public final static String XQUERY_ALLOW_UPDATE = 
        "http://saxon.sf.net/feature/xqueryAllowUpdate";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string ("strip" or "preserve")</p>
     *
     * <p>This option defines the default value of the construction mode in the XQuery static
     *                 context (overridable in the query prolog)</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@constructionMode</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#getConstructionMode
     * @see net.sf.saxon.query.StaticQueryContext#setConstructionMode
     **/


    public final static String XQUERY_CONSTRUCTION_MODE = 
        "http://saxon.sf.net/feature/xqueryConstructionMode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Namespace URI</p>
     *
     * <p>This property defines the default namespace for elements and types that are not
     *                 qualified by a namespace prefix.</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@defaultElementNamespace</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#getDefaultElementNamespace
     * @see net.sf.saxon.query.StaticQueryContext#setDefaultElementNamespace
     **/


    public final static String XQUERY_DEFAULT_ELEMENT_NAMESPACE = 
        "http://saxon.sf.net/feature/xqueryDefaultElementNamespace";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: Namespace URI</p>
     *
     * <p>This property defines the default namespace for function names that are not
     *                 qualified by a namespace prefix.</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@defaultFunctionNamespace</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#getDefaultFunctionNamespace
     * @see net.sf.saxon.query.StaticQueryContext#setDefaultFunctionNamespace
     **/


    public final static String XQUERY_DEFAULT_FUNCTION_NAMESPACE = 
        "http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This property defines how the empty sequence is handled in XQuery sorting (the "order
     *                 by" clause). If true, () comes at the start of the sorted sequence; if false, it
     *                 comes last.</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@emptyLeast</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#isEmptyLeast
     * @see net.sf.saxon.query.StaticQueryContext#setEmptyLeast
     **/


    public final static String XQUERY_EMPTY_LEAST = 
        "http://saxon.sf.net/feature/xqueryEmptyLeast";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This property defines the default value of the inherit-namespaces property in the
     *                 XQuery static context.</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@inheritNamespaces</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#isInheritNamespaces
     * @see net.sf.saxon.query.StaticQueryContext#setInheritNamespaces
     **/


    public final static String XQUERY_INHERIT_NAMESPACES = 
        "http://saxon.sf.net/feature/xqueryInheritNamespaces";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This property defines whether "boundary space" (insignificant space in direct element
     *                 constructors) should be retained or not</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@preserveBoundarySpace</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#isPreserveBoundarySpace
     * @see net.sf.saxon.query.StaticQueryContext#setPreserveBoundarySpace
     **/


    public final static String XQUERY_PRESERVE_BOUNDARY_SPACE = 
        "http://saxon.sf.net/feature/xqueryPreserveBoundarySpace";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This property defines whether unused namespace declarations are retained by XQuery
     *                 element copy operations</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@preserveNamespaces</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#isPreserveNamespaces
     * @see net.sf.saxon.query.StaticQueryContext#setPreserveNamespaces
     **/


    public final static String XQUERY_PRESERVE_NAMESPACES = 
        "http://saxon.sf.net/feature/xqueryPreserveNamespaces";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string containing an ItemType, for example document-node()</p>
     *
     * <p>This property defines the default expected context item type for a query.</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@requiredContextItemType</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#getRequiredContextItemType
     * @see net.sf.saxon.s9api.XQueryCompiler#getRequiredContextItemType
     * @see net.sf.saxon.query.StaticQueryContext#setRequiredContextItemType
     * @see net.sf.saxon.s9api.XQueryCompiler#setRequiredContextItemType
     **/


    public final static String XQUERY_REQUIRED_CONTEXT_ITEM_TYPE = 
        "http://saxon.sf.net/feature/xqueryRequiredContextItemType";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>A query will automatically be schema-aware if it contains an <code>import
     *                 schema</code> declaration. This property allows a query to be marked as
     *                 schema-aware even if it contains no <code>import schema</code> declaration. It is
     *                 necessary for a query to be compiled as schema-aware if it is to handle typed
     *                 (validated) input documents in which nodes have type annotations based on their
     *                 schema-defined type.</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@schemaAware</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#isSchemaAware
     * @see net.sf.saxon.s9api.XQueryCompiler#isSchemaAware
     * @see net.sf.saxon.query.StaticQueryContext#setSchemaAware
     * @see net.sf.saxon.s9api.XQueryCompiler#setSchemaAware
     **/


    public final static String XQUERY_SCHEMA_AWARE = 
        "http://saxon.sf.net/feature/xquerySchemaAware";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: the name of a Java class that implements the interface
                javax.xml.transform.ErrorListener</p>
     *
     * <p>The specified class is instantiated to create an <code>ErrorListener</code>,
     *                 and all reports of static errors in a query will go to this
     *                 <code>ErrorListener</code>.</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>
     * <p>In the absence of this property, the global <code>ErrorListener</code>
     *             specified as the value of the <link>#ERROR_LISTENER_CLASS</link> property is used.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@staticErrorListener</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#getErrorListener
     * @see net.sf.saxon.s9api.XQueryCompiler#getErrorListener
     * @see net.sf.saxon.query.StaticQueryContext#setErrorListener
     * @see net.sf.saxon.s9api.XQueryCompiler#setErrorListener
     **/


    public final static String XQUERY_STATIC_ERROR_LISTENER_CLASS = 
        "http://saxon.sf.net/feature/xqueryStaticErrorListenerClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string ("1.0" or "3.0")</p>
     *
     * <p>This property determines the version of XQuery used by the Configuration. In order
     *                 to use XQuery 3.0, it is necessary both to set the XQuery compiler to process XQuery
     *                 3.0, and to specify XQuery 3.0 in the query prolog of each module that uses XQuery
     *                 3.0 features.</p>
     * <p>This option can be set for a particular XQuery compilation. When the option is set at
     *                 the <code>Configuration</code> level, it acts as a default.</p>
     * <p>Note that XQuery 3.0 features cannot be used with XQuery Update.</p>
     * <p>XQuery 3.0 is supported only in Saxon EE.</p>     *
     * <p><i>Corresponding attribute in configuration file: xquery/@version</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.query.StaticQueryContext#getLanguageVersion
     * @see net.sf.saxon.s9api.XQueryCompiler#getLanguageVersion
     * @see net.sf.saxon.query.StaticQueryContext#setLanguageVersion
     * @see net.sf.saxon.s9api.XQueryCompiler#setLanguageVersion
     **/


    public final static String XQUERY_VERSION = 
        "http://saxon.sf.net/feature/xqueryVersion";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string ("1.0" or "1.1")</p>
     *
     * <p>This property determines the version of XML Schema used by the Configuration. The
     *                 default is XSD 1.0. If XSD 1.0 is selected, XSD 1.1 features will be rejected, with
     *                 the exception of the version control attributes that allow sections of the schema to
     *                 be marked as requiring XSD 1.0 or XSD 1.1.</p>     *
     * <p><i>Corresponding attribute in configuration file: xsd/@version</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     **/


    public final static String XSD_VERSION = 
        "http://saxon.sf.net/feature/xsd-version";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: a QName in Clark notation</p>
     *
     * <p>This property indicates the name of a mode within a stylesheet in which execution
     *             (using template rules) should begin</p>
     * <p>This option can be set for a particular XSLT transformation. When the option is set at
     *                 the <code>Configuration</code> (or on a <code>TransformerFactory</code>), it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@initialMode</i></p>
     * <p><i>Corresponding option on command line: -im:mode-name</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.s9api.XsltTransformer#getInitialMode
     * @see net.sf.saxon.s9api.XsltTransformer#setInitialMode
     **/


    public final static String XSLT_INITIAL_MODE = 
        "http://saxon.sf.net/feature/initialMode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: a QName in Clark notation</p>
     *
     * <p>This property indicates the name of a named template within a stylesheet where
     *             execution should begin</p>
     * <p>This option can be set for a particular XSLT transformation. When the option is set at
     *                 the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@initialTemplate</i></p>
     * <p><i>Corresponding option on command line: -it:template-name</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.s9api.XsltTransformer#getInitialTemplate
     * @see net.sf.saxon.s9api.XsltTransformer#setInitialTemplate
     **/


    public final static String XSLT_INITIAL_TEMPLATE = 
        "http://saxon.sf.net/feature/initialTemplate";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: boolean</p>
     *
     * <p>This property indicates whether stylesheets should be compiled with the ability to
     *                 handle schema-typed input documents. By default a stylesheet is compiled to handle
     *                 such input if it contains an <code>xsl:import-schema</code> instruction, and not
     *                 otherwise. It is
     *                 necessary for a stylesheet to be compiled as schema-aware if it is to handle typed
     *                 (validated) input documents in which nodes have type annotations based on their
     *                 schema-defined type.</p>
     * <p>This option can be set for a particular XSLT compilation. When the option is set at
     *                 the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it acts as a default.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@schemaAware</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.s9api.XsltCompiler#isSchemaAware
     * @see net.sf.saxon.s9api.XsltCompiler#setSchemaAware
     **/


    public final static String XSLT_SCHEMA_AWARE = 
        "http://saxon.sf.net/feature/xsltSchemaAware";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: the name of a class that implements
            javax.xml.transform.ErrorListener</p>
     *
     * <p>The specified class is instantiated to create an <code>ErrorListener</code>,
     *                 and all reports of static errors in a stylesheet will go to this
     *                 <code>ErrorListener</code>.</p>
     * <p>This option can be set for a particular XSLT compilation. When the option is set at
     *                 the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it acts as a default.</p>
     * <p>In the absence of this property, the global <code>ErrorListener</code>
     *                 specified as the value of the <link>#ERROR_LISTENER_CLASS</link> property is used.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@staticErrorListener</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.s9api.XsltCompiler#getErrorListener
     * @see net.sf.saxon.s9api.XsltCompiler#setErrorListener
     **/


    public final static String XSLT_STATIC_ERROR_LISTENER_CLASS = 
        "http://saxon.sf.net/feature/stylesheetErrorListener";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: the name of a class that implements
            javax.xml.transform.URIResolver.</p>
     *
     * <p>This property defines a <code>URIResolver</code> used when dereferencing the URIs
     *                 that appear in the <code>href</code> attributes of the <code>xsl:include</code> and
     *                     <code>xsl:import</code> declarations. Note that this defaults to the setting of
     *                 the global <code>URI_RESOLVER</code> property.</p>
     * <p>This option can be set for a particular XSLT compilation. When the option is set at
     *                 the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it acts as a default.</p>
     * <p>In the absence of this property, the global <code>URIResolver</code>
     *                 specified as the value of the <link>#URI_RESOLVER_CLASS</link> property is used.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@staticUriResolver</i></p>
     * <p><i>Corresponding option on command line: -r:classname</i></p>
     * <p><i>Applies to Saxon editions: HE PE EE</i></p>
     * @see net.sf.saxon.s9api.XsltCompiler#getURIResolver
     * @see net.sf.saxon.s9api.XsltCompiler#setURIResolver
     **/


    public final static String XSLT_STATIC_URI_RESOLVER_CLASS = 
        "http://saxon.sf.net/feature/stylesheetURIResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
     *
     * <p>Type of value: string ("2.0" or "3.0")</p>
     *
     * <p>This property determines the version of XSLT to be supported by default</p>
     * <p>XSLT 3.0 is supported only in Saxon EE. If no value is specified for the property,
     *             an XSLT 2.0 or XSLT 3.0 processor is used depending on the value of the <code>version</code>
     *             attribute of the <code>xsl:stylesheet</code> element.</p>     *
     * <p><i>Corresponding attribute in configuration file: xslt/@version</i></p>
     * <p><i>Corresponding option on command line: -xsltversion:(2.0|3.0)</i></p>
     * <p><i>Applies to Saxon editions: EE</i></p>
     * @see net.sf.saxon.s9api.XsltCompiler#getXsltLanguageVersion
     * @see net.sf.saxon.s9api.XsltCompiler#setXsltLanguageVersion
     **/


    public final static String XSLT_VERSION = 
        "http://saxon.sf.net/feature/xsltVersion";


}

//
// The contents of this file are subject to the Mozilla Public License Version 1.0 (the "License");
// you may not use this file except in compliance with the License. You may obtain a copy of the
// License at http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied.
// See the License for the specific language governing rights and limitations under the License.
//
// The Original Code is: all this file
//
// The Initial Developer of the Original Code is Saxonica Limited.
// Portions created by ___ are Copyright (C) ___. All rights reserved.
//
// Contributor(s):
//