////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2017 Saxonica Limited.
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/.
// This Source Code Form is "Incompatible With Secondary Licenses", as defined by the Mozilla Public License, v. 2.0.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

package net.sf.saxon.style;

import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.trans.XPathException;

/**
 * Extends the standard XPath static context with information that is available for
 * XPath expressions invoked from XSLT
 */

public interface XSLTStaticContext extends StaticContext {

    /**
     * Determine if an extension element is available
     *
     * @throws net.sf.saxon.trans.XPathException
     *          if the name is invalid or the prefix is not declared
     */

    boolean isElementAvailable(String qname) throws XPathException;

}


