from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


__version__ = _Mock()

absolute_import = _Mock()

auxfuncs = _Mock()

buildmodules = _Mock()

callcrackfortran = _Mock()

cb_rules = _Mock()

cfuncs = _Mock()

crackfortran = _Mock()

dict_append = _Mock()

division = _Mock()

errmess = _Mock()

f90mod_rules = _Mock()

filter_files = _Mock()

get_prefix = _Mock()

main = _Mock()

os = _Mock()

outmess = _Mock()

pprint = _Mock()

print_function = _Mock()

re = _Mock()

rules = _Mock()

run_compile = _Mock()

run_main = _Mock()

scaninputline = _Mock()

show = _Mock()

sys = _Mock()

f2py_version = '2'

numpy_version = '1.8.2'



