package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHpcClusterAttribute invokes the ecs.ModifyHpcClusterAttribute API synchronously
func (client *Client) ModifyHpcClusterAttribute(request *ModifyHpcClusterAttributeRequest) (response *ModifyHpcClusterAttributeResponse, err error) {
	response = CreateModifyHpcClusterAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHpcClusterAttributeWithChan invokes the ecs.ModifyHpcClusterAttribute API asynchronously
func (client *Client) ModifyHpcClusterAttributeWithChan(request *ModifyHpcClusterAttributeRequest) (<-chan *ModifyHpcClusterAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyHpcClusterAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHpcClusterAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHpcClusterAttributeWithCallback invokes the ecs.ModifyHpcClusterAttribute API asynchronously
func (client *Client) ModifyHpcClusterAttributeWithCallback(request *ModifyHpcClusterAttributeRequest, callback func(response *ModifyHpcClusterAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHpcClusterAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyHpcClusterAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHpcClusterAttributeRequest is the request struct for api ModifyHpcClusterAttribute
type ModifyHpcClusterAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HpcClusterId         string           `position:"Query" name:"HpcClusterId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
}

// ModifyHpcClusterAttributeResponse is the response struct for api ModifyHpcClusterAttribute
type ModifyHpcClusterAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyHpcClusterAttributeRequest creates a request to invoke ModifyHpcClusterAttribute API
func CreateModifyHpcClusterAttributeRequest() (request *ModifyHpcClusterAttributeRequest) {
	request = &ModifyHpcClusterAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyHpcClusterAttribute", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyHpcClusterAttributeResponse creates a response to parse from ModifyHpcClusterAttribute response
func CreateModifyHpcClusterAttributeResponse() (response *ModifyHpcClusterAttributeResponse) {
	response = &ModifyHpcClusterAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
