## TFSA-2022-062: Missing validation crashes `QuantizeAndDequantizeV4Grad`

### CVE Number
CVE-2022-29192

### Impact
The implementation of [`tf.raw_ops.QuantizeAndDequantizeV4Grad`](https://github.com/tensorflow/tensorflow/blob/f3b9bf4c3c0597563b289c0512e98d4ce81f886e/tensorflow/core/kernels/quantize_and_dequantize_op.cc#L148-L226) does not fully validate the input arguments. This results in a `CHECK`-failure which can be used to trigger a denial of service attack:

```python
import tensorflow as tf

tf.raw_ops.QuantizeAndDequantizeV4Grad(
  gradients=tf.constant(1, shape=[2,2], dtype=tf.float64),
  input=tf.constant(1, shape=[2,2], dtype=tf.float64),
  input_min=tf.constant([], shape=[0], dtype=tf.float64),
  input_max=tf.constant(-10, shape=[], dtype=tf.float64),
  axis=-1)
```

The code assumes `input_min` and `input_max` are scalars but there is no validation for this.

### Patches
We have patched the issue in GitHub commit [098e7762d909bac47ce1dbabe6dfd06294cb9d58](https://github.com/tensorflow/tensorflow/commit/098e7762d909bac47ce1dbabe6dfd06294cb9d58).

The fix will be included in TensorFlow 2.9.0. We will also cherrypick this commit on TensorFlow 2.8.1, TensorFlow 2.7.2, and TensorFlow 2.6.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Neophytos Christou from Secure Systems Lab at Brown University.
