/*************************************************************************
*                                                                        *
*   1) This source code file, in unmodified form, and compiled classes   *
*      derived from it can be used and distributed without restriction,  *
*      including for commercial use.  (Attribution is not required       *
*      but is appreciated.)                                              *
*                                                                        *
*    2) Modified versions of this file can be made and distributed       *
*       provided:  the modified versions are put into a Java package     *
*       different from the original package, edu.hws;  modified          *
*       versions are distributed under the same terms as the original;   *
*       and the modifications are documented in comments.  (Modification *
*       here does not include simply making subclasses that belong to    *
*       a package other than edu.hws, which can be done without any      *
*       restriction.)                                                    *
*                                                                        *
*   David J. Eck                                                         *
*   Department of Mathematics and Computer Science                       *
*   Hobart and William Smith Colleges                                    *
*   Geneva, New York 14456,   USA                                        *
*   Email: eck@hws.edu          WWW: http://math.hws.edu/eck/            *
*                                                                        *
*************************************************************************/

package edu.hws.jcm.data;

/**
 * An object of type Cases stores a list of "case values" that is generated
 * while an expression is being evaluated using the routine Expression.getValuesWithCases().
 * This information can be used as a heuristic (i.e. a fudge) to help detect
 * a possible discontinuity between two evaluations of the expression.  Suppose
 * that the expression is evaluated twice, with some change of variable values
 * between the two evaluations.  If the variables' values are not changed too much,
 * and if the Cases objects generated by the two evaluations are equal (as determined
 * by the "equals" method defined in this class), then it is likely that
 * there is no discontinuity.  (However, this is not perfect.  The discontinuity
 * in 1/x^2 won't be detected since the case value generated by 1/f(x) only
 * checks the sign of f(x), and the denominator of 1/x^2 is positive on both
 * sides of x=0.  If you want to be more paranoid, check both the expression
 * and its derivative.)  (I really don't like this very much, but it can be used to draw
 * pretty good graphs in general.)
 */
public class Cases {  
   private int[] cases = new int[1];  // Array of values that have been added with addCase(value).
   private int caseCt;                // Number of items stored in cases array.

   /**
    * Remove all the cases that have been added with addCase().
    * This makes it possible to reuse this object in another
    * call to Expression.getValueWithCases().
    */
   public void clear() {
     caseCt = 0;
   }

   /**
    * Add a new case value to the list stored in this object.
    */
   public void addCase(int value) {
     if (caseCt == cases.length) {
        int[] temp = new int[2*caseCt];
        System.arraycopy(cases,0,temp,0,caseCt);
        cases = temp;
     }
     cases[caseCt++] = value;
   }

   /**
    * Test whether c contains exactly the same list of case
    * values as this Cases object does.
    */
   public boolean equals(Cases c) {
     if (c.caseCt != caseCt)
        return false;
     for (int i = 0; i < caseCt; i++)
        if (c.cases[i] != cases[i])
           return false;
     return true;
   }

} // end class Cases
